/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.chrhc.mybatis.autodate.util.TemplateUtils;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.CusSmsLogService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.SmsService;
import com.picc.gz.admin.service.SmsTemplateService;
import com.picc.gz.admin.vo.SmsVo;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.SmsTemplate;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(rollbackFor={Exception.class})
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private static final Pattern patt = Pattern.compile("<sendid>([\\d]+)</sendid>");
    private static final String TEMPLATE_PATH = "/templates/sms/";
    private static final String TEMPLATE_SUFFIX = ".ftl";
    @Value(value="${sms.url}")
    private String smsUrl;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    public CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    public CusRecommendService recommendService;
    @Autowired
    private InsuranceProductItemService productItemService;
    @Autowired
    private CusSmsLogService cusSmsLogService;

    public int policySuccess(String mobile, String recommendId, SmsVo smsVo) throws Exception {
        return this.sendSmsByBusinessTypeTemplate("policySuccess", mobile, mobile, smsVo);
    }

    public int insureSuccess(String mobile, String recommendId, SmsVo smsVo) throws Exception {
        return this.sendSmsByBusinessTypeTemplate("insureSuccess", mobile, mobile, smsVo);
    }

    public int sendSmsByBusinessTypeTemplate(String businessType, String mobile, String recommendId, SmsVo smsVo) throws Exception {
        String content = this.getSmsByBusinessTypeTemplate(businessType, recommendId, smsVo);
        int r = this.sendSms(content, mobile);
        return r;
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public String getSmsByBusinessTypeTemplate(String businessType, String recommendId, SmsVo smsVo) throws Exception {
        CusRecommend recommend = this.recommendService.findById(recommendId);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("recommend", recommend);
        templateData.put("applicantInfo", applicantInfo);
        templateData.put("productItem", productItem);
        templateData.put("smsInfo", smsVo == null ? new SmsVo() : smsVo);
        SmsTemplate smsTemplate = this.smsTemplateService.findByBusinessType(businessType);
        String content = "";
        if (smsTemplate == null) {
            throw new RuntimeException(String.format("Sms Template With BusinessType: [%s] Is NOT FOUND!", businessType));
        }
        content = TemplateUtils.renderString((String)smsTemplate.getContent(), templateData);
        log.info("\u8bf7\u6c42\u7684content\u5185\u5bb9\uff1a{}", (Object)content);
        return content;
    }

    public int sendSms(String content, String mobile) throws Exception {
        return this.sendSms(content, mobile, null);
    }

    public int sendSms(String content, String mobile, String businessType) throws Exception {
        try {
            String sendXml = SmsServiceImpl.generateXml((String)content, (String)mobile);
            URL url = new URL(this.smsUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStream outStrm = conn.getOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(outStrm);
            os.writeObject(sendXml);
            os.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuffer sb = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            conn.getInputStream().close();
            log.info("\u54cd\u5e94\u5185\u5bb9\u4e3a:  \n" + sb.toString());
            Matcher m = patt.matcher(sb.toString());
            if (null != m && m.find()) {
                this.cusSmsLogService.logSuccess(mobile, content, businessType);
                return 0;
            }
            this.cusSmsLogService.logError(mobile, content, businessType, String.format("\u77ed\u4fe1\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\uff1a%s", sb.toString()));
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cusSmsLogService.logError(mobile, content, businessType, String.format("\u77ed\u4fe1\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\uff1a%s", e.getLocalizedMessage()));
            return 1;
        }
    }

    private static String generateXml(String content, String mobile) {
        Date current = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer("<RequestDto>");
        sb.append("<lists>");
        sb.append("<SendContentDto>");
        sb.append("<sendid>0</sendid>");
        sb.append("<sendName>CustomerIdentity</sendName>");
        sb.append("<phoneNumber>").append(mobile).append("</phoneNumber>");
        sb.append("<phoneflag>1</phoneflag>");
        sb.append("<sendContent>").append(content).append("</sendContent>");
        sb.append("<insertTime>").append(sf.format(current)).append("</insertTime>");
        sb.append("<replyflag>1</replyflag>");
        sb.append("<certino>0</certino>");
        sb.append("</SendContentDto>");
        sb.append("</lists>");
        sb.append("<type>send</type>");
        sb.append("<fbtype></fbtype>");
        sb.append("</RequestDto>");
        return sb.toString();
    }
}

