/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.constants.Constants;
import com.picc.gz.admin.dao.StatisticsDao;
import com.picc.gz.admin.service.StatisticsService;
import com.picc.gz.admin.vo.statistics.NewUserRegistrationNumVo;
import com.picc.gz.admin.vo.statistics.WebsiteRegisteredProportionVo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class StatisticsServiceImpl
implements StatisticsService {
    @Autowired
    private StatisticsDao statisticsDao;

    public List<Map<String, Object>> getAllSources() {
        List maps = this.statisticsDao.getAllSources();
        if (maps.size() > 0) {
            return maps;
        }
        return null;
    }

    public Map<String, List<NewUserRegistrationNumVo>> getStatisticsInfoByStartEndDateAndSources(String startDate, String endDate) {
        HashMap<String, List<NewUserRegistrationNumVo>> statisticsVoMap = new HashMap<String, List<NewUserRegistrationNumVo>>(16);
        List statisticslistGw = this.statisticsDao.getNewCountByStartEndDateAndOwnerSystem(startDate, endDate, "1");
        for (int j = 0; j < statisticslistGw.size(); ++j) {
            ((NewUserRegistrationNumVo)statisticslistGw.get(j)).setSource("\u5b98\u7f51");
        }
        List statisticslistWt = this.statisticsDao.getNewCountByStartEndDateAndOwnerSystem(startDate, endDate, "2");
        for (int j = 0; j < statisticslistWt.size(); ++j) {
            ((NewUserRegistrationNumVo)statisticslistGw.get(j)).setSource("\u7f51\u5385");
        }
        statisticsVoMap.put("1", statisticslistGw);
        statisticsVoMap.put("2", statisticslistWt);
        return statisticsVoMap;
    }

    public List<WebsiteRegisteredProportionVo> getProportionEverySourceOnStartAndEndDate(String startDate, String endDate) {
        ArrayList<WebsiteRegisteredProportionVo> listVo = new ArrayList<WebsiteRegisteredProportionVo>();
        List listMaps = this.statisticsDao.getCountEverySourceOnStartAndEndDate(startDate, endDate);
        if (StringUtils.isEmpty((Object)listMaps)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#.##");
        WebsiteRegisteredProportionVo websiteRegisteredProportionVo = null;
        Long allRegisteredSum = 0L;
        for (int j = 0; j < listMaps.size(); ++j) {
            allRegisteredSum = allRegisteredSum + Long.parseLong(String.valueOf(((Map)listMaps.get(j)).get("registeredSum")));
        }
        String otherChannelName = null;
        Long otherRegisteredSum = 0L;
        double otherProportion = 0.0;
        for (int i = 0; i < listMaps.size(); ++i) {
            websiteRegisteredProportionVo = new WebsiteRegisteredProportionVo();
            websiteRegisteredProportionVo.setSourceSum(allRegisteredSum);
            websiteRegisteredProportionVo.setSource(String.valueOf(((Map)listMaps.get(i)).get("source")));
            otherChannelName = (String)Constants.CHANNEL_CODE_CHINESE.get(((Map)listMaps.get(i)).get("source"));
            if (StringUtils.isEmpty((Object)otherChannelName)) {
                otherRegisteredSum = otherRegisteredSum + Long.parseLong(String.valueOf(((Map)listMaps.get(i)).get("registeredSum")));
                continue;
            }
            Long registeredSum = Long.valueOf(String.valueOf(((Map)listMaps.get(i)).get("registeredSum")));
            String proportion = df.format((double)registeredSum.longValue() / (double)websiteRegisteredProportionVo.getSourceSum().longValue() * 100.0) + "%";
            websiteRegisteredProportionVo.setRegisteredProportion(proportion);
            websiteRegisteredProportionVo.setRegisteredSum(Long.valueOf(String.valueOf(((Map)listMaps.get(i)).get("registeredSum"))));
            listVo.add(websiteRegisteredProportionVo);
        }
        websiteRegisteredProportionVo = new WebsiteRegisteredProportionVo();
        websiteRegisteredProportionVo.setSource("otherChannel");
        websiteRegisteredProportionVo.setSourceSum(allRegisteredSum);
        websiteRegisteredProportionVo.setRegisteredSum(otherRegisteredSum);
        String proportion = null;
        proportion = websiteRegisteredProportionVo.getSourceSum() == 0L || otherRegisteredSum == 0L ? "0%" : df.format((otherProportion += (double)otherRegisteredSum.longValue() / (double)websiteRegisteredProportionVo.getSourceSum().longValue()) * 100.0) + "%";
        websiteRegisteredProportionVo.setRegisteredProportion(proportion);
        listVo.add(websiteRegisteredProportionVo);
        return listVo;
    }

    public Long getCountByStartAndEndDateAndPhoneActivedAndEmailActived(String startDate, String endDate, String phoneActived, String emailActived) throws RuntimeException {
        if (StringUtils.isEmpty((Object)startDate) || StringUtils.isEmpty((Object)endDate)) {
            throw new RuntimeException("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)phoneActived) || StringUtils.isEmpty((Object)emailActived)) {
            return 0L;
        }
        return this.statisticsDao.getCountByStartAndEndDateAndPhoneActivedAndEmailActived(startDate, endDate, phoneActived, emailActived);
    }

    public Long getAllRegisteredSumCount(String startDate, String endDate) {
        return this.statisticsDao.getAllRegisteredSumCount(startDate, endDate);
    }

    public Long getCountByRegistActived(String startDate, String endDate) {
        return this.statisticsDao.getCountByRegistActived(startDate, endDate);
    }

    public Long getCountByUpdateEmailOrPhone(String startDate, String endDate) {
        return this.statisticsDao.getCountByUpdateEmailOrPhone(startDate, endDate);
    }

    public Long getRequestCountByTypeAndChannel(String startDate, String endDate, String countType, String ownerSystem) {
        Long allCountByAudit = this.statisticsDao.getRequestCountFromAuditByTypeAndOwnerSystem(startDate, endDate, countType, ownerSystem);
        Long allCountByApi = this.statisticsDao.getRequestCountFromApiByTypeAndOwnerSystem(startDate, endDate, countType, ownerSystem);
        return allCountByAudit + allCountByApi;
    }

    public Long getCountByLoginNameUsed(String startDate, String endDate, String userType) {
        return this.statisticsDao.getCountByLoginNameUsed(startDate, endDate, userType);
    }

    public List<Map<String, Object>> getRegisteredCountByOwnerSystem(String startDate, String endDate, String ownerSystem) {
        return this.statisticsDao.getRegisteredCountByOwnerSystem(startDate, endDate, ownerSystem);
    }

    public List<Map<String, Object>> getMaxLoginNumForPeriodTime(String startDate, String endDate) {
        return this.statisticsDao.getMaxLoginNumForPeriodTime(startDate, endDate);
    }

    public List<Map<String, Object>> getDistributionByOwnerSystemAndHour(String ownerSystem, String startDate, String endDate) {
        return this.statisticsDao.getDistributionByOwnerSystemAndHour(ownerSystem, startDate, endDate);
    }
}

