/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.picc.gz.admin.service.ZXingService;
import com.picc.gz.admin.service.impl.ZXingServiceImpl;
import com.picc.gz.utils.Base64Util;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(rollbackFor={Exception.class})
public class ZXingServiceImpl
implements ZXingService {
    Logger log = LoggerFactory.getLogger(ZXingServiceImpl.class);
    @Value(value="${zxing.pathName}")
    private String zxingPathName;
    @Value(value="${zxing.logo.pathName}")
    private String zxingLogoPathName;

    private BitMatrix updateBit(BitMatrix matrix, int margin) {
        int tempM = margin * 2;
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + tempM;
        int resHeight = rec[3] + tempM;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = margin; i < resWidth - margin; ++i) {
            for (int j = margin; j < resHeight - margin; ++j) {
                if (!matrix.get(i - margin + rec[0], j - margin + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public String parseZxingCode(String filePath) {
        String content = "";
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(this, image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            MultiFormatReader formatReader = new MultiFormatReader();
            Result result = formatReader.decode(binaryBitmap, hints);
            content = result.getText();
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u6307\u5b9a\u8def\u5f84\u4e0b\u7684\u4e8c\u7ef4\u7801\u56fe\u7247\u9519\u8bef", (Throwable)e);
        }
        return content;
    }

    public String generateZxingCode(String text, int width, int height, String fileName, String format) throws Exception {
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        int margin = 10;
        bitMatrix = this.updateBit(bitMatrix, margin);
        File ZxingCodePathFile = new File(this.zxingPathName);
        if (!ZxingCodePathFile.exists()) {
            ZxingCodePathFile.mkdir();
        }
        String pathName = this.zxingPathName + fileName + "." + format;
        File outputFile = new File(pathName);
        MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)format, (File)outputFile);
        return pathName;
    }

    public String generateZxingCode(String text, String fileName, String format) throws Exception {
        return this.generateZxingCode(text, 250, 250, fileName, format);
    }

    public String generateZxingCode(String text, String fileName) throws Exception {
        return this.generateZxingCode(text, fileName, "png");
    }

    public String generateZxingCode(String text) throws Exception {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String fileName = sdf.format(now) + String.valueOf(System.currentTimeMillis());
        return this.generateZxingCode(text, fileName, "png");
    }

    public String generateZxingCodeBase64(String text, String fileName) throws Exception {
        String zxingFilePath = this.zxingPathName + fileName + ".png";
        File zxingFile = new File(zxingFilePath);
        if (zxingFile.exists()) {
            boolean bl = zxingFile.delete();
        }
        zxingFilePath = !StringUtils.isEmpty((Object)this.zxingLogoPathName) ? this.getZxingCodeByLogo(text, fileName, "png") : this.generateZxingCode(text, fileName);
        return "data:image/png;base64," + Base64Util.imageToBase64((String)zxingFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgByLogo(String logoPath, String srcImgPath, String targerPath, Integer degree) {
        OutputStream os = null;
        try {
            BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
            BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            Graphics2D g = buffImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
            }
            ImageIcon imgIcon = new ImageIcon(logoPath);
            float alpha = 1.0f;
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            Image img = imgIcon.getImage();
            BufferedImage logoImg = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
            int logoW = logoImg.getWidth();
            int logoH = logoImg.getHeight();
            int srcW = buffImg.getWidth();
            int srcH = buffImg.getHeight();
            int x = (srcW - logoW) / 2;
            int y = (srcH - logoH) / 2;
            g.drawImage(img, x, y, null);
            g.setComposite(AlphaComposite.getInstance(3));
            g.dispose();
            os = new FileOutputStream(targerPath);
            ImageIO.write((RenderedImage)buffImg, "png", os);
        }
        catch (Exception e) {
            this.log.error("\u7ed9\u56fe\u7247\u6dfb\u52a0Logo\u62a5\u9519", (Throwable)e);
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                this.log.error("\u7ed9\u56fe\u7247\u6dfb\u52a0Logo\u62a5\u9519", (Throwable)e);
            }
        }
        return targerPath;
    }

    public String getImgByLogo(String logoPath, String srcImgPath, String targerPath) {
        return this.getImgByLogo(logoPath, srcImgPath, targerPath, null);
    }

    public String getZxingCodeByLogo(String text, String fileName, String format) throws Exception {
        String zxingCodeImg = this.generateZxingCode(text, fileName, format);
        File ZxingCodeLogoPath = new File(this.zxingLogoPathName);
        if (!ZxingCodeLogoPath.exists()) {
            ZxingCodeLogoPath.mkdir();
        }
        String logoPath = String.format("%s%slogo.png", this.zxingLogoPathName, this.zxingLogoPathName.endsWith(File.separator) ? "" : File.separator);
        String pathName = this.getImgByLogo(logoPath, zxingCodeImg, zxingCodeImg);
        return pathName;
    }
}

