/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl.urlshorten;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.config.ShortenUrlProperties;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.ShortenUrlSupplier;
import com.picc.gz.utils.MD5Utils;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="piccGdShorteGnUrlSupplier")
public class PiccGdShorteGnUrlSupplier
implements ShortenUrlSupplier {
    private static final Logger log = LoggerFactory.getLogger(PiccGdShorteGnUrlSupplier.class);
    @Autowired
    ShortenUrlProperties shortenUrlProperties;
    private OkHttpClient okHttpClient;

    public PiccGdShorteGnUrlSupplier(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public PiccGdShorteGnUrlSupplier() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(3L, TimeUnit.SECONDS).connectTimeout(1L, TimeUnit.SECONDS);
        this.okHttpClient = builder.build();
    }

    public String shortenUrl(String longUrl) {
        MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
        String timeStamp = String.valueOf(new Date().getTime()).substring(0, 10);
        String signature = MD5Utils.encode((String)timeStamp, (String)this.shortenUrlProperties.getApiSecret());
        FormBody requestBody = new FormBody.Builder().add("timestamp", timeStamp).add("signature", signature).add("action", "shorturl").add("url", longUrl).add("format", "json").build();
        Request httpRequest = new Request.Builder().url(this.shortenUrlProperties.getApiUrl()).post((RequestBody)requestBody).build();
        try {
            Response response = this.okHttpClient.newCall(httpRequest).execute();
            String responseBody = new String(response.body().bytes(), "UTF-8");
            responseBody = InjectionAttackWrapperDataStr.getDataStr((String)responseBody);
            log.info("responseBody-->{}", (Object)responseBody);
            if (!StringUtils.isEmpty((Object)responseBody)) {
                log.info("\u670d\u52a1\u5668\u8fd4\u56de\u7684\u4fe1\u606f-->{}", (Object)responseBody);
                JSONObject jsonObject = JSON.parseObject((String)responseBody);
                String shortUrl = jsonObject.getString("shorturl");
                return shortUrl;
            }
            log.info("\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

