/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.intf;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.picc.gz.admin.aspect.annocation.ApiService;
import com.picc.gz.admin.config.ReinsuranceProperties;
import com.picc.gz.admin.config.ShortenUrlProperties;
import com.picc.gz.admin.dao.CusRecommendBatchMapper;
import com.picc.gz.admin.dao.CusRecommendCustomerMapper;
import com.picc.gz.admin.dao.CusRecommendExtAttrMapper;
import com.picc.gz.admin.dao.CusRecommendMapper;
import com.picc.gz.admin.dao.CusRecommendPersonnelMapper;
import com.picc.gz.admin.dao.CusRecommendSalerMapper;
import com.picc.gz.admin.factory.ShortenUrlSupplierFactory;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.vo.policy.PolicyQuery;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendBatch;
import com.picc.gz.model.model.CusRecommendCustomer;
import com.picc.gz.model.model.CusRecommendExtAttr;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.CusRecommendPolicy;
import com.picc.gz.model.model.CusRecommendSaler;
import com.picc.gz.model.util.PageRequest;
import com.picc.gz.model.util.Sort;
import com.picc.gz.sfzn.api.security.SignUtil;
import com.picc.gz.sfzn.api.vo.basic.BaseRequest;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import com.picc.gz.sfzn.api.vo.recommend.PolicyQueryRequest;
import com.picc.gz.sfzn.api.vo.recommend.PolicyQueryResp;
import com.picc.gz.sfzn.api.vo.recommend.PolicyVo;
import com.picc.gz.sfzn.api.vo.recommend.RecommendExtAttr;
import com.picc.gz.sfzn.api.vo.recommend.RecommendRequest;
import com.picc.gz.sfzn.api.vo.recommend.RecommendResp;
import com.picc.gz.sfzn.api.vo.recommend.RecommendRiskInfo;
import com.picc.gz.sfzn.api.vo.recommend.RecommendUrl;
import com.picc.gz.sfzn.api.vo.recommend.SalerInfo;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.data.Beans;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Component
public class RecommendInterfaceService {
    private static final Logger log = LoggerFactory.getLogger(RecommendInterfaceService.class);
    @Autowired
    ReinsuranceProperties reinsuranceProperties;
    @Value(value="${yeePay.outerDownloadUrl}")
    private String downloadUrl;
    @Autowired
    ShortenUrlProperties shortenUrlProperties;
    @Autowired
    CusRecommendMapper cusRecommendMapper;
    @Autowired
    CusRecommendBatchMapper cusRecommendBatchMapper;
    @Autowired
    CusRecommendPersonnelMapper cusRecommendPersonnelMapper;
    @Autowired
    CusRecommendCustomerMapper cusRecommendCustomerMapper;
    @Autowired
    ShortenUrlSupplierFactory shortenUrlSupplierFactory;
    @Autowired
    CusRecommendSalerMapper cusRecommendSalerMapper;
    @Autowired
    CusRecommendExtAttrMapper cusRecommendExtAttrMapper;
    @Autowired
    CusRecommendService cusRecommendService;

    @Transactional(rollbackFor={Exception.class})
    @ApiService
    public BaseResponse<RecommendResp> newRecommend(BaseRequest<RecommendRequest> request) {
        request.getHeader().setSign(null);
        request.getHeader().setTimeStamp(null);
        String packetHash = null;
        try {
            packetHash = SignUtil.encodeSHA1((String)SignUtil.getParamStr(request));
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Example batchExample = new Example(CusRecommendBatch.class);
        batchExample.createCriteria().andEqualTo("packetHash", (Object)packetHash).andEqualTo("isDelete", (Object)0);
        int count = this.cusRecommendBatchMapper.selectCountByExample((Object)batchExample);
        List<CusRecommend> cusRecommendList = null;
        String batchId = null;
        if (count > 0) {
            List batches = this.cusRecommendBatchMapper.selectByExample((Object)batchExample);
            cusRecommendList = this.cusRecommendMapper.findByBatchId(((CusRecommendBatch)batches.get(0)).getId());
            log.info("packetHash:{}\uff0c\u5df2\u5b58\u5728\uff0c\u4f7f\u7528\u5386\u53f2\u6570\u636e...", (Object)packetHash);
            batchId = ((CusRecommendBatch)batches.get(0)).getId();
        }
        if (cusRecommendList == null || cusRecommendList.size() <= 0) {
            log.info("packetHash:{}\uff0c\u4e0d\u5b58\u5728\uff0c\u4f7f\u7528\u65b0\u6570\u636e...", (Object)packetHash);
            cusRecommendList = new ArrayList();
            RecommendRequest recommendRequest = (RecommendRequest)request.getBody();
            if (recommendRequest == null) {
                return BaseResponse.createError((String)"1001", (String)"\u4e1a\u52a1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            CusRecommendBatch batch = new CusRecommendBatch();
            batch.setPacketHash(packetHash);
            batch.setPacket(JSON.toJSONString(request));
            this.cusRecommendBatchMapper.insertSelective((Object)batch);
            Example customerQueryExample = new Example(CusRecommendCustomer.class);
            if (StringUtils.isEmpty((Object)recommendRequest.getIdNumber())) {
                customerQueryExample.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("mobile", (Object)recommendRequest.getMobile()).andEqualTo("name", (Object)recommendRequest.getCustomerName());
            } else {
                customerQueryExample.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("idNumber", (Object)recommendRequest.getIdNumber());
            }
            CusRecommendCustomer customer = null;
            List customers = this.cusRecommendCustomerMapper.selectByExample((Object)customerQueryExample);
            if (customers != null && customers.size() > 0) {
                customer = (CusRecommendCustomer)customers.get(0);
            }
            batchId = batch.getId();
            for (RecommendRiskInfo risk : recommendRequest.getRiskInfo()) {
                if (risk == null || Lang.isEmpty((Object)risk.getRiskCode()) || risk.getSalerInfos() == null || risk.getSalerInfos().size() < 1) continue;
                CusRecommend cusRecommend = (CusRecommend)Beans.map((Object)recommendRequest, CusRecommend.class);
                cusRecommend.setRiskCode(risk.getRiskCode());
                cusRecommend.setPlanCode(risk.getPlanCode());
                cusRecommend.setBatchId(batch.getId());
                cusRecommend.setDateCreated(new Date());
                if (customer == null) {
                    customer = (CusRecommendCustomer)Beans.map((Object)recommendRequest, CusRecommendCustomer.class);
                    customer.setName(recommendRequest.getCustomerName());
                    this.cusRecommendCustomerMapper.insertSelective((Object)customer);
                } else {
                    customer.setMobile(recommendRequest.getMobile());
                    customer.setAddress(recommendRequest.getAddress());
                    customer.setBirthDay(recommendRequest.getBirthDay());
                    customer.setEmail(recommendRequest.getEmail());
                    customer.setGender(recommendRequest.getGender());
                    customer.setName(recommendRequest.getCustomerName());
                    this.cusRecommendCustomerMapper.updateByPrimaryKeySelective((Object)customer);
                }
                Calendar insuranceStartDate = Calendar.getInstance();
                insuranceStartDate.add(5, 1);
                insuranceStartDate.set(10, 0);
                insuranceStartDate.set(12, 0);
                insuranceStartDate.set(13, 0);
                cusRecommend.setInsuranceStartDate(insuranceStartDate.getTime());
                cusRecommend.setCusCustomerId(customer.getId());
                cusRecommend.setStatus("0");
                cusRecommend.setCommission(BigDecimal.ZERO);
                this.cusRecommendMapper.insertSelective((Object)cusRecommend);
                CusRecommendPersonnel applicat = (CusRecommendPersonnel)Beans.map((Object)recommendRequest, CusRecommendPersonnel.class);
                applicat.setType("1");
                applicat.setRecommendId(cusRecommend.getId());
                applicat.setName(recommendRequest.getCustomerName());
                this.cusRecommendPersonnelMapper.insertSelective((Object)applicat);
                CusRecommendPersonnel insured = (CusRecommendPersonnel)Beans.map((Object)recommendRequest, CusRecommendPersonnel.class);
                insured.setType("2");
                insured.setRecommendId(cusRecommend.getId());
                insured.setName(recommendRequest.getCustomerName());
                this.cusRecommendPersonnelMapper.insertSelective((Object)insured);
                for (SalerInfo saler : risk.getSalerInfos()) {
                    CusRecommendSaler cusRecommendSaler = (CusRecommendSaler)Beans.map((Object)saler, CusRecommendSaler.class);
                    cusRecommendSaler.setRecommendId(cusRecommend.getId());
                    this.cusRecommendSalerMapper.insertSelective((Object)cusRecommendSaler);
                }
                if (((RecommendRequest)request.getBody()).getExtAttrs() != null) {
                    for (RecommendExtAttr extAttr : ((RecommendRequest)request.getBody()).getExtAttrs()) {
                        CusRecommendExtAttr cusRecommendExtAttr = new CusRecommendExtAttr();
                        cusRecommendExtAttr.setAttrName(extAttr.getName());
                        cusRecommendExtAttr.setAttrValue(extAttr.getValue());
                        cusRecommendExtAttr.setArrtType("1");
                        cusRecommendExtAttr.setRecommendId(cusRecommend.getId());
                        this.cusRecommendExtAttrMapper.insertSelective((Object)cusRecommendExtAttr);
                    }
                }
                cusRecommendList.add(cusRecommend);
            }
        }
        RecommendResp recommendResp = new RecommendResp();
        ArrayList<RecommendUrl> urls = new ArrayList<RecommendUrl>();
        recommendResp.setRecommendUrls(new ArrayList());
        for (CusRecommend cr : cusRecommendList) {
            RecommendUrl recommendUrl = new RecommendUrl();
            String longUrl = String.format("%s://%s%s?%s=%s", this.reinsuranceProperties.getProtocol(), this.reinsuranceProperties.getBasicUrl(), this.reinsuranceProperties.getUrl(), this.reinsuranceProperties.getParamName(), cr.getId());
            if (this.reinsuranceProperties.getShorten().booleanValue()) {
                String shortUrl = this.shortenUrlSupplierFactory.get().shortenUrl(longUrl);
                log.info("shorten enabled shortUrl: {}", (Object)shortUrl);
                recommendUrl.setUrl(StringUtils.isEmpty((Object)shortUrl) ? longUrl : shortUrl);
            } else {
                log.info("shorten disabled longUrl: {}", (Object)longUrl);
                recommendUrl.setUrl(longUrl);
            }
            if (this.shortenUrlProperties.getRemoveProtocol().booleanValue()) {
                recommendUrl.setUrl(recommendUrl.getUrl().replace("http://", "").replace("https://", ""));
            }
            String pclongUrl = String.format("%s://%s%s?%s=%s", this.reinsuranceProperties.getProtocol(), this.reinsuranceProperties.getPcUrlHost(), this.reinsuranceProperties.getPcUri(), this.reinsuranceProperties.getParamName(), cr.getId());
            recommendUrl.setPcUrl(pclongUrl);
            recommendUrl.setRecommendId(cr.getId());
            recommendUrl.setRiskCode(cr.getRiskCode());
            urls.add(recommendUrl);
        }
        recommendResp.setBatchId(batchId);
        recommendResp.setRecommendUrls(urls);
        return BaseResponse.createSuc((Object)recommendResp);
    }

    @Transactional(rollbackFor={Exception.class})
    @ApiService
    public BaseResponse<PolicyQueryResp> queryPolicy(BaseRequest<PolicyQueryRequest> request) {
        PolicyQuery policyQuery = new PolicyQuery();
        policyQuery.setIdNumber(((PolicyQueryRequest)request.getBody()).getIdNum());
        policyQuery.setPolicyTimeEnd(((PolicyQueryRequest)request.getBody()).getPolicyTimeEnd());
        policyQuery.setPolicyTimeStart(((PolicyQueryRequest)request.getBody()).getPolicyTimeStart());
        PageRequest pageRequest = new PageRequest(((PolicyQueryRequest)request.getBody()).getPage(), ((PolicyQueryRequest)request.getBody()).getSize(), (Sort)Beans.map((Object)((PolicyQueryRequest)request.getBody()).getSort(), Sort.class));
        PageInfo queryRs = this.cusRecommendService.queryPolicy(policyQuery, pageRequest);
        List dataList = queryRs.getList();
        queryRs.setList(null);
        PolicyQueryResp resp = (PolicyQueryResp)Beans.map((Object)queryRs, PolicyQueryResp.class);
        resp.setList(Beans.mapList((Iterable)dataList, CusRecommendPolicy.class, PolicyVo.class));
        resp.getList().forEach(it -> it.setDownloadUrl(String.format("%s?requestUUID={}&policyNo={}", this.downloadUrl, it.getRequestId(), it.getPolicyNo())));
        return BaseResponse.createSuc((Object)resp);
    }
}

