/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.timer;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.picc.gz.admin.factory.ShortenUrlSupplierFactory;
import com.picc.gz.admin.service.BusinessUnitService;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.HttpClientService;
import com.picc.gz.admin.service.InsurePolicyService;
import com.picc.gz.admin.service.QuartzLockUtil;
import com.picc.gz.admin.service.RecommendRequestService;
import com.picc.gz.admin.service.SmsService;
import com.picc.gz.admin.vo.SmsVo;
import com.picc.gz.admin.vo.insure.QueryPolicyResponse;
import com.picc.gz.model.model.BusinessUnit;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.RecommendRequest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="timer", name={"enable"}, havingValue="true")
public class TimeRunJob {
    private static final Logger log = LoggerFactory.getLogger(TimeRunJob.class);
    static final String JOB_NAME_GET_POLICY_JOB = "getPolicyJob";
    static final String JOB_NAME_POLICY_SUC_SMS_JOB = "policySucSms";
    @Value(value="${timer.getPolicy.queryAll}")
    private Boolean queryAll;
    @Value(value="${timer.getPolicy.lockTimeout:60000}")
    private Long LOCK_TIMEOUT_GETPOLICYJOB;
    @Value(value="${timer.policySucSms.lockTimeout:500000}")
    private Long LOCK_TIMEOUT_POLICYSUCSMSJOB;
    @Value(value="${timer.maxThreads:1}")
    private Integer maxThreads;
    @Value(value="${timer.minThreads:0}")
    private Integer minThreads;
    @Value(value="${timer.keepAliveTime:1000}")
    private Long keepAliveTime;
    @Value(value="${timer.getPolicy.enableMutiThread:false}")
    private Boolean getPolicyEnableMutiThread;
    private ExecutorService executorService;
    @Autowired
    private QuartzLockUtil quartzLockUtil;
    @Autowired
    private InsurePolicyService insurePolicyService;
    @Autowired
    private RecommendRequestService recommendRequestService;
    @Autowired
    private CusRecommendService cusRecommendService;
    @Autowired
    private SmsService smsService;
    @Autowired
    CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    ShortenUrlSupplierFactory shortenUrlSupplierFactory;
    @Autowired
    BusinessUnitService businessUnitService;
    @Autowired
    HttpClientService httpClientService;
    private static Map<String, BusinessUnit> businessUnitMap = new ConcurrentHashMap();
    @Value(value="${yeePay.outerDownloadUrl}")
    private String outerDownloadUrl;
    @Value(value="${yeePay.downDzfpUrl}")
    private String downDzfpUrl;

    @Scheduled(cron="${timer.getPolicy.corn}")
    @ConditionalOnProperty(prefix="timer.getPolicy", name={"enable"}, havingValue="true")
    public void getPolicy() {
        List recommendRequests;
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5b9a\u65f6\u4efb\u52a1-getPolicy\u83b7\u5f97\u9501\u6210\u529f\uff0c\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c");
        ArrayList<String> updatedRecommendIds = new ArrayList<String>();
        if (this.queryAll.booleanValue()) {
            recommendRequests = this.recommendRequestService.findAllPropasaled();
        } else {
            Calendar startTime = Calendar.getInstance();
            startTime.set(10, 0);
            startTime.set(12, 0);
            startTime.set(13, 0);
            startTime.set(14, 0);
            Calendar endTime = Calendar.getInstance();
            endTime.add(5, 1);
            endTime.set(10, 0);
            endTime.set(12, 0);
            endTime.set(13, 0);
            endTime.set(14, 0);
            recommendRequests = this.recommendRequestService.findAllPropasaledBetweenDate(startTime.getTime(), endTime.getTime());
        }
        if (recommendRequests != null && recommendRequests.size() > 0) {
            if (this.getPolicyEnableMutiThread.booleanValue()) {
                ArrayList futures = new ArrayList();
                for (RecommendRequest r : recommendRequests) {
                    futures.add(this.getExecutorService().submit(new /* Unavailable Anonymous Inner Class!! */));
                }
                for (Future future : futures) {
                    if (future == null) continue;
                    try {
                        String recommendId = (String)future.get();
                        if (recommendId == null) continue;
                        updatedRecommendIds.add(recommendId);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (RecommendRequest r : recommendRequests) {
                    this.doUpdatePolicy(r, updatedRecommendIds);
                }
            }
        }
        log.info("### \u5b9a\u65f6\u4efb\u52a1-getPolicy\u4e1a\u52a1\u64cd\u4f5c\u5b8c\u6210\uff0c\u8017\u65f6" + (System.currentTimeMillis() - methodStartTime) + "ms\uff0c\u91ca\u653e\u9501");
        log.info("\u5df2\u540c\u6b65\u4fdd\u5355\u53f7\u6570\u636e\u91cf\uff1a{}\uff0c\u5df2\u66f4\u65b0\u7684\u6570\u636e\uff1a{}", (Object)updatedRecommendIds.size(), (Object)Joiner.on((String)",").join(updatedRecommendIds));
    }

    private String doUpdatePolicy(RecommendRequest r) {
        QueryPolicyResponse response = this.insurePolicyService.queryPolicyPay(r.getRequestId(), r.getRecommendId());
        if ("true".equals(response.getResponseBody().getResultFlag()) && !StringUtils.isEmpty((Object)response.getResponseBody().getPolicyNo())) {
            this.cusRecommendService.updatePolicy(r.getRecommendId(), response.getResponseBody().getProposalNo(), response.getResponseBody().getPolicyNo());
            r.getRecommendId();
        }
        return null;
    }

    private void doUpdatePolicy(RecommendRequest r, List<String> updatedRecommendIds) {
        QueryPolicyResponse response;
        if (!updatedRecommendIds.contains(r.getRecommendId()) && "true".equals((response = this.insurePolicyService.queryPolicyPay(r.getRequestId(), r.getRecommendId())).getResponseBody().getResultFlag()) && !StringUtils.isEmpty((Object)response.getResponseBody().getPolicyNo())) {
            this.cusRecommendService.updatePolicy(r.getRecommendId(), response.getResponseBody().getProposalNo(), response.getResponseBody().getPolicyNo());
            updatedRecommendIds.add(r.getRecommendId());
        }
    }

    @Scheduled(cron="${timer.policySucSms.corn}")
    @ConditionalOnProperty(prefix="timer.policySucSms", name={"enable"}, havingValue="true")
    public void policySucSms() {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5b9a\u65f6\u4efb\u52a1-policySucSms\u5f00\u59cb...");
        log.info("### \u5b9a\u65f6\u4efb\u52a1-policySucSms\u83b7\u5f97\u9501\u6210\u529f\uff0c\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c");
        List policyRecommends = this.cusRecommendService.findAllNeedPolicySms();
        int sucFlag = 0;
        for (CusRecommend r : policyRecommends) {
            sucFlag = 0;
            try {
                RecommendRequest request = this.recommendRequestService.findByRecommendIdAndProposalNo(r.getId(), r.getProposalNo());
                if (request != null) {
                    String policyDownloadUrl = this.outerDownloadUrl + "?requestUUID=" + request.getRequestId() + "&policyNo=" + r.getPolicyNo() + "&fileType=PDF";
                    BusinessUnit businessUnit = this.getBusinessUnit(r.getRealRiskCode());
                    String shortDownloadUrl = businessUnit != null && businessUnit.getEPolicyFlag() == false ? null : this.shortenUrlSupplierFactory.get().shortenUrl(policyDownloadUrl);
                    shortDownloadUrl = shortDownloadUrl == null ? policyDownloadUrl : shortDownloadUrl;
                    CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(r.getId());
                    SmsVo smsVo = new SmsVo();
                    smsVo.setDownloadUrl(shortDownloadUrl);
                    ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                    formParams.add(new BasicNameValuePair("policyNo", r.getPolicyNo()));
                    formParams.add(new BasicNameValuePair("requestUUID", request.getRequestId()));
                    String respStr = this.httpClientService.getHttpRequest(this.downDzfpUrl, formParams);
                    JSONObject respJsonObject = JSONObject.parseObject((String)respStr);
                    String resultMsg = respJsonObject.getString("resultMsg");
                    if ("success".equals(respJsonObject.getString("dzfpUrl"))) {
                        smsVo.setDownDzfpUrl(respJsonObject.getString("dzfpUrl"));
                    } else {
                        log.warn("\u8bf7\u6c42\u7535\u5b50\u53d1\u7968\u94fe\u63a5\u83b7\u53d6\u63a5\u53e3\u5931\u8d25\uff1a" + respStr);
                    }
                    if (applicantInfo != null && !StringUtils.isEmpty((Object)applicantInfo.getMobile())) {
                        sucFlag = this.smsService.sendSmsByBusinessTypeTemplate("policySuccess", applicantInfo.getMobile(), r.getId(), smsVo);
                    }
                    sucFlag -= this.smsService.sendSmsByBusinessTypeTemplate("policySuccess", r.getTsUserPhone(), r.getId(), smsVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sucFlag < 0) continue;
            this.cusRecommendService.updateSmsSendFlag(r.getId(), Integer.valueOf(1));
        }
        log.info("### \u5b9a\u65f6\u4efb\u52a1-policySucSms\u4e1a\u52a1\u64cd\u4f5c\u5b8c\u6210\uff0c\u8017\u65f6" + (System.currentTimeMillis() - methodStartTime) + "ms\uff0c\u91ca\u653e\u9501");
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(this.minThreads, this.maxThreads, this.keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return this.executorService;
    }

    private BusinessUnit getBusinessUnit(String riskCode) {
        BusinessUnit businessUnit;
        if (businessUnitMap == null) {
            businessUnitMap = new ConcurrentHashMap();
        }
        if ((businessUnit = (BusinessUnit)businessUnitMap.get(riskCode)) == null) {
            businessUnit = this.businessUnitService.findByRiskCode(riskCode);
            businessUnitMap.put(riskCode, businessUnit);
        }
        return businessUnit;
    }

    static /* synthetic */ String access$000(TimeRunJob x0, RecommendRequest x1) {
        return x0.doUpdatePolicy(x1);
    }
}

