/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.picc.gz.admin.service.AttachedsalesmanService;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.ProductItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api"})
public class ItemController {
    private static final Logger log = LoggerFactory.getLogger(ItemController.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    @Autowired
    InsuranceProductItemService insuranceProductItemService;
    @Autowired
    AttachedsalesmanService attachedsalesmanService;
    @Autowired
    private CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    private CusRecommendService recommendService;

    @RequestMapping(value={"/product"})
    @ResponseBody
    public Map<String, Object> findProductItem(HttpServletRequest request, String type) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List insuranceProductItemList = null;
        ArrayList<ProductItem> productItemList = new ArrayList<ProductItem>();
        try {
            insuranceProductItemList = this.insuranceProductItemService.getAllProductsByType();
            if (type.equals("1")) {
                if (insuranceProductItemList.size() != 0) {
                    for (int i = 0; i < insuranceProductItemList.size(); ++i) {
                        ProductItem productItem = new ProductItem();
                        productItem.setRiskCode(((InsuranceProductItem)insuranceProductItemList.get(i)).getRiskCode());
                        productItem.setRiskName(((InsuranceProductItem)insuranceProductItemList.get(i)).getRiskName());
                        productItemList.add(productItem);
                        returnMap.put("successFlag", true);
                        returnMap.put("errorCode", RESULT_SUCCESS);
                        returnMap.put("message", "\u6210\u529f");
                    }
                }
            } else if (insuranceProductItemList.size() != 0) {
                for (int i = 0; i < insuranceProductItemList.size(); ++i) {
                    ProductItem productItem = new ProductItem();
                    productItem.setRiskCode(((InsuranceProductItem)insuranceProductItemList.get(i)).getRiskCode());
                    productItem.setRiskName(((InsuranceProductItem)insuranceProductItemList.get(i)).getRiskName());
                    productItem.setProductCode(((InsuranceProductItem)insuranceProductItemList.get(i)).getProductCode());
                    productItem.setProductName(((InsuranceProductItem)insuranceProductItemList.get(i)).getProductName());
                    productItemList.add(productItem);
                    returnMap.put("successFlag", true);
                    returnMap.put("errorCode", RESULT_SUCCESS);
                    returnMap.put("message", "\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/api/salesman\u5931\u8d25", (Throwable)e);
            returnMap.put("errorCode", RESULT_FAIL);
        }
        returnMap.put("products", productItemList);
        return returnMap;
    }

    @RequestMapping(value={"/salesman"})
    @ResponseBody
    public Map<String, Object> findSalesman(HttpServletRequest request, String comcode) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List attachedsalesmanList = null;
        try {
            attachedsalesmanList = this.attachedsalesmanService.getAllAttachedsalesman(comcode);
            returnMap.put("successFlag", true);
            returnMap.put("errorCode", RESULT_SUCCESS);
            returnMap.put("message", "\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/api/salesman\u5931\u8d25", (Throwable)e);
            returnMap.put("errorCode", RESULT_FAIL);
        }
        returnMap.put("salesmans", attachedsalesmanList);
        System.out.println(JSON.toJSONString(returnMap));
        return returnMap;
    }

    @RequestMapping(value={"/findPersonnel"})
    @ResponseBody
    public Map<String, Object> findPersonnel(HttpServletRequest request, String recommendId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List cusRecommendPersonnelList = null;
        CusRecommend cusRecommend = new CusRecommend();
        try {
            if (!StringUtils.isEmpty((CharSequence)recommendId)) {
                cusRecommend = this.recommendService.findById(recommendId);
                if (!StringUtils.isEmpty((CharSequence)cusRecommend.getProposalNo())) {
                    cusRecommendPersonnelList = this.recommendPersonnelService.findPersonnel(recommendId);
                    returnMap.put("cusRecommendPersonnelList", cusRecommendPersonnelList);
                }
                returnMap.put("cusRecommend", cusRecommend);
                returnMap.put("successFlag", true);
                returnMap.put("errorCode", RESULT_SUCCESS);
                returnMap.put("message", "\u6210\u529f");
            } else {
                returnMap.put("successFlag", true);
                returnMap.put("errorCode", RESULT_FAIL);
                returnMap.put("message", "recommendId\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/api/salesman\u5931\u8d25", (Throwable)e);
            returnMap.put("errorCode", RESULT_FAIL);
        }
        System.out.println(JSON.toJSONString(returnMap));
        return returnMap;
    }
}

