/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.filter.InjectionAttackWrapper;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.RecommendRequestService;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.RecommendRequest;
import com.picc.gz.utils.Lang;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"policy"})
public class PolicyController {
    private static final Logger log = LoggerFactory.getLogger(PolicyController.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    @Autowired
    private CusRecommendService recommendService;
    @Autowired
    private RecommendRequestService recommendRequestService;

    @RequestMapping(value={"/pushPolicyNo.do"})
    @ResponseBody
    public String downDzfpUrl(HttpServletRequest request) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String policyNo = dataObject.getString("policyNo");
            String proposalNo = dataObject.getString("proposalNo");
            log.info(String.format("\u4e0b\u5355\u6613\u540e\u53f0\u63a8\u9001\uff1aproposalNo:%s, policyNo:%s", proposalNo, policyNo));
            if (Lang.isEmpty((Object)policyNo) || Lang.isEmpty((Object)proposalNo)) {
                returnMap.put(RESP_MSG, "\u8bf7\u6c42\u7684\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8bf7\u6c42");
                returnMap.put(RESP_CODE, RESULT_FAIL);
            } else {
                RecommendRequest recommendRequest = this.recommendRequestService.findByProposalNo(proposalNo);
                if (!Lang.isEmpty((Object)recommendRequest)) {
                    CusRecommend recommend = this.recommendService.findById(recommendRequest.getRecommendId());
                    if ("2".equals(recommend.getStatus()) && !Lang.isEmpty((Object)recommend.getPolicyNo())) {
                        returnMap.put(RESP_MSG, "\u4fdd\u5355\u53f7:" + recommend.getPolicyNo() + "\u5df2\u7ecf\u8f6c\u4fdd\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8bf7\u6c42");
                        returnMap.put(RESP_CODE, RESULT_FAIL);
                    } else {
                        this.recommendService.updatePolicy(recommendRequest.getRecommendId(), proposalNo, policyNo);
                        returnMap.put(RESP_MSG, "\u8bf7\u6c42\u6210\u529f");
                        returnMap.put(RESP_CODE, RESULT_SUCCESS);
                    }
                } else {
                    returnMap.put(RESP_MSG, "\u67e5\u8be2\u65e0\u6b64\u6295\u4fdd\u5355\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8bf7\u6c42");
                    returnMap.put(RESP_CODE, RESULT_FAIL);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/policy/pushPolicyNo.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_MSG, "\u8bf7\u6c42\u7684\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8bf7\u6c42");
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }
}

