/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chrhc.mybatis.autodate.util.DataTablesUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.HttpClientService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.SalesmanService;
import com.picc.gz.admin.service.SmsService;
import com.picc.gz.admin.vo.QuerySignSearchRequest;
import com.picc.gz.admin.vo.SmsVo;
import com.picc.gz.admin.vo.policy.PolicyQuery;
import com.picc.gz.admin.web.QueryPolicyController;
import com.picc.gz.model.model.CusRecommendPolicy;
import com.picc.gz.model.model.Salesman;
import com.picc.gz.model.util.PageRequest;
import com.picc.gz.model.util.Sort;
import com.picc.gz.utils.DateUtils;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.data.SpringMvcUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"query"})
public class QueryPolicyController {
    private static final Logger log = LoggerFactory.getLogger(QueryPolicyController.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    private static final String EPOLICY_FILE_NAME = "\u7535\u5b50\u4fdd\u5355.pdf";
    private static final String EINVOICE_FILE_NAME = "\u7535\u5b50\u53d1\u7968.pdf";
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SalesmanService salesmanService;
    @Autowired
    private InsuranceProductItemService insuranceProductItemService;
    @Autowired
    private CusRecommendService cusRecommendService;
    @Value(value="${yeePay.downDzfpUrl}")
    private String downDzfpUrl;
    ThreadFactory downloadFileThreadFactory = new ThreadFactoryBuilder().setNameFormat("file-download-pool-%d").build();
    ExecutorService downloadFileThreadPool = new ThreadPoolExecutor(5, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), this.downloadFileThreadFactory, new ThreadPoolExecutor.AbortPolicy());

    @RequestMapping(value={"/queryPolicy.do"})
    public String queryPolicy(HttpServletRequest request, Model model, String tsUserCode) {
        model.addAttribute("insuranceStartDate", (Object)DateUtils.getNow());
        tsUserCode = InjectionAttackWrapperDataStr.getDataStr((String)tsUserCode);
        model.addAttribute("tsUserCode", (Object)tsUserCode);
        return "query/queryPolicy";
    }

    @RequestMapping(value={"/policyDownloadSms.do"})
    @ResponseBody
    public String policyDownloadSms(HttpServletRequest request, String recommendId) {
        Map<String, String> returnMap = new HashMap();
        try {
            recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
            returnMap = this.getPolicyDownloadSms(recommendId);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/query/policyDownloadSms.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/downDzfpUrl.do"})
    @ResponseBody
    public String downDzfpUrl(HttpServletRequest request, String policyNo, String requestId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            policyNo = InjectionAttackWrapperDataStr.getDataStr((String)policyNo);
            requestId = InjectionAttackWrapperDataStr.getDataStr((String)requestId);
            JSONObject respJsonObject = this.getDownDzfpUrl(policyNo, requestId);
            String resultMsg = respJsonObject.getString("resultMsg");
            if ("success".equals(resultMsg)) {
                returnMap.put("dzfpUrl", respJsonObject.getString("dzfpUrl"));
                returnMap.put(RESP_CODE, RESULT_SUCCESS);
            } else {
                returnMap.put(RESP_CODE, RESULT_FAIL);
            }
            returnMap.put(RESP_MSG, respJsonObject.getString("message"));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/query/downDzfpUrl.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    private JSONObject getDownDzfpUrl(String policyNo, String requestId) {
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("policyNo", policyNo));
        formParams.add(new BasicNameValuePair("requestUUID", requestId));
        String respStr = this.httpClientService.getHttpRequest(this.downDzfpUrl, formParams);
        JSONObject respJsonObject = JSONObject.parseObject((String)respStr);
        return respJsonObject;
    }

    private Map getPolicyDownloadSms(String recommendId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String smsContent = "";
        SmsVo smsVo = new SmsVo();
        PolicyQuery policyQuery = new PolicyQuery();
        policyQuery.setRecommendId(recommendId);
        List cusRecommendPolicies = this.cusRecommendService.queryPolicy(policyQuery);
        CusRecommendPolicy cusRecommendPolicy = new CusRecommendPolicy();
        if (cusRecommendPolicies.size() > 0) {
            cusRecommendPolicy = (CusRecommendPolicy)cusRecommendPolicies.get(0);
        }
        smsVo.setDownloadUrl(cusRecommendPolicy.getDownloadUrl());
        JSONObject respJsonObject = this.getDownDzfpUrl(cusRecommendPolicy.getPolicyNo(), cusRecommendPolicy.getRequestId());
        String resultMsg = respJsonObject.getString("resultMsg");
        if ("success".equals(resultMsg)) {
            smsVo.setDownDzfpUrl(respJsonObject.getString("dzfpUrl"));
        }
        try {
            smsContent = this.smsService.getSmsByBusinessTypeTemplate("policyDownload", recommendId, smsVo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        if (Lang.isEmpty((Object)smsVo.getDownloadUrl())) {
            returnMap.put("downloadUrlEmpty", "1");
        } else {
            returnMap.put("downloadUrlEmpty", "0");
        }
        if (Lang.isEmpty((Object)smsVo.getDownDzfpUrl())) {
            returnMap.put("downDzfpUrlEmpty", "1");
        } else {
            returnMap.put("downDzfpUrlEmpty", "0");
        }
        returnMap.put("smsContent", smsContent);
        return returnMap;
    }

    @RequestMapping(value={"/queryPolicySearch.do"})
    @ResponseBody
    public Object queryPolicySearch(HttpServletRequest request) {
        PageInfo page = this.getCusRecommendPolicyPageInfo(request);
        return DataTablesUtils.pageInfoToDataTables((PageInfo)page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/epolicyBatchDownload.do"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> batchEpolicyDownload(HttpServletRequest request) throws IOException {
        PageInfo page = this.getCusRecommendPolicyPageInfo(request);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(60000).build()).build();
        Object httpResponse = null;
        Object httpEntity = null;
        ArrayList<EpolicyFileEntity> epoliycFileByteArrayList = new ArrayList<EpolicyFileEntity>();
        ArrayList<Future<EpolicyFileEntity>> futures = new ArrayList<Future<EpolicyFileEntity>>();
        for (CusRecommendPolicy cusRecommendPolicy : page.getList()) {
            String epolicyKey = String.format("%s%s", cusRecommendPolicy.getName(), cusRecommendPolicy.getPolicyNo());
            futures.add(this.downloadFileThreadPool.submit(() -> this.lambda$batchEpolicyDownload$0(cusRecommendPolicy, epolicyKey, (HttpClient)httpClient)));
            futures.add(this.downloadFileThreadPool.submit(() -> this.lambda$batchEpolicyDownload$1(cusRecommendPolicy, epolicyKey, (HttpClient)httpClient)));
        }
        for (Future future : futures) {
            try {
                EpolicyFileEntity result = (EpolicyFileEntity)future.get();
                if (result == null) continue;
                epoliycFileByteArrayList.add(result);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        Map<String, List<EpolicyFileEntity>> epolicyMaps = epoliycFileByteArrayList.stream().collect(Collectors.groupingBy(EpolicyFileEntity::getGroupKey));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)byteArrayOutputStream);
        zipOutputStream.setEncoding("GBK");
        try {
            ResponseEntity resourceResponseEntity;
            for (Map.Entry<String, List<EpolicyFileEntity>> entry : epolicyMaps.entrySet()) {
                for (EpolicyFileEntity epolicyFile : entry.getValue()) {
                    if (epolicyFile.getFile().length <= 0) continue;
                    zipOutputStream.putNextEntry(new ZipEntry(entry.getKey() + File.separator + epolicyFile.getFileName()));
                    zipOutputStream.write(epolicyFile.getFile());
                    zipOutputStream.flush();
                }
            }
            zipOutputStream.close();
            byteArrayOutputStream.close();
            ResponseEntity responseEntity = resourceResponseEntity = SpringMvcUtils.downloadResponse((String)"\u6279\u91cf\u4e0b\u8f7d.zip", (byte[])byteArrayOutputStream.toByteArray());
            return responseEntity;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return null;
    }

    @RequestMapping(value={"/querySign.do"})
    public String querySign(HttpServletRequest request, Model model, String tsUserCode) {
        Calendar now = Calendar.getInstance();
        model.addAttribute("insuranceStartDate", (Object)now.getTime());
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.set(11, 0);
        tomorrow.set(12, 0);
        tomorrow.set(13, 0);
        tomorrow.add(5, 1);
        model.addAttribute("insuranceEndDate", (Object)tomorrow.getTime());
        tsUserCode = InjectionAttackWrapperDataStr.getDataStr((String)tsUserCode);
        model.addAttribute("tsUserCode", (Object)tsUserCode);
        model.addAttribute("allRiskCodes", (Object)this.insuranceProductItemService.getRiskCodeList());
        return "query/querySign";
    }

    @RequestMapping(value={"/querySignSearch.do"})
    @ResponseBody
    public Object querySignSearch(QuerySignSearchRequest searchRequest, HttpServletRequest request) {
        PageRequest pageRequest = DataTablesUtils.getPageRequest((HttpServletRequest)request, (Sort)new Sort((List)new /* Unavailable Anonymous Inner Class!! */));
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(searchRequest.getInsureDateEnd());
        endDate.set(11, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.add(5, 1);
        searchRequest.setInsureDateEnd(endDate.getTime());
        PageInfo page = this.cusRecommendService.querySigned(searchRequest, pageRequest);
        return DataTablesUtils.pageInfoToDataTables((PageInfo)page);
    }

    protected PageInfo<CusRecommendPolicy> getCusRecommendPolicyPageInfo(HttpServletRequest request) {
        PageRequest pageRequest = DataTablesUtils.getPageRequest((HttpServletRequest)request, (Sort)new Sort((List)new /* Unavailable Anonymous Inner Class!! */));
        PolicyQuery policyQuery = new PolicyQuery();
        HashMap requestMap = new HashMap(request.getParameterMap());
        String tsUserCode = DataTablesUtils.getString(requestMap, (String)"tsUserCode", (String)"");
        String insuranceDate = DataTablesUtils.getString(requestMap, (String)"insuranceDate", (String)"");
        String insuranceStartDate = DataTablesUtils.getString(requestMap, (String)"insuranceStartDate", (String)"");
        String insuranceEndDate = DataTablesUtils.getString(requestMap, (String)"insuranceEndDate", (String)"");
        String name = DataTablesUtils.getString(requestMap, (String)"name", (String)"");
        String licenseNo = DataTablesUtils.getString(requestMap, (String)"licenseNo", (String)"");
        ArrayList<String> tsUserCodes = new ArrayList<String>();
        Salesman salesman = this.salesmanService.findByUsercode(tsUserCode);
        List salesmans = this.salesmanService.findAllMembersByUsercode(tsUserCode);
        String salesmanType = "A";
        String salesmanComcode = "";
        for (Salesman sm : salesmans) {
            tsUserCodes.add(sm.getUsercode());
        }
        if (salesman != null) {
            salesmanType = salesman.getPosttype();
            if (!Lang.isEmpty((Object)salesman.getComcode())) {
                salesmanComcode = salesman.getComcode().substring(0, 4);
            }
        }
        if ("-1".equals(insuranceDate)) {
            if (!Lang.isEmpty((Object)insuranceStartDate)) {
                policyQuery.setPolicyTimeStart(DateUtils.longStrToDate((String)(insuranceStartDate + " 00:00:00")));
            }
            if (!Lang.isEmpty((Object)insuranceEndDate)) {
                policyQuery.setPolicyTimeEnd(DateUtils.longStrToDate((String)(insuranceEndDate + " 23:59:59")));
            }
        } else if ("0".equals(insuranceDate)) {
            policyQuery.setPolicyTimeStart(DateUtils.longStrToDate((String)(DateUtils.getStringDateShort() + " 00:00:00")));
            policyQuery.setPolicyTimeEnd(DateUtils.longStrToDate((String)(DateUtils.getStringDateShort() + " 23:59:59")));
        } else if ("6".equals(insuranceDate)) {
            policyQuery.setPolicyTimeStart(DateUtils.strToDate((String)(DateUtils.getTimeBeforeORAfter((int)0, (int)0, (int)-6) + " 00:00:00")));
            policyQuery.setPolicyTimeEnd(DateUtils.longStrToDate((String)(DateUtils.getStringDateShort() + " 23:59:59")));
        }
        if (!Lang.isEmpty((Object)name)) {
            policyQuery.setName(name);
        }
        if (!Lang.isEmpty((Object)licenseNo)) {
            policyQuery.setLicenseNo(licenseNo);
        }
        if (("M".equals(salesmanType) || "S".equals(salesmanType)) && !Lang.isEmpty((Object)salesmanComcode)) {
            policyQuery.setComCode(salesmanComcode + "%");
        } else if ("L".equals(salesmanType) && !Lang.isEmpty((Object)salesmanComcode)) {
            policyQuery.setTsUserCode(tsUserCodes);
        } else {
            tsUserCodes = new ArrayList();
            tsUserCodes.add(tsUserCode);
            policyQuery.setTsUserCode(tsUserCodes);
        }
        policyQuery.setIsOuter(Boolean.valueOf(false));
        policyQuery.setIsShort(Boolean.valueOf(false));
        return this.cusRecommendService.queryPolicy(policyQuery, pageRequest);
    }

    private /* synthetic */ EpolicyFileEntity lambda$batchEpolicyDownload$1(CusRecommendPolicy policy, String epolicyKey, HttpClient httpClient) throws Exception {
        String resultMsg;
        JSONObject respJsonObject = this.getDownDzfpUrl(policy.getPolicyNo(), policy.getRequestId());
        if (respJsonObject != null && "success".equals(resultMsg = respJsonObject.getString("resultMsg"))) {
            HttpGet httpGet = new HttpGet(respJsonObject.getString("dzfpUrl"));
            try {
                return new EpolicyFileEntity(this, epolicyKey, EINVOICE_FILE_NAME, IOUtils.toByteArray((InputStream)httpClient.execute((HttpUriRequest)httpGet).getEntity().getContent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private /* synthetic */ EpolicyFileEntity lambda$batchEpolicyDownload$0(CusRecommendPolicy policy, String epolicyKey, HttpClient httpClient) throws Exception {
        HttpGet httpGet = new HttpGet(policy.getDownloadUrl());
        try {
            return new EpolicyFileEntity(this, epolicyKey, EPOLICY_FILE_NAME, IOUtils.toByteArray((InputStream)httpClient.execute((HttpUriRequest)httpGet).getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

