/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.dao.CusRecommendSalerMapper;
import com.picc.gz.admin.factory.ShortenUrlSupplierFactory;
import com.picc.gz.admin.filter.InjectionAttackWrapper;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.AddressService;
import com.picc.gz.admin.service.CusRecommendExtAttrService;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.DuplicateRequestDefender;
import com.picc.gz.admin.service.FeeRateService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.InsurePolicyService;
import com.picc.gz.admin.service.RenewalService;
import com.picc.gz.admin.service.SalerSelectorFactory;
import com.picc.gz.admin.service.SalesmanService;
import com.picc.gz.admin.service.SmsService;
import com.picc.gz.admin.service.SmsTemplateService;
import com.picc.gz.admin.service.ZXingService;
import com.picc.gz.admin.vo.SmsVo;
import com.picc.gz.admin.vo.insure.EauRequiredInfo;
import com.picc.gz.admin.vo.insure.JabRequiredInfo;
import com.picc.gz.admin.vo.insure.JebRequiredInfo;
import com.picc.gz.admin.vo.insure.LdoRequiredInfo;
import com.picc.gz.admin.vo.insure.SignatureRequest;
import com.picc.gz.model.model.Address;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.CusRecommendSaler;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.InsureDO;
import com.picc.gz.model.model.InsureRiskSalesRate;
import com.picc.gz.model.model.Salesman;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import com.picc.gz.utils.DateUtils;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.MD5Utils;
import com.picc.gz.utils.data.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reinsurance"})
public class ReinsuranceController {
    private static final Logger log = LoggerFactory.getLogger(ReinsuranceController.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    public static final String CUSTOMER_SIGN_TYPE_SIGNONLY = "1";
    public static final String CUSTOMER_SIGN_TYPE_SIGNANDPAY = "2";
    public static final String SIGN_REMIND_URL_CUSTOMER = "/reinsurance/signature.do";
    public static final String SIGN_REMIND_URL_CUSTOMER_HEALTH = "/reinsurance/health.do";
    public static final String SIGN_REMIND_URL_VIEW = "/reinsurance/signature/view.do";
    @Autowired
    private InsurePolicyService insurePolicyService;
    @Autowired
    private InsuranceProductItemService productItemService;
    @Autowired
    private CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    private CusRecommendService recommendService;
    @Autowired
    private CusRecommendExtAttrService extAttrService;
    @Autowired
    private ShortenUrlSupplierFactory shortenUrlSupplierFactory;
    @Autowired
    private ZXingService zXingService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private DuplicateRequestDefender duplicateRequestDefender;
    @Autowired
    private AddressService addressService;
    @Autowired
    private SalesmanService salesmanService;
    @Autowired
    RenewalService renewalService;
    @Autowired
    public FeeRateService feeRateService;
    @Autowired
    private CusRecommendSalerMapper cusRecommendSalerMapper;
    @Autowired
    private SalerSelectorFactory salerSelectorFactory;
    @Value(value="${reinsurance.basicUrl}")
    private String basicUrl;
    @Value(value="${reinsurance.protocol}")
    private String scheme;
    @Value(value="${signature.basicUrl}")
    private String signBasicUrl;
    @Value(value="${signature.protocol}")
    private String signProtocol;
    @Value(value="${signature.shorten}")
    private Boolean signShorten;
    private static ExecutorService sendSmsExecutorService = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    @RequestMapping(value={"/productInfo.do"})
    public String productInfo(HttpServletRequest request, Model model, String recommendId) {
        if (!Lang.isEmpty((Object)recommendId)) {
            recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        }
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        this.recommendService.updateStatus(recommendId, "01");
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        String postCode = this.recommendPersonnelService.getPostCode(insuredInfo);
        postCode = InjectionAttackWrapperDataStr.getDataStr((String)postCode);
        model.addAttribute("insuredPostCode", (Object)postCode);
        model.addAttribute("insuredInfo", (Object)insuredInfo);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        model.addAttribute("beneficiary", (Object)beneficiary);
        Map requiredInfo = this.extAttrService.findExtAttrInfo(recommendId);
        model.addAttribute("requiredInfo", (Object)requiredInfo);
        if ("EAU".equals(recommend.getRealRiskCode())) {
            String vehicleSeat = (String)requiredInfo.get("vehicleSeat");
            if (Lang.isEmpty((Object)vehicleSeat)) {
                requiredInfo.put("vehicleSeat", "5");
            }
            model.addAttribute("requiredInfo", (Object)requiredInfo);
        }
        if ("EAU".equals(recommend.getRiskCode())) {
            return "accident/anyDriveInfo";
        }
        if ("EDD".equals(recommend.getRiskCode())) {
            return "accident/relievedInfo";
        }
        if ("YEL".equals(recommend.getRiskCode())) {
            return "accident/withCarInfo";
        }
        if ("LDO".equals(recommend.getRiskCode())) {
            return "accident/fullHouse";
        }
        if ("ZCI".equals(recommend.getRiskCode())) {
            return "accident/fittingInfo";
        }
        if ("ZFO".equals(recommend.getRiskCode())) {
            return "accident/zfo";
        }
        if ("JEB".equals(recommend.getRiskCode())) {
            return "accident/jeb";
        }
        if ("WCD".equals(recommend.getRiskCode())) {
            return "reinsurance/wcd";
        }
        if ("ECD".equals(recommend.getRiskCode())) {
            return "reinsurance/ecd";
        }
        if ("WBK_2".equals(recommend.getRiskCode()) || "WBK".equals(recommend.getRiskCode())) {
            return "reinsurance/productInfo";
        }
        return "accident/" + recommend.getRiskCode().toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/baseInfo.do"})
    public String baseInfo(HttpServletRequest request, Model model, String recommendId) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        this.recommendService.updateStatus(recommendId, "03");
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        model.addAttribute("insuredInfo", (Object)insuredInfo);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        model.addAttribute("beneficiary", (Object)beneficiary);
        Map requiredInfo = this.extAttrService.findExtAttrInfo(recommendId);
        model.addAttribute("requiredInfo", (Object)requiredInfo);
        try {
            if (!Lang.isEmpty((Object)recommend.getYeePayUrl())) {
                String payUrlBase64 = this.zXingService.generateZxingCodeBase64(recommend.getYeePayUrl(), recommend.getQrHash());
                payUrlBase64 = InjectionAttackWrapperDataStr.getDataStr((String)payUrlBase64);
                model.addAttribute("payUrlBase64", (Object)payUrlBase64);
            }
            if (!"EAU".equals(recommend.getRealRiskCode()) && !"YEL".equals(recommend.getRealRiskCode()) && !"EDD".equals(recommend.getRealRiskCode()) && !"WBK".equals(recommend.getRiskCode()) && !"WBK_2".equals(recommend.getRiskCode()) && !"LDO".equals(recommend.getRealRiskCode()) && !"ZCI".equals(recommend.getRealRiskCode())) return "accident/sumbitInfo";
        }
        catch (Exception e) {
            log.error("baseInfo.do\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
            return "accident/sumbitInfo";
        }
        return "accident/sumbitInfo";
    }

    @RequestMapping(value={"/insurance.do"})
    public String insurance(HttpServletRequest request, Model model, String recommendId) {
        String vehicleSeat;
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        model.addAttribute("recommend", (Object)recommend);
        this.recommendService.updateStatus(recommendId, CUSTOMER_SIGN_TYPE_SIGNONLY);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        model.addAttribute("insuredInfo", (Object)insuredInfo);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        model.addAttribute("beneficiary", (Object)beneficiary);
        Map requiredInfo = this.extAttrService.findExtAttrInfo(recommendId);
        model.addAttribute("requiredInfo", (Object)requiredInfo);
        if ("EAU".equals(recommend.getRealRiskCode()) && Lang.isEmpty((Object)(vehicleSeat = (String)requiredInfo.get("vehicleSeat")))) {
            requiredInfo.put("vehicleSeat", "5");
        }
        if ("EAU".equals(recommend.getRiskCode())) {
            return "cusIdentity/anyDriveInfo";
        }
        if ("EDD".equals(recommend.getRiskCode())) {
            return "cusIdentity/relievedInfo";
        }
        if ("WBK".equals(recommend.getRiskCode()) || "WBK_2".equals(recommend.getRiskCode())) {
            return "cusIdentity/productInfo";
        }
        if ("YEL".equals(recommend.getRiskCode())) {
            return "cusIdentity/withCarInfo";
        }
        if ("LDO".equals(recommend.getRiskCode())) {
            return "cusIdentity/fullHouse";
        }
        if ("ZCI".equals(recommend.getRiskCode())) {
            return "cusIdentity/fittingInfo";
        }
        if ("WCD".equals(recommend.getRiskCode())) {
            return "cusIdentity/wcd";
        }
        if ("ECD".equals(recommend.getRiskCode())) {
            return "cusIdentity/ecd";
        }
        return "cusIdentity/" + recommend.getRiskCode().toLowerCase();
    }

    private String getInsureSuccessContent(HttpServletRequest request, String recommendId, String cusSignType) {
        CusRecommend recommend = this.recommendService.findById(recommendId);
        String smsContent = "";
        if ("WBK".equals(recommend.getRealRiskCode()) || "WBK_2".equals(recommend.getRiskCode())) {
            String customerUri = "";
            customerUri = CUSTOMER_SIGN_TYPE_SIGNANDPAY.equals(cusSignType) ? SIGN_REMIND_URL_CUSTOMER_HEALTH : SIGN_REMIND_URL_CUSTOMER;
            String url = String.format("%s://%s%s%s?recommendId=%s", this.signProtocol, this.signBasicUrl, request.getContextPath(), customerUri, recommendId);
            String shortUrl = this.shortenUrlSupplierFactory.get().shortenUrl(url);
            SmsVo smsVo = new SmsVo();
            smsVo.setShortUrl(Lang.isEmpty((Object)shortUrl) ? url : shortUrl);
            try {
                smsContent = this.smsService.getSmsByBusinessTypeTemplate("needSignRemind", recommendId, smsVo);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            this.recommendService.resetSignUrl(recommendId);
        } else {
            String basePath = this.scheme + "://" + this.basicUrl + request.getContextPath() + "/";
            String redirectUrl = basePath + "reinsurance/baseInfo.do?recommendId=" + recommendId;
            String shortUrl = this.shortenUrlSupplierFactory.get().shortenUrl(redirectUrl);
            SmsVo smsVo = new SmsVo();
            smsVo.setShortUrl(Lang.isEmpty((Object)shortUrl) ? redirectUrl : shortUrl);
            try {
                smsContent = this.smsService.getSmsByBusinessTypeTemplate("insureSuccess", recommendId, smsVo);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return smsContent;
    }

    @RequestMapping(value={"/insureSms.do"})
    public String insureSms(HttpServletRequest request, Model model, String recommendId, Integer renewFlag) {
        String smsContent = this.getInsureSuccessContent(request, recommendId, CUSTOMER_SIGN_TYPE_SIGNONLY);
        smsContent = InjectionAttackWrapperDataStr.getDataStr((String)smsContent);
        CusRecommend recommend = this.recommendService.findById(recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId));
        if (recommend.getRiskCode().startsWith("W")) {
            model.addAttribute("smsContentSignSelfhelp", (Object)this.getInsureSuccessContent(request, recommendId, CUSTOMER_SIGN_TYPE_SIGNANDPAY));
            model.addAttribute("smsContentSignOnly", (Object)smsContent);
        }
        this.recommendService.updateStatus(recommendId, "03");
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        model.addAttribute("recommendId", (Object)recommendId);
        model.addAttribute("smsContent", (Object)smsContent);
        model.addAttribute("mobile", (Object)applicantInfo.getMobile());
        model.addAttribute("renewFlag", (Object)renewFlag);
        try {
            if (!Lang.isEmpty((Object)recommend.getYeePayUrl())) {
                String payUrlBase64 = this.zXingService.generateZxingCodeBase64(recommend.getYeePayUrl(), recommend.getQrHash());
                payUrlBase64 = InjectionAttackWrapperDataStr.getDataStr((String)payUrlBase64);
                model.addAttribute("payUrlBase64", (Object)payUrlBase64);
            }
        }
        catch (Exception e) {
            log.error("baseInfo.do\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
        }
        if ("EAU".equals(recommend.getRealRiskCode())) {
            EauRequiredInfo eauRequiredInfo = this.extAttrService.findEauInfoByRecommendId(recommendId);
            model.addAttribute("requiredInfo", (Object)eauRequiredInfo);
            return "cusIdentity/insureSms";
        }
        if ("EDD".equals(recommend.getRiskCode())) {
            return "cusIdentity/insureSms";
        }
        if ("LDO".equals(recommend.getRiskCode())) {
            return "cusIdentity/insureSms";
        }
        if ("ZCI".equals(recommend.getRiskCode())) {
            return "cusIdentity/insureSms";
        }
        if ("WBK".equals(recommend.getRiskCode()) || "WBK_2".equals(recommend.getRiskCode())) {
            return "cusIdentity/insureSms";
        }
        return "cusIdentity/insureSms";
    }

    @RequestMapping(value={"/payQrView.do"})
    public String payQrView(HttpServletRequest request, Model model, String recommendId) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        model.addAttribute("recommendId", (Object)recommendId);
        model.addAttribute("mobile", (Object)applicantInfo.getMobile());
        try {
            if (!Lang.isEmpty((Object)recommend.getYeePayUrl())) {
                String payUrlBase64 = this.zXingService.generateZxingCodeBase64(recommend.getYeePayUrl(), recommend.getQrHash());
                payUrlBase64 = InjectionAttackWrapperDataStr.getDataStr((String)payUrlBase64);
                model.addAttribute("payUrlBase64", (Object)payUrlBase64);
            }
        }
        catch (Exception e) {
            log.error("payQrView.do\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
        }
        if ("EAU".equals(recommend.getRealRiskCode())) {
            EauRequiredInfo eauRequiredInfo = this.extAttrService.findEauInfoByRecommendId(recommendId);
            model.addAttribute("requiredInfo", (Object)eauRequiredInfo);
        }
        return "cusIdentity/payQrView";
    }

    @RequestMapping(value={"/checkCusSign.do"})
    @ResponseBody
    public Map<String, Object> checkCusSign(HttpServletRequest request, Model model, String recommendId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        String signUrl = this.recommendService.getSignImage(recommendId);
        returnMap.put(RESP_CODE, RESULT_SUCCESS);
        Boolean signFlag = !StringUtils.isEmpty((Object)signUrl);
        if (signFlag.booleanValue()) {
            returnMap.put("signUrl", signUrl);
        }
        returnMap.put("signFlag", signFlag);
        return returnMap;
    }

    @RequestMapping(value={"/sendInsureSms.do"})
    @ResponseBody
    public String sendInsureSms(HttpServletRequest request, String recommendId, String mobile) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        String smsContent = this.getInsureSuccessContent(request, recommendId, CUSTOMER_SIGN_TYPE_SIGNONLY);
        try {
            this.smsService.sendSms(smsContent, mobile);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/query/sendInsureSms.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/getProductItem.do"})
    @ResponseBody
    public String getProductItem(HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String applicantIsSocialSe = dataObject.getString("applicantIsSocialSe");
            String age = dataObject.getString("age");
            String amountSelect = dataObject.getString("amountSelect");
            String recommendId = dataObject.getString("recommendId");
            List<InsuranceProductItem> results = new ArrayList();
            CusRecommend cusRecommend = this.recommendService.findById(recommendId);
            String a = dataObject.getString("a");
            String mostPerson = null;
            if (cusRecommend.getRealRiskCode().equals("ECD")) {
                results = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelectECD(applicantIsSocialSe, amountSelect);
            } else if (cusRecommend.getRealRiskCode().equals("WCD")) {
                mostPerson = Integer.valueOf(a) <= 2 ? "4" : "7";
                results = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelectWCD(applicantIsSocialSe, age, amountSelect, mostPerson);
            } else {
                results = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelect(applicantIsSocialSe, age, amountSelect);
            }
            if (a != null) {
                String applicantIsSocialSe6 = dataObject.getString("applicantIsSocialSe6");
                String age6 = dataObject.getString("age6");
                List productItem1 = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelectWCD(applicantIsSocialSe6, age6, amountSelect, mostPerson);
                InsuranceProductItem productItem = (InsuranceProductItem)results.get(0);
                double price = 0.0;
                if (!a.equals("0")) {
                    int p = Integer.valueOf(a);
                    for (int i = 1; i <= p; ++i) {
                        List items;
                        String applicantlsSocialSe0 = dataObject.getString("applicantIsSocialSe" + i);
                        String age0 = dataObject.getString("age" + i);
                        if (StringUtils.isEmpty((Object)applicantlsSocialSe0) || StringUtils.isEmpty((Object)age0) || (items = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelectWCD(applicantlsSocialSe0, age0, amountSelect, mostPerson)).size() <= 0) continue;
                        Double price1 = Double.valueOf(((InsuranceProductItem)items.get(0)).getInsurancePremium());
                        price = price1 + price;
                    }
                }
                price = price + Double.valueOf(productItem.getInsurancePremium()) + Double.valueOf(((InsuranceProductItem)productItem1.get(0)).getInsurancePremium());
                productItem.setInsurancePremium(String.valueOf(price));
                results = new ArrayList();
                results.add(productItem);
            }
            returnMap.put("productItem", results);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/getProductItem.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_MSG, e.getLocalizedMessage());
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/getProductItemRate.do"})
    @ResponseBody
    public String getProductItemRate(HttpServletRequest request) throws IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String recommendId = dataObject.getString("recommendId");
            String productItemCode = dataObject.getString("productItemCode");
            String idNumber = dataObject.getString("idNumber");
            ArrayList results = new ArrayList();
            CusRecommend cusRecommend = this.recommendService.findById(recommendId);
            Salesman salesman = this.salesmanService.findByUsercode(cusRecommend.getTsUserCode());
            CusRecommendSaler salerQueryTpl = new CusRecommendSaler();
            salerQueryTpl.setIsDelete(Integer.valueOf(0));
            salerQueryTpl.setRecommendId(recommendId);
            salerQueryTpl.setVersion(null);
            List salers = this.cusRecommendSalerMapper.select((Object)salerQueryTpl);
            CusRecommendSaler saler = new CusRecommendSaler();
            if (!StringUtils.isEmpty((Object)productItemCode)) {
                InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
                saler = this.salerSelectorFactory.get().select(salers, new BigDecimal(productItem.getInsurancePremium()));
            }
            if (saler.getSellfeerate() > 0) {
                CusRecommendPersonnel insurer = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
                boolean renewFlag = false;
                boolean claimFlag = false;
                String feeRate = null;
                if (cusRecommend.getRiskCode().equals("EAU")) {
                    InsureRiskSalesRate insureRiskSalesRate;
                    String riskCode = cusRecommend.getRiskCode();
                    if (!String.valueOf(saler.getSellfeerate()).equals("0") && (insureRiskSalesRate = this.feeRateService.findByRiskCode(salesman.getComcode(), riskCode, productItemCode)) != null) {
                        feeRate = String.valueOf(insureRiskSalesRate.getSalesRate().intValue());
                    }
                } else if (!StringUtils.isEmpty((Object)idNumber)) {
                    List insureDOList = this.renewalService.getRenewal(idNumber, cusRecommend.getRealRiskCode());
                    if (insureDOList != null && insureDOList.size() > 0) {
                        InsureRiskSalesRate rate;
                        Integer lastClaimFlag;
                        insureDOList.sort((o1, o2) -> o2.getEnddate().compareTo(o1.getEnddate()));
                        InsureDO lastInsure = (InsureDO)insureDOList.get(0);
                        InsuranceProductItem insuranceProductItem = this.productItemService.findByProductCode(productItemCode);
                        LocalDateTime lastEndDate = LocalDateTime.ofInstant(lastInsure.getEnddate().toInstant(), ZoneId.systemDefault()).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        LocalDateTime curStartDate = LocalDateTime.ofInstant(cusRecommend.getInsuranceStartDate().toInstant(), ZoneId.systemDefault()).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        if (!StringUtils.isEmpty((Object)insuranceProductItem)) {
                            LocalDateTime limitedEndDate = lastEndDate.plusDays(insuranceProductItem.getEnddateLimits() + 1);
                            renewFlag = !limitedEndDate.isBefore(curStartDate);
                        }
                        if ((lastClaimFlag = Integer.valueOf((lastClaimFlag = lastInsure.getFlagLp()) == null ? 0 : lastClaimFlag)) > 0) {
                            claimFlag = true;
                        }
                        if (saler != null && !String.valueOf(saler.getSellfeerate()).equals("0") && (rate = this.feeRateService.findByProduct(salesman.getComcode(), cusRecommend.getRiskCode(), productItemCode, Boolean.valueOf(renewFlag), Boolean.valueOf(claimFlag))) != null) {
                            feeRate = String.valueOf(rate.getSalesRate().intValue());
                        }
                    } else {
                        InsureRiskSalesRate rate = this.feeRateService.findByProduct(salesman.getComcode(), cusRecommend.getRiskCode(), productItemCode, Boolean.valueOf(false), Boolean.valueOf(false));
                        if (rate != null) {
                            feeRate = String.valueOf(rate.getSalesRate().intValue());
                        }
                    }
                } else {
                    InsureRiskSalesRate rate = this.feeRateService.findByProduct(salesman.getComcode(), cusRecommend.getRiskCode(), productItemCode, Boolean.valueOf(false), Boolean.valueOf(false));
                    if (rate != null) {
                        feeRate = String.valueOf(rate.getSalesRate().intValue());
                    }
                }
                if (feeRate != null) {
                    returnMap.put("feeRate", feeRate);
                } else {
                    returnMap.put("feeRate", saler.getSellfeerate());
                }
            } else {
                returnMap.put("feeRate", 0);
            }
            returnMap.put("comCode", salesman.getComcode().substring(0, 4));
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/getProductItemRate.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_MSG, e.getLocalizedMessage());
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/getAccidentItems.do"})
    @ResponseBody
    public String getAccidentItems(HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String recommendId = dataObject.getString("recommendId");
            CusRecommend recommend = this.recommendService.findById(recommendId);
            List productItems = this.productItemService.findByRiskCode(recommend.getRiskCode());
            returnMap.put("productItems", productItems);
            Salesman salesman = this.salesmanService.findByUsercode(recommend.getTsUserCode());
            returnMap.put("comCode", salesman.getComcode().substring(0, 4));
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/getProductItem.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/selectAccidentItem.do"})
    @ResponseBody
    public String selectAccidentItem(HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String productItemCode = dataObject.getString("productItemCode");
            InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
            returnMap.put("productItem", productItem);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/getProductItem.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/insureBaseInfo.do"})
    @ResponseBody
    public String insureBaseInfo(HttpServletRequest request) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            String safeDataStr = InjectionAttackWrapper.filtXss((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)safeDataStr);
            String name = dataObject.getString("name");
            String idType = dataObject.getString("idType");
            String idNumber = dataObject.getString("idNumber");
            String mobile = dataObject.getString("mobile");
            String email = dataObject.getString("email");
            String gender = dataObject.getString("gender");
            String birthDay = dataObject.getString("birthDay");
            String inCityInfo = dataObject.getString("inCityInfo");
            String province = dataObject.getString("province");
            String city = dataObject.getString("city");
            String area = dataObject.getString("area");
            String address = dataObject.getString("address");
            String insuredIdentity = dataObject.getString("insuredIdentity");
            String applicantIsSocialSe = dataObject.getString("applicantIsSocialSe");
            String recommendId = dataObject.getString("recommendId");
            String insuranceStartDate = dataObject.getString("insuranceStartDate");
            String insuranceEndDate = dataObject.getString("insuranceEndDate");
            String productItemCode = dataObject.getString("productItemCode");
            log.info("insureBaseInfo.do \u8bf7\u6c42\uff0crequestId:{}\uff0crecommendId:{}", (Object)request.getRequestedSessionId(), (Object)recommendId);
            String processingKey = String.format("%s_%s_%s", "insureBaseInfo", recommendId, MD5Utils.encode((String)dataStr));
            BaseResponse baseResponse = this.duplicateRequestDefender.getResult(processingKey);
            if (baseResponse != null) {
                if (baseResponse.getSuccessFlag().booleanValue()) {
                    returnMap.put(RESP_CODE, RESULT_SUCCESS);
                } else {
                    returnMap.put(RESP_CODE, RESULT_FAIL);
                    returnMap.put(RESP_MSG, baseResponse.getMessage());
                }
            } else {
                this.duplicateRequestDefender.startProcessing(processingKey);
                CusRecommend cusRecommend = this.recommendService.findById(recommendId);
                cusRecommend.setProductItemCode(productItemCode);
                cusRecommend.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                cusRecommend.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                this.recommendService.saveCusRecommend(cusRecommend);
                CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
                insuredInfo.setName(name);
                insuredInfo.setIdType(idType);
                insuredInfo.setIdNumber(idNumber);
                insuredInfo.setMobile(mobile);
                insuredInfo.setEmail(email);
                if (!Lang.isEmpty((Object)gender)) {
                    insuredInfo.setGender(Integer.valueOf(gender));
                }
                if (!Lang.isEmpty((Object)birthDay)) {
                    insuredInfo.setBirthDay(DateUtils.strToDate((String)birthDay));
                }
                insuredInfo.setInCityInfo(inCityInfo);
                insuredInfo.setProvince(province);
                insuredInfo.setCity(city);
                insuredInfo.setArea(area);
                insuredInfo.setAddress(address);
                insuredInfo.setInsuredIdentity(insuredIdentity);
                insuredInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                this.recommendPersonnelService.saveCusRecommendPersonnel(insuredInfo);
                if ("0".equals(insuredIdentity)) {
                    CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
                    applicantInfo.setName(name);
                    applicantInfo.setIdType(idType);
                    applicantInfo.setIdNumber(idNumber);
                    applicantInfo.setMobile(mobile);
                    applicantInfo.setEmail(email);
                    if (!Lang.isEmpty((Object)gender)) {
                        applicantInfo.setGender(Integer.valueOf(gender));
                    }
                    if (!Lang.isEmpty((Object)birthDay)) {
                        applicantInfo.setBirthDay(DateUtils.strToDate((String)birthDay));
                    }
                    applicantInfo.setInCityInfo(inCityInfo);
                    applicantInfo.setProvince(province);
                    applicantInfo.setCity(city);
                    applicantInfo.setArea(area);
                    applicantInfo.setAddress(address);
                    applicantInfo.setInsuredIdentity(insuredIdentity);
                    applicantInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                    this.recommendPersonnelService.saveCusRecommendPersonnel(applicantInfo);
                }
                BaseResponse response = new BaseResponse();
                response.setSuccessFlag(Boolean.valueOf(true));
                response.setData((Object)true);
                this.duplicateRequestDefender.finish(processingKey, response);
                returnMap.put(RESP_CODE, RESULT_SUCCESS);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/insureBaseInfo.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    public Map policyPay(String recommendId, int number, String amountSelect, String oldPolicyNo, String feeRate) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        com.picc.gz.admin.vo.insure.ResponseBody responseBody = this.insurePolicyService.policyPay(recommendId, number, amountSelect, oldPolicyNo, feeRate);
        if (Boolean.valueOf(responseBody.getResultFlag()).booleanValue()) {
            cusRecommend = this.recommendService.findById(recommendId);
            cusRecommend.setPolicyNo(responseBody.getPolicyNo());
            cusRecommend.setProposalNo(responseBody.getProposalNo());
            cusRecommend.setYeePayUrl(responseBody.getYeepayurl());
            cusRecommend.setStatus(CUSTOMER_SIGN_TYPE_SIGNONLY);
            if (!Lang.isEmpty((Object)responseBody.getPolicyNo())) {
                cusRecommend.setStatus(CUSTOMER_SIGN_TYPE_SIGNANDPAY);
                returnMap.put(RESP_MSG, "\u5df2\u7ecf\u8f6c\u4fdd\u6210\u529f\uff0c\u4fdd\u5355\u53f7\u4e3a:" + responseBody.getPolicyNo());
                returnMap.put(RESP_CODE, RESULT_FAIL);
            }
            returnMap.put("payUrl", responseBody.getYeepayurl());
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        } else {
            cusRecommend.setStatus("91");
            returnMap.put(RESP_CODE, RESULT_FAIL);
            returnMap.put(RESP_MSG, responseBody.getResultMessage());
        }
        this.recommendService.saveCusRecommend(cusRecommend);
        return returnMap;
    }

    @RequestMapping(value={"/insurePay.do"})
    @ResponseBody
    public String insurePay(HttpServletRequest request) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String dataStr = "";
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            dataStr = InjectionAttackWrapperDataStr.getDataStr((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)dataStr);
            String recommendId = dataObject.getString("recommendId");
            log.info("insureBaseInfo.do \u8bf7\u6c42\uff0crequestId:{}\uff0crecommendId:{}", (Object)request.getRequestedSessionId(), (Object)recommendId);
            String processingKey = String.format("%s_%s_%s", "insureBaseInfo", recommendId, MD5Utils.encode((String)dataStr));
            BaseResponse baseResponse = this.duplicateRequestDefender.getResult(processingKey);
            if (baseResponse != null) {
                if (baseResponse.getSuccessFlag().booleanValue()) {
                    returnMap.put(RESP_CODE, RESULT_SUCCESS);
                    CusRecommend cusRecommend = this.recommendService.findById(recommendId);
                    if (!Lang.isEmpty((Object)cusRecommend.getYeePayUrl())) {
                        returnMap.put("payUrl", cusRecommend.getYeePayUrl());
                    }
                } else {
                    returnMap.put(RESP_CODE, RESULT_FAIL);
                    returnMap.put(RESP_MSG, baseResponse.getMessage());
                }
            } else {
                this.duplicateRequestDefender.startProcessing(processingKey);
                CusRecommend cusRecommend = this.recommendService.findById(recommendId);
                BaseResponse response = new BaseResponse();
                if (!Lang.isEmpty((Object)cusRecommend.getYeePayUrl())) {
                    returnMap.put("payUrl", cusRecommend.getYeePayUrl());
                    returnMap.put(RESP_CODE, RESULT_SUCCESS);
                    response.setSuccessFlag(Boolean.valueOf(true));
                    response.setData((Object)cusRecommend.getYeePayUrl());
                } else {
                    returnMap.put(RESP_CODE, RESULT_FAIL);
                    response.setSuccessFlag(Boolean.valueOf(false));
                }
                this.duplicateRequestDefender.finish(processingKey, response);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/insurePolicy.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/insurePayInfo.do"})
    @ResponseBody
    public String insurePayInfo(HttpServletRequest request) {
        Map<String, String> returnMap = new HashMap<String, Object>();
        String dataStr = "";
        String recommendIdNew = null;
        try {
            dataStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            dataStr = InjectionAttackWrapperDataStr.getDataStr((String)dataStr);
            JSONObject dataObject = JSONObject.parseObject((String)dataStr);
            String policyPay = dataObject.getString("policyPay");
            String idNumber = dataObject.getString("idNumber");
            String email = dataObject.getString("email");
            String applicantName = dataObject.getString("applicantName");
            String applicantIdType = dataObject.getString("applicantIdType");
            String applicantIdNumber = dataObject.getString("applicantIdNumber");
            String applicantGender = dataObject.getString("applicantGender");
            String applicantInfoBirthDay = dataObject.getString("applicantInfoBirthDay");
            String applicantMobile = dataObject.getString("applicantMobile");
            String applicantEmail = dataObject.getString("applicantEmail");
            String insuredIdentity = dataObject.getString("insuredIdentity");
            String applicantIsSocialSe = dataObject.getString("applicantIsSocialSe");
            String recommendId = dataObject.getString("recommendId");
            String insuranceStartDate = dataObject.getString("insuranceStartDate");
            String insuranceEndDate = dataObject.getString("insuranceEndDate");
            String productItemCode = dataObject.getString("productItemCode");
            String amountSelect = dataObject.getString("amountSelect");
            String feeRate = dataObject.getString("feeRate");
            String oldPolicyNo = dataObject.getString("oldPolicyNo");
            log.info("insureBaseInfo.do \u8bf7\u6c42\uff0crequestId:{}\uff0crecommendId:{}", (Object)request.getRequestedSessionId(), (Object)recommendId);
            String processingKey = String.format("%s_%s_%s", "insureBaseInfo", recommendId, MD5Utils.encode((String)dataStr));
            BaseResponse baseResponse = this.duplicateRequestDefender.getResult(processingKey);
            if (baseResponse != null) {
                if (baseResponse.getSuccessFlag().booleanValue()) {
                    returnMap.put(RESP_CODE, RESULT_SUCCESS);
                    returnMap.put("payUrl", (String)baseResponse.getData());
                } else {
                    returnMap.put(RESP_CODE, RESULT_FAIL);
                    returnMap.put(RESP_MSG, baseResponse.getMessage());
                }
            } else {
                this.duplicateRequestDefender.startProcessing(processingKey);
                BaseResponse response = new BaseResponse();
                CusRecommend cusRecommend = this.recommendService.findById(recommendId);
                if (cusRecommend.getProposalNo() == null) {
                    recommendIdNew = recommendId;
                    this.saveCusRecommend(recommendId, dataObject);
                    CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
                    applicantInfo.setName(applicantName);
                    applicantInfo.setIdType(applicantIdType);
                    applicantInfo.setIdNumber(applicantIdNumber);
                    if (!Lang.isEmpty((Object)applicantGender)) {
                        applicantInfo.setGender(Integer.valueOf(applicantGender));
                    }
                    if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                        if ("-".equals(applicantInfoBirthDay)) {
                            applicantInfo.setBirthDay(null);
                        } else {
                            applicantInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
                        }
                    }
                    applicantInfo.setInsuredIdentity(insuredIdentity);
                    applicantInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                    applicantInfo.setMobile(applicantMobile);
                    applicantInfo.setEmail(Lang.isEmpty((Object)applicantEmail) ? email : applicantEmail);
                    this.recommendPersonnelService.saveCusRecommendPersonnel(applicantInfo);
                    CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
                    this.recommendPersonnelService.saveRecommendPersonnel(insuredInfo, dataObject, recommendId);
                    String p = dataObject.getString("p");
                    CusRecommendPersonnel cusRecommendPersonnel1 = new CusRecommendPersonnel();
                    if (p != null) {
                        this.recommendPersonnelService.saveTwoCusRecommendPersonnel(dataObject, insuredInfo.getRecommendId());
                    }
                    if (p != null && !p.equals("0")) {
                        int a = Integer.valueOf(p);
                        this.recommendPersonnelService.saverecommendPersonnel(dataObject, a, recommendId);
                    }
                    InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
                    cusRecommend = this.setCusRecommend(dataObject, cusRecommend, productItem, recommendIdNew);
                    cusRecommend.setProductItemCode(productItemCode);
                    cusRecommend.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                    cusRecommend.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                    this.recommendService.saveCusRecommend(cusRecommend);
                    if (!Lang.isEmpty((Object)policyPay) && CUSTOMER_SIGN_TYPE_SIGNONLY.equals(policyPay)) {
                        if (p != null) {
                            int number = Integer.valueOf(p) + 2;
                            returnMap = this.policyPay(recommendId, number, amountSelect, oldPolicyNo, feeRate);
                        } else {
                            returnMap = this.policyPay(recommendId, 1, amountSelect, oldPolicyNo, feeRate);
                        }
                    } else {
                        returnMap.put(RESP_CODE, RESULT_SUCCESS);
                    }
                } else {
                    cusRecommend.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                    cusRecommend.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                    CusRecommendPersonnel applicantInfoOld = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
                    CusRecommendPersonnel insuredInfoOld = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
                    if ("EAU".equals(cusRecommend.getRealRiskCode())) {
                        EauRequiredInfo eauRequiredInfoOld = this.extAttrService.findEauInfoByRecommendId(recommendId);
                        String licenseNo1 = dataObject.getString("licenseNo");
                        if (eauRequiredInfoOld != null) {
                            CusRecommendPersonnel applicantInfo;
                            CusRecommendPersonnel insuredInfo;
                            CusRecommend cusRecommendNew = (CusRecommend)Beans.map((Object)cusRecommend, CusRecommend.class);
                            cusRecommendNew.setDateCreated(new Date());
                            cusRecommendNew.setLastUpdated(new Date());
                            cusRecommendNew.setCommission(BigDecimal.valueOf(0.0));
                            cusRecommendNew.setVersion(Integer.valueOf(1));
                            cusRecommendNew.setId(null);
                            this.recommendService.saveCusRecommend(cusRecommendNew);
                            recommendIdNew = cusRecommendNew.getId();
                            this.recommendPersonnelService.saveCusRecommendBeneficiary(dataObject, cusRecommend.getId(), cusRecommendNew);
                            if (insuredInfoOld == null) {
                                insuredInfo = new CusRecommendPersonnel();
                            } else {
                                insuredInfo = (CusRecommendPersonnel)Beans.map((Object)insuredInfoOld, CusRecommendPersonnel.class);
                                insuredInfo.setId(null);
                            }
                            insuredInfo.setLastUpdated(new Date());
                            insuredInfo.setName(applicantName);
                            insuredInfo.setIdType(applicantIdType);
                            insuredInfo.setIdNumber(applicantIdNumber);
                            if (!Lang.isEmpty((Object)applicantGender)) {
                                insuredInfo.setGender(Integer.valueOf(applicantGender));
                            }
                            if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                                if ("-".equals(applicantInfoBirthDay)) {
                                    insuredInfo.setBirthDay(null);
                                } else {
                                    insuredInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
                                }
                            }
                            insuredInfo.setInsuredIdentity(insuredIdentity);
                            insuredInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                            insuredInfo.setMobile(applicantMobile);
                            insuredInfo.setEmail(Lang.isEmpty((Object)applicantEmail) ? email : applicantEmail);
                            insuredInfo.setRecommendId(cusRecommendNew.getId());
                            this.recommendPersonnelService.saveCusRecommendPersonnel(insuredInfo);
                            if (applicantInfoOld == null) {
                                applicantInfo = new CusRecommendPersonnel();
                            } else {
                                applicantInfo = (CusRecommendPersonnel)Beans.map((Object)applicantInfoOld, CusRecommendPersonnel.class);
                                applicantInfo.setId(null);
                            }
                            applicantInfo.setLastUpdated(new Date());
                            applicantInfo.setName(applicantName);
                            applicantInfo.setIdType(applicantIdType);
                            applicantInfo.setIdNumber(applicantIdNumber);
                            if (!Lang.isEmpty((Object)applicantGender)) {
                                applicantInfo.setGender(Integer.valueOf(applicantGender));
                            }
                            if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                                if ("-".equals(applicantInfoBirthDay)) {
                                    applicantInfo.setBirthDay(null);
                                } else {
                                    applicantInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
                                }
                            }
                            applicantInfo.setInsuredIdentity(insuredIdentity);
                            applicantInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                            applicantInfo.setMobile(applicantMobile);
                            applicantInfo.setEmail(Lang.isEmpty((Object)applicantEmail) ? email : applicantEmail);
                            applicantInfo.setRecommendId(cusRecommendNew.getId());
                            this.recommendPersonnelService.saveCusRecommendPersonnel(applicantInfo);
                            InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
                            String isCarNo = dataObject.getString("isCarNo");
                            String licenseNo = dataObject.getString("licenseNo");
                            String vinNo = dataObject.getString("vinNo");
                            String engineNo = dataObject.getString("engineNo");
                            String vehicleSeat = dataObject.getString("vehicleSeat");
                            String unit = dataObject.getString("unit");
                            EauRequiredInfo eauRequiredInfo = new EauRequiredInfo();
                            eauRequiredInfo.setIsCarNo(isCarNo);
                            eauRequiredInfo.setLicenseNo(licenseNo);
                            eauRequiredInfo.setVinNo(vinNo);
                            eauRequiredInfo.setEngineNo(engineNo);
                            eauRequiredInfo.setVehicleSeat(vehicleSeat);
                            eauRequiredInfo.setUnit(unit);
                            this.extAttrService.saveEauInfoByRecommendId(cusRecommendNew.getId(), eauRequiredInfo);
                            cusRecommendNew.setUnit(unit);
                            DecimalFormat df = new DecimalFormat("0.00");
                            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(vehicleSeat) * Double.valueOf(unit);
                            cusRecommendNew.setPremium(df.format(sumPremium));
                            cusRecommendNew.setProductItemCode(productItemCode);
                            cusRecommendNew.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                            cusRecommendNew.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                            this.recommendService.saveCusRecommend(cusRecommendNew);
                            if (!Lang.isEmpty((Object)policyPay) && CUSTOMER_SIGN_TYPE_SIGNONLY.equals(policyPay)) {
                                returnMap = this.policyPay(cusRecommendNew.getId(), 1, amountSelect, oldPolicyNo, feeRate);
                            } else {
                                returnMap.put(RESP_CODE, RESULT_SUCCESS);
                            }
                        }
                    } else if (!applicantInfoOld.getIdNumber().equals(applicantIdNumber) || !insuredInfoOld.getIdNumber().equals(idNumber) || cusRecommend.getProposalNo() != null) {
                        CusRecommendPersonnel applicantInfo;
                        CusRecommendPersonnel insuredInfo;
                        CusRecommend cusRecommendNew = (CusRecommend)Beans.map((Object)cusRecommend, CusRecommend.class);
                        cusRecommendNew.setCommission(BigDecimal.valueOf(0.0));
                        cusRecommendNew.setLastUpdated(new Date());
                        cusRecommendNew.setDateCreated(new Date());
                        cusRecommendNew.setVersion(Integer.valueOf(1));
                        cusRecommendNew.setId(null);
                        this.recommendService.saveCusRecommend(cusRecommendNew);
                        this.recommendPersonnelService.saveCusRecommendBeneficiary(dataObject, cusRecommend.getId(), cusRecommendNew);
                        recommendIdNew = cusRecommendNew.getId();
                        if (insuredInfoOld == null) {
                            insuredInfo = new CusRecommendPersonnel();
                        } else {
                            insuredInfo = (CusRecommendPersonnel)Beans.map((Object)insuredInfoOld, CusRecommendPersonnel.class);
                            insuredInfo.setId(null);
                        }
                        this.recommendPersonnelService.saveRecommendPersonnel(insuredInfo, dataObject, cusRecommendNew.getId());
                        if (applicantInfoOld == null) {
                            applicantInfo = new CusRecommendPersonnel();
                        } else {
                            applicantInfo = (CusRecommendPersonnel)Beans.map((Object)applicantInfoOld, CusRecommendPersonnel.class);
                            applicantInfo.setId(null);
                        }
                        applicantInfo.setName(applicantName);
                        applicantInfo.setIdType(applicantIdType);
                        applicantInfo.setIdNumber(applicantIdNumber);
                        if (!Lang.isEmpty((Object)applicantGender)) {
                            applicantInfo.setGender(Integer.valueOf(applicantGender));
                        }
                        if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                            if ("-".equals(applicantInfoBirthDay)) {
                                applicantInfo.setBirthDay(null);
                            } else {
                                applicantInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
                            }
                        }
                        applicantInfo.setInsuredIdentity(insuredIdentity);
                        applicantInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                        applicantInfo.setMobile(applicantMobile);
                        applicantInfo.setEmail(Lang.isEmpty((Object)applicantEmail) ? email : applicantEmail);
                        applicantInfo.setLastUpdated(new Date());
                        applicantInfo.setRecommendId(cusRecommendNew.getId());
                        this.recommendPersonnelService.saveCusRecommendPersonnel(applicantInfo);
                        String p = dataObject.getString("p");
                        if (p != null) {
                            this.recommendPersonnelService.saveTwoCusRecommendPersonnel(dataObject, cusRecommendNew.getId());
                        }
                        if (p != null && !p.equals("0")) {
                            int a = Integer.valueOf(p);
                            this.recommendPersonnelService.saverecommendPersonnel(dataObject, a, cusRecommendNew.getId());
                        }
                        InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
                        cusRecommendNew = this.setCusRecommend(dataObject, cusRecommend, productItem, recommendIdNew);
                        cusRecommendNew.setProductItemCode(productItemCode);
                        cusRecommendNew.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                        cusRecommendNew.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                        DecimalFormat df = new DecimalFormat("0.00");
                        Double sumPremium = Double.valueOf(productItem.getInsurancePremium());
                        cusRecommendNew.setPremium(df.format(sumPremium));
                        this.recommendService.saveCusRecommend(cusRecommendNew);
                        if (!Lang.isEmpty((Object)policyPay) && CUSTOMER_SIGN_TYPE_SIGNONLY.equals(policyPay)) {
                            if (p != null) {
                                int number = Integer.valueOf(p) + 2;
                                returnMap = this.policyPay(recommendIdNew, number, amountSelect, oldPolicyNo, feeRate);
                            } else {
                                returnMap = this.policyPay(recommendIdNew, 1, amountSelect, oldPolicyNo, feeRate);
                            }
                        } else {
                            returnMap.put(RESP_CODE, RESULT_SUCCESS);
                        }
                    } else {
                        this.saveCusRecommend(recommendId, dataObject);
                        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
                        applicantInfo.setName(applicantName);
                        applicantInfo.setIdType(applicantIdType);
                        applicantInfo.setIdNumber(applicantIdNumber);
                        if (!Lang.isEmpty((Object)applicantGender)) {
                            applicantInfo.setGender(Integer.valueOf(applicantGender));
                        }
                        if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                            if ("-".equals(applicantInfoBirthDay)) {
                                applicantInfo.setBirthDay(null);
                            } else {
                                applicantInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
                            }
                        }
                        applicantInfo.setInsuredIdentity(insuredIdentity);
                        applicantInfo.setApplicantIsSocialSe(applicantIsSocialSe);
                        applicantInfo.setMobile(applicantMobile);
                        applicantInfo.setEmail(Lang.isEmpty((Object)applicantEmail) ? email : applicantEmail);
                        this.recommendPersonnelService.saveCusRecommendPersonnel(applicantInfo);
                        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
                        this.recommendPersonnelService.saveRecommendPersonnel(insuredInfo, dataObject, recommendId);
                        String p = dataObject.getString("p");
                        CusRecommendPersonnel cusRecommendPersonnel1 = new CusRecommendPersonnel();
                        if (p != null) {
                            this.recommendPersonnelService.saveTwoCusRecommendPersonnel(dataObject, insuredInfo.getRecommendId());
                        }
                        if (p != null && !p.equals("0")) {
                            int a = Integer.valueOf(p);
                            this.recommendPersonnelService.saverecommendPersonnel(dataObject, a, recommendId);
                        }
                        InsuranceProductItem productItem = this.productItemService.findByProductCode(productItemCode);
                        cusRecommend = this.setCusRecommend(dataObject, cusRecommend, productItem, recommendIdNew);
                        cusRecommend.setProductItemCode(productItemCode);
                        cusRecommend.setInsuranceStartDate(DateUtils.strToDate((String)insuranceStartDate));
                        cusRecommend.setInsuranceEndDate(DateUtils.strToDate((String)insuranceEndDate));
                        this.recommendService.saveCusRecommend(cusRecommend);
                        recommendIdNew = cusRecommend.getId();
                        if (!Lang.isEmpty((Object)policyPay) && CUSTOMER_SIGN_TYPE_SIGNONLY.equals(policyPay)) {
                            if (p != null) {
                                int number = Integer.valueOf(p) + 2;
                                returnMap = this.policyPay(recommendId, number, amountSelect, oldPolicyNo, feeRate);
                            } else {
                                returnMap = this.policyPay(recommendId, 1, amountSelect, oldPolicyNo, feeRate);
                            }
                        } else {
                            returnMap.put(RESP_CODE, RESULT_SUCCESS);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/reinsurance/insurePolicy.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        returnMap.put("recommendId", recommendIdNew);
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/agreement.do"})
    public String agreement(HttpServletRequest request, Model model, String recommendId, String source, String productItemCode) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        source = InjectionAttackWrapperDataStr.getDataStr((String)source);
        model.addAttribute("recommendId", (Object)recommendId);
        source = Lang.isEmpty((Object)source) ? "" : source;
        model.addAttribute("source", (Object)source);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        model.addAttribute("riskCode", (Object)cusRecommend.getRiskCode());
        model.addAttribute("realRiskCode", (Object)cusRecommend.getRealRiskCode());
        model.addAttribute("productItemCode", (Object)(StringUtils.isEmpty((Object)productItemCode) ? cusRecommend.getProductItemCode() : productItemCode));
        return "reinsurance/agreement";
    }

    @RequestMapping(value={"/claim.do"})
    public String claim(HttpServletRequest request, Model model, String recommendId, String source, String productItemCode) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        source = InjectionAttackWrapperDataStr.getDataStr((String)source);
        model.addAttribute("recommendId", (Object)recommendId);
        source = Lang.isEmpty((Object)source) ? "" : source;
        model.addAttribute("source", (Object)source);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        model.addAttribute("riskCode", (Object)cusRecommend.getRiskCode());
        model.addAttribute("realRiskCode", (Object)cusRecommend.getRealRiskCode());
        model.addAttribute("productItemCode", (Object)(StringUtils.isEmpty((Object)productItemCode) ? cusRecommend.getProductItemCode() : productItemCode));
        return "reinsurance/claim";
    }

    @RequestMapping(value={"/clause.do"})
    public String clause(HttpServletRequest request, Model model, String recommendId, String source, String productItemCode) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        source = InjectionAttackWrapperDataStr.getDataStr((String)source);
        model.addAttribute("recommendId", (Object)recommendId);
        source = Lang.isEmpty((Object)source) ? "" : source;
        model.addAttribute("source", (Object)source);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        model.addAttribute("riskCode", (Object)cusRecommend.getRiskCode());
        model.addAttribute("realRiskCode", (Object)cusRecommend.getRealRiskCode());
        model.addAttribute("productItemCode", (Object)(StringUtils.isEmpty((Object)productItemCode) ? cusRecommend.getProductItemCode() : productItemCode));
        return "reinsurance/clause";
    }

    @RequestMapping(value={"/health.do"})
    public String health(HttpServletRequest request, Model model, String recommendId) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        model.addAttribute("riskCode", (Object)cusRecommend.getRiskCode());
        model.addAttribute("realRiskCode", (Object)cusRecommend.getRealRiskCode());
        return "reinsurance/health";
    }

    @RequestMapping(value={"/insured.do"})
    public String insured(HttpServletRequest request, Model model, String source, String recommendId, String productItemCode) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        source = InjectionAttackWrapperDataStr.getDataStr((String)source);
        model.addAttribute("recommendId", (Object)recommendId);
        model.addAttribute("source", (Object)source);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        model.addAttribute("riskCode", (Object)cusRecommend.getRiskCode());
        model.addAttribute("realRiskCode", (Object)cusRecommend.getRealRiskCode());
        model.addAttribute("productItemCode", (Object)(StringUtils.isEmpty((Object)productItemCode) ? cusRecommend.getProductItemCode() : productItemCode));
        return "reinsurance/insured";
    }

    @RequestMapping(value={"/idverify.do"}, method={RequestMethod.GET})
    public String idverify(HttpServletRequest request, HttpServletResponse response, Model model, String recommendId) throws IOException {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        this.recommendService.updateStatus(recommendId, "01");
        if (this.recommendService.isIdEmpty(recommendId).booleanValue()) {
            request.getSession().setAttribute(String.format("%s%s", "VALID_FLAG_ID_", recommendId), (Object)true);
            response.sendRedirect((String)request.getSession().getAttribute("VALIDSUC_CALLBACK"));
        }
        model.addAttribute("recommendId", (Object)recommendId);
        return "reinsurance/idverify";
    }

    @RequestMapping(value={"/idverify.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String idverify(HttpServletRequest request, Model model, @RequestBody Map<String, String> reqMap) {
        String idNum = reqMap.get("idNum");
        String recommendId = reqMap.get("recommendId");
        idNum = InjectionAttackWrapperDataStr.getDataStr((String)idNum);
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        Boolean verifyFlag = this.recommendService.idverify(recommendId, idNum);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        if (verifyFlag.booleanValue()) {
            request.getSession().setAttribute(String.format("%s%s", "VALID_FLAG_ID_", recommendId), (Object)true);
            this.recommendService.updateStatus(recommendId, "02");
        } else {
            this.recommendService.updateStatus(recommendId, "01");
        }
        returnMap.put(RESP_CODE, RESULT_SUCCESS);
        returnMap.put("passed", verifyFlag);
        returnMap.put("callBack", request.getSession().getAttribute("VALIDSUC_CALLBACK"));
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/signature.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> signature(@RequestBody SignatureRequest signReq, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        String recommendId = signReq.getRecommendId();
        String contextPath = request.getContextPath();
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        boolean successFlag = true;
        String message = "SUCCESS";
        if (Lang.isEmpty((Object)signReq.getRecommendId()) && Lang.isEmpty((Object)signReq.getProposalNo())) {
            message = "\u8bf7\u6c42\u53c2\u6570\u3010RecommendId\u3011\u548c\u3010ProposalNo\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01";
            successFlag = false;
        }
        if (Lang.isEmpty((Object)signReq.getSignatureUrl())) {
            message = "\u8bf7\u6c42\u53c2\u6570\u3010SignatureUrl\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            successFlag = false;
        }
        if (successFlag) {
            try {
                this.recommendService.updateSignUrl(signReq);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                successFlag = false;
                message = String.format("\u670d\u52a1\u5668\u5904\u7406\u51fa\u9519\uff1a%s", ex.getLocalizedMessage());
            }
            String finalRecommendId = recommendId;
            sendSmsExecutorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        returnMap.put(RESP_CODE, successFlag ? RESULT_SUCCESS : RESULT_FAIL);
        returnMap.put(RESP_MSG, message);
        return returnMap;
    }

    @RequestMapping(value={"/resignremind.do"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> reSignRemind(String recommendId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        boolean successFlag = true;
        String message = "SUCCESS";
        if (Lang.isEmpty((Object)recommendId)) {
            message = "\u8bf7\u6c42\u53c2\u6570\u3010RecommendId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            successFlag = false;
        }
        if (successFlag) {
            CusRecommend recommend = this.recommendService.findById(recommendId);
            this.recommendService.resetSignUrl(recommendId);
            SmsVo smsVo = new SmsVo();
            try {
                String contextPath = request.getContextPath();
                contextPath = InjectionAttackWrapperDataStr.getDataStr((String)contextPath);
                String url = String.format("%s://%s%s%s?recommendId=%s", this.signProtocol, this.signBasicUrl, contextPath, SIGN_REMIND_URL_CUSTOMER, recommendId);
                if (this.signShorten.booleanValue()) {
                    url = this.shortenUrlSupplierFactory.get().shortenUrl(url);
                }
                smsVo.setShortUrl(url);
                this.smsService.sendSmsByBusinessTypeTemplate("needSignRemind", recommend.getTsUserPhone(), recommend.getId(), smsVo);
            }
            catch (Exception e) {
                e.printStackTrace();
                successFlag = false;
                message = String.format("\u53d1\u9001\u63d0\u9192\u77ed\u4fe1\u51fa\u9519\uff1a%s", e.getLocalizedMessage());
            }
        }
        returnMap.put(RESP_CODE, successFlag ? RESULT_SUCCESS : RESULT_FAIL);
        returnMap.put(RESP_MSG, message);
        return returnMap;
    }

    @RequestMapping(value={"/signature.do"}, method={RequestMethod.GET})
    public String signature(String recommendId, Model model) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        this.recommendService.updateStatus(recommendId, "01");
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        model.addAttribute("insuredInfo", (Object)insuredInfo);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        model.addAttribute("beneficiary", (Object)beneficiary);
        Map requiredInfo = this.extAttrService.findExtAttrInfo(recommendId);
        model.addAttribute("requiredInfo", (Object)requiredInfo);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        model.addAttribute("viewSign", (Object)false);
        String riskCode = recommend.getRealRiskCode();
        if ("EAU".equals(riskCode)) {
            String vehicleSeat = (String)requiredInfo.get("vehicleSeat");
            if (Lang.isEmpty((Object)vehicleSeat)) {
                requiredInfo.put("vehicleSeat", "5");
            }
        } else if ("WBK".equals(riskCode) || "WBK_2".equals(riskCode)) {
            riskCode = "WBK";
        }
        return String.format("signature/%s", riskCode.toLowerCase());
    }

    @RequestMapping(value={"/signature/view.do"}, method={RequestMethod.GET})
    public String signatureView(String recommendId, HttpServletRequest request, HttpServletResponse response, Model model) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        model.addAttribute("recommendId", (Object)recommendId);
        CusRecommend recommend = this.recommendService.findById(recommendId);
        this.recommendService.updateStatus(recommendId, "01");
        model.addAttribute("recommend", (Object)recommend);
        CusRecommendPersonnel insuredInfo = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        model.addAttribute("insuredInfo", (Object)insuredInfo);
        CusRecommendPersonnel applicantInfo = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        model.addAttribute("applicantInfo", (Object)applicantInfo);
        CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        model.addAttribute("beneficiary", (Object)beneficiary);
        Map requiredInfo = this.extAttrService.findExtAttrInfo(recommendId);
        model.addAttribute("requiredInfo", (Object)requiredInfo);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(recommend.getProductItemCode());
        model.addAttribute("productItem", (Object)productItem);
        model.addAttribute("viewSign", (Object)true);
        model.addAttribute("signImage", (Object)recommend.getSignUrl());
        String riskCode = recommend.getRealRiskCode();
        if ("EAU".equals(riskCode)) {
            String vehicleSeat = (String)requiredInfo.get("vehicleSeat");
            if (Lang.isEmpty((Object)vehicleSeat)) {
                requiredInfo.put("vehicleSeat", "5");
            }
        } else if ("WBK".equals(riskCode) || "WBK_2".equals(riskCode)) {
            riskCode = "WBK";
        }
        return String.format("signature/%s", riskCode.toLowerCase());
    }

    public CusRecommend setCusRecommend(JSONObject dataObject, CusRecommend cusRecommend, InsuranceProductItem productItem, String recommendIdNew) {
        String recommendId = null;
        recommendId = !StringUtils.isEmpty((Object)recommendIdNew) ? recommendIdNew : dataObject.getString("recommendId");
        String unit = dataObject.getString("unit");
        unit = Lang.isEmpty((Object)unit) ? CUSTOMER_SIGN_TYPE_SIGNONLY : unit;
        cusRecommend.setUnit(unit);
        if ("EAU".equals(cusRecommend.getRealRiskCode())) {
            String isCarNo = dataObject.getString("isCarNo");
            String licenseNo = dataObject.getString("licenseNo");
            String vinNo = dataObject.getString("vinNo");
            String engineNo = dataObject.getString("engineNo");
            String vehicleSeat = dataObject.getString("vehicleSeat");
            EauRequiredInfo eauRequiredInfo = new EauRequiredInfo();
            eauRequiredInfo.setIsCarNo(isCarNo);
            eauRequiredInfo.setLicenseNo(licenseNo);
            eauRequiredInfo.setVinNo(vinNo);
            eauRequiredInfo.setEngineNo(engineNo);
            eauRequiredInfo.setVehicleSeat(vehicleSeat);
            eauRequiredInfo.setUnit(unit);
            this.extAttrService.saveEauInfoByRecommendId(recommendId, eauRequiredInfo);
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(vehicleSeat) * Double.valueOf(unit);
            cusRecommend.setPremium(df.format(sumPremium));
        } else if ("EAU".equals(cusRecommend.getRealRiskCode())) {
            String requiredInfo = dataObject.getString("requiredInfo");
            JSONObject dataObjectRequiredInfo = JSONObject.parseObject((String)requiredInfo);
            String licenseNo = dataObjectRequiredInfo.getString("licenseNo");
            String isCarNo = dataObjectRequiredInfo.getString("isCarNo");
            String vinNo = dataObjectRequiredInfo.getString("vinNo");
            String engineNo = dataObjectRequiredInfo.getString("engineNo");
            String vehicleSeat = dataObjectRequiredInfo.getString("vehicleSeat");
            String useNatureCode = dataObjectRequiredInfo.getString("useNatureCode");
            EauRequiredInfo eauRequiredInfo = new EauRequiredInfo();
            eauRequiredInfo.setIsCarNo(isCarNo);
            eauRequiredInfo.setLicenseNo(licenseNo);
            eauRequiredInfo.setVinNo(vinNo);
            eauRequiredInfo.setEngineNo(engineNo);
            eauRequiredInfo.setVehicleSeat(vehicleSeat);
            eauRequiredInfo.setUnit(unit);
            eauRequiredInfo.setUseNatureCode(useNatureCode);
            this.extAttrService.saveYejInfoByRecommendId(recommendId, eauRequiredInfo);
        } else if ("YEL".equals(cusRecommend.getRealRiskCode())) {
            String isGps = dataObject.getString("isGps");
            String licenseNo = dataObject.getString("licenseNo");
            String vinNo = dataObject.getString("vinNo");
            String brandName = dataObject.getString("brandName");
            EauRequiredInfo eauRequiredInfo = new EauRequiredInfo();
            eauRequiredInfo.setIsGps(isGps);
            eauRequiredInfo.setLicenseNo(licenseNo);
            eauRequiredInfo.setVinNo(vinNo);
            eauRequiredInfo.setBrandName(brandName);
            this.extAttrService.saveEauInfoByRecommendId(recommendId, eauRequiredInfo);
            cusRecommend.setPremium(productItem.getInsurancePremium());
        } else if ("LDO".equals(cusRecommend.getRealRiskCode())) {
            String insureAreaCode = dataObject.getString("insureAreaCode");
            String mortgageNo = dataObject.getString("mortgageNo");
            String loanBankCode = dataObject.getString("loanBankCode");
            String loanUsage = dataObject.getString("loanUsage");
            String preChar1 = dataObject.getString("preChar1");
            String claimBase = dataObject.getString("claimBase");
            String saleArea = dataObject.getString("saleArea");
            String officeType = dataObject.getString("officeType");
            String guaranteeName = dataObject.getString("guaranteeName");
            LdoRequiredInfo ldoRequiredInfo = new LdoRequiredInfo();
            String licenseNo = dataObject.getString("licenseNo");
            String vehicleSeat = dataObject.getString("vehicleSeat");
            ldoRequiredInfo.setLicenseNo(licenseNo);
            ldoRequiredInfo.setVehicleSeat(vehicleSeat);
            ldoRequiredInfo.setInsureAreaCode(insureAreaCode);
            ldoRequiredInfo.setMortgageNo(mortgageNo);
            ldoRequiredInfo.setLoanBankCode(loanBankCode);
            ldoRequiredInfo.setLoanUsage(loanUsage);
            ldoRequiredInfo.setPreChar1(preChar1);
            ldoRequiredInfo.setClaimBase(claimBase);
            ldoRequiredInfo.setSaleArea(saleArea);
            ldoRequiredInfo.setOfficeType(officeType);
            ldoRequiredInfo.setGuaranteeName(guaranteeName);
            this.extAttrService.saveLdoInfoByRecommendId(recommendId, ldoRequiredInfo);
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(unit);
            cusRecommend.setPremium(df.format(sumPremium));
        } else if ("ZCI".equals(cusRecommend.getRealRiskCode())) {
            JSONObject zciInfoObject = dataObject.getJSONObject("zciInfo");
            this.extAttrService.saveExtAttrInfo(recommendId, zciInfoObject);
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(unit);
            cusRecommend.setPremium(df.format(sumPremium));
        } else if ("ZFO".equals(cusRecommend.getRealRiskCode())) {
            String insureAreaCode = dataObject.getString("insureAreaCode");
            LdoRequiredInfo ldoRequiredInfo = new LdoRequiredInfo();
            ldoRequiredInfo.setInsureAreaCode(insureAreaCode);
            this.extAttrService.saveLdoInfoByRecommendId(recommendId, ldoRequiredInfo);
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(unit);
            cusRecommend.setPremium(df.format(sumPremium));
        } else {
            JabRequiredInfo jabRequiredInfo = (JabRequiredInfo)dataObject.getObject("jabRequiredInfo", JabRequiredInfo.class);
            JebRequiredInfo jebRequiredInfo = (JebRequiredInfo)dataObject.getObject("jebRequiredInfo", JebRequiredInfo.class);
            LdoRequiredInfo ldoRequiredInfo = (LdoRequiredInfo)dataObject.getObject("ldoRequiredInfo", LdoRequiredInfo.class);
            HashMap<String, String> extattrMap = new HashMap<String, String>(10);
            if (jabRequiredInfo != null) {
                Address a;
                extattrMap.put("jabRequiredInfo.address", jabRequiredInfo.getAddress());
                extattrMap.put("jabRequiredInfo.province", jabRequiredInfo.getProvince());
                extattrMap.put("jabRequiredInfo.city", jabRequiredInfo.getCity());
                extattrMap.put("jabRequiredInfo.area", jabRequiredInfo.getArea());
                String postCode = jabRequiredInfo.getPostCode();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)postCode) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jabRequiredInfo.getArea())) {
                    a = this.addressService.findById(jabRequiredInfo.getArea());
                    String string = postCode = a == null ? null : a.getZipCode();
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)postCode) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jabRequiredInfo.getCity())) {
                    a = this.addressService.findById(jabRequiredInfo.getCity());
                    String string = postCode = a == null ? null : a.getZipCode();
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)postCode) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jabRequiredInfo.getProvince())) {
                    a = this.addressService.findById(jabRequiredInfo.getProvince());
                    postCode = a == null ? null : a.getZipCode();
                }
                extattrMap.put("jabRequiredInfo.postCode", postCode);
            }
            if (jebRequiredInfo != null) {
                extattrMap.put("jebRequiredInfo.sumQuantity", jebRequiredInfo.getSumQuantity());
            }
            if (ldoRequiredInfo != null) {
                extattrMap.put("ldoRequiredInfo.insureAreaCode", ldoRequiredInfo.getInsureAreaCode());
                extattrMap.put("ldoRequiredInfo.mortgageNo", ldoRequiredInfo.getMortgageNo());
                extattrMap.put("ldoRequiredInfo.loanBankCode", ldoRequiredInfo.getLoanBankCode());
                extattrMap.put("ldoRequiredInfo.loanUsage", ldoRequiredInfo.getLoanUsage());
                extattrMap.put("ldoRequiredInfo.preChar1", ldoRequiredInfo.getPreChar1());
                extattrMap.put("ldoRequiredInfo.claimBase", ldoRequiredInfo.getClaimBase());
                extattrMap.put("ldoRequiredInfo.saleArea", ldoRequiredInfo.getSaleArea());
                extattrMap.put("ldoRequiredInfo.officeType", ldoRequiredInfo.getOfficeType());
                extattrMap.put("ldoRequiredInfo.guaranteeName", ldoRequiredInfo.getGuaranteeName());
                extattrMap.put("ldoRequiredInfo.licenseNo", ldoRequiredInfo.getLicenseNo());
                extattrMap.put("ldoRequiredInfo.vehicleSeat", ldoRequiredInfo.getVehicleSeat());
            }
            this.extAttrService.saveExtAttrInfo(recommendId, extattrMap);
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(cusRecommend.getUnit());
            cusRecommend.setPremium(df.format(sumPremium));
        }
        return cusRecommend;
    }

    private void saveCusRecommend(String recommendId, JSONObject dataObject) {
        String isBeneficiary = dataObject.getString("isBeneficiary");
        String beneficiaryName = dataObject.getString("beneficiaryName");
        String beneficiaryIdNumber = dataObject.getString("beneficiaryIdNumber");
        String beneficiaryGender = dataObject.getString("beneficiaryGender");
        String beneficiaryBirthDay = dataObject.getString("beneficiaryBirthDay");
        if (CUSTOMER_SIGN_TYPE_SIGNONLY.equals(isBeneficiary)) {
            CusRecommendPersonnel beneficiary = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
            beneficiary.setName(beneficiaryName);
            beneficiary.setIdType("01");
            beneficiary.setIdNumber(beneficiaryIdNumber);
            if (!Lang.isEmpty((Object)beneficiaryGender)) {
                beneficiary.setGender(Integer.valueOf(beneficiaryGender));
            }
            if (!Lang.isEmpty((Object)beneficiaryBirthDay)) {
                beneficiary.setBirthDay(DateUtils.strToDate((String)beneficiaryBirthDay));
            }
            this.recommendPersonnelService.saveCusRecommendPersonnel(beneficiary);
        } else {
            this.recommendPersonnelService.removeBeneficiaryByRecommendId(recommendId);
        }
    }

    static /* synthetic */ CusRecommendService access$000(ReinsuranceController x0) {
        return x0.recommendService;
    }

    static /* synthetic */ String access$100(ReinsuranceController x0) {
        return x0.signProtocol;
    }

    static /* synthetic */ String access$200(ReinsuranceController x0) {
        return x0.signBasicUrl;
    }

    static /* synthetic */ Boolean access$300(ReinsuranceController x0) {
        return x0.signShorten;
    }

    static /* synthetic */ ShortenUrlSupplierFactory access$400(ReinsuranceController x0) {
        return x0.shortenUrlSupplierFactory;
    }

    static /* synthetic */ SmsService access$500(ReinsuranceController x0) {
        return x0.smsService;
    }
}

