/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.HisRationAmountService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.RenewalService;
import com.picc.gz.admin.vo.InsureVo;
import com.picc.gz.admin.vo.LastInsuredInfoVo;
import com.picc.gz.admin.vo.insure.LastInsuredInfo;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.CusRecommendPersonnelDo;
import com.picc.gz.model.model.HisRationAmount;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.InsureDO;
import com.picc.gz.utils.Lang;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"renewal"})
public class RenewalController {
    private static final Logger log = LoggerFactory.getLogger(RenewalController.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    @Autowired
    private CusRecommendService cusRecommendService;
    @Autowired
    private CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    private RenewalService renewalService;
    @Autowired
    private InsuranceProductItemService productItemService;
    @Autowired
    private HisRationAmountService hisRationAmountService;

    @RequestMapping(value={"/renewal.do"})
    @ResponseBody
    public String Test(HttpServletRequest request, String recommendId, String idnum) throws ParseException {
        idnum = InjectionAttackWrapperDataStr.getDataStr((String)idnum);
        InsureVo insureVo = new InsureVo();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put(RESP_CODE, RESULT_SUCCESS);
        if (!StringUtils.isEmpty((Object)recommendId)) {
            CusRecommend recommend = this.cusRecommendService.findById(recommendId);
            String idNumber = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)idnum) ? this.cusRecommendService.getInsurerIdNumber(recommendId) : idnum;
            String riskCode = recommend.getRealRiskCode();
            int maxEndDay = this.cusRecommendService.getMaxEndDay(riskCode);
            if (!(Lang.isEmpty((Object)idNumber) || Lang.isEmpty((Object)riskCode) || Lang.isEmpty((Object)maxEndDay))) {
                List insureDOList = new ArrayList();
                insureDOList = this.renewalService.getRenewal(idNumber, riskCode);
                if (insureDOList.size() != 0) {
                    Date date = ((InsureDO)insureDOList.get(0)).getEnddate();
                    Date date1 = new Date();
                    String plancode = ((InsureDO)insureDOList.get(0)).getPlancode();
                    InsuranceProductItem productItem = this.productItemService.findByProductCode(plancode);
                    String insuranceAmount = null;
                    if (productItem != null) {
                        insuranceAmount = productItem.getInsuranceAmount();
                        if (recommend.getRiskCode().equals("WBK_2") && insuranceAmount.equals("2000000.00")) {
                            maxEndDay = 1;
                        }
                    } else {
                        HisRationAmount hisRationAmount = this.hisRationAmountService.findByProductCode(plancode);
                        if (hisRationAmount != null) {
                            insuranceAmount = hisRationAmount.getAmount();
                            if (recommend.getRiskCode().equals("WBK_2") && insuranceAmount.equals("2000000.00")) {
                                maxEndDay = 1;
                            }
                        }
                    }
                    if (date.getTime() + (long)(maxEndDay * 24 * 3600 * 1000) > date1.getTime()) {
                        insureVo = this.insureDOToVo((InsureDO)insureDOList.get(0));
                        String proposalno = insureVo.getLastProposalNo();
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Calendar c = Calendar.getInstance();
                        c.setTime(insureVo.getLastEndDate());
                        c.add(5, 1);
                        Date tomorrow = c.getTime();
                        String dt = simpleDateFormat.format(tomorrow);
                        insureVo.setEndDate(dt);
                        LastInsuredInfoVo lastInsuredInfoVo = new LastInsuredInfoVo();
                        LastInsuredInfoVo lastApplicantInfoVo = new LastInsuredInfoVo();
                        LastInsuredInfo lastInsuredInfo = this.renewalService.findXuBaoCusRecommendPersonnel(proposalno);
                        lastInsuredInfoVo = this.LastInsuredInfoToVo(lastInsuredInfo);
                        returnMap.put("lastInsuredInfoVo", (String)lastInsuredInfoVo);
                        LastInsuredInfo lastApplicantInfo = this.renewalService.findXuBaoApplicantInfo(proposalno);
                        lastApplicantInfoVo = this.LastInsuredInfoToVo(lastApplicantInfo);
                        returnMap.put("lastApplicantInfoVo", (String)lastApplicantInfoVo);
                        returnMap.put("insureVo", (String)insureVo);
                    } else {
                        insureVo.setRenewal(Boolean.valueOf(false));
                        returnMap.put("insureVo", (String)insureVo);
                    }
                } else {
                    insureVo.setRenewal(Boolean.valueOf(false));
                    returnMap.put("insureVo", (String)insureVo);
                }
            }
        }
        return JSON.toJSONString(returnMap);
    }

    public InsureVo insureDOToVo(InsureDO insureDO) {
        InsureVo insureVo = new InsureVo();
        insureVo.setRenewal(Boolean.valueOf(true));
        insureVo.setLastPolicyNo(insureDO.getPolicyno());
        insureVo.setLastEndDate(insureDO.getEnddate());
        insureVo.setLastStartDate(insureDO.getStartdate());
        insureVo.setLastProposalNo(insureDO.getProposalno());
        insureVo.setLastClaimCount(insureDO.getFlagLp().toString());
        return insureVo;
    }

    public LastInsuredInfoVo LastInsuredInfoToVo(LastInsuredInfo lastInsuredInfo) {
        LastInsuredInfoVo lastInsuredInfoVo = new LastInsuredInfoVo();
        lastInsuredInfoVo.setIdentifynumber(lastInsuredInfo.getIdentifynumber());
        lastInsuredInfoVo.setInsuredaddress(lastInsuredInfo.getInsuredaddress());
        lastInsuredInfoVo.setInsuredname(lastInsuredInfo.getInsuredname());
        return lastInsuredInfoVo;
    }

    @RequestMapping(value={"/findCode.do"})
    @ResponseBody
    public String findCode(HttpServletRequest request, String applicantIdNumber) throws ParseException {
        applicantIdNumber = InjectionAttackWrapperDataStr.getDataStr((String)applicantIdNumber);
        String organizationCode = this.renewalService.findCode(applicantIdNumber);
        organizationCode = InjectionAttackWrapperDataStr.getDataStr((String)organizationCode);
        return JSON.toJSONString((Object)organizationCode);
    }

    @RequestMapping(value={"/isrenew.do"})
    @ResponseBody
    public String isrenew(HttpServletRequest request, String recommendId) throws ParseException {
        InsureVo insureVo = new InsureVo();
        HashMap returnMap = new HashMap();
        List cusRecommendPersonnelList = this.recommendPersonnelService.findPersonneByRecommendId(recommendId);
        ArrayList<CusRecommendPersonnelDo> cusRecommendPersonnelDoList = new ArrayList<CusRecommendPersonnelDo>();
        CusRecommend cusRecommend = this.cusRecommendService.findById(recommendId);
        String riskCode = cusRecommend.getRealRiskCode();
        int maxEndDay = this.cusRecommendService.getMaxEndDay(riskCode);
        for (int i = 0; i < cusRecommendPersonnelList.size(); ++i) {
            String idNumber = ((CusRecommendPersonnel)cusRecommendPersonnelList.get(i)).getIdNumber();
            if (Lang.isEmpty((Object)idNumber) || Lang.isEmpty((Object)riskCode) || Lang.isEmpty((Object)maxEndDay)) continue;
            List insureDOList = new ArrayList();
            CusRecommendPersonnelDo cusRecommendPersonnelDo = new CusRecommendPersonnelDo();
            insureDOList = this.renewalService.getRenewal(idNumber, riskCode);
            if (insureDOList.size() != 0) {
                Date date = ((InsureDO)insureDOList.get(0)).getEnddate();
                Date date1 = new Date();
                long a = date.getTime();
                if (date.getTime() / 86400000L + (long)maxEndDay > date1.getTime() / 86400000L) {
                    cusRecommendPersonnelDo.setName(((CusRecommendPersonnel)cusRecommendPersonnelList.get(i)).getName());
                    cusRecommendPersonnelDo.setRenewal(Boolean.valueOf(true));
                    cusRecommendPersonnelDoList.add(cusRecommendPersonnelDo);
                    returnMap.put("cusRecommendPersonnelDoList", cusRecommendPersonnelDoList);
                    continue;
                }
                cusRecommendPersonnelDo.setName(((CusRecommendPersonnel)cusRecommendPersonnelList.get(i)).getName());
                cusRecommendPersonnelDo.setRenewal(Boolean.valueOf(false));
                cusRecommendPersonnelDoList.add(cusRecommendPersonnelDo);
                returnMap.put("cusRecommendPersonnelDoList", cusRecommendPersonnelDoList);
                continue;
            }
            cusRecommendPersonnelDo.setName(((CusRecommendPersonnel)cusRecommendPersonnelList.get(i)).getName());
            cusRecommendPersonnelDo.setRenewal(Boolean.valueOf(false));
            cusRecommendPersonnelDoList.add(cusRecommendPersonnelDo);
            returnMap.put("cusRecommendPersonnelDoList", cusRecommendPersonnelDoList);
        }
        return JSON.toJSONString(returnMap);
    }
}

