/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.chrhc.mybatis.autodate.util.PageData;
import com.chrhc.mybatis.autodate.util.ResponseEntity;
import com.chrhc.mybatis.autodate.util.RowBoundUtil;
import com.github.pagehelper.PageInfo;
import com.picc.gz.admin.service.QueryRateService;
import com.picc.gz.model.model.InsureRiskSalesRate;
import com.picc.gz.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.WebUtils;
import tk.mybatis.mapper.entity.Example;

@Controller
@RequestMapping(value={"sell"})
public class SellRateController {
    private static final Logger log = LoggerFactory.getLogger(SellRateController.class);
    @Autowired
    private QueryRateService queryRateService;

    @RequestMapping(value={"/queryRate.do"})
    public String queryPolicy(HttpServletRequest request, Model model) {
        model.addAttribute("insuranceStartDate", (Object)DateUtils.getNow());
        return "query/queryRate";
    }

    @RequestMapping(value={"/queryRateSearch.do"})
    @ResponseBody
    public PageData<InsureRiskSalesRate> list(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="limit", defaultValue="10") Integer limit, ServletRequest request) {
        Map map = WebUtils.getParametersStartingWith((ServletRequest)request, (String)"s_");
        PageData userPageData = new PageData();
        Example selectExamp = new Example(InsureRiskSalesRate.class);
        selectExamp.setOrderByClause("LAST_UPDATED DESC");
        if (!map.isEmpty()) {
            String riskCode = (String)map.get("type");
            String companyCode = (String)map.get("key");
            if (StringUtils.isNotBlank((CharSequence)riskCode) && StringUtils.isNotBlank((CharSequence)companyCode)) {
                selectExamp.createCriteria().andEqualTo("deleteFlag", (Object)0).andEqualTo("riskCode", (Object)riskCode).andEqualTo("companyCode", (Object)companyCode);
            } else if (!StringUtils.isNotBlank((CharSequence)riskCode) && StringUtils.isNotBlank((CharSequence)companyCode)) {
                selectExamp.createCriteria().andEqualTo("deleteFlag", (Object)0).andEqualTo("companyCode", (Object)companyCode);
            } else if (StringUtils.isNotBlank((CharSequence)riskCode) && !StringUtils.isNotBlank((CharSequence)companyCode)) {
                selectExamp.createCriteria().andEqualTo("deleteFlag", (Object)0).andEqualTo("riskCode", (Object)riskCode);
            }
        } else {
            selectExamp.createCriteria().andEqualTo("deleteFlag", (Object)0);
        }
        RowBounds rowBounds = RowBoundUtil.getRowBounds((String)String.valueOf(limit), (String)String.valueOf(page - 1));
        List insureRiskSalesRateList = this.queryRateService.findAllRate(selectExamp, rowBounds);
        PageInfo info = new PageInfo(insureRiskSalesRateList);
        List insureRiskSalesRateListCount = this.queryRateService.findCount(selectExamp);
        PageInfo infoCount = new PageInfo(insureRiskSalesRateListCount);
        userPageData.setCount(Long.valueOf(infoCount.getTotal()));
        userPageData.setData(info.getList());
        return userPageData;
    }

    @RequestMapping(value={"/delete.do"})
    @ResponseBody
    public ResponseEntity delete(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseEntity.failure((String)"\u53c2\u6570\u9519\u8bef");
        }
        InsureRiskSalesRate insureRiskSalesRate = this.queryRateService.getById(id);
        if (insureRiskSalesRate == null) {
            return ResponseEntity.failure((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        this.queryRateService.deleteRate(id);
        return ResponseEntity.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"edit"})
    public String edit(String id, ModelMap modelMap) {
        InsureRiskSalesRate insureRiskSalesRate = this.queryRateService.getById(id);
        modelMap.put((Object)"insureRiskSalesRate", (Object)insureRiskSalesRate);
        return "query/editRate";
    }

    @RequestMapping(value={"/editRate.do"})
    @ResponseBody
    public ResponseEntity edit(@RequestBody InsureRiskSalesRate insureRiskSalesRate) {
        if (StringUtils.isBlank((CharSequence)insureRiskSalesRate.getId())) {
            return ResponseEntity.failure((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (insureRiskSalesRate.getInvalidTime() == null || insureRiskSalesRate.getEffectiveTime() == null || insureRiskSalesRate.getLongTimeFlag() == null || insureRiskSalesRate.getSalesRate() == null) {
            return ResponseEntity.failure((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u6570\u636e");
        }
        InsureRiskSalesRate insureRiskSalesRateOld = this.queryRateService.getById(insureRiskSalesRate.getId());
        this.queryRateService.updateSellRate(insureRiskSalesRate);
        if (StringUtils.isBlank((CharSequence)insureRiskSalesRateOld.getId())) {
            return ResponseEntity.failure((String)"\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u51fa\u9519");
        }
        return ResponseEntity.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"add"})
    public String add(ModelMap modelMap) {
        return "query/addRate";
    }

    @PostMapping(value={"/addRate.do"})
    @ResponseBody
    public ResponseEntity add(@RequestBody InsureRiskSalesRate insureRiskSalesRate) {
        if (StringUtils.isBlank((CharSequence)insureRiskSalesRate.getRiskCode())) {
            return ResponseEntity.failure((String)"\u9669\u79cd\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        insureRiskSalesRate.setDateCreated(new Date());
        insureRiskSalesRate.setDeleteFlag(Integer.valueOf(0));
        insureRiskSalesRate.setLastUpdated(new Date());
        insureRiskSalesRate.setVersion(Integer.valueOf(1));
        this.queryRateService.saveQueryRate(insureRiskSalesRate);
        if (StringUtils.isBlank((CharSequence)insureRiskSalesRate.getId())) {
            return ResponseEntity.failure((String)"\u4fdd\u5b58\u4fe1\u606f\u51fa\u9519");
        }
        return ResponseEntity.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

