/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.factory.ShortenUrlSupplierFactory;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.HttpClientService;
import com.picc.gz.admin.service.SmsService;
import com.picc.gz.admin.vo.SmsVo;
import com.picc.gz.admin.vo.policy.PolicyQuery;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPolicy;
import com.picc.gz.utils.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sms"})
public class SmsController {
    private static final Logger log = LoggerFactory.getLogger(SmsController.class);
    @Value(value="${reinsurance.basicUrl}")
    private String basicUrl;
    @Value(value="${reinsurance.protocol}")
    private String scheme;
    private static final String RESP_CODE = "respCode";
    private static final String RESP_MSG = "respMsg";
    private static final String RESULT_SUCCESS = "0000";
    private static final String RESULT_FAIL = "0001";
    public static final String CUSTOMER_SIGN_TYPE_SIGNONLY = "1";
    public static final String CUSTOMER_SIGN_TYPE_SIGNANDPAY = "2";
    public static final String SIGN_REMIND_URL_CUSTOMER = "/reinsurance/signature.do";
    public static final String SIGN_REMIND_URL_CUSTOMER_HEALTH = "/reinsurance/health.do";
    public static final String SIGN_REMIND_URL_VIEW = "/reinsurance/signature/view.do";
    @Autowired
    private SmsService smsService;
    @Autowired
    private ShortenUrlSupplierFactory shortenUrlSupplierFactory;
    @Autowired
    private CusRecommendService cusRecommendService;
    @Autowired
    private HttpClientService httpClientService;
    @Value(value="${signature.basicUrl}")
    private String signBasicUrl;
    @Value(value="${signature.protocol}")
    private String signProtocol;
    @Value(value="${signature.shorten}")
    private Boolean signShorten;
    @Value(value="${yeePay.downDzfpUrl}")
    private String downDzfpUrl;

    @RequestMapping(value={"/sendInsureSms.do"})
    @ResponseBody
    public String sendInsureSms(HttpServletRequest request, String recommendId, String mobile, String cusSignType) {
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String smsContent = this.getInsureSuccessContent(request, recommendId, cusSignType);
        try {
            this.smsService.sendSms(smsContent, mobile);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/query/sendInsureSms.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    @RequestMapping(value={"/sendPolicyDownloadSms.do"})
    @ResponseBody
    public String sendPolicyDownloadSms(HttpServletRequest request, String recommendId, String mobile) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        String smsContent = this.getPolicyDownloadSms(recommendId);
        try {
            this.smsService.sendSms(smsContent, mobile);
            returnMap.put(RESP_CODE, RESULT_SUCCESS);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42/sms/sendPolicyDownloadSms.do\u5931\u8d25", (Throwable)e);
            returnMap.put(RESP_CODE, RESULT_FAIL);
        }
        return JSON.toJSONString(returnMap);
    }

    private String getPolicyDownloadSms(String recommendId) {
        String smsContent = "";
        SmsVo smsVo = new SmsVo();
        PolicyQuery policyQuery = new PolicyQuery();
        policyQuery.setRecommendId(recommendId);
        List cusRecommendPolicies = this.cusRecommendService.queryPolicy(policyQuery);
        CusRecommendPolicy cusRecommendPolicy = new CusRecommendPolicy();
        if (cusRecommendPolicies.size() > 0) {
            cusRecommendPolicy = (CusRecommendPolicy)cusRecommendPolicies.get(0);
        }
        smsVo.setDownloadUrl(cusRecommendPolicy.getDownloadUrl());
        JSONObject respJsonObject = this.getDownDzfpUrl(cusRecommendPolicy.getPolicyNo(), cusRecommendPolicy.getRequestId());
        String resultMsg = respJsonObject.getString("resultMsg");
        if ("success".equals(resultMsg)) {
            smsVo.setDownDzfpUrl(respJsonObject.getString("dzfpUrl"));
        }
        try {
            smsContent = this.smsService.getSmsByBusinessTypeTemplate("policyDownload", recommendId, smsVo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return smsContent;
    }

    private JSONObject getDownDzfpUrl(String policyNo, String requestId) {
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("policyNo", policyNo));
        formParams.add(new BasicNameValuePair("requestUUID", requestId));
        String respStr = this.httpClientService.getHttpRequest(this.downDzfpUrl, formParams);
        JSONObject respJsonObject = JSONObject.parseObject((String)respStr);
        return respJsonObject;
    }

    private String getInsureSuccessContent(HttpServletRequest request, String recommendId, String cusSignType) {
        String smsContent = "";
        CusRecommend recommend = this.cusRecommendService.findById(recommendId);
        if ("WBK".equals(recommend.getRiskCode()) || "WBK_2".equals(recommend.getRiskCode())) {
            String customerUri = "";
            customerUri = CUSTOMER_SIGN_TYPE_SIGNANDPAY.equals(cusSignType) ? SIGN_REMIND_URL_CUSTOMER_HEALTH : SIGN_REMIND_URL_CUSTOMER;
            String url = String.format("%s://%s%s%s?recommendId=%s", this.signProtocol, this.signBasicUrl, request.getContextPath(), customerUri, recommendId);
            String shortUrl = this.shortenUrlSupplierFactory.get().shortenUrl(url);
            SmsVo smsVo = new SmsVo();
            smsVo.setShortUrl(Lang.isEmpty((Object)shortUrl) ? url : shortUrl);
            try {
                smsContent = this.smsService.getSmsByBusinessTypeTemplate("needSignRemind", recommendId, smsVo);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            this.cusRecommendService.resetSignUrl(recommendId);
        } else {
            String basePath = this.scheme + "://" + this.basicUrl + request.getContextPath() + "/";
            String redirectUrl = basePath + "reinsurance/baseInfo.do?recommendId=" + recommendId;
            String shortUrl = this.shortenUrlSupplierFactory.get().shortenUrl(redirectUrl);
            SmsVo smsVo = new SmsVo();
            smsVo.setShortUrl(Lang.isEmpty((Object)shortUrl) ? redirectUrl : shortUrl);
            try {
                smsContent = this.smsService.getSmsByBusinessTypeTemplate("insureSuccess", recommendId, smsVo);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return smsContent;
    }
}

