<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache">
    <meta name="renderer" content="webkit">
    <link rel="stylesheet" href="${c_static}/layui/css/layui.css">

    <link rel="stylesheet" href="${c_static}/css/reinsurance/insurance.css">
    <script type='text/javascript' src="${c_static}/js/reinsurance/jquery-3.1.1.min.js"></script>
    <link rel="stylesheet" href="${c_static}/jQuery_UI/css/jquery-ui.min.css">
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/jquery-ui.min.js"></script>
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/datepicker-zh-CN.js"></script>
    <title>产品投保</title>
</head>
<body>
<div class="content">
    <div class="h-title">产品投保</div>
    <div class="base-content">
        <input type="hidden" value="${(recommend.id)!}" name="recommendId" id="recommendId">
        <input type="hidden" value="${(recommend.productItemCode)!}" name="productItemCode" id="productItemCode">
        <div class="base-title">投保信息</div>
        <div class="base-info">
            <div class="info-line">
                <div class="info">
                    <span class="lable-text">产品保额:</span>
                    <select class="select-text" name="productAmounts" id="productAmounts">
                    </select>
                </div>
                <div class="info">
                    <span class="lable-text">产品方案:</span>
                    <select class="select-text" name="productPlan" id="productPlan">
                    </select>
                </div>
                <div class="info">
                    <span class="lable-text">保障期间:</span>
                    <input type="text" class="date-text" readonly="readonly" name="insuranceStartDate"
                           id="insuranceStartDate"
                           value="${(recommend.insuranceStartDate)?string("yyyy-MM-dd")!}"/> -
                    <input type="text" class="date-text" readonly="readonly" name="insuranceEndDate"
                           id="insuranceEndDate"
                           value="${(recommend.insuranceEndDate)?string("yyyy-MM-dd")!}"/>
                </div>
                <div class="info ">
                    <span class="lable-text">为谁投保:</span>
                    <span class="radio-text">
                        <#if insuredInfo.insuredIdentity??>
                            <input type="radio" name="insuredIdentity" value="0"
                                   <#if  insuredInfo.insuredIdentity == "0">checked="checked"</#if>/>本人
                        <input type="radio" name="insuredIdentity" value="7"
                               <#if insuredInfo.insuredIdentity == "7">checked="checked"</#if>/>其他
                        <#else>
                            <input type="radio" name="insuredIdentity" value="0" checked="checked"/>本人
                        <input type="radio" name="insuredIdentity" value="7"/>其他
                        </#if>
                            <input type="hidden" id="insuredIdentity" value="${insuredInfo.insuredIdentity !"0"}"/>
                    </span>
                </div>
                <div class="info">
                    <span class="lable-text">投保份数:</span>
                    <input type="number" class="input-text" name="unit" id="unit"
                           value="${(recommend.unit)!"1"}" onchange="validateNumber(this)"/>
                </div>
                <div class="info" id="feeRateInput">
                    <span class="lable-text">费用比例:</span>
                    <input type="number" class="input-styleRate"  name="feeRate" id="feeRate"  readonly="readonly"
                    />%<a id="oldRate" style="color: red"></a>
                </div>
            </div>
        </div>
        <div class="base-title">投保人信息</div>
        <div class="base-info">
            <div class="info-line">
                <div class="info">
                    <span class="lable-text">投保人姓名:</span>
                    <input type="text" class="input-text" name="applicantName" id="applicantName"
                           value="${(applicantInfo.name)!}" onchange="validateName(this,'1')"/>
                </div>
                <div class="info">
                    <span class="lable-text">证件类型:</span>
                    <select class="select-text" name="applicantIdType" id="applicantIdType">
                        <option value="01" <#if applicantInfo.idType == "01">selected="selected"</#if>>身份证</option>
                        <option value="02" <#if applicantInfo.idType == "02">selected="selected"</#if>>户口薄</option>
                        <option value="03" <#if applicantInfo.idType == "03">selected="selected"</#if>>护照</option>
                        <option value="04" <#if applicantInfo.idType == "04">selected="selected"</#if>>军人证件</option>
                        <option value="05" <#if applicantInfo.idType == "05">selected="selected"</#if>>驾驶执照</option>
                        <option value="06" <#if applicantInfo.idType == "06">selected="selected"</#if>>返乡证</option>
                        <option value="07" <#if applicantInfo.idType == "07">selected="selected"</#if>>港澳身份证</option>
                        <option value="08" <#if applicantInfo.idType == "08">selected="selected"</#if>>工号</option>
                        <option value="09" <#if applicantInfo.idType == "09">selected="selected"</#if>>赴台通行证</option>
                        <option value="10" <#if applicantInfo.idType == "10">selected="selected"</#if>>港澳通行证</option>
                        <option value="15" <#if applicantInfo.idType == "15">selected="selected"</#if>>士兵证</option>
                        <option value="21" <#if applicantInfo.idType == "21">selected="selected"</#if>>外国护照</option>
                        <option value="22" <#if applicantInfo.idType == "22">selected="selected"</#if>>旅行证</option>
                        <option value="23" <#if applicantInfo.idType == "23">selected="selected"</#if>>回乡证</option>
                        <option value="24" <#if applicantInfo.idType == "24">selected="selected"</#if>>居留证件</option>
                        <option value="25" <#if applicantInfo.idType == "25">selected="selected"</#if>>港澳居民来往内地通行证
                        </option>
                        <option value="26" <#if applicantInfo.idType == "26">selected="selected"</#if>>台湾居民来往内地通行证
                        </option>
                        <option value="29" <#if applicantInfo.idType == "29">selected="selected"</#if>>其他个人证件</option>
                        <option value="31" <#if applicantInfo.idType == "31">selected="selected"</#if>>组织机构代码证</option>
                        <option value="32" <#if applicantInfo.idType == "32">selected="selected"</#if>>工商登记证</option>
                        <option value="33" <#if applicantInfo.idType == "33">selected="selected"</#if>>税务登记证</option>
                        <option value="34" <#if applicantInfo.idType == "34">selected="selected"</#if>>营业执照</option>
                        <option value="99" <#if applicantInfo.idType == "99">selected="selected"</#if>>其他</option>
<#--                        <option value="37" <#if applicantInfo.idType == "37">selected="selected"</#if>>统一社会信用代码</option>-->
                    </select>
                </div>
                <div class="info">
                    <span class="lable-text">证件号码:</span>
                    <input type="text" class="input-text" name="applicantIdNumber" id="applicantIdNumber"
                           value="${(applicantInfo.idNumber)!}" onchange="validateIdCard(this,'2','1')"/>
                </div>
                <div class="info">
                    <span class="lable-text">投保人手机:</span>
                    <input type="text" class="input-text" name="applicantMobile" id="applicantMobile"
                           value="${(applicantInfo.mobile)!}" onchange="validateMobile(this,'1')"/>
                </div>
                <div class="info applicantInfoCard">
                    <span class="lable-text">投保人性别:</span>
                    <span class="radio-text">
                        <input type="radio" name="applicantGender" value="1"
                               <#if (applicantInfo.gender!1) == 1>checked="checked"</#if>/>男
                        <input type="radio" name="applicantGender" value="2"
                               <#if (applicantInfo.gender!1) == 2>checked="checked"</#if>/>女
                        <input type="hidden" id="applicantGender" value="${applicantInfo.gender !"1"}"/>
                    </span>
                </div>
                <div class="info applicantInfoCard">
                    <span class="lable-text">出生日期:</span>
                    <input type="text" class="input-text" readonly="readonly" name="applicantInfoBirthDay"
                           id="applicantInfoBirthDay"
                           value="${(applicantInfo.birthDay)?string("yyyy-MM-dd")!}"/>
                </div>
            </div>
        </div>

        <div class="base-title">被保人信息</div>
        <div class="base-info">
            <div class="info-line">
                <div class="info">
                    <span class="lable-text">被保人姓名:</span>
                    <input type="text" class="input-text" name="name" id="name" value="${(insuredInfo.name)!}"
                           onchange="validateName(this)"/>
                </div>
                <div class="info">
                    <span class="lable-text">证件类型:</span>
                    <select class="select-text" name="idType" id="idType">
                        <option value="01" <#if insuredInfo.idType == "01">selected="selected"</#if>>身份证</option>
                        <option value="02" <#if insuredInfo.idType == "02">selected="selected"</#if>>户口薄</option>
                        <option value="03" <#if insuredInfo.idType == "03">selected="selected"</#if>>护照</option>
                        <option value="04" <#if insuredInfo.idType == "04">selected="selected"</#if>>军人证件</option>
                        <option value="05" <#if insuredInfo.idType == "05">selected="selected"</#if>>驾驶执照</option>
                        <option value="06" <#if insuredInfo.idType == "06">selected="selected"</#if>>返乡证</option>
                        <option value="07" <#if insuredInfo.idType == "07">selected="selected"</#if>>港澳身份证</option>
                        <option value="08" <#if insuredInfo.idType == "08">selected="selected"</#if>>工号</option>
                        <option value="09" <#if insuredInfo.idType == "09">selected="selected"</#if>>赴台通行证</option>
                        <option value="10" <#if insuredInfo.idType == "10">selected="selected"</#if>>港澳通行证</option>
                        <option value="15" <#if insuredInfo.idType == "15">selected="selected"</#if>>士兵证</option>
                        <option value="21" <#if insuredInfo.idType == "21">selected="selected"</#if>>外国护照</option>
                        <option value="22" <#if insuredInfo.idType == "22">selected="selected"</#if>>旅行证</option>
                        <option value="23" <#if insuredInfo.idType == "23">selected="selected"</#if>>回乡证</option>
                        <option value="24" <#if insuredInfo.idType == "24">selected="selected"</#if>>居留证件</option>
                        <option value="25" <#if insuredInfo.idType == "25">selected="selected"</#if>>港澳居民来往内地通行证
                        </option>
                        <option value="26" <#if insuredInfo.idType == "26">selected="selected"</#if>>台湾居民来往内地通行证
                        </option>
                        <option value="29" <#if insuredInfo.idType == "29">selected="selected"</#if>>其他个人证件</option>
                        <option value="31" <#if insuredInfo.idType == "31">selected="selected"</#if>>组织机构代码证</option>
                        <option value="32" <#if insuredInfo.idType == "32">selected="selected"</#if>>工商登记证</option>
                        <option value="33" <#if insuredInfo.idType == "33">selected="selected"</#if>>税务登记证</option>
                        <option value="34" <#if insuredInfo.idType == "34">selected="selected"</#if>>营业执照</option>
                        <option value="99" <#if insuredInfo.idType == "99">selected="selected"</#if>>其他</option>
<#--                        <option value="37" <#if insuredInfo.idType == "37">selected="selected"</#if>>统一社会信用代码</option>-->
                    </select>
                </div>
                <div class="info">
                    <span class="lable-text">证件号码:</span>
                    <input type="text" class="input-text" name="idNumber" id="idNumber"
                           value="${(insuredInfo.idNumber)!}"  onchange="validateIdCard(this,'1')"/>
                </div>
                <div class="info">
                    <span class="lable-text">被保人手机:</span>
                    <input type="text" class="input-text" name="mobile" id="mobile" value="${(insuredInfo.mobile)!}"
                           onchange="validateMobile(this)"/>
                </div>
                <div class="info insuredInfoCard">
                    <span class="lable-text">被保人性别:</span>
                    <span class="radio-text">
                        <input type="radio" name="gender" value="1"
                               <#if (insuredInfo.gender!1) == 1>checked="checked"</#if>/>男
                        <input type="radio" name="gender" value="2"
                               <#if (insuredInfo.gender!1) == 2>checked="checked"</#if>/>女
                        <input type="hidden" id="gender" value="${insuredInfo.gender !"1"}"/>
                    </span>
                </div>
                <div class="info insuredInfoCard">
                    <span class="lable-text">出生日期:</span>
                    <input type="text" class="input-text" readonly="readonly" name="birthDay" id="birthDay"
                           value="${(insuredInfo.birthDay)?string("yyyy-MM-dd")!}"/>
                </div>
                <div class="info">
                    <span class="lable-text">详细地址:</span>
                    <input type="text" class="input-text" name="address" id="address"
                           value="${(insuredInfo.address)!}" onchange="validateNull(this)"/>
                </div>
                <div class="info">
                    <span class="lable-text">被保人邮箱:</span>
                    <input type="text" class="input-text" name="email" id="email"
                           value="${(insuredInfo.email)!}" onchange="validateEmail(this, '1')"/>
                </div>
            </div>
        </div>


        <div class="base-title">标的信息</div>
        <div class="base-info">
            <div class="info-line">
                <div class="info">
                    <span class="lable-text">家庭成员构成:</span>
                    <select class="select-text" name="mortgageNo" id="insureAreaCode">
                        <option value="00" <#if (requiredInfo.mortgageNo!"01") == "01">selected="selected"</#if>>无子女</option>
                        <option value="01" <#if (requiredInfo.mortgageNo!"01") == "00">selected="selected"</#if>>有子女</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="button-line">
            <span class="price-text">￥<span id="insurancePremium">0.00</span>元</span>
            <span class="button-text" onclick="insurePayInfo()">确认投保</span>
        </div>
    </div>

</div>
<div class="web-page">
<#include "../common/common.ftl" />
</div>
</body>
<#include "commonJs.ftl" />
<script type='text/javascript' src="${c_static}/js/cusIdentity/zfo.js?ver=${static_v}"></script>
</html>