<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache">
    <meta name="renderer" content="webkit">
    <link rel="stylesheet" href="${c_static}/css/reinsurance/insurance.css">
    <link rel="stylesheet" href="${c_static}/jQuery_UI/css/jquery-ui.min.css">
    <link rel="stylesheet" href="${c_static}/datatables/jquery.dataTables.css">
    <link rel="stylesheet" href="${c_static}/datatables/dataTables.bootstrap.css">
    <script type='text/javascript' src="${c_static}/js/reinsurance/jquery-3.1.1.min.js"></script>
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/jquery-ui.min.js"></script>
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/datepicker-zh-CN.js"></script>
    <script type='text/javascript' src="${c_static}/datatables/jquery.dataTables.js"></script>
    <script type='text/javascript' src="${c_static}/datatables/dataTables.bootstrap.js"></script>
    <script type='text/javascript' src="${c_static}/js/common.js"></script>
    <title>产品投保</title>
</head>
<body>
<div class="content">
    <div class="h-title">产品投保</div>
    <div class="base-content">
        <div class="base-title">保单查询</div>
        <form id="searchForm">
            <input type="hidden" value="${tsUserCode!""}" name="tsUserCode" id="tsUserCode">
            <div class="base-info">
                <div class="info-line">
                    <div class="long-info">
                        <span class="lable-text">投保区间:</span>
                        <span class="radio-text">
                        <input type="radio" name="insuranceDate" value="0" checked="checked"/>当天
                        <input type="radio" name="insuranceDate" value="6"/>七天内
                        <input type="radio" name="insuranceDate" value="-1"/>自定义
                        <input type="hidden" id="insuranceDate" value="0"/>
                    </span>
                    </div>
                    <div class="long-info">
                        <span class="lable-text">投保日期:</span>
                        <input type="text" class="date-text" readonly="readonly" name="insuranceStartDate"
                               id="insuranceStartDate" disabled="disabled"
                               value="${(insuranceStartDate)?string("yyyy-MM-dd")!}"/> -
                        <input type="text" class="date-text" readonly="readonly" name="insuranceEndDate"
                               id="insuranceEndDate" disabled="disabled"
                               value="${(insuranceStartDate)?string("yyyy-MM-dd")!}"/>
                    </div>
                    <div class="long-info">
                        <span class="lable-text">客户名称:</span>
                        <input type="text" class="input-text" name="name" id="name"/>
                    </div>
                    <div class="long-info">
                        <span class="lable-text">车牌号:</span>
                        <input type="text" class="input-text" name="licenseNo" id="licenseNo"/>
                    </div>
                </div>
            </div>
        </form>
        <div class="button-line">
            <span class="button-text" onclick="quaryPolicy()">查询</span>
            <span class="button-text" id="batchDownLoad">批量下载</span>
        </div>

        <div class="base-title">查询结果</div>
        <div class="table-content">
            <table class="table table-bordered jambo_table bulk_action table-striped table-hover"
                   id="resultDataTable">
                <thead>
                <tr class="headings">
                    <th width="8%">序号</th>
                    <th width="15%">投保日期</th>
                    <th width="12%">保单号</th>
                    <th width="15%">电子保单链接</th>
                    <th width="15%">电子发票链接</th>
                    <th width="10%">客户姓名</th>
                    <th width="10%">客户手机</th>
                    <th width="8%">被保人名称</th>
                    <th width="8%">保费</th>
                    <th width="10%">操作</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>

    <div class="alert-content">
        <div class="text-title"><span class="top">短信内容：</span><span class="text-info"></span><span class="close" id="alert-close">×</span></div>
        <div class="text-content"></div>
        <div class="text-line">
            <span class="alert-label">客户手机：</span>
            <span class="alert-input"><input id="smsMobile" name="smsMobile" maxlength="11"></span>
            <span class="alert-button" onclick="smsDownloanPolicy()">确定发送</span>
        </div>
    </div>
</div>
<div class="web-page">
<#include "../common/common.ftl" />
</div>
</body>
<script type='text/javascript' src="${c_static}/js/dataTables/dataTablesCommon.js"></script>
<script type='text/javascript' src="${c_static}/js/reinsurance/validate.js"></script>
<script type='text/javascript' src="${c_static}/js/query/queryPolicy.js"></script>
</html>