<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache">
    <meta name="renderer" content="webkit">
    <link rel="stylesheet" href="${c_static}/css/reinsurance/insurance.css">
    <link rel="stylesheet" href="${c_static}/jQuery_UI/css/jquery-ui.min.css">
    <link rel="stylesheet" href="${c_static}/datatables/jquery.dataTables.css">
    <link rel="stylesheet" href="${c_static}/datatables/dataTables.bootstrap.css">
    <script type='text/javascript' src="${c_static}/js/reinsurance/jquery-3.1.1.min.js"></script>
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/jquery-ui.min.js"></script>
    <script type='text/javascript' src="${c_static}/jQuery_UI/js/datepicker-zh-CN.js"></script>
    <script type='text/javascript' src="${c_static}/datatables/jquery.dataTables.js"></script>
    <script type='text/javascript' src="${c_static}/datatables/dataTables.bootstrap.js"></script>
    <script type='text/javascript' src="${c_static}/js/common.js"></script>
    <title>产品投保</title>
    <style>
        .sign-thumbnail {
            width: 100px;
        }
    </style>
</head>
<body>
<div class="content">
    <div class="h-title">产品投保</div>
    <div class="base-content">
        <div class="base-title">签名查询</div>
        <form id="searchForm">
            <input type="hidden" value="${tsUserCode!""}" name="tsUserCode" id="tsUserCode">
            <div class="base-info">
                <div class="info-line">
                    <span class="remind">温馨提示：如客户已签名则可在此页面查询到签名记录，客户名称支持模糊查询，鼠标悬停签名图片可显示大图。点击投保单号可显示支付二维码，如有需要可将二维码截图发给客户进行支付。</span>
                </div>
                <div class="info-line">
                    <div class="long-info">
                        <span class="lable-text">投保日期:</span>
                        <input type="text" class="date-text" name="insureDateStart"
                               id="insuranceStartDate"
                               value="${(insuranceStartDate)?string("yyyy-MM-dd")!}"/> -
                        <input type="text" class="date-text" name="insureDateEnd"
                               id="insuranceEndDate"
                               value="${(insuranceEndDate)?string("yyyy-MM-dd")!}"/>
                    </div>
                    <div class="long-info">
                        <span class="lable-text">客户名称:</span>
                        <input type="text" class="input-text" name="customerName" id="name"/>
                    </div>
                    <div class="long-info">
                        <span class="lable-text">险种:</span>
                        <select class="select-text" name="riskCode" id="riskCode">
                            <option value="">全部</option>
                            <#list allRiskCodes as r>
                                <option value="${r.code}">${r.code!}-${r.name!}</option>
                            </#list>
                        </select>
                    </div>
                </div>
            </div>
        </form>
        <div class="button-line">
            <span class="button-text" onclick="querySign()">查询</span>
        </div>

        <div class="base-title">查询结果</div>
        <div class="table-content">
            <table class="table table-bordered jambo_table bulk_action table-striped table-hover"
                   id="resultDataTable">
                <thead>
                <tr class="headings">
                    <th width="8%">序号</th>
                    <th width="8%">投保日期</th>
                    <th width="12%">投保单号</th>
                    <th width="8%">投保险种</th>
                    <th width="8%">客户姓名</th>
                    <th width="8%">客户手机</th>
                    <th width="8%">被保人名称</th>
                    <th width="8%">保费</th>
                    <th width="10%">签名</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
    <div class="big-sign-modal">
        <img src="">
    </div>
</div>
<div class="web-page">
<#include "../common/common.ftl" />
</div>
</body>
<script type='text/javascript' src="${c_static}/js/dataTables/dataTablesCommon.js"></script>
<script type='text/javascript' src="${c_static}/js/reinsurance/validate.js"></script>
<script type='text/javascript' src="${c_static}/js/query/querySign.js"></script>
</html>