<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>健康问卷</title>
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=0">
    <link rel="stylesheet" href="${c_static}/css/reinsurance/input.css">
    <link rel="stylesheet" href="${c_static}/css/reinsurance/questionnaire.css">

    <script type='text/javascript' src="${c_static}/js/reinsurance/jquery-3.1.1.min.js"></script>
    <script src="${c_static}/js/signature_pad.min.js"></script>
    <style type="text/css">
        .yuan1 {
            position: absolute;
            left: 0;
            top: 0.1rem;
            border: 1px solid #ed4a47;
            background-color: #ffffff;
            width: 0.3rem;
            height: 0.3rem;
            border-radius: 50%;
        }

        .yuanContent {
            padding: 0.1rem 0.1rem;
            line-height: 0.30rem;
            font-size: 0.3rem;
            font-weight: bold;
        }

        .signature-canvas-wapper {
            border: 1px solid black;
            width: 100%;
            height: 175px;
        }

        #signature-canvas {
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
        }
    </style>
</head>
<body>
<input type="hidden" id="recommendId" value="${recommendId!}"/>
<div class="title"><a href="${ctx}/reinsurance/productInfo.do?recommendId=${recommendId}" class="return"><span
        class="return"></span></a>健康问卷
</div>
<div class="content">
    <p class="bold titles">“人人安康”百万医疗保险健康问卷</p>
    <p class="bold">尊敬的客户：</p>
    <p class="bold indent">为了维护您的权益，投保前请仔细阅读并 回答 以下健康 问询
        。投保人应在对被保险人健康状况充分了解的基础上履行如下告知义务。投保人承诺完全知晓被保险人的健康状况。若被保险人健康状况与下述告知内容不符：</p>
    <p class="bold indent2">（1）本保险人有权不同意承保。</p>
    <p class="bold indent2">（2）若发生保险事故，本保险人不承担给付保险金的责任。</p>
    <p>1. 被保险人过去 2 年内投保人身保险或健康保险时， 未曾被保险公司拒保、延期、加费或者附加条件承保。</p>
    <p>2. 被保险人过去 1 年内未曾发现健康检查结果异常（包括但不限于血液、超声、影像、内镜、病理检查），或发现健康检查结果异常但医生未曾对被保险人提出进一步复查、治疗或手术建议。但因下列情况不属于健康检查结果异常：</p>
    <p class="indent">●&nbsp;甲状腺囊肿、甲状腺结节直径小于 1 厘米、甲状腺结节经穿刺活检证实为良性 </p>
    <p class="indent">●&nbsp;轻度脂肪肝：腹部 B 超提示为轻度脂肪肝 </p>
    <p class="indent">●&nbsp;血脂偏高，但血压的收缩压低于 140mmHg 且舒张压低于 90mmHg </p>
    <p class="indent">●&nbsp;血压偏高，但收缩压低于 160mmHg 且舒张压低于 100mmHg，并且血脂正常 </p>
    <p class="indent">●&nbsp;呼吸道感染引起的血常规检查异常 </p>
    <p class="indent">●&nbsp;尿路感染引起的尿常规检查异常 </p>
    <p class="indent">●&nbsp;子宫颈或阴道炎症引起的白带异常 </p>
    <p class="indent">●&nbsp;轻度宫颈炎</p>
    <p class="indent">●&nbsp;鼻炎、咽喉炎 </p>
    <p class="indent">●&nbsp;近视、远视、散光</p>
    <p class="indent">●&nbsp;牙科检查异常 </p>
    <p class="indent">●&nbsp;健康检查结果异常，但经医生进一步复查后证实原检查结果有误，并经复查结果正常 </p>
    <p>3．在过去 2 年内被保险人 未曾住院。</p>
    <p>但因以下原因住院，且截至目前已痊愈出院超过一个月的，视同未曾住院：</p>
    <p class="indent">●&nbsp;剖腹产、顺产</p>
    <p class="indent">●&nbsp;鼻炎/鼻中隔偏曲手术</p>
    <p class="indent">●&nbsp;急性胃肠炎</p>
    <p class="indent">●&nbsp;肺炎</p>
    <p class="indent">●&nbsp;急性上呼吸道感染</p>
    <p class="indent">●&nbsp;急性气管炎/急性支气管炎/急性肺炎</p>
    <p class="indent">●&nbsp;扁桃体摘除术</p>
    <p class="indent">●&nbsp;急性阑尾炎</p>
    <p class="indent">●&nbsp;疝气修补术</p>
    <p class="indent">●&nbsp;胆囊结石<u>（不包括肝内胆管结石）</u>、胆囊息肉手术、胆囊切除手术</p>
    <p class="indent">●&nbsp;输尿管结石手术</p>
    <p class="indent">●&nbsp;子宫肌瘤手术</p>
    <p class="indent">●&nbsp;卵巢良性肿瘤、卵巢囊肿手术</p>
    <p class="indent">●&nbsp;乳房纤维瘤手术</p>
    <p class="indent">●&nbsp;单纯痔疮切除术</p>
    <p class="indent">●&nbsp;宫外孕</p>
    <p class="indent">●&nbsp;四肢骨折</p>
    <p class="indent">●&nbsp;单纯住院体检，且检查结果正常（本原因无需等待痊愈出院一个月）</p>
    <p>4. 被保险人目前及过往未曾出现过下列疾病、症状或情况：</p>
    <p class="indent">恶性肿瘤(包括原位癌、白血病)、良性肿瘤（不包括子宫肌瘤、乳房纤维瘤、卵巢良性肿瘤、卵巢囊肿、皮下脂肪瘤）、2 级或以上高血压(收缩压大于等于 160mmHg
        或舒张压大于等于100mmHg)、糖尿病（不包括妊娠糖尿病但产后恢复正常的情形）、冠心病/冠状动脉狭窄、心肌梗死、风湿性心脏病、心肌病、心功能不全二级以上、脑梗死/脑出血、慢性肾炎、肾功能不全、乙型肝炎伴肝功能异常、丙型肝炎伴肝功能异常、肝硬化、再生障碍性贫血、血友病、系统性红斑狼疮、类风湿性关节炎、胶原性疾病及结缔组织疾病（包括但不限于硬皮病、干燥综合征、皮肌炎、动脉炎）、风湿性关节炎、痛风性关节炎
        （发作超过一次或伴有关节变形）、强直性脊柱炎、帕金森氏病、阿尔茨海默症、癫痫、精神病、慢性阻塞性肺病、瘫痪、克罗恩病（节段性肠炎）、慢性支气管炎、溃疡性结肠炎、先天性疾病、艾滋病及 HIV
        阳性、药物成瘾史、酗酒史【酗酒是指一年内平均每日酒精摄取量超过 60 克（男性）或 40 克（女性），每10 克酒精摄取量相当于 1 杯（330ml）啤酒或半杯（150ml）葡萄酒或者 45ml
        白酒】、职业病、智能障碍。</p>
    <p>5. 被保险人过去 1 年内未曾存在下列症状：</p>
    <p class="indent">
        反复头痛、晕厥、胸痛、气急、紫绀，持续反复发热、抽搐，不明原因皮下出血点、咯血，反复呕吐、进食梗噎感或吞咽困难、腹痛，浮肿、呕血、黄疸（新生儿黄疸已治愈的除外）、便血（单纯因痔疮原因除外）、血尿、蛋白尿、肿块、消瘦（不明原因
        6 个月内体重减轻 5 公斤以上）。</p>
    <p>6. 女性被保险人：被保险人目前未在妊娠过程中，且未有医生或体检医师告知过被保险人有乳房结节或肿块（不包括单纯乳腺增生）、子宫内膜异位症或卵巢巧克力囊肿、子宫肌瘤(直径大于 5
        厘米)、中度及以上宫颈炎、慢性盆腔炎、葡萄胎。</p>
    <p>7. 2 周岁以下被保险人未存在下列情况：</p>
    <p class="indent">出生时体重低于 2.5 公斤、早产、窒息或缺氧史，发育迟缓，脑瘫。</p>
<#--<p class="bold" id="agree-tips">对于上述 条件，被保险人的健康状况 是否完全符合？</p>-->
<#--<div class="yuanGroup">-->
<#--<div class="see yuanWrap">-->
<#--<div class="yuan1">-->
<#--<div class="yuan2"></div>-->
<#--<input type="hidden" id="health-agree" value="0">-->
<#--</div>-->
<#--<div class="yuanContent">-->
<#--完全符合-->
<#--</div>-->
<#--</div>-->
<#--<div class="see yuanWrap">-->
<#--<div class="yuan1">-->
<#--<div class="yuan2"></div>-->
<#--<input type="hidden" id="health-not-agree" value="0">-->
<#--</div>-->
<#--<div class="yuanContent">-->
<#--部分符合-->
<#--</div>-->
<#--</div>-->
<#--</div>-->
    <div class="calculation content3">
        <div class="topTitle">投保人声明</div>
        <p>本人已详细阅读
            <span class="seeContent"
                  onclick="showContent('${ctx}/reinsurance/insured.do?source=health&recommendId=${recommendId}')">《投保须知》</span>、
            <span class="seeContent"
                  onclick="showContent('${ctx}/reinsurance/clause.do?source=health&recommendId=${recommendId}')">《保险条款》</span>、
            <span class="seeContent"
                  onclick="showContent('${ctx}/reinsurance/agreement.do?source=health&recommendId=${recommendId}')">《特别约定》</span>和
            保险公司偿付能力声明等内容，尤其对其中免除保险人责任的条款（包括但不限于责任免除条款、免赔额、免赔率、比例赔付或者给付等免除或者减轻保险人责任的条款）已充分理解并接受，同意以此作为订立保险合同的依据。上述所填写的内容及其他本人所填投保资料为保险合同的重要组成部分，均属事实。
        </p>
        <p>本人同意保险人自行或委托第三方调查、收集与被保险人健康相关的资料，用以办理本保险投保或理赔事宜，并同意知晓或拥有被保险人健康状况资料的个人或机构向保险人如实提供。</p>
        <p>本人已认真阅读本产品的健康问卷，并确认：对于健康问卷中述及的所有条件，所有被保险人的健康状况均符合要求。</p>
        <p id="isrenew"></p>
    </div>
    <div class="calculation content3">
        <div class="topTitle">投保人签名</div>
        <div class="signature-canvas-wapper">
            <canvas id="signature-canvas" style="touch-action: none;"></canvas>
        </div>
    </div>
</div>
<div class="button" id="sign-btns">
    <a class="no" href="javascript:(0)">重签</a>
    <a class="yes" data-sign-finished-to="${ctx}/reinsurance/baseInfo.do?recommendId=${recommendId}"
       href="javascript:(0)">确认</a>
</div>
<div class="mask"></div>
<div class="popup" id="no_sign_popup" style="z-index: 9999;">
    <p class="title2">未通过</p>
    <div class="cont">请先签名后再提交。</div>
    <div class="pop-button">确定</div>
</div>

<script type='text/javascript' src="${c_static}/js/reinsurance/index.js"></script>
<script type="text/javascript">
    function showContent(url) {
        window.location.href = url;

    }


    $.ajax('/sfzn/renewal/isrenew.do?recommendId=' + $('#recommendId').val(), {
        data: JSON.stringify({
            recommendId: "${recommendId}"

        }),
        contentType: "application/json; charset=utf-8",
        dataType: 'json',//服务器返回json格式数据
        type: 'post',//HTTP请求类型
        timeout: 10000,//超时时间设置为10秒；
        success: function (r) {
            var data = eval("(" + r + ")");
            var name = "";
            var name1 = "";
            var context;
            var length = data.cusRecommendPersonnelDoList.length;
            for (var i = 0; i < length; i++) {

                if (data.cusRecommendPersonnelDoList[i].renewal == true) {
                    if (name == "") {
                        name = data.cusRecommendPersonnelDoList[i].name;
                    } else {
                        name = name + "、" + data.cusRecommendPersonnelDoList[i].name;
                    }

                } else {
                    if (name1 == "") {
                        name1 = data.cusRecommendPersonnelDoList[i].name;
                    } else {
                        name1 = name1 + "、" + data.cusRecommendPersonnelDoList[i].name;
                    }
                }
            }
            var context = ""
            if (name != "" && name1 != "") {
                context = "本次投保的" + name1 + "是新保，" + name + "是续保。"
            } else if (name != "" && name1 == "") {
                context = "本次投保的" + name + "是续保。"
            } else {
                context = "本次投保的" + name1 + "是新保。"
            }
            $("#isrenew").html(context);


        },
        error: function (xhr, type, errorThrown) {

        }
    });
    var canvas = document.querySelector("#signature-canvas");
    var signaturePad = new SignaturePad(canvas, {
        // It's Necessary to use an opaque color when saving image as JPEG;
        // this option can be omitted if only saving as PNG or SVG
        backgroundColor: 'rgb(255, 255, 255)'
    });
    var $signaturePadWapper = $('.signature-canvas-wapper');

    function resizeCanvas() {
        var ratio = Math.max(window.devicePixelRatio || 1, 1);
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = canvas.offsetHeight * ratio;
        canvas.getContext("2d").scale(ratio, ratio);
        signaturePad.clear(); // otherwise isEmpty() might return incorrect value
    }

    window.addEventListener("resize", resizeCanvas);
    resizeCanvas();

    $('.yes').on('click', function (e) {
        var _that = $(this);
        if (signaturePad.isEmpty()) {
            $('.mask').show();
            $('#no_sign_popup').show();
        } else {
            // 上传图片
            $.ajax('/sfzn/uploader/image/api/dataUrl', {
                data: JSON.stringify({
                    images: [
                        {dataUrl: signaturePad.toDataURL("image/jpeg")}
                    ]
                }),
                contentType: "application/json; charset=utf-8",
                dataType: 'json',//服务器返回json格式数据
                type: 'post',//HTTP请求类型
                timeout: 10000,//超时时间设置为10秒；
                success: function (data) {
                    $.ajax('/sfzn/reinsurance/signature.do?recommendId=' + $('#recommendId').val(), {
                        data: JSON.stringify({
                            recommendId: "${recommendId}",
                            signatureUrl: data[0].absoluteFilePath
                        }),
                        contentType: "application/json; charset=utf-8",
                        dataType: 'json',//服务器返回json格式数据
                        type: 'post',//HTTP请求类型
                        timeout: 10000,//超时时间设置为10秒；
                        success: function (r) {
                            if (r['respCode'] === '0000') {
                                window.location.href = _that.attr('data-sign-finished-to');
                            }
                        },
                        error: function (xhr, type, errorThrown) {

                        }
                    });
                },
                error: function (xhr, type, errorThrown) {

                }
            });
        }
    });

    $('.no').on('click', function (e) {
        signaturePad.clear();
    });

    $('.pop-button').click(function () {
        $('.mask,.popup').hide();
    });
    $('.yuan1').click(function () {
        var $this = $(this);
        var $p = $this.parents('.yuanWrap');
        var broders = [];
        $p.prevAll().each(function (e) {
            broders.push($(this));
        });

        $p.nextAll().each(function (e) {
            broders.push($(this));
        });

        $this.find('.yuan2').toggle();

        if (broders.length > 0) {
            // 当有兄弟节点时，互斥选择
            if ($this.find('input').val() == '0') {
                $this.find('input').val("1");
                $this.find('.bottomRight').removeClass('disable');
                var $input;
                // 将其它兄弟的选中状态去掉
                for (var i in broders) {
                    $input = broders[i].find('.yuan1 input');
                    if ($input.val() === '1') {
                        $input.val('0');
                        broders[i].find('.yuan1 .yuan2').hide();
                    }

                }
            } else {
                $this.find('input').val("0");
                $this.find('.bottomRight').addClass('disable');
            }
        } else {
            // 没有兄弟节点时，单圈处理
            if ($this.find('input').val() == '0') {
                $this.find('input').val("1");
                $this.find('.bottomRight').removeClass('disable');
            } else {
                $this.find('input').val("0");
                $this.find('.bottomRight').addClass('disable');
            }
        }
        $this.find('input').trigger("change");
    });

    $('#health-not-agree').on('change', function (e) {
        var that = $(this);
        if (that.val() === '1') {
            $('.mask,.popup').show();
            $('#sign-btns').hide();
        }
    });
    $('#health-agree').on('change', function (e) {
        var that = $(this);
        if (that.val() === '1') {
            $('#sign-btns').show();
        }
    })
</script>
</body>
</html>