<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link rel="stylesheet" type='text/css' href="${ctx}/css/queryRiskScore.css">
    <title>风险分查询</title>
<#include "${ctx}/layout/_head.ftl" />
</head>
<body class="customBody">
<div class="layui-layout layui-layout-admin">
    <fieldset class="layui-elem-field layui-field-title customFiledSet">
        <legend>
            信息查询 > 风险分查询
            <span class="downloadSpan">
                【
                <a id="antifraudDoc" class="downloadAll" href="${ctx}/download/天御反欺诈方案.pdf" download="天御反欺诈方案.pdf">功能文档下载</a>
                】
            </span>
        </legend>
    </fieldset>

    <form class="layui-form query-form" id="queryForm" action="javascript:void(0)" method="post">
        <input id="userName" name="userName" type="hidden" value="${amdinUsername}">
        <input id="isInit" name="isInit" type="hidden" value="0">
        <div class="layui-form-item" style="width: 100%; margin-bottom: 5px;">
            <div class="layui-form-item layui-inline" style="width: 30%;">
                <label class="layui-form-label">身份证号</label>
                <div class="layui-inline" style="width: 70%">
                    <input type="text" id="identifyNo" name="identifyNo" lay-verify="identifyNo" placeholder="请输入身份证号"
                           autocomplete="off" class="layui-input" maxlength="18">
                </div>
            </div>
            <div class="layui-form-item layui-inline" style="width: 30%;">
                <label class="layui-form-label">地区</label>
                <div class="layui-inline" style="width: 70%">
                    <select name="city" lay-verify="required">
                        <option value="0086-" selected>中国大陆 +86</option>
                        <option value="00852-">中国香港 +852</option>
                        <option value="00853-">中国澳门 +853</option>
                        <option value="00886-">中国台湾地区 +886</option>
                    </select>
                </div>
            </div>
            <div class="layui-form-item layui-inline" style="width: 30%;">
                <label class="layui-form-label">联系方式</label>
                <div class="layui-inline" style="width: 70%">
                    <input type="text" id="mobile" name="mobile" lay-verify="mobile" placeholder="请输入联系方式"
                           autocomplete="off" class="layui-input" maxlength="11">
                </div>
            </div>
        </div>
        <div class="layui-form-item" style="width: 100%; margin-bottom: 5px;">
            <div class="layui-form-item layui-inline" style="width: 60%;">
                <label class="layui-form-label">获取时间</label>
                <div class="layui-input-inline" style="width: 30%">
                    <input type="text" id="updateDateStart" name="updateDateStart" placeholder="开始时间" autocomplete="off" class="layui-input">
                </div>
                <div class="layui-form-mid">-</div>
                <div class="layui-input-inline" style="width: 30%">
                    <input type="text" id="updateDateEnd" name="updateDateEnd" placeholder="结束时间" autocomplete="off" class="layui-input">
                </div>
            </div>
        </div>


    <#--<div class="layui-form-item layui-inline">
        <label class="layui-form-label">银行卡号</label>
        <div class="layui-inline">
            <input type="text" id="creditCardNo" name="creditCardNo" lay-verify="creditCardNo" placeholder="请输入银行卡号"
                   autocomplete="off" class="layui-input" maxlength="18">
        </div>
    </div>-->
        <div class="layui-form-item" style="width: 100%; text-align: right; margin-bottom: 0px;">
            <div class="layui-inline" style="margin-right: 20px">
                <button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit"
                        lay-submit lay-filter="queryDemo" id="queryBtn">
                    <i class="layui-icon">&#xe615;</i>搜 索
                </button>
                <!--<button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit"
                        lay-submit lay-filter="downloadA" id="downloadABtn">
                    <i class="layui-icon">&#xe601;</i>条件下载
                </button>-->
                <#if amdinUsername=='admin'>
                <button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit"
                        lay-submit lay-filter="downloadB" id="downloadBBtn">
                    <i class="layui-icon">&#xe601;</i>条件下载
                </button>
                </#if>
                <button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit"
                        id="upload">
                    <i class="layui-icon">&#xe681;</i>上传操作
                </button>
                <button class="layui-btn layui-btn-warm layui-btn-fluid layui-anim layui-anim-upbit" type="reset">
                    <i class="layui-icon">&#xe640;</i>重 置
                </button>
            </div>
        </div>
    </form>

<#--<div class="layui-row">-->
<#--<button class="layui-btn layui-btn-fluid layui-anim layui-anim-upbit"-->
<#--style="margin-left:3%" onclick="goToNewUrl('${ctx}/userMaint/edit')">新 增</button>-->
<#--</div>-->

    <table id="dataTable" lay-filter="contentTable"></table>
    <script type="text/html" id="modBtn">
        <a class="layui-btn layui-btn-xs" lay-event="edit">重新获取</a>
    </script>
</div>


<#include "${ctx}/layout/_resource.ftl"/>

<script type="text/javascript">
    var myctx = "${ctx}";
</script>

<script id="createTime" type="text/html">
    {{#
    var date = new Date();
    date.setTime(d.updateDate);
    return date.Format("yyyy-MM-dd hh:mm:ss");
    }}
</script>


<script type="text/javascript" src="${ctx}/js/util.js"></script>
<script type="text/javascript" src="${ctx}/js/queryRiskScore.js"></script>

</body>
</html>