<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>

    <title>发送短信分布</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  > 发送短信分布</legend>
</fieldset>
<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 90%;height:400px;"></div>

    <div id="noDataId" style="position: absolute;top: 300px;left:474px;font-size:15px;display: none;">
        暂无数据
    </div>

</div>
<#include "/layout/_resource.ftl"/>

<script>

    $(function(){
        // 基于准备好的dom，初始化echarts实例
//    var myChart = echarts.init(document.getElementById('main'));
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'),{
            noDataLoadingOption:{
                text : '暂无数据',
                effect : 'whirling',
                effectOption:{
                    backgroundColor:"#fff"
                },
                textStyle : {
                    fontSize : 30
                }
            }
        });

        layui.use(['laydate','layer','jquery'],function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true

            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);
            var initializeStartDate = new Date(start.value)
            var initializeendDate = new Date(end.value)
            //页面初始化
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                var sd = new Date(startDate);
                var ed = new Date(endDate);
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    return;
                }
                if(!isSameYear(startDate, endDate)) {
                    layer.tips('请选择同一年份内时间区间', '#startDateId');
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                if(sd.getTime() > ed.getTime() ){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url:"${ctx}/smsMessageDistribution/smsMessageDistributionTotal"
                    ,data:{
                        startDate: initializeStartDate.dateConvert('yyyy/MM/dd'),
                        endDate: initializeendDate.dateConvert('yyyy/MM/dd')
                    },
                    type:"post",
                    dataType:"json",
                    cache: false
                    ,success:function (data) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.flag==false){
                            if(data.status==="startDate"){
                                layer.tips(data.msg,'#startDateId');
                            }
                        }else{
//                    console.log(data);
                            var smsMessageTypes =  data.data.smsMessageTypes;
                            var smsMessageTotals =  data.data.smsMessageTotals;
                            render(smsMessageTypes,smsMessageTotals);
                            if(smsMessageTotals.length==0){
                                $("#noDataId").show();
                            }else{
                                $("#noDataId").css("display","none")
                            }
                        }
                    }
                });
            });

            //点击统计
            $(".statisticsBtn").on("click",function () {
                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();
                var sd = new Date(startDate);
                var ed = new Date(endDate);
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    return;
                }
                if(!isSameYear(startDate, endDate)) {
                    layer.tips('请选择同一年份内时间区间', '#startDateId');
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                if(sd.getTime() > ed.getTime()){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url:"${ctx}/smsMessageDistribution/smsMessageDistributionTotal"
                    ,data:{
                        startDate: startDate,
                        endDate: endDate
                    },
                    type:"post",
                    dataType:"json",
                    cache: false
                    ,success:function (data) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.flag==false){
                            if(data.status==="startDate"){
                                layer.tips(data.msg,'#startDateId');
                            }
                        }else{
//                    console.log(data);
                            var smsMessageTypes =  data.data.smsMessageTypes;
                            var smsMessageTotals =  data.data.smsMessageTotals;
                            render(smsMessageTypes,smsMessageTotals);
                            if(smsMessageTotals.length==0){
                                $("#noDataId").show();
                            }else{
                                $("#noDataId").css("display","none")
                            }
                        }
                    }
                });
            });
        });

        function render(smsMessageTypes,smsMessageTotals) {
            option = {
                title: {
                    text: '发送短信分布',
//                subtext: '虚构数据',
                    left: 'center'
                },
                tooltip : {
                    trigger: 'item',
                    formatter: " {b} : {c} ({d}%)"
                },
                legend: {
                    bottom: 10,
//                left: 'center',
                },
                series : [
                    {
                        type: 'pie',
                        radius : '65%',
                        center: ['50%', '50%'],
                        data:[
                            {value:smsMessageTotals[0],name:smsMessageTypes[0]+':'},
                            {value:smsMessageTotals[1],name:smsMessageTypes[1]+':'},
                            {value:smsMessageTotals[2],name:smsMessageTypes[2]+':'}
                        ],
                        itemStyle: {
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例:({d}%)'
                                },
                                labelLine:{
                                    show:true
                                }
                            }
                            //   emphasis: {
                            //       shadowBlur: 10,
                            //       shadowOffsetX: 0,
                            //       shadowColor: 'rgba(0, 0, 0, 0.5)'
                            //   }
                        }

                    }
                ]
            };
            myChart.setOption(option);
        }

    });


</script>

</body>
</html>








