<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>

    <title>激活方式与激活渠道</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  激活方式与渠道</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="mainTop" style="width: 100%;height:400px;"></div>
    <div id="mainBottom" style="width: 100%;height:400px;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){
        // 基于准备好的dom，初始化echarts实例
        var myChartTop = echarts.init(document.getElementById('mainTop'));
        var myChartBottom = echarts.init(document.getElementById('mainBottom'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }

                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }

                myChartTop.showLoading();
                myChartBottom.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/activateWayAndChannels'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        myChartTop.clear();
                        myChartBottom.clear();
                        if(data.code==0){
                            var obj = data.data;
                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData_top = [];
                            var legendData_top = ['手机和邮箱都未激活数','手机和邮箱都激活数','邮箱激活数','手机激活数'];
                            var seriesData_bottom = [];
                            var legendData_bottom = ['修改手机号/邮箱激活','注册激活'];

                            if(obj.allNonactivated != undefined){
                                seriesData_top.push({value: obj.allNonactivated,name: '手机和邮箱都未激活数'});
                            }
                            if(obj.allActivated != undefined){
                                seriesData_top.push({value: obj.allActivated,name: '手机和邮箱都激活数'});
                            }
                            if(obj.emailActivated !=undefined){
                                seriesData_top.push({value: obj.emailActivated,name: '邮箱激活数'});
                            }
                            if(obj.phoneActivated != undefined){
                                seriesData_top.push({value: obj.phoneActivated,name: '手机激活数'});
                            }

                            if(obj.updateEmailOrPhoneSum != undefined){
                                seriesData_bottom.push({value: obj.updateEmailOrPhoneSum,name:'修改手机号/邮箱激活'});
                            }
                            if(obj.registActivedSum != undefined){
                                seriesData_bottom.push({value: obj.registActivedSum,name:'注册激活'});
                            }

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText_top = firstMonth+"月新增注册用户的激活方式比例";
                            //var titleText_bottom = firstMonth+"月用户的激活渠道比例";
                            var titleText_top = "新增注册用户的激活方式比例";
                            var titleText_bottom = "用户的激活渠道比例";

                            renderTop(titleText_top, legendData_top, seriesData_top);
                            renderBottom(titleText_bottom, legendData_bottom, seriesData_bottom);

                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChartTop.showLoading();
                myChartBottom.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/activateWayAndChannels'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData_top = [];
                            var legendData_top = ['手机和邮箱都未激活数','手机和邮箱都激活数','邮箱激活数','手机激活数'];
                            var seriesData_bottom = [];
                            var legendData_bottom = ['修改手机号/邮箱激活','注册激活'];

                            if(obj.allNonactivated != undefined){
                                seriesData_top.push({value: obj.allNonactivated,name: '手机和邮箱都未激活数'});
                            }
                            if(obj.allActivated != undefined){
                                seriesData_top.push({value: obj.allActivated,name: '手机和邮箱都激活数'});
                            }
                            if(obj.emailActivated !=undefined){
                                seriesData_top.push({value: obj.emailActivated,name: '邮箱激活数'});
                            }
                            if(obj.phoneActivated != undefined){
                                seriesData_top.push({value: obj.phoneActivated,name: '手机激活数'});
                            }

                            if(obj.updateEmailOrPhoneSum != undefined){
                                seriesData_bottom.push({value: obj.updateEmailOrPhoneSum,name:'修改手机号/邮箱激活'});
                            }
                            if(obj.registActivedSum != undefined){
                                seriesData_bottom.push({value: obj.registActivedSum,name:'注册激活'});
                            }

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText_top = firstMonth+"月新增注册用户的激活方式比例";
                            //var titleText_bottom = firstMonth+"月用户的激活渠道比例";
                            var titleText_top = "新增注册用户的激活方式比例";
                            var titleText_bottom = "用户的激活渠道比例";
                            renderTop(titleText_top, legendData_top, seriesData_top);
                            renderBottom(titleText_bottom, legendData_bottom, seriesData_bottom);
                        }//code==0 end
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        /**
         * 渲染数据
         */
        function renderTop(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [10,30,0,130],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 30,
                    data: legendData
                },
                series : [
                    {
                        name: '新增注册用户的激活方式比例',
                        type: 'pie',
                        radius : '55%',
                        center: ['50%', '50%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }

                    }
                ]
            };

            myChartTop.setOption(option);
        }

        function renderBottom(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [10,30,0,130],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 30,
                    data: legendData
                },
                series : [
                    {
                        name: '用户的激活渠道比例',
                        type: 'pie',
                        radius : '55%',
                        center: ['50%', '50%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }
                    }
                ]
            };

            myChartBottom.setOption(option);
        }
    });


</script>

</body>
</html>








