<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>

    <title>登录名使用比例</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  登录名使用比例</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 100%;height:400px;float:left;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
                ,ready: function(date){ //控件初始打开的回调
                    console.log('---ready:---'+date); //得到初始的日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                }
                ,change: function(value, date, endDate){ //日期时间被切换后的回调
                    //layer.alert(value); //在控件上弹出value值
                    console.log('---change---'+value); //得到日期生成的值，如：2017-08-18
                    console.log('---change---'+date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                    console.log('---change---'+endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                }
                ,done: function(value, date, endDate){ //空间选择完毕的回调
                    console.log('---done---'+value); //得到日期生成的值，如：2017-08-18
                    console.log('---done---'+date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                    console.log('---done---'+endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                }
            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }

                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/loginNameUsed'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = ['手机号总数','邮箱总数','用户名总数'];
                            seriesData.push({
                                value: obj.phoneCount, name: '手机号总数'
                            });
                            seriesData.push({
                                value: obj.emailCount, name: '邮箱总数'
                            });
                            seriesData.push({
                                value: obj.userNameCount, name: '用户名总数'
                            });
                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月登录名使用比例";
                            var titleText = "登录名使用比例";
                            render(titleText, legendData, seriesData);
                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/loginNameUsed'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = ['手机号总数','邮箱总数','用户名总数'];
                            seriesData.push({
                                value: obj.phoneCount, name: '手机号总数'
                            });
                            seriesData.push({
                                value: obj.emailCount, name: '邮箱总数'
                            });
                            seriesData.push({
                                value: obj.userNameCount, name: '用户名总数'
                            });
                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月登录名使用比例";
                            var titleText = "登录名使用比例";
                            render(titleText, legendData, seriesData);
                        }//code==0 end
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        /**
         * 渲染数据
         */
        function render(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [10,30,0,130],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 20,
                    data: legendData
                },
                series : [
                    {
                        name: '登录名使用比例',
                        type: 'pie',
                        radius : '70%',
                        center: ['50%', '50%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }
                    }
                ]
            };

            myChart.setOption(option);
        }

    });



</script>

</body>
</html>








