<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>

    <title>登录数峰值与时段分布</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  登录数峰值与时段分布</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 100%;height:300px;"></div>
    <!--登录时分布 -->
    <div id="distributionMain" style="width: 100%;height:300px;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){

        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'));
        var distributionMyChart = echarts.init(document.getElementById('distributionMain'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true

            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                myChart.showLoading();
                distributionMyChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/loginNumAndPeriod'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        distributionMyChart.hideLoading();
                        distributionMyChart.clear();
                        if(data.code==0){
                            var allDate = getAll(startDate, endDate); //所选范围内时间（单位：天）

                            var obj = data.data;
                            if(null==obj || undefined==obj){
                                return;
                            }

                            var distribution = obj.distribution;//登录时
                            var loginNumberDateArray = obj.loginDateList; //登录日期 与 登录最大数一一对应
                            var loginNumberArray =obj.loginNumberList; //登录最大数 与登录日期 一一对应

                            var titleVal = "每日用户登录数峰值";
                            render(titleVal,loginNumberDateArray,loginNumberArray);
                            flag = false;
                            var distributionXAxisData = [];
                            var distributionSeriesData = [];
                            for(var j = 0; j < 24; j++ ){
                                distributionXAxisData.push(j+':00~'+(j+1)+':00');
                                for(var i = 0; i < distribution.length; i++ ){
                                    if(j==distribution[i].SUDTIME){
                                        distributionSeriesData.push(distribution[i].SUM);
                                        flag = true;
                                    }
                                }
                                if(flag){
                                    flag = false;
                                }else{
                                    distributionSeriesData.push(0);
                                }
                            }
                            var distributionTitleVal = "官网用户登录时段分布";
                            distributionRender(distributionTitleVal,distributionXAxisData,distributionSeriesData);
                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        distributionMyChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChart.showLoading();
                distributionMyChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/loginNumAndPeriod'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        distributionMyChart.hideLoading();
                        if(data.code==0){
                            var allDate = getAll(startDate, endDate); //所选范围内时间（单位：天）

                            var obj = data.data;
                            if(null==obj || undefined==obj){
                                return;
                            }

                            var loginNumberDateArray = obj.loginDateList; //登录日期 与 登录最大数一一对应
                            var loginNumberArray =obj.loginNumberList; //登录最大数 与登录日期 一一对应
                            var distribution = obj.distribution;//登录时

                            var titleVal = "每日用户登录数峰值";
//                            render(titleVal,allDate,seriesData);
                            render(titleVal,loginNumberDateArray,loginNumberArray);
                            flag = false;
                            var distributionXAxisData = [];
                            var distributionSeriesData = [];
                            for(var j = 0; j < 24; j++ ){
                                distributionXAxisData.push(j+':00~'+(j+1)+':00');
                                for(var i = 0; i < distribution.length; i++ ){
                                    if(j==distribution[i].SUDTIME){
                                        distributionSeriesData.push(distribution[i].SUM);
                                        flag = true;
                                    }
                                }
                                if(flag){
                                    flag = false;
                                }else{
                                    distributionSeriesData.push(0);
                                }
                            }
                            var distributionTitleVal = "官网用户登录时段分布";
                            distributionRender(distributionTitleVal,distributionXAxisData,distributionSeriesData);
                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        distributionMyChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        function render(titleVal, allDate, seriesData){
            myChart.setOption({
                title: {
                    text: titleVal
                    ,subtext: '每日用户登录数峰值'
                    ,x: 'center'
                    ,show:true
                },
                tooltip: {
                    trigger: 'axis'
                },
                legend: {
                    data:['当日最大登录用户数']
                    ,right: 0
                    ,top: 200
                },
                toolbox: {
                    show: false,
                    feature: {
                        dataZoom: {
                            yAxisIndex: 'none'
                        },
                        dataView: {readOnly: false},
                        magicType: {type: ['line', 'bar']},
                        restore: {},
                        saveAsImage: {}
                    }
                },
                grid: {
                    left: '5%',
                    right: '15%',
                    bottom: '5%',
                    top: 70,
                    containLabel: true
                },
                xAxis:  {
                    type: 'category',
                    boundaryGap: false,
                    data: allDate,
                    axisLabel: {
                        interval:0,
                        rotate:40
                    }
                },
                yAxis: {
                    type: 'value',
                    max: 75,
                    min: 0
                },
                series: [
                    {
                        name:'当日最大登录用户数',
                        type:'line',
                        data: seriesData,
                        markPoint: {
                            data: [
                                {type: 'max', name: '最大值'},
                                {type: 'min', name: '最小值'}
                            ]
                        }
                        /*,markLine: {
                            data: [
                                {type: 'average', name: '平均值'}
                            ]
                        }*/
                    }
                ]
            });

        }

        function distributionRender(titleVal, distributionXAxisData, distributionSeriesData){
            distributionMyChart.setOption({
                title: {
                    text: titleVal
                    ,subtext: '官网用户登录时段分布'
                    ,x: 'center'
                    ,show:true
                },
                tooltip: {
                    trigger: 'axis'
                },
                legend: {
                    data:['登录用户数']
                    ,right: 50
                    ,top: 200
                },
                toolbox: {
                    show: false,
                    feature: {
                        dataZoom: {
                            yAxisIndex: 'none'
                        },
                        dataView: {readOnly: false},
                        magicType: {type: ['line', 'bar']},
                        restore: {},
                        saveAsImage: {}
                    }
                },
                grid: {
                    left: '5%',
                    right: '15%',
                    bottom: '5%',
                    top: 70,
                    containLabel: true
                },
                xAxis:  {
                    type: 'category',
                    boundaryGap: false,
                    data: distributionXAxisData,
                    axisLabel: {
                        interval:0,
                        rotate:40
                    }
                },
                yAxis: {
                    type: 'value',
                    max: 400,
                    min: 0
                },
                series: [
                    {
                        name:'登录用户数',
                        type:'line',
                        data: distributionSeriesData
                        /*,markPoint: {
                            data: [
                                {type: 'max', name: '最大值'},
                                {type: 'min', name: '最小值'}
                            ]
                        }*/
                        /*,markLine: {
                            data: [
                                {type: 'average', name: '平均值'}
                            ]
                        }*/
                    }
                ]
            });

        }


    });


</script>


</body>
</html>








