<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>
    <script src="${ctx}/js/util.js"></script>

    <title>新增注册用户数</title>
    <#include "../layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  新增注册用户数</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 90%;height:400px;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){

        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true

            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/newUserRegistrationNum'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.code==0){
                            var allDate = getAll(startDate, endDate); //所选范围内时间（单位：天）
                            var sourceCount = 0;
                            for(var p in (data.data)){
                                sourceCount++;
                            }

                            var legend = ["官网","网厅"]; //封装legend and series.name
                            var series=[];
                            // 指定图表的配置项和数据
                            var dayNum = dateInteval(startDate, endDate)+1;
                            var nums = new Array(sourceCount);//总条数（包括官网、网厅等）
                            for(var i = 1; i < sourceCount+1; i++){
                                if(undefined!=data.data[i][0]){
                                    legend.push(data.data[i][0].source);
                                }

                                //当前时间内每个渠道每天注册数集合
                                var seriesData_source = [];
                                var flag_g = false;
                                for (var k = 0; k < dayNum; k++){
                                    for(var j = 0; j < data.data[i].length; j++ ){
                                        if(allDate[k]==data.data[i][j].dateCreated.replace(/-/g,  "/")){
                                            seriesData_source[k]=data.data[i][j].currentRegistNum;
//                                            seriesData_source[k]=data.data[i][j].currentRegistNum*1/1000;

                                            flag_g = true;
                                            break;
                                        }
                                    }
                                    if(!flag_g){
                                        seriesData_source[k] = 0;
                                    }else{
                                        flag_g = false;
                                    }
                                }

                                if(i==1){
                                    series.push({
                                        name: "官网",
                                        type: 'bar',
                                        data: seriesData_source
                                    });
                                }else{
                                    series.push({
                                        name: "网厅",
                                        type: 'bar',
                                        data: seriesData_source
                                    });
                                }

                                nums[i] = 0;
                                //当前时间内每个渠道注册总和
                                for(var m = 0; m < dayNum; m++){
                                    if(data.data[i][m]!=undefined){
                                        nums[i] += data.data[i][m].currentRegistNum;
                                    }else{
                                        nums[i] += 0;
                                    }
                                }

                            }

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月新增用户注册数（统计时间：" + statisticsDate + "月），";
                            var titleText = "新增用户注册数（统计时间：" + statisticsDate + "月），";
                            for(var t=0; t < sourceCount; t++){
                                titleText += legend[t]+"渠道：总数"+nums[t+1]+",日均"+Math.round(nums[t+1]/dayNum)+"；";
                            }
                            titleText = titleText.substr(0, titleText.length-1);

                            var titleNum = Math.ceil(titleText.length/60);
                            if(0 <= titleText.length && titleText.length <= 60){
                                titleNum = 1;
                            }
                            var titleVal = "";
                            for(var f=0;f<titleNum;f++){
                                titleVal += titleText.substr(f*60, 60)+"\n";
                            }
                            titleVal += titleText.substr(titleNum*60);
                            var marginTop = 60*titleNum;

                            var legendMarginTop = 75;
                            var gridMarginTop = 115;
                            render(titleVal,legendMarginTop,gridMarginTop,legend,allDate,series);

                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                            myChart.hideLoading();
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/newUserRegistrationNum'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        if(data.code==0){
                            var allDate = getAll(startDate, endDate); //所选范围内时间（单位：天）

                            var sourceCount = 0;
                            for(var i in (data.data)){
                                sourceCount++;
                            }

                            var legend = ["官网","网厅"]; //封装legend and series.name
                            var seriesData = []; //所选范文内 数据绑定（单位：天）
                            var series=[];
                            // 指定图表的配置项和数据
                            var dayNum = dateInteval(startDate, endDate)+1;
                            var nums = new Array(sourceCount);//总条数（包括官网、金服等）
                            for(var i = 1; i < sourceCount+1; i++){

                                seriesData.push(data.data[i]);

                                //当前
                                var seriesData_source = []; //所选范围内 数据绑定（单位：天）
                                var flag_g = false;
                                for (var k = 0; k < dateInteval(startDate, endDate)+1; k++){
                                    for(var j = 0; j < data.data[i].length; j++ ){
                                        if(allDate[k]==data.data[i][j].dateCreated.replace(/-/g,  "/")){
                                            seriesData_source[k]=data.data[i][j].currentRegistNum;
//                                            seriesData_source[k]=data.data[i][j].currentRegistNum*1/1000;
                                            flag_g = true;
                                            break;
                                        }
                                    }
                                    if(!flag_g){
                                        seriesData_source[k] = 0;
                                    }else{
                                        flag_g = false;
                                    }
                                }

                                if(i==1){
                                    series.push({
                                        name: "官网",
                                        type: 'bar',
                                        data: seriesData_source
                                    });
                                }else{
                                    series.push({
                                        name: "网厅",
                                        type: 'bar',
                                        data: seriesData_source
                                    });
                                }

                                nums[i] = 0;
                                //获取官网渠道总条数
                                for(var m = 0; m < dayNum; m++){
                                    if(data.data[i][m]!=undefined){
                                        nums[i] += data.data[i][m].currentRegistNum;
                                    }else{
                                        nums[i] += 0;
                                    }
                                }

                            }

                            myChart.hideLoading();

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;

                            //var titleText = firstMonth+"月新增用户注册数（统计时间：" + statisticsDate + "月），";
                            var titleText = "新增用户注册数（统计时间：" + statisticsDate + "月），";
                            //处理在当前时间段内存在为空的渠道，在nums渠道总和中清除该渠道
                            for(var t=0; t < sourceCount; t++){
                                titleText += legend[t]+"渠道：总数"+nums[t+1]+",日均"+Math.round(nums[t+1]/dayNum)+"；";
                            }
                            titleText = titleText.substr(0, titleText.length-1);

                            var titleNum = Math.ceil(titleText.length/60);
                            if(0 <= titleText.length && titleText.length <= 60){
                                titleNum = 1;
                            }
                            var titleVal = "";
                            for(var f=0;f<titleNum;f++){
                                titleVal += titleText.substr(f*60, 60)+"\n";
                            }
                            titleVal += titleText.substr(titleNum*60);
                            var marginTop = 60*titleNum;

                            var legendMarginTop = 75;
                            var gridMarginTop = 115;
                            
                            render(titleVal,legendMarginTop,gridMarginTop,legend,allDate,series);

                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                            myChart.hideLoading();
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        function render(titleVal, legendMarginTop, gridMarginTop, legend, allDate, series){
            
            myChart.setOption({
                title: {
                    text: titleVal,
                    textAlign: 'left',
                    textBaseline: 'middle',
                    top:45,
                    innerHeight:20,
                    left: 30,
                    style:{
                        fontSize:12
                    }
                },
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                        type : 'cross',        // 默认为直线，可选为：'line' | 'shadow' | 'cross'
                        label: {
                            backgroundColor: '#283b56'
                        }
                    }
                },
                legend: {
                    x : 'right',
                    top: legendMarginTop,
                    data: legend
                }
                ,
                calculable: true,
                grid: {
                    left: '7%',
                    right: '4%',
                    bottom: '3%',
                    top: gridMarginTop,
                    containLabel: true
                },
                xAxis: {
                    data: allDate
                    ,axisLabel: {
                        interval: 0
                        ,rotate: 40
                    }
                },
                yAxis : [
                    {
                        type : 'value',
                        min: 0,
                        boundaryGap: [0.2, 0.2]
                        ,axisLabel: {
                        formatter: '{value}'
                    }
                    }
                ],
                series: series
            });
        }

    });




</script>


</body>
</html>








