<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/echarts/js/echarts-gl.min.js"></script>
    <#--<script src="http://echarts.baidu.com/resource/echarts-gl-latest/dist/echarts-gl.min.js"></script>-->
    <script src="${ctx}/echarts/js/theme/macarons.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>

    <title>找回密码请求数与成功数</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  找回密码请求数与成功数</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 90%;height:400px;float:left;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/retrievePassword'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = ['请求数','成功数'];
                            var xAxisData = [];
                            for(var j = 0; j < obj.xAxis.length; j++){
                                xAxisData.push(obj.xAxis[j]);
                            }
                            seriesData.push({
                                name: '请求数',
                                type: 'bar',
                                barMaxWidth: '40',
                                data: [obj.gwAll, obj.wtAll] //请求总数
                            });
                            seriesData.push({
                                name: '成功数',
                                type: 'bar',
                                barMaxWidth: '40',
                                data: [obj.gwSuccess, obj.wtSuccess] //请求成功数
                            });

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月官网网厅找回密码的请求数与成功数";
                            var titleText = "官网网厅找回密码的请求数与成功数";
                            var legendMarginTop = 75;
                            var gridMarginTop = 115;
                            render(titleText,legendMarginTop,gridMarginTop,legendData,xAxisData,seriesData);
                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/retrievePassword'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = ['请求数','成功数'];
                            var xAxisData = [];
                            for(var j = 0; j < obj.xAxis.length; j++){
                                xAxisData.push(obj.xAxis[j]);
                            }
                            seriesData.push({
                                name: '请求数',
                                type: 'bar',
                                barMaxWidth: '40',
                                data: [obj.gwAll, obj.wtAll] //请求总数
                            });
                            seriesData.push({
                                name: '成功数',
                                type: 'bar',
                                barMaxWidth: '40',
                                data: [obj.gwSuccess, obj.wtSuccess] //请求成功数
                            });

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月官网网厅找回密码的请求数与成功数";
                            var titleText = "官网网厅找回密码的请求数与成功数";
                            var legendMarginTop = 75;
                            var gridMarginTop = 115;
                            render(titleText,legendMarginTop,gridMarginTop,legendData,xAxisData,seriesData);

                        }//code==0 end
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        /**
         * 渲染数据
         */
        function render(titleVal,legendMarginTop,gridMarginTop,legend,xAxis,series){
            myChart.setOption({
                title: {
                    text: titleVal,
                    textAlign: 'left',
                    textBaseline: 'middle',
                    top:45,
                    innerHeight:20,
                    left: 30,
                    style:{
                        fontSize:12
                    }
                },
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                        type : 'cross',        // 默认为直线，可选为：'line' | 'shadow' | 'cross'
                        label: {
                            backgroundColor: '#283b56'
                        }
                    }
                },
                legend: {
                    x : 'right',
                    top: legendMarginTop,
                    data: legend
                },
                grid: {
                    left: '7%',
                    right: '4%',
                    bottom: '3%',
                    top: gridMarginTop,
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: xAxis
                },
                yAxis : [
                    {
                        type : 'value',
//                        scale: true,
//                        max: 125,
                        min: 0,
                        boundaryGap: [0.2, 0.2],
                        axisLabel:{
                            formatter:'{value}'
                        }
                    }
                ],
                series: series
            });
        }

    });


</script>

</body>
</html>








