<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/echarts/js/echarts-gl.min.js"></script>
    <#--<script src="http://echarts.baidu.com/resource/echarts-gl-latest/dist/echarts-gl.min.js"></script>-->
    <script src="${ctx}/echarts/js/theme/macarons.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>
    <script src="${ctx}/js/date.js"></script>
    <#--<script type="text/javascript" src="${ctx}/js/date-zh-CN.js"></script>-->



    <title>总注册数</title>
    <#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 38px;
            margin-top: 8px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  总注册数</legend>
</fieldset>

<div class="container">
    <div class="layui-form-item">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-inline">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-inline">
            <label class="layui-form-label" style=" width: 5px;margin-left: -23px;margin-bottom: -29px;">-</label>
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-inline">
            <input id="startDateNextId" type="text" name="startDateNext" placeholder="开始时间1" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-inline">
            <label class="layui-form-label" style=" width: 5px;margin-left: -23px;margin-bottom: -29px;">-</label>
            <input id="endDateNextId" type="text" name="endDateNext" placeholder="结束时间1" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>

    </div>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
    <div id="main" style="width: 100%;height:400px;float:left;"></div>

</div>

<#include "/layout/_resource.ftl"/>

<script>

    $(function(){

        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'));

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
//                ,value: lastXDateAndSameYear(6)
                ,value: Date.today().addMonths(-2).moveToFirstDayOfMonth()

                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: Date.today().addMonths(-2).moveToLastDayOfMonth()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            /**
             * 开始时间
             */
            var startNext = {
                elem: '#startDateNextId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: Date.today().addMonths(-1).moveToFirstDayOfMonth()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            var endNext = {
                elem: '#endDateNextId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: Date.today().addMonths(-1).moveToLastDayOfMonth()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            laydate.render(start);
            laydate.render(end);
            laydate.render(startNext);
            laydate.render(endNext);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();
                var startDateNext = $("#startDateNextId").val();
                var endDateNext = $("#endDateNextId").val();

                var titleVal = "新增注册用户数环比";
                var legendMarginTop = 0;
                var gridMarginTop = 60;
                var xAxisData = ['总注册用户数','官网渠道','网厅渠道'];
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDate > startDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDate > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDateNext > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateNextId');
                    return;
                }
                if(endDate > startDateNext){
                    layer.tips('开始日期不能大于结束日期','#endDateId');
                    return;
                }
                if(endDate > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#endDateId');
                    return;
                }

                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    return;
                }
                if(!isSameYear(startDate, startDateNext)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    return;
                }
                if(!isSameYear(startDate, endDateNext)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    return;
                }
                if(!isSameYear(startDateNext, endDateNext)){
                    layer.tips('请选择同一年份内时间区间','#startDateNext');
                    return;
                }
                if(!isSameYear(endDate, startDateNext)){
                    layer.tips('请选择同一年份内时间区间','#startDateNext');
                    return;
                }
                if(!isSameYear(endDate, endDateNext)){
                    layer.tips('请选择同一年份内时间区间','#endDateNext');
                    return;
                }
                var dateIntevalsCompareOne = dateInteval(startDate, endDate)+1;
                var dateIntevalsCompareTwo = dateInteval(startDate, startDateNext)+1;
                var dateIntevalsCompareThree = dateInteval(startDate, endDateNext)+1;
                var dateIntevalsCompareFour = dateInteval(startDateNext, endDateNext)+1;
                var dateIntevalsCompareFri = dateInteval(endDate, startDateNext)+1;
                var dateIntevalsCompareSix = dateInteval(endDate, endDateNext)+1;

                if(dateIntevalsCompareOne>60||dateIntevalsCompareTwo>60||dateIntevalsCompareThree>60||dateIntevalsCompareFour>60||dateIntevalsCompareFri>60||dateIntevalsCompareSix>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }

                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/allRegisteredCount'
                    ,data: {startDate: startDate, endDate: endDate,startDateNext: startDateNext, endDateNext: endDateNext}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = [];
                            var xAxisData = [];
                            for(var j = 0; j < obj.xAxis.length; j++){
                                xAxisData.push(obj.xAxis[j]);
                            }
                            for(var j = 0; j < obj.legend.length; j++){
                                legendData.push(obj.legend[j]+"月");

                                var sumCount = 0;
                                var gwSum = 0;
                                var wtSum = 0;

                                for(var i=0; i< obj.allRegisteredSumCount.length; i++){
                                    if(splitGetMonth(obj.allRegisteredSumCount[i].YEARMONTH)==obj.legend[j]){
                                        sumCount = obj.allRegisteredSumCount[i].SUM;
//                                        sumCount = obj.allRegisteredSumCount[i].SUM*1/1000;

                                    }
                                }
                                for(var i=0; i< obj.registeredSumCountGW.length; i++){
                                    if(splitGetMonth(obj.registeredSumCountGW[i].YEARMONTH)==obj.legend[j]){
                                        gwSum = obj.registeredSumCountGW[i].SUM;
//                                        gwSum = obj.registeredSumCountGW[i].SUM*1/1000;

                                    }
                                }
                                for(var i=0; i< obj.registeredSumCountWT.length; i++){
                                    if(splitGetMonth(obj.registeredSumCountWT[i].YEARMONTH)==obj.legend[j]){
                                        wtSum = obj.registeredSumCountWT[i].SUM;
//                                        wtSum = obj.registeredSumCountWT[i].SUM*1/1000;

                                    }
                                }
                                seriesData.push({
                                    name: obj.legend[j]+"月",
                                    type: 'bar',
                                    barMaxWidth: '40',
                                    data: [sumCount,gwSum,wtSum]
                                })
                            }
                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            var titleText = firstMonth+"月新增注册用户数环比";
                            var titleVal = "新增注册用户数环比";
                            var legendMarginTop = 0;
                            var gridMarginTop = 60;
                            render(titleVal,legendMarginTop,gridMarginTop,legendData,xAxisData,seriesData);
                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = Date.today().addMonths(-2).moveToFirstDayOfMonth().toString("yyyy/MM/dd");
                var endDate = Date.today().addMonths(-2).moveToLastDayOfMonth().toString("yyyy/MM/dd");
                var startDateNext = Date.today().addMonths(-1).moveToFirstDayOfMonth().toString("yyyy/MM/dd");
                var endDateNext = Date.today().addMonths(-1).moveToLastDayOfMonth().toString("yyyy/MM/dd");
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    return;
                }
                if(startDateNext==undefined || startDateNext==""){
                    layer.tips('开始日期不能为空','#startDateNextId');
                    return;
                }
                if(endDateNext==undefined || endDateNext==""){
                    layer.tips('结束日期不能为空','#endDateNextId');
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDate > startDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDate > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(startDateNext > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    return;
                }
                if(endDate > startDateNext){
                    layer.tips('开始日期不能大于结束日期','#endDateId');
                    return;
                }
                if(endDate > endDateNext){
                    layer.tips('开始日期不能大于结束日期','#endDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/allRegisteredCount'
                    ,data: {startDate: startDate, endDate: endDate,startDateNext: startDateNext, endDateNext: endDateNext}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = [];
                            var xAxisData = [];
                            for(var j = 0; j < obj.xAxis.length; j++){
                                xAxisData.push(obj.xAxis[j]);
                            }
                            for(var j = 0; j < obj.legend.length; j++){
                                legendData.push(obj.legend[j]+"月");

                                var sumCount = 0;
                                var gwSum = 0;
                                var wtSum = 0;

                                for(var i=0; i< obj.allRegisteredSumCount.length; i++){
                                    if(splitGetMonth(obj.allRegisteredSumCount[i].YEARMONTH)==obj.legend[j]){
                                        sumCount = obj.allRegisteredSumCount[i].SUM;
//                                        sumCount = obj.allRegisteredSumCount[i].SUM*1/1000;

                                    }
                                }
                                for(var i=0; i< obj.registeredSumCountGW.length; i++){
                                    if(splitGetMonth(obj.registeredSumCountGW[i].YEARMONTH)==obj.legend[j]){
                                        gwSum = obj.registeredSumCountGW[i].SUM;
//                                        gwSum = obj.registeredSumCountGW[i].SUM*1/1000;

                                    }
                                }
                                for(var i=0; i< obj.registeredSumCountWT.length; i++){
                                    if(splitGetMonth(obj.registeredSumCountWT[i].YEARMONTH)==obj.legend[j]){
                                        wtSum = obj.registeredSumCountWT[i].SUM;
//                                        wtSum = obj.registeredSumCountWT[i].SUM*1/1000;

                                    }
                                }
                                seriesData.push({
                                    name: obj.legend[j]+"月",
                                    type: 'bar',
                                    barMaxWidth: '40',
                                    data: [sumCount,gwSum,wtSum]
                                })
                            }
                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            var titleText = firstMonth+"月新增注册用户数环比";
                            var titleVal = "新增注册用户数环比";
                            var legendMarginTop = 0;
                            var gridMarginTop = 60;
                            render(titleVal,legendMarginTop,gridMarginTop,legendData,xAxisData,seriesData);
                        }//code==0 end
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        /**
         * 渲染数据
         */
        function render(titleVal,legendMarginTop,gridMarginTop,legend,xAxis,series){
            myChart.setOption({
                title: {
                    text: titleVal,
                    x: 'center',
                    textBaseline: 'middle',
                    top:10,
                    left: 40,
                    innerHeight:20,
                    style:{
                        fontSize:12
                    }
                },
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                        type : 'cross',        // 默认为直线，可选为：'line' | 'shadow' | 'cross'
                        label: {
                            backgroundColor: '#283b56'
                        }
                    }
                },
                legend: {
                    x : 'right',
//                top: legendMarginTop,
                    data: legend
                },
                grid: {
                    left: '7%',
                    right: '4%',
                    bottom: '3%',
                    top: gridMarginTop,
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: xAxis
                },
                yAxis : [
                    {
                        type : 'value',
//                        scale: true,
//                        max: 20,
                        min: 0,
                        boundaryGap: [0.2, 0.2],
                        axisLabel:{
                            formatter:'{value}'
                        }
                    }
                ],
                series: series
            });
        }

    });


</script>

</body>
</html>








