<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>
    <script src="${ctx}/js/util.js"></script>
    <title>登录总次数与登录用户数</title>
<#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight {
            height: 30px;
            line-height: 30px;
            margin-top: 10px;
        }

        .statisticsBtn {
            height: 30px;
            line-height: 30px;
            background-color: #E4DFd8;
            margin-left: 100px;
        }

        .statisticsTimeLabel {
            height: 30px;
            line-height: 30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理 > 登录总次数与登录用户数</legend>
</fieldset>
<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off"
                   class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off"
                   class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计</button>

    <!-- 为 ECharts 准备一个具备大小（宽高）的 DOM -->
<#--<div id="main" style="width: 90%;height:400px;"></div>-->
    <div style="position: relative;height: 700px;">
        <div id="mainTop" style="width: 64%;height:400px;position: absolute;top: 10%;"></div>
        <div id="rightTop" style="width: 29%;height:400px;float:right;position: absolute;top: 10%;right: 3%;">
            <table border=1>
                <colgroup>
                    <col width="130"/>
                    <col width="50"/>
                    <col width="80"/>
                </colgroup>
                <thead>
                <tr>
                    <th>登录总次数渠道</th>
                    <th>登录总次数</th>
                    <th>比例</th>
                </tr>
                </thead>
                <tbody id="proportionTopTable">
                </tbody>
            </table>
        </div>
    </div>
    <div style="position: relative;height: 700px;">
        <div id="mainBottom" style="width: 64%;height:400px;position: absolute;top: 10%;"></div>
        <!-- 右侧表格数据 -->

        <div id="rightBottom" style="width: 29%;height:400px;float:right;position: absolute;top: 10%;right: 3%;">
            <table border=1>
                <colgroup>
                    <col width="130"/>
                    <col width="50"/>
                    <col width="80"/>
                </colgroup>
                <thead>
                <tr>
                    <th>登录用户数渠道</th>
                    <th>登录用户数</th>
                    <th>比例</th>
                </tr>
                </thead>
                <tbody id="proportionBottomTable">
                </tbody>
            </table>
        </div>
    </div>

</div>
<#include "/layout/_resource.ftl"/>

<script>

    $(function(){
        // 基于准备好的dom，初始化echarts实例

        var myChartTop = echarts.init(document.getElementById('mainTop'));
        var myChartBottom = echarts.init(document.getElementById('mainBottom'));

        layui.use(['laydate', 'layer', 'jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });
            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                , type: 'date'
                , range: false
                , format: 'yyyy/MM/dd'
                , value: lastXDateAndSameYear(6)
                , max: 0
                , trigger: 'click'
                , showBottom: true
                , btns: ['now', 'confirm']
                , lang: 'cn'
                , theme: 'molv'
                , calendar: true

            };
            var end = {
                elem: '#endDateId'
                , type: 'date'
                , range: false
                , format: 'yyyy/MM/dd'
                , value: new Date()
                , max: 0
                , trigger: 'click'
                , showBottom: true
                , btns: ['now', 'confirm']
                , lang: 'cn'
                , theme: 'molv'
                , calendar: true
            };

            laydate.render(start);
            laydate.render(end);
            var initializeStartDate = new Date(start.value)
            var initializeendDate = new Date(end.value)
            //页面初始化
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                var sd = new Date(startDate);
                var ed = new Date(endDate);
                if (startDate == undefined || startDate == "") {
                    layer.tips('开始日期不能为空', '#startDateId');
                    return;
                }
                if (endDate == undefined || endDate == "") {
                    layer.tips('结束日期不能为空', '#endDateId');
                    return;
                }
                if (!isSameYear(startDate, endDate)) {
                    layer.tips('请选择同一年份内时间区间', '#startDateId');
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate) + 1;
                if (dateIntevals > 60) {
                    layer.tips('所选时间范围不能大于60天', '#startDateId');
                    return;
                }
                if (sd.getTime() > ed.getTime()) {
                    layer.tips('开始日期不能大于结束日期', '#startDateId');
                    return;
                }
                myChartTop.showLoading();
                myChartBottom.showLoading();
                $.ajax({
                    url: "${ctx}/loginStatistics/userLoginStatistics"
                    , data: {
                        startDate: initializeStartDate.dateConvert('yyyy/MM/dd'),
                        endDate: initializeendDate.dateConvert('yyyy/MM/dd')
                    },
                    type: "post",
                    dataType: "json",
                    cache: false
                    , success: function (data) {
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        myChartTop.clear();
                        myChartBottom.clear();
                        if (data.flag == false) {
                            if (data.status === "startDate") {
                                layer.tips(data.msg, '#startDateId');
                            }
                        } else {
                            //所有登录总次数渠道
                            var allLoginTotalChannelList = data.data.allLoginTotalChannelList;
                            //每个渠道下面的登录总次数
                            var channelLoginTotals = data.data.channelLoginTotals;
                            //所有登录用户数渠道
                            var allLoginUserchannelList = data.data.allLoginUserchannelList;
                            //每个渠道下面的登录用户数
                            var channelLoginNumberList = data.data.channelLoginNumberList;
                            var loginTotal = parseInt(data.data.loginTotal);
                            var userLoginTotal = parseInt(data.data.userLoginTotal);
                            var seriesData_top = [];
                            var legendData_top = [];
                            var seriesData_bottom = [];
                            var legendData_bottom = [];
                            var seriesDateTopOther=0;
                            var seriesDateBottomOther=0;
                            var seriesDateTopCas=0;
                            var seriesDateBottomCas=0;
                            var seriesDateTopNew=[];
                            var seriesDateBottomNew=[];
                            var legendData_top_new = [];
                            var legendData_bottom_new = [];
                            var channelLoginTotalPercentArray = [];
                            var channelUserLoginTotalPercentArray = [];
                            var channelLoginTotalPercentArrayNew = [];
                            var channelUserLoginTotalPercentArrayNew = [];
                            var channelLoginTotalPercentOther=0.00;
                            var channelUserLoginTotalPercentOther=0.00;
                            var channelLoginTotalPercentCas=0.00;
                            var channelUserLoginTotalPercentCas=0.00;
                            var channelLoginTotalOther=0;
                            var channelUserLoginTotalOther=0;
                            var channelLoginTotalCas=0;
                            var channelUserLoginTotalCas=0;
                            var htmlTop = "";
                            var htmlBottom = "";
                            if (allLoginTotalChannelList.length > 0&&allLoginUserchannelList.length>0&&channelLoginTotals.length > 0&&channelLoginNumberList.length > 0) {
                                for (var i = 0; i < allLoginTotalChannelList.length; i++) {
                                    var channelLoginTotal=parseInt(channelLoginTotals[i]);
                                    var channelLoginTotalPercent=0.00;
                                    if(loginTotal!=0){
                                        channelLoginTotalPercent=((channelLoginTotal/loginTotal).toFixed(4)*100).toFixed(2);
                                    }
                                    seriesData_top.push({value: channelLoginTotals[i],name: getChannelName(allLoginTotalChannelList[i])});
                                    legendData_top.push(getChannelName(allLoginTotalChannelList[i]));
                                    channelLoginTotalPercentArray.push({channel:getChannelName(allLoginTotalChannelList[i]),total:channelLoginTotals[i],percent:channelLoginTotalPercent})

                                }
                                for (var i = 0; i < allLoginUserchannelList.length; i++) {
                                    var channelUserLoginTotal=parseInt(channelLoginNumberList[i]);
                                    var channelUserLoginTotalPercent=0.00;
                                    if(userLoginTotal!=0){
                                        channelUserLoginTotalPercent=((channelUserLoginTotal/userLoginTotal).toFixed(4)*100).toFixed(2);
                                    }
                                    legendData_bottom.push(getChannelName(allLoginUserchannelList[i]));
                                    seriesData_bottom.push({value: channelLoginNumberList[i],name: getChannelName(allLoginUserchannelList[i])});
                                    channelUserLoginTotalPercentArray.push({channel:getChannelName(allLoginUserchannelList[i]),total:channelLoginNumberList[i],percent:channelUserLoginTotalPercent});

                                }

                            }
                            if(seriesData_top.length>0&&seriesData_bottom.length>0){
                                debugger;
                                $.each(seriesData_top,function (index,value) {
                                    if(seriesData_top[index].name=="其他"){
                                        seriesDateTopOther=seriesDateTopOther+seriesData_top[index].value;
                                    }else if(seriesData_top[index].name=="统一身份认证注册"){
                                        seriesDateTopCas=seriesDateTopCas+seriesData_top[index].value;
                                    }else{
                                        seriesDateTopNew.push({value:seriesData_top[index].value,name:seriesData_top[index].name});
                                        legendData_top_new.push(seriesData_top[index].name);

                                    }
                                });
                                $.each(seriesData_bottom,function (index,value) {
                                    if(seriesData_bottom[index].name=="其他"){
                                        seriesDateBottomOther=seriesDateBottomOther+seriesData_bottom[index].value;
                                    }else if(seriesData_top[index].name=="统一身份认证注册"){
                                        seriesDateBottomCas=seriesDateBottomCas+seriesData_bottom[index].value;
                                    }else{
                                        seriesDateBottomNew.push({value:seriesData_bottom[index].value,name:seriesData_bottom[index].name});
                                        legendData_bottom_new.push(seriesData_bottom[index].name);

                                    }
                                });
                                //展示右侧表数据
                                debugger;
                                $.each(channelLoginTotalPercentArray,function (index,value) {
                                    if(channelLoginTotalPercentArray[index].channel=="其他"){
                                        channelLoginTotalPercentOther=parseFloat(channelLoginTotalPercentOther)+parseFloat(channelLoginTotalPercentArray[index].percent);
                                        channelLoginTotalOther=parseInt(channelLoginTotalOther)+parseInt(channelLoginTotalPercentArray[index].total);
                                    }else if(channelLoginTotalPercentArray[index].channel=="统一身份认证注册"){
                                        channelLoginTotalPercentCas=parseFloat(channelLoginTotalPercentCas)+parseFloat(channelLoginTotalPercentArray[index].percent);
                                        channelLoginTotalCas=parseInt(channelLoginTotalCas)+parseInt(channelLoginTotalPercentArray[index].total);
                                    }else{
                                        channelLoginTotalPercentArrayNew.push(channelLoginTotalPercentArray[index]);
                                    }
                                });
                                $.each(channelUserLoginTotalPercentArray,function (index,value) {
                                    if(channelUserLoginTotalPercentArray[index].channel=="其他"){
                                        channelUserLoginTotalPercentOther=parseFloat(channelUserLoginTotalPercentOther)+parseFloat(channelUserLoginTotalPercentArray[index].percent);
                                        channelUserLoginTotalOther=parseInt(channelUserLoginTotalOther)+parseInt(channelUserLoginTotalPercentArray[index].total);

                                    }else if(channelUserLoginTotalPercentArray[index].channel=="统一身份认证注册"){
                                        channelUserLoginTotalPercentCas=parseFloat(channelUserLoginTotalPercentCas)+parseFloat(channelUserLoginTotalPercentArray[index].percent);
                                        channelUserLoginTotalCas=parseInt(channelUserLoginTotalCas)+parseInt(channelUserLoginTotalPercentArray[index].total);
                                    }else{
                                        channelUserLoginTotalPercentArrayNew.push(channelUserLoginTotalPercentArray[index]);
                                    }
                                });
                                channelLoginTotalPercentArrayNew.push({channel:"其他",total:channelLoginTotalOther,percent:channelLoginTotalPercentOther.toFixed(2)});
                                channelUserLoginTotalPercentArrayNew.push({channel:"其他",total:channelUserLoginTotalOther,percent:channelUserLoginTotalPercentOther.toFixed(2)});
                                channelLoginTotalPercentArrayNew.push({channel:"统一身份认证注册",total:channelLoginTotalCas,percent:channelLoginTotalPercentCas.toFixed(2)});
                                channelUserLoginTotalPercentArrayNew.push({channel:"统一身份认证注册",total:channelUserLoginTotalCas,percent:channelUserLoginTotalPercentCas.toFixed(2)});
                                //渲染表格
                                $.each(channelLoginTotalPercentArrayNew,function (index,value) {
                                    var htmlTemplateTop = "<tr><td>"+channelLoginTotalPercentArrayNew[index].channel+"</td><td>"+channelLoginTotalPercentArrayNew[index].total+"</td><td>"+channelLoginTotalPercentArrayNew[index].percent+"%</td></tr>";
                                    htmlTop += htmlTemplateTop;
                                })
                                $.each(channelUserLoginTotalPercentArrayNew,function (index,value) {
                                    var htmlTemplateBottom = "<tr><td>"+channelUserLoginTotalPercentArrayNew[index].channel+"</td><td>"+channelUserLoginTotalPercentArrayNew[index].total+"</td><td>"+channelUserLoginTotalPercentArrayNew[index].percent+"%</td></tr>";
                                    htmlBottom += htmlTemplateBottom;
                                })
                                seriesDateTopNew.push({value: seriesDateTopOther,name: "其他"});
                                seriesDateBottomNew.push({value: seriesDateBottomOther,name: "其他"});
                                seriesDateTopNew.push({value: seriesDateTopCas,name: "统一身份认证注册"});
                                seriesDateBottomNew.push({value: seriesDateBottomCas,name: "统一身份认证注册"});
                                legendData_top_new.push("其他");
                                legendData_bottom_new.push("其他");
                                legendData_top_new.push("统一身份认证注册");
                                legendData_bottom_new.push("统一身份认证注册");
                            }
                            var titleText_top = "登录总次数";
                            var titleText_bottom = "登录用户数";
                            renderTop(titleText_top, legendData_top_new, seriesDateTopNew);
                            renderBottom(titleText_bottom, legendData_bottom_new, seriesDateBottomNew);
                            $("#proportionTopTable").html(htmlTop);
                            $("#proportionBottomTable").html(htmlBottom);

                        }
                    },error:function(error){
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });
            });

            $(".statisticsBtn").on("click", function () {
                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();
                var sd = new Date(startDate);
                var ed = new Date(endDate);
                if (startDate == undefined || startDate == "") {
                    layer.tips('开始日期不能为空', '#startDateId');
                    return;
                }
                if (endDate == undefined || endDate == "") {
                    layer.tips('结束日期不能为空', '#endDateId');
                    return;
                }
                if (!isSameYear(startDate, endDate)) {
                    layer.tips('请选择同一年份内时间区间', '#startDateId');
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate) + 1;
                if (dateIntevals > 60) {
                    layer.tips('所选时间范围不能大于60天', '#startDateId');
                    return;
                }
                if (sd.getTime() > ed.getTime()) {
                    layer.tips('开始日期不能大于结束日期', '#startDateId');
                    return;
                }
                $.ajax({
                    url: "${ctx}/loginStatistics/userLoginStatistics"
                    , data: {
                        startDate: startDate,
                        endDate: endDate
                    },
                    type: "post",
                    dataType: "json",
                    cache: false
                    , success: function (data) {
                        if (data.flag == false) {
                            if (data.status === "startDate") {
                                layer.tips(data.msg, '#startDateId');
                            }
                        } else {
                            //所有登录总次数渠道
                            var allLoginTotalChannelList = data.data.allLoginTotalChannelList;
                            //每个渠道下面的登录总次数
                            var channelLoginTotals = data.data.channelLoginTotals;
                            //所有登录用户数渠道
                            var allLoginUserchannelList = data.data.allLoginUserchannelList;
                            //每个渠道下面的登录用户数
                            var channelLoginNumberList = data.data.channelLoginNumberList;
                            var loginTotal = parseInt(data.data.loginTotal);
                            var userLoginTotal = parseInt(data.data.userLoginTotal);
                            var seriesData_top = [];
                            var legendData_top = [];
                            var seriesData_bottom = [];
                            var legendData_bottom = [];
                            var seriesDateTopOther=0;
                            var seriesDateBottomOther=0;
                            var seriesDateTopCas=0;
                            var seriesDateBottomCas=0;
                            var seriesDateTopNew=[];
                            var seriesDateBottomNew=[];
                            var legendData_top_new = [];
                            var legendData_bottom_new = [];
                            var channelLoginTotalPercentArray = [];
                            var channelUserLoginTotalPercentArray = [];
                            var channelLoginTotalPercentArrayNew = [];
                            var channelUserLoginTotalPercentArrayNew = [];
                            var channelLoginTotalPercentOther=0.00;
                            var channelUserLoginTotalPercentOther=0.00;
                            var channelLoginTotalPercentCas=0.00;
                            var channelUserLoginTotalPercentCas=0.00;
                            var channelLoginTotalOther=0;
                            var channelUserLoginTotalOther=0;
                            var channelLoginTotalCas=0;
                            var channelUserLoginTotalCas=0;
                            var htmlTop = "";
                            var htmlBottom = "";
                            if (allLoginTotalChannelList.length > 0&&allLoginUserchannelList.length>0&&channelLoginTotals.length > 0&&channelLoginNumberList.length > 0) {
                                for (var i = 0; i < allLoginTotalChannelList.length; i++) {
                                    var channelLoginTotal=parseInt(channelLoginTotals[i]);
                                    var channelLoginTotalPercent=0.00;
                                    if(loginTotal!=0){
                                        channelLoginTotalPercent=((channelLoginTotal/loginTotal).toFixed(4)*100).toFixed(2);
                                    }
                                    seriesData_top.push({value: channelLoginTotals[i],name: getChannelName(allLoginTotalChannelList[i])});
                                    legendData_top.push(getChannelName(allLoginTotalChannelList[i]));
                                    channelLoginTotalPercentArray.push({channel:getChannelName(allLoginTotalChannelList[i]),total:channelLoginTotals[i],percent:channelLoginTotalPercent})

                                }
                                for (var i = 0; i < allLoginUserchannelList.length; i++) {
                                    var channelUserLoginTotal=parseInt(channelLoginNumberList[i]);
                                    var channelUserLoginTotalPercent=0.00;
                                    if(userLoginTotal!=0){
                                        channelUserLoginTotalPercent=((channelUserLoginTotal/userLoginTotal).toFixed(4)*100).toFixed(2);
                                    }
                                    legendData_bottom.push(getChannelName(allLoginUserchannelList[i]));
                                    seriesData_bottom.push({value: channelLoginNumberList[i],name: getChannelName(allLoginUserchannelList[i])});
                                    channelUserLoginTotalPercentArray.push({channel:getChannelName(allLoginUserchannelList[i]),total:channelLoginNumberList[i],percent:channelUserLoginTotalPercent});

                                }

                            }
                            if(seriesData_top.length>0&&seriesData_bottom.length>0){

                                $.each(seriesData_top,function (index,value) {
                                    if(seriesData_top[index].name=="其他"){
                                        seriesDateTopOther=seriesDateTopOther+seriesData_top[index].value;
                                    }else if(seriesData_top[index].name=="统一身份认证注册"){
                                        seriesDateTopCas=seriesDateTopCas+seriesData_top[index].value;
                                    }else{
                                        seriesDateTopNew.push({value:seriesData_top[index].value,name:seriesData_top[index].name});
                                        legendData_top_new.push(seriesData_top[index].name);

                                    }
                                });
                                $.each(seriesData_bottom,function (index,value) {
                                    if(seriesData_bottom[index].name=="其他"){
                                        seriesDateBottomOther=seriesDateBottomOther+seriesData_bottom[index].value;
                                    }else if(seriesData_top[index].name=="统一身份认证注册"){
                                        seriesDateBottomCas=seriesDateBottomCas+seriesData_bottom[index].value;
                                    }else{
                                        seriesDateBottomNew.push({value:seriesData_bottom[index].value,name:seriesData_bottom[index].name});
                                        legendData_bottom_new.push(seriesData_bottom[index].name);

                                    }
                                });
                                //展示右侧表数据
                                $.each(channelLoginTotalPercentArray,function (index,value) {
                                    if(channelLoginTotalPercentArray[index].channel=="其他"){
                                        channelLoginTotalPercentOther=parseFloat(channelLoginTotalPercentOther)+parseFloat(channelLoginTotalPercentArray[index].percent);
                                        channelLoginTotalOther=parseInt(channelLoginTotalOther)+parseInt(channelLoginTotalPercentArray[index].total);
                                    }else if(channelLoginTotalPercentArray[index].channel=="统一身份认证注册"){
                                        channelLoginTotalPercentCas=parseFloat(channelLoginTotalPercentCas)+parseFloat(channelLoginTotalPercentArray[index].percent);
                                        channelLoginTotalCas=parseInt(channelLoginTotalCas)+parseInt(channelLoginTotalPercentArray[index].total);
                                    }else{
                                        channelLoginTotalPercentArrayNew.push(channelLoginTotalPercentArray[index]);
                                    }
                                });
                                $.each(channelUserLoginTotalPercentArray,function (index,value) {
                                    if(channelUserLoginTotalPercentArray[index].channel=="其他"){
                                        channelUserLoginTotalPercentOther=parseFloat(channelUserLoginTotalPercentOther)+parseFloat(channelUserLoginTotalPercentArray[index].percent);
                                        channelUserLoginTotalOther=parseInt(channelUserLoginTotalOther)+parseInt(channelUserLoginTotalPercentArray[index].total);

                                    }else if(channelUserLoginTotalPercentArray[index].channel=="统一身份认证注册"){
                                        channelUserLoginTotalPercentCas=parseFloat(channelUserLoginTotalPercentCas)+parseFloat(channelUserLoginTotalPercentArray[index].percent);
                                        channelUserLoginTotalCas=parseInt(channelUserLoginTotalCas)+parseInt(channelUserLoginTotalPercentArray[index].total);
                                    }else{
                                        channelUserLoginTotalPercentArrayNew.push(channelUserLoginTotalPercentArray[index]);
                                    }
                                });
                                channelLoginTotalPercentArrayNew.push({channel:"其他",total:channelLoginTotalOther,percent:channelLoginTotalPercentOther.toFixed(2)});
                                channelUserLoginTotalPercentArrayNew.push({channel:"其他",total:channelUserLoginTotalOther,percent:channelUserLoginTotalPercentOther.toFixed(2)});
                                channelLoginTotalPercentArrayNew.push({channel:"统一身份认证注册",total:channelLoginTotalCas,percent:channelLoginTotalPercentCas.toFixed(2)});
                                channelUserLoginTotalPercentArrayNew.push({channel:"统一身份认证注册",total:channelUserLoginTotalCas,percent:channelUserLoginTotalPercentCas.toFixed(2)});
                                //渲染表格
                                $.each(channelLoginTotalPercentArrayNew,function (index,value) {
                                    var htmlTemplateTop = "<tr><td>"+channelLoginTotalPercentArrayNew[index].channel+"</td><td>"+channelLoginTotalPercentArrayNew[index].total+"</td><td>"+channelLoginTotalPercentArrayNew[index].percent+"%</td></tr>";
                                    htmlTop += htmlTemplateTop;
                                })
                                $.each(channelUserLoginTotalPercentArrayNew,function (index,value) {
                                    var htmlTemplateBottom = "<tr><td>"+channelUserLoginTotalPercentArrayNew[index].channel+"</td><td>"+channelUserLoginTotalPercentArrayNew[index].total+"</td><td>"+channelUserLoginTotalPercentArrayNew[index].percent+"%</td></tr>";
                                    htmlBottom += htmlTemplateBottom;
                                })
                                seriesDateTopNew.push({value: seriesDateTopOther,name: "其他"});
                                seriesDateBottomNew.push({value: seriesDateBottomOther,name: "其他"});
                                seriesDateTopNew.push({value: seriesDateTopCas,name: "统一身份认证注册"});
                                seriesDateBottomNew.push({value: seriesDateBottomCas,name: "统一身份认证注册"});
                                legendData_top_new.push("其他");
                                legendData_bottom_new.push("其他");
                                legendData_top_new.push("统一身份认证注册");
                                legendData_bottom_new.push("统一身份认证注册");
                            }
                            var titleText_top = "登录总次数";
                            var titleText_bottom = "登录用户数";
                            renderTop(titleText_top, legendData_top_new, seriesDateTopNew);
                            renderBottom(titleText_bottom, legendData_bottom_new, seriesDateBottomNew);
                            $("#proportionTopTable").html(htmlTop);
                            $("#proportionBottomTable").html(htmlBottom);

                        }
                    },error:function(error){
                        myChartTop.hideLoading();
                        myChartBottom.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });
            });

        });
//        改为饼状图
        /**
         * 渲染数据
         */
        function renderTop(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [5,30,10,50],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 10
//                    ,
//                    data: legendData
                },
                series : [
                    {
                        name: '登录总次数',
                        type: 'pie',
                        radius : '45%',
//                        center 第一个参数是左右，第二个是大小
                        center: ['60%', '45%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }

                    }
                ]
            };

            myChartTop.setOption(option);
        }

        function renderBottom(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [10,30,0,50],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 30
//                    ,
//                    data: legendData
                },
                series : [
                    {
                        name: '登录用户数',
                        type: 'pie',
                        radius : '45%',
                        center: ['60%', '45%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }
                    }
                ]
            };

            myChartBottom.setOption(option);
        }


    });







</script>

</body>
</html>








