<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- 引入 ECharts 文件 -->
    <script src="${ctx}/echarts/js/echarts.js"></script>
    <script src="${ctx}/js/dateTimeUtils.js"></script>
    <script src="${ctx}/js/util.js"></script>

    <title>官网注册比例</title>
    <#include "/layout/_head.ftl" />
    <style>
        .dataInputHeight{
            height:30px;
            line-height:30px;
            margin-top: 10px;
        }
        .statisticsBtn{
            height:30px;
            line-height:30px;
            background-color:#E4DFd8;
            margin-left: 100px;
        }
        .statisticsTimeLabel {
            height:30px;
            line-height:30px;
        }
    </style>
</head>
<body>
<fieldset class="layui-elem-field layui-field-title" style="margin-top: 20px;">
    <legend>统计管理  >  官网注册比例</legend>
</fieldset>

<div class="container">

    <div class="layui-inline">
        <label class="layui-form-label statisticsTimeLabel">统计时间：</label>
        <div class="layui-input-inline" style="width: 100px;float: left;">
            <input id="startDateId" type="text" name="startDate" placeholder="开始时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
        <div class="layui-form-mid" style="margin-left:10px;margin-top: 8px;">-</div>
        <div class="layui-input-inline" style="width: 100px;">
            <input id="endDateId" type="text" name="endDate" placeholder="结束时间" autocomplete="off" class="layui-input date dataInputHeight">
        </div>
    </div>
    <button class="layui-btn layui-btn-primary statisticsBtn"> 统计 </button>
    <div style="position: relative;height: 800px;">
        <div id="main" style="width: 64%;height:800px;position: absolute;"></div>
        <!-- 右侧表格数据 -->

        <div id="main" style="width: 29%;height:400px;float:right;position: absolute;top: 10%;right: 3%;">
            <table border=1>
                <colgroup>
                    <col width="200"/>
                    <col width="50"/>
                    <col width="80"/>
                </colgroup>
                <thead>
                <tr>
                    <th>注册渠道</th>
                    <th>注册数</th>
                    <th>注册比例</th>
                </tr>
                </thead>
                <tbody id="proportionTable">
                </tbody>
            </table>
        </div>
    </div>
    <#--<!-- 为 ECharts 准备一个具备大小（宽高）的 DOM &ndash;&gt;-->
    <#--<div id="main" style="width: 70%;height:400px;float:left;"></div>-->

    <#--<!-- 右侧表格数据 &ndash;&gt;-->
    <#--<div id="main" style="width: 29%;height:400px;float:right;">-->
        <#--<table border=1>-->
            <#--<colgroup>-->
                <#--<col width="200"/>-->
                <#--<col width="50"/>-->
                <#--<col width="80"/>-->
            <#--</colgroup>-->
            <#--<thead>-->
                <#--<tr>-->
                    <#--<th>注册渠道</th>-->
                    <#--<th>注册数</th>-->
                    <#--<th>注册比例</th>-->
                <#--</tr>-->
            <#--</thead>-->
            <#--<tbody id="proportionTable">-->
            <#--</tbody>-->
        <#--</table>-->
    <#--</div>-->

    <div id="noDataId" style="position: absolute;top: 300px;left:550px;font-size:15px;display: none;">
        暂无数据
    </div>

</div>

<#include "/layout/_resource.ftl"/>

<script>


    $(function(){
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('main'),{
            noDataLoadingOption:{
                text : '暂无数据',
                effect : 'whirling',
                effectOption:{
                    backgroundColor:"#fff"
                },
                textStyle : {
                    fontSize : 30
                }
            }
        });

        layui.use(['laydate','layer','jquery'], function () {
            var laydate = layui.laydate;
            var layer = layui.layer;
            var $ = layui.jquery;
            layer.config({
                extend: 'myskin/style.css',
                skin: 'layer-ext-yourskin'
            });

            /**
             * 开始时间
             */
            var start = {
                elem: '#startDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: lastXDateAndSameYear(6)
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };
            var end = {
                elem: '#endDateId'
                ,type: 'date'
                ,range: false
                ,format: 'yyyy/MM/dd'
                ,value: new Date()
                ,max: 0
                ,trigger: 'click'
                ,showBottom: true
                ,btns: ['now','confirm']
                ,lang: 'cn'
                ,theme: 'molv'
                ,calendar: true
            };

            laydate.render(start);
            laydate.render(end);

            //获取指定年月的最后一天，month默认为当前月，year默认为当前年。如：
            var endDate1 = laydate.getEndDate(10); //得到31
            var endDate2 = laydate.getEndDate(2, 2080); //得到29

            $('.statisticsBtn').on('click',function () {

                var startDate = $("#startDateId").val();
                var endDate = $("#endDateId").val();

                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                if(!isSameYear(startDate, endDate)){
                    layer.tips('请选择同一年份内时间区间','#startDateId');
                    //layer.alert("请选择同一年份内时间区间", {icon: 2});
                    return;
                }
                var dateIntevals = dateInteval(startDate, endDate)+1;
                if(dateIntevals>60){
                    layer.tips('所选时间范围不能大于60天','#startDateId');
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/websiteRegisteredProportion'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        myChart.clear();
                        if(data.code==0){
                            var obj = data.data;
                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = [];
                            var html = "";
                            for(var i = 0; i < obj.length; i++){
                                seriesData.push({
                                    value: obj[i].registeredSum,name: getChannelName(obj[i].source)
                                });
                                legendData.push(getChannelName(obj[i].source));

                                var htmlTemplate = "<tr><td>"+getChannelName(obj[i].source)+"</td><td>"+obj[i].registeredSum+"</td><td>"+obj[i].registeredProportion+"</td></tr>";
                                html += htmlTemplate;
                            }

                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            var titleText = "官网渠道注册数比例";

                            render(titleText, legendData, seriesData);
                            if(seriesData.length==0){
                                $("#noDataId").show();
                            }else{
                                $("#noDataId").hide();
                            }

                            $("#proportionTable").html(html);

                        }
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });


            /**
             * 页面初始化
             */
            $(function () {
                var startDate = lastXDateAndSameYear(6);
                var endDate = currentDate();
                if(startDate==undefined || startDate==""){
                    layer.tips('开始日期不能为空','#startDateId');
                    //layer.alert("开始日期不能为空", {icon: 2});
                    return;
                }
                if(endDate==undefined || endDate==""){
                    layer.tips('结束日期不能为空','#endDateId');
                    //layer.alert("结束日期不能为空", {icon: 2});
                    return;
                }
                if(startDate > endDate){
                    layer.tips('开始日期不能大于结束日期','#startDateId');
                    //layer.alert("开始日期不能大于结束日期", {icon: 2});
                    return;
                }
                myChart.showLoading();
                $.ajax({
                    url: '${ctx}/statistics/websiteRegisteredProportion'
                    ,data: {startDate: startDate, endDate: endDate}
                    ,type: 'POST'
                    ,dataType: 'json'
                    ,cache: false
                    ,sync: true
                    ,success:function (data, status) {
                        myChart.hideLoading();
                        if(data.code==0){
                            var obj = data.data;

                            if(null==obj || undefined==obj){
                                return;
                            }

                            var seriesData = [];
                            var legendData = [];
                            var html = "";
                            for(var i = 0; i < obj.length; i++){
                                seriesData.push({
                                    value: obj[i].registeredSum,name: getChannelName(obj[i].source)
                                });
                                legendData.push(getChannelName(obj[i].source));

                                var htmlTemplate = "<tr><td>"+getChannelName(obj[i].source)+"</td><td>"+obj[i].registeredSum+"</td><td>"+obj[i].registeredProportion+"</td></tr>";
                                html += htmlTemplate;
                            }
                            var firstMonth = startDate.split('/')[1];
                            var statisticsDate = (new Date()).getMonth()+1;
                            //var titleText = firstMonth+"月官网渠道注册数比例";
                            var titleText = "官网渠道注册数比例";
                            render(titleText, legendData, seriesData);
                            if(seriesData.length==0){
                                $("#noDataId").show();
                            }else{
                                $("#noDataId").hide();
                            }

                            $("#proportionTable").html(html);

                        }//code==0 end
                        if(data.code==1){
                            layer.alert(data.msg, {icon: 2});
                        }

                    }
                    ,error:function(error){
                        myChart.hideLoading();
                        layer.alert(data.msg, {icon: 2});
                    }
                });//ajax end
            });//jquery end

        });//layui.use end

        /**
         * 渲染数据
         */
        function render(titleText, legendData, seriesData) {
            var option = {
                title : {
                    text: titleText,
                    subtext: '',//备注：2017年6月份之前的数据（包含6月份）官网PC端注册数包含了商城PC端注册数。
                    x:'left',
                    padding: [100,30,0,130],
                    itemGap: 350,
                    subtextStyle: {
                        fontSize: 12
                    }

                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    top: 30
//                    data: legendData
                },
                series : [
                    {
                        name: '官网渠道注册数比例',
                        type: 'pie',
                        radius : '20%',
                        center: ['60%', '60%'],
                        data: seriesData
                        ,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            },
                            normal:{
                                label:{
                                    show:true,
                                    formatter: '{b} : {c} \n 比例({d}%)'
                                }
                            }
                        }
                    }
                ]
            };

            myChart.setOption(option);
        }

    });






</script>

</body>
</html>








