/**
 * *********  操作实例  **************
 *   var map = new HashMap();
 *   map.put("key1","Value1");
 *   map.put("key2","Value2");
 *   map.put("key3","Value3");
 *   map.put("key4","Value4");
 *   map.put("key5","Value5");
 *   alert("size："+map.size()+" key1："+map.get("key1"));
 *   map.remove("key1");
 *   map.put("key3","newValue");
 *   var values = map.values();
 *   for(var i in values){
*       document.write(i+"："+values[i]+"   ");
*   }
 *   document.write("<br>");
 *   var keySet = map.keySet();
 *   for(var i in keySet){
*       document.write(i+"："+keySet[i]+"  ");
*   }
 *   alert(map.isEmpty());
 */

function HashMap(){
    //定义长度
    var length = 0;
    //创建一个对象
    var obj = new Object();

    /**
     * 判断Map是否为空
     */
    this.isEmpty = function(){
        return length == 0;
    };

    /**
     * 判断对象中是否包含给定Key
     */
    this.containsKey=function(key){
        return (key in obj);
    };

    /**
     * 判断对象中是否包含给定的Value
     */
    this.containsValue=function(value){
        for(var key in obj){
            if(obj[key] == value){
                return true;
            }
        }
        return false;
    };

    /**
     *向map中添加数据
     */
    this.put=function(key,value){
        if(!this.containsKey(key)){
            length++;
        }
        obj[key] = value;
    };

    /**
     * 根据给定的Key获得Value
     */
    this.get=function(key){
        return this.containsKey(key)?obj[key]:null;
    };

    /**
     * 根据给定的Key删除一个值
     */
    this.remove=function(key){
        if(this.containsKey(key)&&(delete obj[key])){
            length--;
        }
    };

    /**
     * 获得Map中的所有Value
     */
    this.values=function(){
        var _values= new Array();
        for(var key in obj){
            _values.push(obj[key]);
        }
        return _values;
    };

    /**
     * 获得Map中的所有Key
     */
    this.keySet=function(){
        var _keys = new Array();
        for(var key in obj){
            _keys.push(key);
        }
        return _keys;
    };

    /**
     * 获得Map的长度
     */
    this.size = function(){
        return length;
    };

    /**
     * 清空Map
     */
    this.clear = function(){
        length = 0;
        obj = new Object();
    };
}



$(function(){
    /**
     *
     *  单例提交
     */
    //接口地址
    var url = "http://127.0.0.1/fault/save";

    var data = {
        "attachment":"b.doc"
        ,"businessDescription":"核保审核报错"
        ,"comCode":"44010000"
        ,"operationPoint":"核保-审核"
        ,"systemCode":"cb"
        ,"systemName":"承保"
        ,"tagging":"标签1;标签2"
        ,"tips":"弹出错误框"
        ,"url":"http://www.baidu.com"
        ,"userCode":"4423313101031"
        ,"userName":"李四"
    };

    // 提交接口
    var postJob = function(url,data){
        $.ajax({
            url: url
            , type: "POST"
            , contentType: "application/json;charset=utf-8"
            , dataType: "json"
            , data: JSON.stringify(data)
            , success: function (result) {
                   /*
                    * result.code 状态码  :  1 成功 ,0 失败
                    * result.msg  返回的提示信息
                    * result.count 影响的行数
                    * result.data  一个数组,存保存的数据
                    */
                if(result.code == 1){
                    //alert("成功保存");
                    // dosomething
                }else{
                    //alert("保存失败");
                    // dosomething
                }
            }
        });
    };
   // postJob(url,data);
    /**
     *
     *  批量提交
     */
    var bathPostJob = function (url,arr) {
        var c = 0;
        $.each(arr,function (i,n) {
           postJob(url,n);
           c = ++i;
        });
        alert("完成批量工作,共计处理量："+c);
    }
    var createBathData = function(c){
        var arr = [];
        try{
            var counter = parseInt(c);
            for(var i=0;i<counter;i++){
                var randonNumber =  Math.round(Math.random()*10);
                if(randonNumber<=0){
                    randonNumber = randonNumber+1;
                }
                if(randonNumber>10){
                    randonNumber = 10;
                }
                var data ={};
                data.attachment = dictAttachmentMap.get(randonNumber);
                var comKeyNum = (randonNumber+11>comCodeMap.size())?comCodeMap.size()-1:randonNumber+11;
                var comCode = comCodeMap.keySet()[comKeyNum];
                data.comCode =comCode;
                var sysKeyNum = (randonNumber-2>0)?randonNumber-2:systemCodeAndSystemName.size()-1;
                data.systemCode = systemCodeAndSystemName.keySet()[sysKeyNum];
                data.systemName = systemCodeAndSystemName.get(data.systemCode);
                data.businessDescription =businessDescriptionMap.get(data.systemCode+randonNumber);
                data.userCode =  userCodeAndUserNameMap.keySet()[randonNumber];
                data.userName = userCodeAndUserNameMap.get(data.userCode);
                data.url = "http://www.qq.com";
                data.operationPoint = "";
                data.tagging = data.systemName;
                data.tips = "提示错误";
                for(var j = 0;j<randonNumber;j++){

                    data.operationPoint += (data.operationPoint=="")?"节点"+j:"->节点"+j;

                    data.tagging +=(data.tagging=="")?"标签"+j:";标签"+j;


                }
                arr.push(data);
            }

        }catch (err){
            alert("无效的字符,请输入数字："+counter)
        }
        return arr;
    };

    var dictAttachmentMap = new HashMap();
    dictAttachmentMap.put(1,"a.jpg");
    dictAttachmentMap.put(2,"b.jpg");
    dictAttachmentMap.put(3,"c.jpg");
    dictAttachmentMap.put(4,"d.jpg");
    dictAttachmentMap.put(5,"e.jpg");
    dictAttachmentMap.put(6,"f.jpg");
    dictAttachmentMap.put(7,"g.jpg");
    dictAttachmentMap.put(8,"h.jpg");
    dictAttachmentMap.put(9,"i.jpg");
    dictAttachmentMap.put(10,"j.jpg");

    var businessDescriptionMap = new HashMap();
    businessDescriptionMap.put("SCMSPRD1","无法提取佣金，提示'汇总信息缺失，请确认'");
    businessDescriptionMap.put("SCMSPRD2","在佣金系统提取佣金时，显示提取实收信息时失败，无法提取跟单，导致我司无法支付经纪费");
    businessDescriptionMap.put("SCMSPRD3","无法提取附件中的保单税金部份的支付手续费信息'");
    businessDescriptionMap.put("SCMSPRD4","发现在系统提取支付手续费时,有一批保单存在数据重复.请帮查找原因并提出处理办法,谢谢!'");
    businessDescriptionMap.put("SCMSPRD5","省间主联，代从联方支手续费，是否更改了佣金规则？现我们财务、销管有以下两个问题");
    businessDescriptionMap.put("SCMSPRD6","佣金系统异常，出现同一保单存在相同的两条佣金信息，提取手续费时一并提取、结算、支付，造成多支费用到代理公司'");
    businessDescriptionMap.put("SCMSPRD7","无法提取佣金，提示'汇总信息缺失，请确认'");
    businessDescriptionMap.put("SCMSPRD8","在佣金系统提取佣金时，显示提取实收信息时失败，无法提取跟单，导致我司无法支付经纪费");
    businessDescriptionMap.put("SCMSPRD9","无法提取附件中的保单税金部份的支付手续费信息'");
    businessDescriptionMap.put("SCMSPRD10","发现在系统提取支付手续费时,有一批保单存在数据重复.请帮查找原因并提出处理办法,谢谢!'");
    businessDescriptionMap.put("PRPC1","转保失败，提示：Column (f) not found in any table in the query (or SLV is undefined). '");
    businessDescriptionMap.put("PRPC2","转保单失败，提示：投保查询码已过期 ，见费系统是缴费确认状态'");
    businessDescriptionMap.put("PRPC3","生成保单失败null");
    businessDescriptionMap.put("PRPC4","纳税人名称过长核保不过问题");
    businessDescriptionMap.put("PRPC5","该车辆因车架码录入错误，导致投保人在别的保险公司因没有关联到我司的交强险保单而重复投保");
    businessDescriptionMap.put("PRPC6","调用车险承保Q01接口进行报价。发现发现整单折扣与单个险别的折扣不对应");
    businessDescriptionMap.put("PRPC7","已过起保时间的保单重新投保提示重复投保");
    businessDescriptionMap.put("PRPC8","该车辆因车架码录入错误，导致投保人在别的保险公司因没有关联到我司的交强险保单而重复投保");
    businessDescriptionMap.put("PRPC9","调用车险承保Q01接口进行报价。发现发现整单折扣与单个险别的折扣不对应");
    businessDescriptionMap.put("PRPC10","已过起保时间的保单重新投保提示重复投保");
    businessDescriptionMap.put("PRPI1","转保失败，提示：Column (f) not found in any table in the query (or SLV is undefined). '");
    businessDescriptionMap.put("PRPI2","转保单失败，提示：投保查询码已过期 ，见费系统是缴费确认状态'");
    businessDescriptionMap.put("PRPI3","生成保单失败null");
    businessDescriptionMap.put("PRPI4","纳税人名称过长核保不过问题");
    businessDescriptionMap.put("PRPI5","该车辆因车架码录入错误，导致投保人在别的保险公司因没有关联到我司的交强险保单而重复投保");
    businessDescriptionMap.put("PRPI6","调用车险承保Q01接口进行报价。发现发现整单折扣与单个险别的折扣不对应");
    businessDescriptionMap.put("PRPI7","已过起保时间的保单重新投保提示重复投保");
    businessDescriptionMap.put("PRPI8","该车辆因车架码录入错误，导致投保人在别的保险公司因没有关联到我司的交强险保单而重复投保");
    businessDescriptionMap.put("PRPI9","调用车险承保Q01接口进行报价。发现发现整单折扣与单个险别的折扣不对应");
    businessDescriptionMap.put("PRPI10","已过起保时间的保单重新投保提示重复投保");
    businessDescriptionMap.put("PNC1","报错：估损超权限，请提交高级审核(a2) ");
    businessDescriptionMap.put("PNC2","无法结案 ");
    businessDescriptionMap.put("PNC3","车险理赔测试环境无法启动 ");
    businessDescriptionMap.put("PNC4","报案号错误 ");
    businessDescriptionMap.put("PNC5","零结案审核部分案件出现提交失败 ");
    businessDescriptionMap.put("PNC6","案件重复信息打不开 ");
    businessDescriptionMap.put("PNC7","案件丢失 ");
    businessDescriptionMap.put("PNC8","追偿案件无法处理 ");
    businessDescriptionMap.put("PNC9","案件丢失 ");
    businessDescriptionMap.put("PNC10","追偿案件无法处理 ");
    businessDescriptionMap.put("PNCAL1","追偿案件无法处理 ");
    businessDescriptionMap.put("PNCAL2","对应保单批改后理算有误  ");
    businessDescriptionMap.put("PNCAL3","意外险保期之外报案无提示  ");
    businessDescriptionMap.put("PNCAL4","核赔报错 ");
    businessDescriptionMap.put("PNCAL5","领款人信息无法进去 ");
    businessDescriptionMap.put("PNCAL6","业务与收付费直接理赔费用不一致  ");
    businessDescriptionMap.put("PNCAL7","计算书支付失败！ ");
    businessDescriptionMap.put("PNCAL8","报案号无法上传影像  ");
    businessDescriptionMap.put("PNCAL9","计算书支付失败！ ");
    businessDescriptionMap.put("PNCAL10","报案号无法上传影像  ");
    businessDescriptionMap.put("SFF1","打印的电子发票抬头有误，红冲失败  ");
    businessDescriptionMap.put("SFF2","无法开具发票，税控返回异常信息  ");
    businessDescriptionMap.put("SFF3","关于开票提示缺少相关信息请求报文不正确的问题  ");
    businessDescriptionMap.put("SFF4","key损坏无法红冲发票  ");
    businessDescriptionMap.put("SFF5","发票打印时出现乱码  ");
    businessDescriptionMap.put("SFF6","税控红冲报错纳税人识别号必须为大写字母和数字  ");
    businessDescriptionMap.put("SFF7","作废发票报错：税控系统返回异常 ");
    businessDescriptionMap.put("SFF8","CW-税控key无法正常使用，提示单证归属机构税号不一致  ");
    businessDescriptionMap.put("SFF9","车险保单无法开具电子发票，税控系统返回异常信息  ");
    businessDescriptionMap.put("SFF10","错误纳税号无法红冲  ");
    businessDescriptionMap.put("PICCTP1","领款人修改显示：null  ");
    businessDescriptionMap.put("PICCTP2","车险省间通赔系统核赔无法通过  ");
    businessDescriptionMap.put("PICCTP3","通赔业务与再保数据一致性问题  ");
    businessDescriptionMap.put("PICCTP4","需将追偿类型'追回物品'修正'追回现金'，收付费做相应修正  ");
    businessDescriptionMap.put("PICCTP5","领款人信息调整任务无法处理  ");
    businessDescriptionMap.put("PICCTP6","省间案件领款人信息调整处理  ");
    businessDescriptionMap.put("PICCTP7","无法发起本车定损任务  ");
    businessDescriptionMap.put("PICCTP8","无法综合接案  ");
    businessDescriptionMap.put("PICCTP9","一码通无定损车辆可以选  ");
    businessDescriptionMap.put("PICCTP10","一码通无定损车辆可以选  ");
    businessDescriptionMap.put("JY1","定损录入残值，定损、报价环节可以显示扣减残值金额，但核损环节无法同步残值金额  ");
    businessDescriptionMap.put("JY2","定损工具二代部分零配件返回理赔为空  ");
    businessDescriptionMap.put("JY3","一级报价如果要调整系统价格，并上浮10%，是否可以实现  ");
    businessDescriptionMap.put("JY4","提取东风日产、日产、东风英菲尼迪、英菲尼迪相关配件（28个常见配件）数据信息，如附件格式。  ");
    businessDescriptionMap.put("JY5","无法批量导入定损人员权限表  ");
    businessDescriptionMap.put("JY6","系统配件折扣可以超过修理厂设置的折扣  ");
    businessDescriptionMap.put("JY7","关于低碳功能问题咨询  ");
    businessDescriptionMap.put("JY8","零部件价格综合管理平台低碳修理厂无法维护  ");
    businessDescriptionMap.put("JY9","关于低碳功能问题咨询  ");
    businessDescriptionMap.put("JY10","零部件价格综合管理平台低碳修理厂无法维护  ");

    var userCodeAndUserNameMap = new HashMap();
    userCodeAndUserNameMap.put("5412098765","张三");
    userCodeAndUserNameMap.put("6666098765","李四");
    userCodeAndUserNameMap.put("1213098765","陆五");
    userCodeAndUserNameMap.put("2346098765","赵一");
    userCodeAndUserNameMap.put("1213657865","钱二");
    userCodeAndUserNameMap.put("1234568765","孙二");
    userCodeAndUserNameMap.put("8976098765","周六");
    userCodeAndUserNameMap.put("2309098765","吴久");
    userCodeAndUserNameMap.put("5678098765","王五");
    userCodeAndUserNameMap.put("1379498765","何六");

    var comCodeMap = new HashMap();
    comCodeMap.put("4400","广东省");
    comCodeMap.put("4401", "广州市分公司");
    comCodeMap.put("4494", "国际保险部");
    comCodeMap.put("4402", "韶关市分公司");
    comCodeMap.put("4405", "汕头市分公司");
    comCodeMap.put("4408", "湛江市分公司");
    comCodeMap.put("4409", "茂名市分公司");
    comCodeMap.put("4412", "肇庆市分公司");
    comCodeMap.put("4413", "惠州市分公司");
    comCodeMap.put("4414", "梅州市分公司");
    comCodeMap.put("4415", "汕尾市分公司");
    comCodeMap.put("4416", "河源市分公司");
    comCodeMap.put("4417", "阳江市分公司");
    comCodeMap.put("4418", "清远市分公司");
    comCodeMap.put("4451", "潮州市分公司");
    comCodeMap.put("4452", "揭阳市分公司");
    comCodeMap.put("4453", "云浮市分公司");
    comCodeMap.put("4404", "珠海市分公司");
    comCodeMap.put("4406", "佛山市分公司");
    comCodeMap.put("4407", "江门市分公司");
    comCodeMap.put("4419", "东莞市分公司");
    comCodeMap.put("4420", "中山市分公司");
    comCodeMap.put("4471", "顺德市分公司");




    var systemCodeAndSystemName = new HashMap();
    systemCodeAndSystemName.put("PRPC","车险承保");
    systemCodeAndSystemName.put("PRPI","非车承保");
    systemCodeAndSystemName.put("PNC","车险理赔");
    systemCodeAndSystemName.put("PNCAL","非车理赔");
    systemCodeAndSystemName.put("SCMSPRD","佣金系统");
    systemCodeAndSystemName.put("SFF","新收付费系统");
    systemCodeAndSystemName.put("PICCTP","车险通赔");
    systemCodeAndSystemName.put("JY","精友项目");

  /*  var dataArr = createBathData(1);
    bathPostJob(url,dataArr);
*/
    $("#single").click(function (e) {
        postJob(url,data);
        alert("完成单例工作,共计处理量："+1);
        e.stopPropagation();
    });
    $("#batch").click(function (e) {
        var counter = $("#counter").val();
        try{
            var c = parseInt(counter);
            if(Boolean(c)){
                bathPostJob(url,createBathData(c));
            }else{
                alert("无效的字符,请输入数字："+c);
            }

        }catch (err){
            alert("无效的字符,请输入数字："+counter);
            return false;
        }

        e.stopPropagation();
    });

});