var nameEl = document.getElementById('inCityInfo');

var first = [];
/* 省，直辖市 */
var second = [];
/* 市 */
var third = [];
/* 镇 */

var $nameEl = $(nameEl);
var defaultProvinceCode = $nameEl.attr('default-province');
var defaultCityCode = $nameEl.attr('default-city');
var defaultAreaCode = $nameEl.attr('default-area');
var defaultProvince;
var defaultCity;
var defaultArea;
if(isNotNull(defaultProvinceCode)) {
    defaultProvince = getIndex(city, defaultProvinceCode);
    if(isNotNull(defaultCityCode)) {
        defaultCity = getIndex(city[defaultProvince].sub, defaultCityCode);
        if(isNotNull(defaultAreaCode)) {
            defaultArea = getIndex(city[defaultProvince].sub[defaultCity].sub, defaultAreaCode);
        }
    }
}

var selectedIndex = [defaultProvince?defaultProvince:0, defaultCity?defaultCity:0,defaultArea?defaultArea:0];
/* 默认选中的地区 */
var checked = [defaultProvince?defaultProvince:0, defaultCity?defaultCity:0,defaultArea?defaultArea:0];
/* 已选选项 */

function getIndex(obj,code) {
    var objIndex;
    obj.forEach(function (item, index, arr) {
        if(code == item.code){
            objIndex = index;
            return;
        }
    })
    return objIndex;
}

function checkVal(obj,val) {
    var result = false;
    obj.forEach(function (item, index, arr) {
        if(val == item.name){
            result = true;
            return;
        }
    })
    return result;
}


function creatList(obj, list) {
    obj.forEach(function (item, index, arr) {
        var temp = new Object();
        temp.text = item.name;
        temp.value = item.code;
        list.push(temp);
    })
}

creatList(city, first);

if (city[selectedIndex[0]].hasOwnProperty('sub')) {
    creatList(city[selectedIndex[0]].sub, second);
} else {
    second = [{text: '', value: 0}];
}

if (city[selectedIndex[0]].sub[selectedIndex[1]].hasOwnProperty('sub')) {
    creatList(city[selectedIndex[0]].sub[selectedIndex[1]].sub, third);
} else {
    third = [{text: '', value: 0}];
}

var picker = new Picker({
    data: [first, second, third],
    selectedIndex: selectedIndex,
    title: '所在城市'
});

picker.on('picker.select', function (selectedVal, selectedIndex) {
    var text1 = first[selectedIndex[0]].text;
    var text2 = second[selectedIndex[1]].text;
    var text3 = third[selectedIndex[2]] ? third[selectedIndex[2]].text : '';
    var checkCity = checkVal(city[selectedIndex[0]].sub,text2);
    var checkArea = checkVal(city[selectedIndex[0]].sub[selectedIndex[1]].sub,text3);
    if(checkCity && checkArea){
        nameEl.value = text1 + ' ' + text2 + ' ' + text3;
    }else {
        showAlert('你选择的*所在城市有误，请重新选择');
        nameEl.value = '';
    }
});

picker.on('picker.change', function (index, selectedIndex) {
    if (index === 0) {
        firstChange();
    } else if (index === 1) {
        secondChange();
    }

    function firstChange() {
        second = [];
        third = [];
        checked[0] = selectedIndex;
        var firstCity = city[selectedIndex];
        if (firstCity.hasOwnProperty('sub')) {
            creatList(firstCity.sub, second);

            var secondCity = city[selectedIndex].sub[0]
            if (secondCity.hasOwnProperty('sub')) {
                creatList(secondCity.sub, third);
            } else {
                third = [{text: '', value: 0}];
                checked[2] = 0;
            }
        } else {
            second = [{text: '', value: 0}];
            third = [{text: '', value: 0}];
            checked[1] = 0;
            checked[2] = 0;
        }

        picker.refillColumn(1, second);
        picker.refillColumn(2, third);
        picker.scrollColumn(1, 0)
        picker.scrollColumn(2, 0)
    }

    function secondChange() {
        third = [];
        checked[1] = selectedIndex;
        var first_index = checked[0];
        if (city[first_index].sub[selectedIndex].hasOwnProperty('sub')) {
            var secondCity = city[first_index].sub[selectedIndex];
            creatList(secondCity.sub, third);
            picker.refillColumn(2, third);
            picker.scrollColumn(2, 0)
        } else {
            third = [{text: '', value: 0}];
            checked[2] = 0;
            picker.refillColumn(2, third);
            picker.scrollColumn(2, 0)
        }
    }

});

picker.on('picker.valuechange', function (selectedVal, selectedIndex) {
    $('#province').val(selectedVal[0]);
    $('#city').val(selectedVal[1]);
    $('#area').val(selectedVal[2]);
    // console.log(selectedVal);
    // console.log(selectedIndex);
});

nameEl.addEventListener('click', function () {
    picker.show();
});

function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}


