/**
 * Created by KZ.Chen on 2018/7/9.
 *
 * 企业客户画像
 */
var ctx = $("#ctx").val();

var submitFlag = true;  //提交标志，只允许提交一次

$(document).ready(function(){
    layui.use(['layer'], function(){
        var layer = layui.layer;
        var index = layer.load(1, {time: 1500});
        layer.close(index);
    });

    $("#editForm").bind('submit', function(){
        if(submitFlag == true){
            submitFlag = false;
            layui.use(['layer'], function(){
                var layer = layui.layer;

                layer.config({
                    title: false,   //标题
                    resize: false,  //是否可以拉伸
                    closeBtn: 0,    //弹窗右上角关闭按钮样式
                    time: 3000      //自动关闭时间（3秒）
                });

                if($("#insuredname").val() == ""){
                    layer.msg("请输入企业名称", {icon: 5, time: 3000});
                    submitFlag = true;
                }else if($("#address").val() == ""){
                    layer.msg("请输入地址", {icon: 5, time: 3000});
                    submitFlag = true;
                }else if(!new RegExp("(^(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$)|(^0?[1][358][0-9]{9}$)").test($("#teltag").val())){
                    layer.msg("请输入正确的联系方式", {icon: 5, time: 3000});
                    submitFlag = true;
                }else if($("#scale").val() == ""){
                    layer.msg("请输入规模", {icon: 5, time: 3000});
                    submitFlag = true;
                }else if($("#addresstag").val() == ""){
                    layer.msg("请输入所在地区", {icon: 5, time: 3000});
                    submitFlag = true;
                }else{
                    $.ajax({
                        url: ctx + "/comCusPortrait/add",
                        type: 'post',
                        data: getFormJson($("#editForm")),
                        success: function(data){
                            if(data.status == "success"){
                                var goFlag = true;
                                layer.alert(data.message, {icon: 1}, function(){
                                    goFlag = false;
                                    goToNewUrl(ctx + "/comCusPortrait/edit?page=1"
                                        + "&customerCode=" + data.customerCode + "&createby=" + $("#createby").val());
                                });
                                setTimeout(function(){
                                    if(goFlag == true){
                                        goToNewUrl(ctx + "/comCusPortrait/edit?page=1"
                                            + "&customerCode=" + data.customerCode + "&createby=" + $("#createby").val());
                                    }
                                }, 3000);
                            }else if(data.status == "error"){
                                layer.alert(data.message, {icon: 2});
                                submitFlag = true;
                            }
                        }
                    });
                }
            });
        }
        return false;
    });
});

function getFormJson(frm) {
    var o = {};
    var a = $(frm).serializeArray();
    $.each(a, function () {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
}