/**
 * Created by KZ.Chen on 2018/7/9.
 *
 * 企业客户画像
 */
var ctx = $("#ctx").val();


layui.use(['layer', 'table'], function(){
    var layer = layui.layer;
    var table = layui.table;

    table.render({
        id: "dataTable",
        elem: "#dataTable",
        url: ctx + "/comCusPortrait/getCBDataForTable",
        method: "post",
        where: {
            queryFlag: $("#queryFlag").val(),
            insuredcode: $("#insuredcode").val(),
            riskcode: $("#riskcode").val()
        },
        skin: 'line',    //行边框
        even: true,      //开启隔行背景
        unresize: true,  //是否禁止拖拉列宽
        loading: true,   //请求数据时显示loading
        page: {
            curr: 1,     //默认显示页
            limit: 5,    //每页显示的数据条数
            groups: 10,  //连续出现的页码个数
            prev: '上一页',
            next: '下一页',
            first: '首页',
            last: '末页',
            layout: ['prev', 'page', 'next', 'skip', 'count']  //自定义分页布局
        },
        cols: [[
            {field:'insuredcode',    title:'关系人代码', width: '15%', align: 'center'},
            {field:'insuredname',    title:'关系人名称', width: '15%', align: 'center'},
            {field:'comcode',        title:'归属机构',   width: '15%', align: 'center'},
            {field:'proposalno',     title:'投保单号',   width: '15%', align: 'center'},
            {field:'policyno',       title:'保单号',     width: '15%', align: 'center'},
            {field:'sumpremium',     title:'保费',       width: '15%', align: 'center'},
            {field:'agentcode',      title:'渠道代码',   width: '15%', align: 'center'},
            {field:'operatedate',    title:'签单日期',   width: '15%', align: 'center'},
            {field:'startdate',      title:'起保日期',   width: '15%', align: 'center'},
            {field:'enddate',        title:'终保日期',   width: '15%', align: 'center'},
            {field:'businessnature', title:'业务来源',   width: '15%', align: 'center'},
            {field:'sumamount',      title:'保险金额',   width: '15%', align: 'center'},
            {field:'riskcode',       title:'承保险种',   width: '15%', align: 'center'},
            {field:'bili',           title:'联共保比例', width: '15%', align: 'center'},
            {field:'plancode',       title:'方案代码',   width: '15%', align: 'center'},
        ]]
    });
});