/**
 * Created by KZ.Chen on 2018/7/9.
 *
 * 企业客户画像
 */
var ctx = $("#ctx").val();

var submitFlag = true;  //提交标志，只允许提交一次

$(document).ready(function(){
    layui.use(['layer'], function(){
        var layer = layui.layer;
        var index = layer.load(1, {time: 1500});
        layer.close(index);
    });

    $("#editForm").bind('submit', function(){
        if(submitFlag == true){
            submitFlag = false;
            layui.use(['layer'], function(){
                var layer = layui.layer;

                layer.config({
                    title: false,   //标题
                    resize: false,  //是否可以拉伸
                    closeBtn: 0,    //弹窗右上角关闭按钮样式
                    time: 3000      //自动关闭时间（3秒）
                });

                if(!new RegExp("(^(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$)|(^0?[1][358][0-9]{9}$)").test($("#teltag").val())){
                    layer.msg("请输入正确的联系方式", {icon: 5, time: 3000});
                    submitFlag = true;
                }else{
                    $.ajax({
                        url: ctx + "/comCusPortrait/update",
                        type: 'post',
                        data: getFormJson($("#editForm")),
                        success: function(data){
                            if(data.status == "success"){
                                var goFlag = true;
                                layer.alert(data.message, {icon: 1}, function(){
                                    goFlag = false;
                                    goToNewUrl(ctx + "/comCusPortrait/edit?page=" + $("#currPage").val()
                                        + "&customerCode=" + $("#insuredcode").val() + "&createby=" + $("#createby").val());
                                });
                                setTimeout(function(){
                                    if(goFlag == true){
                                        goToNewUrl(ctx + "/comCusPortrait/edit?page=" + $("#currPage").val()
                                            + "&customerCode=" + $("#insuredcode").val() + "&createby=" + $("#createby").val());
                                    }
                                }, 3000);
                            }else if(data.status == "error"){
                                layer.alert(data.message, {icon: 2});
                                submitFlag = true;
                            }
                        }
                    });
                }
            });
        }
        return false;
    });
});

/**
 * 点击在保险种“明细清单”按钮展示表格数据
 */
$("a[cb-riskcode]").on("click", function(){
    var queryFlag = $(this).attr("query-flag");
    var insuredcode = $("#insuredcode").val();
    var riskcode = $(this).attr("cb-riskcode");
    var riskname = $(this).attr("cb-riskname");

    layui.use(['layer'], function(){
        var title = (queryFlag == "oninsuredrisk" ? "在保险种" : "历史购买险种") + " - " + riskname;
        var layerOpenJson = {
            type: 2,
            title: title,
            area: ['90%','71%'],
            offset: ['10%', '5%'],
            resize: false,
            closeBtn: 2,
            content: ctx + "/comCusPortrait/goToCbTable?queryFlag=" + queryFlag +
                    "&insuredcode=" + insuredcode + "&riskcode=" + riskcode,
            yes: function(index){
                layer.close(index);
            },
            cancel: function(index){
                layer.close(index);
            }
        };
        layer.open(layerOpenJson);
        $("#tradetag").next().hide();
    });
});

/**
 * 点击产品推荐，根据产品展示风险点
 */
$("span[recommend-data]").on("click", function(){
    var insuredcode = $("#insuredcode").val();
    var recommend = $(this).attr("recommend-data");

    layui.use(['layer'], function() {
        var layer = layui.layer;
        var index = layer.load(3);

        $.ajax({
            url: ctx + "/comCusPortrait/getRecommendRiskpoint",
            type: 'post',
            data: {
                insuredcode : insuredcode,
                riskcname : recommend
            },
            success: function(data){
                if(data.status == "success"){
                    var riskpoints = data.riskpoints;
                    if(riskpoints.length <= 0){
                        layer.alert("该产品暂无风险点案例", {title: false, closeBtn: 0, icon: 5});
                    }else{
                        if(riskpoints.length == 1){
                            $("#riskpointUl").html("<div><li class='layui-btn layui-btn-primary layui-btn-xs top5'><span>"+riskpoints[0]+"</span></li></div>");
                        }else{
                            var riskpointHtml = "";
                            for(var i = 0; i < riskpoints.length; i++){
                                riskpointHtml += "<div><li class='layui-btn layui-btn-primary layui-btn-xs top5'><span>"+(i+1)+"."+riskpoints[i]+"</span></li></div>";
                            }
                            $("#riskpointUl").html(riskpointHtml);
                        }
                    }
                }
                layer.close(index);
            },
            error: function(){
                layer.alert("获取产品风险点失败，请联系管理员！", {title: false, closeBtn: 0, icon: 2});
                layer.close(index);
            }
        });

    });
});

/**
 * 点击产品推荐的“案例详情”按钮，显示
 */
$("a[recommend-example]").on("click", function(){
    var recommend = $(this).attr("recommend-example");

    layui.use(['layer'], function() {
        var layer = layui.layer;
        var index = layer.load(3);

        $.ajax({
            url: ctx + "/comCusPortrait/getRecommendExample",
            type: 'post',
            data: {
                riskname : recommend
            },
            success: function(data){
                if(data.status == "success"){
                    var summary = data.summary;
                    var content = data.content;
                    layer.alert("<span style='font-size:18px;font-weight:bold;'>概要：</span><br>" + summary + "<br><br>" +
                                "<span style='font-size:18px;font-weight:bold;'>内容：</span><br>" + content,
                        {
                            title: recommend + " - 案例详情",
                            area: ['1000px', '450px'],
                            scrollbar: false,
                            closeBtn: 0
                        });
                }else{
                    layer.alert("该产品暂无案例详情", {title: false, closeBtn: 0, icon: 5});
                }
                layer.close(index);
            },
            error: function(){
                layer.alert("获取产品案例详情失败，请联系管理员！", {title: false, closeBtn: 0, icon: 2});
                layer.close(index);
            }
        });

    });
});

function getFormJson(frm) {
    var o = {};
    var a = $(frm).serializeArray();
    $.each(a, function () {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
}