/**
 * Created by DixonLim
 */
function formatDate(dateValue,format){
    var date;
    if(dateValue == undefined){
        return undefined;
    }
    if((typeof dateValue) === 'object'){ //日期类型
        date = dateValue;
    }else if(isNaN(dateValue)){ //字符串类型
        var reg1 = /^([0-9]{4})(\-)([0-9]{1,2})(\-)([0-9]{1,2})$/;
        var reg2 = /^([0-9]{4})(\/)([0-9]{1,2})(\/)([0-9]{1,2})$/;
        var reg3 = /^([0-9]{4})(\-)([0-9]{1,2})(\-)([0-9]{1,2})/;
        var reg4 = /^([0-9]{4})(\/)([0-9]{1,2})(\/)([0-9]{1,2})/;
        if(reg1.test(dateValue)) {
            var dateObj = dateValue.split('-');
            date =  new Date(dateObj[0], dateObj[1] - 1, dateObj[2]);
        }else if(reg2.test(dateValue)){
            var dateObj = dateValue.split('/');
            date =  new Date(dateObj[0], dateObj[1] - 1, dateObj[2]);
        }else if(reg3.test(dateValue)){
            var dateObj = dateValue.split('-');
            var datDayObj = dateObj[2].split(' ');
            date =  new Date(dateObj[0], dateObj[1] - 1, datDayObj[0]);
        }else if(reg4.test(dateValue)){
            var dateObj = dateValue.split('/');
            var datDayObj = dateObj[2].split(' ');
            date =  new Date(dateObj[0], dateObj[1] - 1, datDayObj[0]);
        }else {
            date =  new Date(dateValue);
        }
    }else { //时间戳类型
        date =  new Date(dateValue);
    }
    var Y = date.getFullYear();
    var M = date.getMonth() + 1;
    var D = date.getDate();
    if(M<10){
        M="0"+M;
    }
    if(D<10){
        D="0"+D;
    }
    if(format =='yyyy-MM'){
        return Y + '-' + M;
    }else if(format =='yyyy-MM-dd') {
        return Y + '-' + M + '-' + D;
    }else {
        return Y + '-' + M + '-' + D;
    }

}

