/**
 * Created by DixonLim
 */
var renewCheckEnabled = false;
layui.use('laydate', function () {
    var laydate = layui.laydate;

    // 被保险人生日
    laydate.render({
        elem: '#birthDay' //指定元素
        , done: function (value, date, endDate) {
        }
    });
    // 投保人生日
    laydate.render({
        elem: '#applicantInfoBirthDay', //指定元素
        max: Date.today().addYears(-18).toString('yyyy-MM-dd'),
        done: function (value, date, endDate) {
        }
    });
});
// $("#applicantInfoBirthDay").datepicker({
//     changeMonth: true,
//     changeYear: true,
//     dateFormat: 'yy-mm-dd',
//     yearRange: 'c-100, c'
// });
// $("#birthDay").datepicker({
//     changeMonth: true,
//     changeYear: true,
//     dateFormat: 'yy-mm-dd',
//     yearRange: 'c-100, c'
// });
// $("#insuranceStartDate").datepicker({
//     changeMonth: true,
//     changeYear: true,
//     dateFormat: 'yy-mm-dd',
//     minDate: 0
// });

// $("#insuranceStartDate").change(function () {
//     setInsuranEndDate($("#insuranceStartDate").val());
// });

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

$('#idType').change(function () {
    changeIdType();
});
$('#applicantIdType').change(function () {
    changeApplicantIdType();
});

$('#applicantIdNumber').change(function () {
    showLoading();
    selectAccidentItem(function () {
        hideLoading();
    }, function () {
        hideLoading();
    });


});

$('input[name="isCarNo"]').change(function () {
    var $isCarNo = $(this);
    changeIsCarNo($isCarNo.val());
});

$('input[name="applicantGender"]').change(function () {
    var $applicantGender = $(this);
    var applicantGender = $applicantGender.val();
    $('#applicantGender').val(applicantGender);
});


function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            var defaultBirthDay = Date.today().addYears(-18).toString('yyyy-MM-dd');
            $('#applicantInfoBirthDay').val(defaultBirthDay);
            $('#birthDay').val(defaultBirthDay);
        }

        $('.insuredInfoCard').show();
    }
}

function changeApplicantIdType() {
    $('#organizecode').hide();
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#applicantIdType').val();
    if (thisIdType == '01') {
        $('.applicantInfoCard').hide();
        $('#applicantInfoBirthDay').val('');
        $('#birthDay').val('');
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            var defaultBirthDay = Date.today().addYears(-18).toString('yyyy-MM-dd');
            $('#applicantInfoBirthDay').val(defaultBirthDay);
            $('#birthDay').val(defaultBirthDay);
        }

        $('.applicantInfoCard').show();
    }
}

function validateIdCards(element, type, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                if (flag == '1') {
                    applicantInfoToInsuranInfo();
                }
                return true;
            }
        } else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if (checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                });
                return false;
            }
        } else if (idType == '37') {
            if (validateCard(value)) {
                var dataObj = {
                    applicantIdNumber: $("#applicantIdNumber").val()
                }
                var applicantIdNumber = $("#applicantIdNumber").val();
                var url = '/sfzn/renewal/findCode.do?applicantIdNumber=' + applicantIdNumber;
                ajaxRequest(url, dataObj, function successCallback(data) {
                    hideLoading();

                    if (data == null) {
                        alert('该机构无法获取组织机构代码证号需手工补充');
                        $('#organizecode').show();
                    } else {
                        $('#organizecode').show();
                        $("#organizetext").val(data);
                    }


                    $this.parent('.info').removeClass('error');
                    return true;

                }, function errorCallback(error) {
                    $this.parent('.info').addClass('error');
                    return false;
                });

            } else {
                $this.parent('.info').addClass('error');
                return false;
            }

        } else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    } else {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    }
    $('#isCarNo').val(isCarNo);
}

var oldRate = null;
initInsuranInfo();


function initInsuranInfo() {
    changeIdType();
    changeApplicantIdType();
    var $isCarNo = $('input[name="isCarNo"][checked]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    $('#feeRate').change(function () {
        var feeRate = $("#feeRate").val();
        var patt1 = new RegExp(/[0-9]$/);

        var result = patt1.test(feeRate);
        if (!result) {
            alert("费率格式不正确。");
        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                alert("修改费率不能增加。");
            }
        }
    });
}

getAccidentItem();

function getAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val()
    }
    var url = '/sfzn/reinsurance/getAccidentItems.do?recommendId=' + $("#recommendId").val();
    showLoading();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            $("#productPlan").html("");
            var productItemCode = $("#productItemCode").val();

            for (var i = 0; i < data.productItems.length; i++) {
                var productItem = data.productItems[i];


                if(productItem.productCode=="EAU00000012"||productItem.productCode=="EAU00000022"){
                    if(data.comCode!="4419"){
                        if (isNotNull(productItemCode)) {
                            if (productItem.productCode == productItemCode) {
                                $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                            } else {
                                $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                            }
                        } else {
                            if (i == 0) {
                                $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                            } else {
                                $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                            }
                        }
                    }

                }
                else {

                    if (isNotNull(productItemCode)) {
                        if (productItem.productCode == productItemCode) {
                            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        } else {
                            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        }
                    } else {
                        if (i == 0) {
                            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        } else {
                            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        }
                    }
                }

             // if (isNotNull(productItemCode)) {
             //        if (productItem.productCode == productItemCode) {
             //            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
             //        } else {
             //            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
             //        }
             //    } else {
             //        if (i == 0) {
             //            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
             //        } else {
             //            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
             //        }
             //    }

            }
            $("#productItemCode").val($("#productPlan").val());
            selectAccidentItem(function () {
                hideLoading();
            }, function () {
                hideLoading();
            });
        }
    });
}

$('#productPlan').change(function () {
    $("#productItemCode").val($("#productPlan").val());
    showLoading();
    selectAccidentItem(function () {
        hideLoading();
    }, function () {
        hideLoading();
    });
})

var startDate = null;

var changeInsuranceStartDate = 0;

function selectAccidentItem(suc, error) {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val()
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var isEau2020 = false;

            var insurancePremium = data.productItem.insurancePremium;
            var vehicleSeat = $("#vehicleSeat").val();
            if (isNaN(vehicleSeat)) {
                vehicleSeat = 1;
            }
            var unit = $("#unit").val();
            if (isNaN(unit)) {
                unit = 1;
            }
            var premium = parseInt(vehicleSeat) * parseInt(unit) * insurancePremium;
            $("#insurancePremium").html(premium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);
            var idNumber = $("#applicantIdNumber").val();
            var dataObjRate = {
                recommendId: $("#recommendId").val(),
                productItemCode: productItemCode,
                idNumber: idNumber
            }
            var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;

            if (data.productItem.productCode == 'EAU440001r' || data.productItem.productCode == 'EAU440001s'
                || data.productItem.productCode == 'EAU440001t' || data.productItem.productCode == 'EAU440001u') {
                isEau2020 = true;
            }

            var min = isEau2020 ? 3 : 1;
            var newStartDate = moment().add(min, 'days').startOf('day');
            // 如果当前选择的起保日期已在默认日期之后，则不需要设置
            if(changeInsuranceStartDate!=1){

            var curStartDate = moment($('#insuranceStartDate').val());
            if (curStartDate.isBefore(newStartDate)) {
                $('#insuranceStartDate').val(newStartDate.format('YYYY-MM-DD'));
                $('#insuranceEndDate').val(newStartDate.add(-1, 'days').add(1, 'years').endOf('day').format('YYYY-MM-DD'));
            }

            layui.use('laydate', function () {
                var laydate = layui.laydate;
                var startMoment = moment().add(min, 'days').startOf('day');

                // 起保日期选择
                if (startDate == null) {
                    startDate = laydate.render({
                        elem: '#insuranceStartDate' //指定元素
                        , min: min
                        , value: moment().add(min, 'days').startOf('day').format('YYYY-MM-DD')
                        , done: function (value, date, endDate) {
                            setInsuranEndDate(value);
                            // setInsuranEndDate(startMoment.format('YYYY-MM-DD'));
                        }
                    });
                }
                // 动态设置起始日期和默认值
                var defalutStartDateStr = moment().add(min, 'days').startOf('day').format('YYYY-MM-DD');
                $('#insuranceStartDate').val(defalutStartDateStr);
                startDate.config.value = defalutStartDateStr;
                startDate.config.min ={
                    year: startMoment.year(),
                    month: startMoment.month(),
                    date: startMoment.date(),
                    hours: 0,
                    minutes: 0,
                    seconds : 0
                }
                setInsuranEndDate(startMoment.format('YYYY-MM-DD'));
            });
            }
            ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                if (data.respCode == '0000') {
                    $("#feeRate").val(data.feeRate);
                    oldRate = $("#feeRate").val();
                    var aObj = document.getElementById("oldRate");
                    aObj.innerText = '(上限' + oldRate + '%)';
                    if (data.comCode == '4417' || data.comCode == '4413' || data.comCode == '4412' || data.comCode == '4408') {
                        $("#feeRateInput").hide();
                    }
                    if (data.comCode != '4405') {
                        $("#remarkInfo").hide();
                    }
                }

                if (typeof suc == 'function') {
                    suc(data);
                }
            }, function (data) {
                if (typeof error == 'function') {
                    error(data);
                }
            });

        }
    }, function (data) {
        if (typeof error == 'function') {
            error(data);
        }
    });
}


function selectAccidentItemByPay(suc, error) {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val()
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var isEau2020 = false;

            var insurancePremium = data.productItem.insurancePremium;
            var vehicleSeat = $("#vehicleSeat").val();
            if (isNaN(vehicleSeat)) {
                vehicleSeat = 1;
            }
            var unit = $("#unit").val();
            if (isNaN(unit)) {
                unit = 1;
            }
            var premium = parseInt(vehicleSeat) * parseInt(unit) * insurancePremium;
            $("#insurancePremium").html(premium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);
 


            if (data.productItem.productCode == 'EAU440001r' || data.productItem.productCode == 'EAU440001s'
                || data.productItem.productCode == 'EAU440001t' || data.productItem.productCode == 'EAU440001u') {
                isEau2020 = true;
            }

            var min = isEau2020 ? 3 : 1;
            var newStartDate = moment().add(min, 'days').startOf('day');
            // 如果当前选择的起保日期已在默认日期之后，则不需要设置
            if(changeInsuranceStartDate!=1){

                var curStartDate = moment($('#insuranceStartDate').val());
                if (curStartDate.isBefore(newStartDate)) {
                    $('#insuranceStartDate').val(newStartDate.format('YYYY-MM-DD'));
                    $('#insuranceEndDate').val(newStartDate.add(-1, 'days').add(1, 'years').endOf('day').format('YYYY-MM-DD'));
                }

                layui.use('laydate', function () {
                    var laydate = layui.laydate;
                    var startMoment = moment().add(min, 'days').startOf('day');

                    // 起保日期选择
                    if (startDate == null) {
                        startDate = laydate.render({
                            elem: '#insuranceStartDate' //指定元素
                            , min: min
                            , value: moment().add(min, 'days').startOf('day').format('YYYY-MM-DD')
                            , done: function (value, date, endDate) {
                                setInsuranEndDate(value);
                                // setInsuranEndDate(startMoment.format('YYYY-MM-DD'));
                            }
                        });
                    }
                    // 动态设置起始日期和默认值
                    var defalutStartDateStr = moment().add(min, 'days').startOf('day').format('YYYY-MM-DD');
                    $('#insuranceStartDate').val(defalutStartDateStr);
                    startDate.config.value = defalutStartDateStr;
                    startDate.config.min ={
                        year: startMoment.year(),
                        month: startMoment.month(),
                        date: startMoment.date(),
                        hours: 0,
                        minutes: 0,
                        seconds : 0
                    }
                    setInsuranEndDate(startMoment.format('YYYY-MM-DD'));
                });
            }


        }

    }, function (data) {
        if (typeof error == 'function') {
            error(data);
        }

    });
}



function ajaxRequest(url, data, successCallback, errorCallback) {
    var oneDayAgoStr = Date.today().addYears(-18).toString('yyyy-MM-dd');
    // 如果是机构投保，则虚拟投保人生日为当前日期
    if (data.applicantInfoBirthDay == '-') {
        data.applicantInfoBirthDay = oneDayAgoStr;
    }
    if (data.birthDay == '-') {
        data.birthDay = oneDayAgoStr;
    }

    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

function validateName(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateIdCard(element, type) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                return true;
            }
        } else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if (checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    layer.tips('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"', $this, {
                        tips: 1
                    });
                });
                return false;
            }
        } else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateMobile(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateVehicleNum(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkVehicleNumber(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateCarNo(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = validateCard(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateNumber(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        if (isNaN(value)) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            if ($this.attr('id') == 'vehicleSeat' || $this.attr('id') == 'unit') {

                 changeInsuranceStartDate = 1;
                selectAccidentItemByPay(function () {
                     if(!insurePayInfoDisabled) {
                        hideLoading();
                    }
                }, function () {

                     if(!insurePayInfoDisabled) {
                        hideLoading();
                     }
                });

            }

            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

var insurePayInfoDisabled = false;

function insurePayInfo() {
    if (!insurePayInfoDisabled) {
        showLoading("正在投保中，请等待！");
        insurePayInfoDisabled = true;
        var applicantAge = 0;
        var isCarNo = $("#isCarNo").val();
        var licenseNo = $("#licenseNo").val();
        var vinNo = $("#vinNo").val();
        var engineNo = $("#engineNo").val();
        var vehicleSeat = $("#vehicleSeat").val();
        var unit = $("#unit").val();
        var applicantName = $("#applicantName").val();
        var applicantIdType = $("#applicantIdType").val();
        var applicantIdNumber = $("#applicantIdNumber").val();
        var applicantGender = $("#applicantGender").val();
        var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
        var applicantMobile = $("#applicantMobile").val();
        var recommendId = $("#recommendId").val();
        var insuranceStartDate = $("#insuranceStartDate").val();
        var insuranceEndDate = $("#insuranceEndDate").val();
        var productItemCode = $("#productItemCode").val();
        var feeRate = $('#feeRate').val();
        var remark = $('#remark').val();
        if (applicantIdType == '01') {
            applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
            applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
            applicantGender = getSexByIdNum(applicantIdNumber);
        } else {
            var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
            applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
        }
        if (applicantIdType == '37') {
            $("#applicantIdType").val('31');
            applicantIdType = '31';
            $("#applicantIdNumber").val($("#organizetext").val());
            applicantIdNumber = $("#organizetext").val();

        }
        var dataObj = {
            policyPay: '1',
            insuredIdentity: "0",
            recommendId: recommendId,
            isCarNo: isCarNo,
            licenseNo: licenseNo,
            vinNo: vinNo,
            engineNo: engineNo,
            vehicleSeat: vehicleSeat,
            unit: unit,
            applicantName: applicantName,
            applicantIdType: applicantIdType,
            applicantIdNumber: applicantIdNumber,
            applicantGender: applicantGender,
            applicantAge: applicantAge,
            applicantInfoBirthDay: applicantInfoBirthDay,
            applicantMobile: applicantMobile,
            name: applicantName,
            idType: applicantIdType,
            idNumber: applicantIdNumber,
            gender: applicantGender,
            age: applicantAge,
            birthDay: applicantInfoBirthDay,
            mobile: applicantMobile,
            insuranceStartDate: insuranceStartDate,
            insuranceEndDate: insuranceEndDate,
            productItemCode: productItemCode,
            feeRate: feeRate,
            remark:remark
        }
        var errorCount = 0;
        if (isCarNo == '1') {
            if (!isNotNull(licenseNo)) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*车牌号不能为空');
                return;
            }
            if (!validateVehicleNum("#licenseNo")) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*车牌号有误，请重新修改信息。');
                return;
            }
        } else {
            if (!isNotNull(vinNo)) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*车架号不能为空');
                return;
            }
            if (!validateCarNo("#vinNo")) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*车架号码有误，请重新修改信息。');
                return;
            }
            if (!isNotNull(engineNo)) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*发动机号不能为空');
                return;
            }
            if (!validateCarNo("#engineNo")) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('填写的*发动机号有误，请重新修改信息。');
                return;
            }
        }
        if (!isNotNull(vehicleSeat)) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*核定载人数不能为空');

            return;
        }
        if (!validateNumber("#vehicleSeat")) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*核定载人数有误，请重新修改信息。');
            return;
        }
        showLoading();
        if (!isNotNull(unit)) {
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保份数不能为空');
            return;
        }
        if (!validateNumber("#unit")) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保份数有误，请重新修改信息。');
            return;
        }
        if (!isNotNull(applicantName)) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人姓名不能为空');
            return;
        }
        if (!validateName("#applicantName")) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人姓名有误，请重新修改信息。');
            return;
        }
        if (applicantAge < 18) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('投保人未满18周岁，请重新修改信息。');
            return;
        }
        if (!isNotNull(applicantIdNumber)) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人证件号码不能为空');
            return;
        }
        if (!validateIdCard("#applicantIdNumber", '2')) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人证件号码有误，请重新修改信息。');
            return;
        }
        if (!isNotNull(applicantMobile)) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人手机号不能为空');
            return;
        }
        if (!validateMobile("#applicantMobile")) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('填写的*投保人手机号有误，请重新修改信息。');
            return;
        }
        if (isNotNull(feeRate)) {

            var patt1 = new RegExp(/[0-9]*/);

            var result = patt1.test(feeRate);
            if (!result) {
                hideLoading();
                errorCount++;
                insurePayInfoDisabled = false;
                alert('费率格式不正确');
                return;


            } else {
                var feeNum = feeRate;
                var oldRateNum = oldRate;
                if (parseInt(feeNum) > parseInt(oldRateNum)) {
                    hideLoading();
                    errorCount++;
                    insurePayInfoDisabled = false;
                    alert('修改费率不能增加');
                    return;

                }
            }

        }
        if (!isNotNull(dataObj.feeRate)) {
            hideLoading();
            errorCount++;
            insurePayInfoDisabled = false;
            alert('费率不能为空');
            return;
        }
        if (errorCount == 0) {
            var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
            ajaxRequest(url, dataObj, function successCallback(data) {
                if (data.respCode == '0000') {
                    window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId;
                    // alert('投保成功！');
                } else {
                    hideLoading();
                    insurePayInfoDisabled = false;
                    if (isNotNull(data.respMsg)) {
                        alert(data.respMsg);
                    } else {
                        alert('网络错误，请稍后重试！');
                    }
                }
            }, function errorCallback(error) {
                hideLoading();
                insurePayInfoDisabled = false;
                alert('网络错误，请稍后重试！');
            });
        }
    }

}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}

$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});

function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}

function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}