/**
 * 业务员投保流程公共JS
 * @author Akers.Liang akersliang@foxmail.com
 */
$(function ($) {
    function changeIsCarNo($p, isCarNo) {
        if (isCarNo == '0') {
            $p.find('.licenseNoInfo').hide();
            $p.find('.engineNoInfo').show();
        } else {
            $p.find('.licenseNoInfo').show();
            $p.find('.engineNoInfo').hide();
        }
        $p.find('.isCarNo').val(isCarNo);
    }

    $('.car-info').each(function () {
        var $carInfo = $(this);
        var $isCarNoSelect = $carInfo.find('[name=isCarNoSelect]');
        if($isCarNoSelect != null && typeof $isCarNoSelect != 'undefined' && $isCarNoSelect.length > 0) {
            // isCarNoFlag为1表示有车牌
            var isCarNoFlag = $carInfo.find('[name=isCarNoSelect]:checked').val();
            changeIsCarNo($carInfo, isCarNoFlag);
            $carInfo.find('[name=isCarNoSelect]').on('change', function () {
                changeIsCarNo($carInfo, $(this).val());
            });
        }

        // 使用性质
        var $useNatureInfo =  $('.use-nature-code-info');
        $useNatureInfo.find('[name="useNatureCodeSelect"]').on('change', function () {
            $useNatureInfo.find('.useNatureCode').val($(this).val()).trigger('change');
        });

    });


});

function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            $('#birthDay').val(Date.today().add(-1).toString("yyyy-MM-dd"));
        }

        $('.insuredInfoCard').show();
    }
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
}



/**
 * 被保人 => 投保人
 */
function insuranInfoToApplicantInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {//被保人为本人
        $("#applicantName").val($("#name").val()).trigger('change');
        $("#applicantIdType").val($("#idType").val()).trigger('change');
        $("#applicantIdNumber").val($("#idNumber").val()).trigger('change');
        $("#applicantMobile").val($("#mobile").val()).trigger('change');
        $("#applicantGender").val($("#gender").val()).trigger('change');
        $("#applicantInfoBirthDay").val($("#birthDay").val()).trigger('change');
        // $('#applicantInfoBirthDay').html($("#birthDay").val());
        changeApplicantGender($("#gender").val());

    }
}

/**
 * 校验投/被保险人姓名
 * @param element
 * @param flag
 * @returns {boolean}
 */
function validateName(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

/**
 * 校验邮编
 * @param element
 * @returns {boolean}
 */
function validatePostCode(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkPostCode(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

/**
 * 校验证件号
 * @param element
 * @param type
 * @param flag
 * @returns {boolean}
 */
function validateIdCard(element, type, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');

                return true;
            }
        }  else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                // $infoEl.attr("txt_backup", $infoEl.html());
                // $infoEl.html("请输入正确的组织结构代码证号, 例如客户\"英德市石灰铺镇人民政府\"，统一社会信用代码是\"11441881007312939J\"，组织机构代码是\"00731293-9\"");
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    // layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                    layer.tips('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"', $this,{
                        tips: 1,
                        time: 0
                    });
                });

                return false;
            }
        }  else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

/**
 * 校验手机号
 * @param element
 * @param flag
 * @returns {boolean}
 */
function validateMobile(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

/**
 * 通用输入检查
 */
function checkInputs(options) {
    options = $.extend({
        success: function () {

        },
        error: function (errorCount, errorNames, messages) {

        }
    }, options);
    var data = basicDatas();
    var errorNames = [];
    var messages = [];
    var errorCount = 0;
    if (!validateName("#name")) {
        errorCount++;
        errorNames.push("name");
        messages.push('填写的*被保人姓名有误，请重新修改信息。');
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        errorNames.push("idNumber");
        messages.push('填写的*被保人证件号码有误，请重新修改信息。');
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        errorNames.push("mobile");
        messages.push('填写的*被保人手机号有误，请重新修改信息。');
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        errorNames.push("applicantName");
        messages.push('填写的*投保人姓名有误，请重新修改信息。');
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        errorNames.push("applicantIdNumber");
        messages.push('填写的*投保人证件号码有误，请重新修改信息。');
    }
    if (data.applicantAge < 18) {
        errorCount++;
        errorNames.push("applicantAge");
        messages.push('投保人未满18周岁，请重新修改信息。');
    }
    if (!validateMobile("#applicantMobile")) {
        errorNames.push("applicantMobile");
        errorCount++;
        messages.push('填写的*投保人手机号有误，请重新修改信息。');
    }
    if (data.insuredIdentity != '0') {
        if (data.name == data.applicantName) {
            errorCount++;
            errorNames.push("applicantName");
            messages.push('投保人和被保人姓名不能相同');
        }
        if (data.idType == data.applicantIdType && data.idNumber == data.applicantIdNumber) {
            errorCount++;
            errorNames.push("applicantName");
            messages.push('投保人和被保人证件号码不能相同');
        }
    }
    if (!isNotNull(data.address)) {
        errorCount++;
        errorNames.push("address");
        messages.push('填写的*投保人地址不能为空');
    }
    if (isNotNull(data.feeRate)) {

        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(data.feeRate);
        if(!result){
            errorCount++;
            errorNames.push("feeRate");
            messages.push('费率格式不正确');

        }else{
            var  feeNum =    data.feeRate;
            var oldRateNum  = oldRate;
            if(parseInt(feeNum)>parseInt(oldRateNum)){
                errorCount++;
                errorNames.push("feeRate");
                messages.push('修改费率不能增加');

            }
        }

    }
    if (!isNotNull(data.feeRate)) {


        errorCount++;
        errorNames.push("feeRate");
        messages.push('费率不能为空');

    }
    if (!validatePostCode('#area')) {
        errorCount++;
        errorNames.push("postCode");
        messages.push('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
    }

    if(errorCount > 0) {
        options.error.call(this, errorCount, errorNames, messages);
    } else {
        options.success.call(this);
    }
}

/**
 * 获取通用的数据对象
 */
function basicDatas() {
    var data = {};
    data.age = 0;
    data.policyPay = '1';
    data.applicantAge = 0;
    data.name = $("#name").val();
    data.idType = $("#idType").val();
    data.idNumber = $("#idNumber").val();
    data.mobile = $("#mobile").val();
    data.gender = $("#gender").val();
    data.birthDay = $("#birthDay").val();
    data.applicantIsSocialSe = $('#applicantIsSocialSe').val();
    data.area = $('#area').val();
    data.address = $('#address').val();
    data.applicantName = $("#applicantName").val();
    data.applicantIdType = $("#applicantIdType").val();
    data.applicantIdNumber = $("#applicantIdNumber").val();
    data.applicantGender = $("#applicantGender").val();
    data.applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    data.applicantMobile = $("#applicantMobile").val();
    data.insuredIdentity = $("#insuredIdentity").val();
    data.recommendId = $("#recommendId").val();
    data.insuranceStartDate = $("#insuranceStartDate").val();
    data.insuranceEndDate = $("#insuranceEndDate").val();
    data.productItemCode = $("#productItemCode").val();
    data.isBeneficiary = $('#isBeneficiary').val();
    data.beneficiaryName = $('#beneficiaryName').val();
    data.beneficiaryIdNumber = $('#beneficiaryIdNumber').val();
    data.oldPolicyNo =$('#last-policy').val();
    data.feeRate = $('#feeRate').val();
    data.remark = $('#remark').val();
    if (data.idType == '01') {
        data.age = getAgeBybirthDay(getbirthDayByIdNum(data.idNumber));
        data.birthDay = getbirthDayByIdNum(data.idNumber);
        data.gender = getSexByIdNum(data.idNumber);
    } else {
        data.birthDay = $('#birthDay').val();
        data.age = getAgeBybirthDay(data.birthDay);
    }
    if (data.applicantIdType == '01') {
        data.applicantAge = getAgeBybirthDay(getbirthDayByIdNum(data.applicantIdNumber));
        data.applicantInfoBirthDay = getbirthDayByIdNum(data.applicantIdNumber);
        data.applicantGender = getSexByIdNum(data.applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        data.applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    if (data.isBeneficiary == '1') {
        data.beneficiaryBirthDay = getbirthDayByIdNum(data.beneficiaryIdNumber);
        data.beneficiaryGender = getSexByIdNum(data.beneficiaryIdNumber);
    }
    if (data.insuredIdentity == '0') {//如果是本人,人人安康做被保人赋值给投保人的处理
        data.applicantName = data.name;
        data.applicantIdType = data.idType;
        data.applicantIdNumber = data.idNumber;
        data.applicantGender = data.gender;
        data.applicantAge = data.age;
        data.applicantInfoBirthDay = data.birthDay;
        data.applicantMobile = data.mobile;
    }



    return data;
}


