/**
 * Created by DixonLim
 */
// 被保险人生日控件
var laydateBirthDay;
// 投保人生日控件
var laydateApplicantBirthDay;
// 起保日期选择
var laydateInsuranceStartDate;

function alert(msg) {
    layui.use('layer', function () {
        layer.alert(msg)
    });
}

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

var renewCheckEnabled = true;

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    } else {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    }
}

function changeIsBeneficiary(isBeneficiary) {
    if (isBeneficiary == '0') {
        $('.beneficiaryDiv').hide();
    } else {
        $('.beneficiaryDiv').show();
    }
}

function changeGender(value) {
    $('input[name="gender"]').removeAttr('checked');
    $('input[name="gender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}

function changeApplicantGender(value) {
    $('input[name="applicantGender"]').removeAttr('checked');
    $('input[name="applicantGender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}
var oldRate = null;
function initInsuranInfo() {

    $('#feeRate').change(function () {
        var feeRate = $("#feeRate").val();
        var patt1 = new RegExp(/[0-9]$/);

        var result = patt1.test(feeRate);
        if (!result) {
            alert("费率格式不正确。");
        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                alert("修改费率不能增加。");
            }
        }
    });

    $('#amountSelect').change(function () {
        getAccidentItem();
    });
    $('#idType').change(function () {
        changeIdType();
        insuranInfoToApplicantInfo();
    });
    $('#name').change(function () {
        validateName(this);
        insuranInfoToApplicantInfo();
    });
    $('#mobile').change(function () {
        validateMobile(this);
        insuranInfoToApplicantInfo();
    });
    $('input[name="applicantIsSocialSe"]').change(function () {
        var $applicantIsSocialSe = $(this);
        var applicantIsSocialSe = $applicantIsSocialSe.val();
        $('#applicantIsSocialSe').val(applicantIsSocialSe);
        getAccidentItem();
    });
    $('#idNumber').change(function () {
        if (validateIdCard("#idNumber", '1')) {
            getAccidentItem();
        }
        insuranInfoToApplicantInfo();
    });
    $('input[name="isBeneficiary"]').change(function () {
        var $isBeneficiary = $(this);
        var isBeneficiary = $isBeneficiary.val();
        $('#isBeneficiary').val(isBeneficiary);
        changeIsBeneficiary(isBeneficiary);
    });

    $('input[name="gender"]').change(function () {
        var $gender = $(this);
        var gender = $gender.val();
        $('#gender').val(gender);
        insuranInfoToApplicantInfo();
    });

    $('input[name="applicantGender"]').change(function () {
        var $applicantGender = $(this);
        var applicantGender = $applicantGender.val();
        $('#applicantGender').val(applicantGender);
    });
    $('#insuredIdentity').on('change', function () {
        var $this = $(this);
        if ($this.val() == '0') {
            insuranInfoToApplicantInfo();
            $('#application-infoes').addClass('hidden');
            $('#self-insure-infoes').removeClass('hidden');
        } else {
            $('#application-infoes').removeClass('hidden');
            $('#self-insure-infoes').addClass('hidden');
        }
    });
    // 投保人录入项相关事件绑定
    $('#applicantName').on('change', function () {
        var $p = $(this).parents('.info-line');
        if(!$p.hasClass('hidden')) {
            validateName(this,'1');
        }
    });
    // 投保人证件类型转变
    $('#applicantIdType').change(function () {
        changeApplicantIdType();
    });

    layui.use('laydate', function(){
        var laydate = layui.laydate;

        // 被保险人生日
        laydateBirthDay = laydate.render({
            elem: '#birthDay' //指定元素
            , done: function(value, date, endDate){
                // console.log(value); //得到日期生成的值，如：2017-08-18
                // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                getAccidentItem(value);
                insuranInfoToApplicantInfo();
            }
        });
        // 投保人生日
        laydateApplicantBirthDay = laydate.render({
            elem: '#applicantInfoBirthDay' //指定元素
            , done: function(value, date, endDate){
                // console.log(value); //得到日期生成的值，如：2017-08-18
                // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                // getProductItem(value);
                // insuranInfoToApplicantInfo();
            }
        });
        // 起保日期选择
        laydateInsuranceStartDate = laydate.render({
            elem: '#insuranceStartDate' //指定元素
            , min: 1
            , done: function(value, date, endDate) {
                setInsuranEndDate(value);
            }
        });
    });

    changeIdType();
    // changeApplicantIdType();
    $('#insuredIdentity').change();
    var $isCarNo = $('input[name="isCarNo"]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    getAccidentItem();

    $('#productPlan').change(function () {
        $("#productItemCode").val($("#productPlan").val());
        selectAccidentItem();
    })

    changeIsBeneficiary($("#isBeneficiary").val())
}

var renewalFlag = null;


function getAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val()
    }

    var url = '/sfzn/reinsurance/getAccidentItems.do?recommendId=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            $("#productPlan").html("");
            var productItemCode = $("#productItemCode").val();
            for (var i = 0; i < data.productItems.length; i++) {
                var productItem = data.productItems[i];
                if (isNotNull(productItemCode)) {
                    if (productItem.productCode == productItemCode) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                } else {
                    if (i == 0) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                }
            }
            $("#productItemCode").val($("#productPlan").val());
            selectAccidentItem();
        }
    });
}

function selectAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val(),
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var insurancePremium = data.productItem.insurancePremium;
            var unit = $("#unit").val();
            if(isNaN(unit)){
                unit = 1;
            }
            var premium = parseInt(unit) * insurancePremium;
            $("#insurancePremium").html(premium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);
            var idNumber = $("#applicantIdNumber").val();
            var dataObjRate = {
                recommendId: $("#recommendId").val(),
                productItemCode: productItemCode,
                idNumber:idNumber
            }
            var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() +'&productItemCode=' + productItemCode+'&idNumber='+idNumber;


            ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                if (data.respCode == '0000') {

                    $("#feeRate").val(data.feeRate);
                    oldRate  =  $("#feeRate").val();
                    var aObj = document.getElementById("oldRate");
                    aObj.innerText = '(上限'+oldRate+'%)';
                }
            });
        }

    });
}


function insurePayInfo() {
    var age = 0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var address = $('#address').val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    var occupationCode = $("#occupationCode").val();
    var businessDetail = $("#businessDetail").val();
    var houseProperty = $("#houseProperty").val();
    var incomeSource = $("#incomeSource").val();
    var feeRate = $('#feeRate').val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber)
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        policyPay: '1',
        recommendId: recommendId,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        gender: gender,
        age: age,
        birthDay: birthDay,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
        address: address,
        occupationCode: occupationCode,
        businessDetail: businessDetail,
        houseProperty: houseProperty,
        incomeSource: incomeSource,
        feeRate:feeRate

    }
    var errorCount = 0;
    if (!validateName("#name")) {
        errorCount++;
        alert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if (applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (idType != '01') {
        if (!isNotNull(houseProperty)) {
            errorCount++;
            alert('填写的被保人学校不能为空');
            return;
        }
        if (!isNotNull(incomeSource)) {
            errorCount++;
            alert('填写的被保人班级不能为空');
            return;
        }
    }

    if (!isNotNull(address)) {
        errorCount++;
        alert('填写的*投保人地址不能为空');
        return;
    }
    if (!validatePostCode('#area')) {
        errorCount++;
        alert('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
        return;
    }
    if (age<3||age>40) {
        errorCount++;
        alert("没有合适的产品方案，学平险只适合3~40岁人群");
        return;
    }
    if (isNotNull(feeRate)) {

        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(feeRate);
        if (!result) {
            errorCount++;
            alert('费率格式不正确');
            return;


        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                errorCount++;
                alert('修改费率不能增加');
                return;

            }
        }

    }
    if (errorCount == 0) {
        showLoading("正在投保中，请等待！");
        var isRenewal = false;
        insureService.insurePayInfo({
            data: dataObj,
            success: function (d) {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + d.recommendId + ('&renewFlag=' + (isRenewal ? 1 : 0));
            },
            error: function (c, m) {
                alert(c + ": " + m);
                hideLoading();
            }
        });
    }
}

$(function(){
    var checkLayuiInterval = window.setInterval(function () {
        if(typeof layui != 'undefined' && layui != null) {
            window.clearInterval(checkLayuiInterval);
            initInsuranInfo();
        }
    }, 10);
});



function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function selectChangeOccupationCode(obj)
{
    var businessDetail = document.getElementById("businessDetail");
    if(obj.value=='12010211'){
        businessDetail .value = 'A1';
    }else if(obj.value=='12010212'){
        businessDetail .value = '43';
    }else if(obj.value=='12010213'){
        businessDetail .value = '43';
    }else if(obj.value=='12010221'){
        businessDetail .value = 'A3';
    }else if(obj.value=='12010222'){
        businessDetail .value = 'A2';
    }else if(obj.value=='1201023'){
        businessDetail .value = '94';
    }else if(obj.value=='2104011'){
        businessDetail .value = 'A4';
    }else if(obj.value=='2104012'){
        businessDetail .value = 'A4';
    }
}
