/**
 * Created by DixonLim
 */

$("#applicantInfoBirthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#birthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#insuranceStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    minDate: 0
});
$("#launchDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#makeStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#makeEndDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#licStartDateForHull").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#licEndDateForHull").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});

$("#insuranceStartDate").change(function () {
    var $this = $("#insuranceStartDate");
    setInsuranEndDate($this.val());
    setLicStartDateForHull($this.val());
});

$('#licStartDateForHull').change(function () {
    var $this = $(this);
    var licEndDateForHull = getDateByDateParams($this.val(), '1', '+', '', '', '', '');
    $('#licEndDateForHull').val(licEndDateForHull);
});

$("#makeStartDate").change(function () {
    if (!isNotEmpty($('#licStartDateForHull').val()) && !isNotEmpty($('#licEndDateForHull').val())) {
        changeFittingDate(true);
    } else {
        changeFittingDate();
    }
});

$('#stepHull').change(function () {
    changeFittingDate();
})

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}
function setLicStartDateForHull(startDate) {
    $('#licStartDateForHull').val(startDate).trigger("change");
}

$('#idType').change(function () {
    changeIdType();
});
$('#applicantIdType').change(function () {
    changeApplicantIdType();
});

$('input[name="isCarNo"]').change(function () {
    var $isCarNo = $(this);
    changeIsCarNo($isCarNo.val());
});

$('input[name="applicantGender"]').change(function () {
    var $applicantGender = $(this);
    var applicantGender = $applicantGender.val();
    $('#applicantGender').val(applicantGender);
});


function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for(var k in comIdTypes) {
            if(comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if(isCompany) {
            $('#applicantInfoBirthDay').val('-');
            $('#birthDay').val('-');
        }

        $('.insuredInfoCard').show();
    }
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
}
function changeFittingDate(sync) {
    if (isNotEmpty($('#makeStartDate').val())) {
        var makeEndDate = getDateByDateParams($('#makeStartDate').val(), $('#stepHull').val(), '+', '', '', '', '');
        $('#makeEndDate').val(makeEndDate);
        var licStartDateForHull = getDateByDateParams($('#makeEndDate').val(), '', '', '', '', '1', '+');
        if (sync == true) {
            $('#licStartDateForHull').val(licStartDateForHull);
            var licEndDateForHull = getDateByDateParams($('#licStartDateForHull').val(), '1', '+', '', '', '', '');
            $('#licEndDateForHull').val(licEndDateForHull);
        }
        $('#insuranceStartDate').val(licStartDateForHull);
        var insuranceEndDate = getDateByDateParams(licStartDateForHull, '1', '+', '', '', '', '');
        insuranceEndDate = getDateByDateParams(insuranceEndDate, '', '', '', '', '1', '-');
        $('#insuranceEndDate').val(insuranceEndDate);

    }
}

initInsuranInfo();
function initInsuranInfo() {
    changeIdType();
    changeApplicantIdType();
    setInsuranEndDate($("#insuranceStartDate").val());
    var makeStartDate = $('#makeStartDate').val();
    if(isNotEmpty(makeStartDate)){
        $('#makeStartDateInfo').html($('#makeStartDate').val())
    }
    var makeEndDate = $('#makeEndDate').val();
    if(isNotEmpty(makeEndDate)){
        $('#makeEndDateInfo').html($('#makeEndDate').val())
    }
    var licStartDateForHull = $('#licStartDateForHull').val();
    if(isNotEmpty(licStartDateForHull)){
        $('#licStartDateForHullInfo').html($('#licStartDateForHull').val())
    }else {
        changeFittingDate(true);
    }
    var licEndDateForHull = $('#licEndDateForHull').val();
    if(isNotEmpty(licEndDateForHull)){
        $('#licEndDateForHullInfo').html($('#licEndDateForHull').val())
    }else {
        changeFittingDate(true);
    }
}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

getAccidentItem();
function getAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val()
    }
    var url = '/sfzn/reinsurance/getAccidentItems.do?recommendId=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            $("#productPlan").html("");
            var productItemCode = $("#productItemCode").val();
            for (var i = 0; i < data.productItems.length; i++) {
                var productItem = data.productItems[i];
                if (isNotNull(productItemCode)) {
                    if (productItem.productCode == productItemCode) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                } else {
                    if (i == 0) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                }
            }
            $("#productItemCode").val($("#productPlan").val());
            selectAccidentItem();
        }
    });
}

$('#productPlan').change(function () {
    $("#productItemCode").val($("#productPlan").val());
    selectAccidentItem();
})
function selectAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val()
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var insurancePremium = data.productItem.insurancePremium;
            var vehicleSeat = $("#vehicleSeat").val();
            if (isNaN(vehicleSeat)) {
                vehicleSeat = 1;
            }
            var unit = $("#unit").val();
            if (isNaN(unit)) {
                unit = 1;
            }
            var premium = parseInt(vehicleSeat) * parseInt(unit) * insurancePremium;
            $("#insurancePremium").html(premium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);
        }
    });
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}
function validateName(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateIdCard(element, type) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                return true;
            }
        }  else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                });
                return false;
            }
        }  else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateMobile(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateVehicleNum(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkVehicleNumber(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateCarNo(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = validateCard(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateNumber(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        if (isNaN(value)) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            if ($this.attr('id') == 'vehicleSeat') {
                selectAccidentItem();
            }
            if ($this.attr('id') == 'unit') {
                selectAccidentItem();
            }
            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function insurePayInfo() {
    var applicantAge = 0;
    var licenseNo = $("#licenseNo").val();
    var trySailPeriod = $("#trySailPeriod").val();
    var trySailArea = $("#trySailArea").val();
    var shipManagerAddress = $("#shipManagerAddress").val();
    var shipPort = $("#shipPort").val();
    var isLicForIntTon = $("#isLicForIntTon").val();
    var shipWayType = $("#shipWayType").val();
    var shipManagerAddress = $("#shipManagerAddress").val();
    var engineNo = $("#engineNo").val();
    var vinNo = $("#vinNo").val();
    var useNatureCode = $("#useNatureCode").val();
    var shipStruct = $("#shipStruct").val();
    var shipValue = $("#shipValue").val();
    var launchDate = $("#launchDate").val();
    var applyCriterion = $("#applyCriterion").val();
    var isLicForIntLoad = $("#isLicForIntLoad").val();
    var shipAssociation = $("#shipAssociation").val();
    var registrySite = $("#registrySite").val();
    var sailAreaName = $("#sailAreaName").val();
    var makeStartDate = $("#makeStartDate").val();
    var stepHull = $("#stepHull").val();
    var makeEndDate = $("#makeEndDate").val();
    var licStartDateForHull = $("#licStartDateForHull").val();
    var licEndDateForHull = $("#licEndDateForHull").val();
    var deliveryPlace = $("#deliveryPlace").val();
    var unit = $("#unit").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        policyPay: '1',
        insuredIdentity: "0",
        recommendId: recommendId,
        zciInfo: {
            licenseNo: licenseNo,
            trySailPeriod: trySailPeriod,
            trySailArea: trySailArea,
            shipManagerAddress: shipManagerAddress,
            shipPort: shipPort,
            isLicForIntTon: isLicForIntTon,
            shipWayType: shipWayType,
            engineNo: engineNo,
            vinNo: vinNo,
            useNatureCode: useNatureCode,
            shipStruct: shipStruct,
            shipValue: shipValue,
            launchDate: launchDate,
            applyCriterion: applyCriterion,
            isLicForIntLoad: isLicForIntLoad,
            shipAssociation: shipAssociation,
            registrySite: registrySite,
            sailAreaName: sailAreaName,
            makeStartDate: makeStartDate,
            stepHull: stepHull,
            makeEndDate: makeEndDate,
            licStartDateForHull: licStartDateForHull,
            licEndDateForHull: licEndDateForHull,
            deliveryPlace: deliveryPlace
        },
        unit: unit,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
    }
    var errorCount = 0;
    if (!isNotNull(trySailPeriod)) {
        errorCount++;
        showAlert('填写的*厂牌型号不能为空');
        return;
    }
    if (!isNotNull(trySailArea)) {
        errorCount++;
        showAlert('填写的*车型编码不能为空');
        return;
    }
    if (!isNotNull(shipManagerAddress)) {
        errorCount++;
        showAlert('填写的*车型名称不能为空');
        return;
    }
    if (!isNotNull(shipPort)) {
        errorCount++;
        showAlert('填写的*车系名称不能为空');
        return;
    }
    if (!isNotNull(unit)) {
        errorCount++;
        alert('填写的*投保份数不能为空');
        return;
    }
    if (!validateNumber("#unit")) {
        errorCount++;
        alert('填写的*投保份数有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantName)) {
        errorCount++;
        alert('填写的*投保人姓名不能为空');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantIdNumber)) {
        errorCount++;
        alert('填写的*投保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if(applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantMobile)) {
        errorCount++;
        alert('填写的*投保人手机号不能为空');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(launchDate)) {
        errorCount++;
        showAlert('填写的*车辆购买日期不能为空');
        return;
    }
    var canBuyTime = new Date(getDateByDateParams(new Date(), '3', '-', '', '', '', '')).getTime();
    var launchTime = new Date(launchDate).getTime();
    if (launchTime <= canBuyTime) {
        errorCount++;
        showAlert('购车日期不能大于3年');
        return;
    }
    if (errorCount == 0) {
        showLoading("正在投保中，请等待！");
        var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
        ajaxRequest(url, dataObj, function successCallback(data) {
            hideLoading();
            if (data.respCode == '0000') {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId;
                // alert('投保成功！');
            } else {
                if (isNotNull(data.respMsg)) {
                    alert(data.respMsg);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, function errorCallback(error) {
            hideLoading();
            alert('网络错误，请稍后重试！');
        });
    }

}

$(document).ready(function (e) {
    if (!isNotEmpty($('#licStartDateForHull').val()) && !isNotEmpty($('#licEndDateForHull').val())) {
        changeFittingDate(true);
    } else {
        changeFittingDate();
    }
});
