/**
 * Created by DixonLim
 */

$("#applicantInfoBirthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#birthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#insuranceStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    minDate: 0
});

$("#insuranceStartDate").change(function () {
    setInsuranEndDate($("#insuranceStartDate").val());
});


$('#idNumber').change(function () {

    selectAccidentItem();


});

$("#applicantInfoBirthDay").change(function () {
    var insuredIdentity = $('#insuredIdentity').val();
    if(insuredIdentity == '0'){
        applicantInfoToInsuranInfo();
    }
});

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

function validateVehicleNum(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkVehicleNumber(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

$('#idType').change(function () {
    changeIdType();
});
$('#applicantIdType').change(function () {
    changeApplicantIdType();
});

$('input[name="insuredIdentity"]').change(function () {
    var $insuredIdentity = $(this);
    var insuredIdentity = $insuredIdentity.val();
    $('#insuredIdentity').val(insuredIdentity);
    if(insuredIdentity == '0'){
        applicantInfoToInsuranInfo();
    }
});

$('input[name="gender"]').change(function () {
    var $gender = $(this);
    var gender = $gender.val();
    $('#gender').val(gender);
});

$('input[name="applicantGender"]').change(function () {
    var $applicantGender = $(this);
    var applicantGender = $applicantGender.val();
    $('#applicantGender').val(applicantGender);
    var insuredIdentity = $('#insuredIdentity').val();
    if(insuredIdentity == '0'){
        applicantInfoToInsuranInfo();
    }
});

function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for(var k in comIdTypes) {
            if(comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if(isCompany) {
            $('#applicantInfoBirthDay').val('-');
            $('#birthDay').val('-');
        }

        $('.insuredInfoCard').show();
    }
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
    var insuredIdentity = $('#insuredIdentity').val();
    if(insuredIdentity == '0'){
        applicantInfoToInsuranInfo();
    }
}

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    } else {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    }
}
function changeGender(value) {
    $('input[name="gender"]').removeAttr('checked');
    $('input[name="gender"]').each(function () {
        var $this = $(this);
        if($this.val() == value){
            $this.prop('checked','checked');
        }
    })
}
var oldRate = null;
initInsuranInfo();
function initInsuranInfo() {
    changeIdType();
    changeApplicantIdType();
    var $isCarNo = $('input[name="isCarNo"]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    $('#feeRate').change(function () {
        var feeRate = $("#feeRate").val();
        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(feeRate);
        if (!result) {
            alert("费率格式不正确。");
        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                alert("修改费率不能增加。");
            }
        }
    });
}

getAccidentItem();
function getAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val()
    }
    var url = '/sfzn/reinsurance/getAccidentItems.do?recommendId=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            $("#productPlan").html("");
            var productItemCode = $("#productItemCode").val();
            for (var i = 0; i < data.productItems.length; i++) {
                var productItem = data.productItems[i];
                if (isNotNull(productItemCode)) {
                    if (productItem.productCode == productItemCode) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                } else {
                    if (i == 0) {
                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    } else {
                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                    }
                }
            }
            $("#productItemCode").val($("#productPlan").val());
            selectAccidentItem();
        }
    });
}

$('#productPlan').change(function () {
    $("#productItemCode").val($("#productPlan").val());
    var productPlan =  $("#productPlan").val();
    if(productPlan=="LDO440003v"||productPlan=="LDO440003w"||productPlan=="LDO440003x"||productPlan=="LDO440003y"){
        $("#license").show();
        $("#seat").show();
    }else{
        $("#license").hide();
        $("#seat").hide();
    }
    selectAccidentItem();
})
function selectAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val()
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var insurancePremium = data.productItem.insurancePremium;
            var unit = $("#unit").val();
            if(isNaN(unit)){
                unit = 1;
            }
            var premium = parseInt(unit)*insurancePremium;
            $("#insurancePremium").html(premium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);
            var idNumber = $("#applicantIdNumber").val();
            var dataObjRate = {
                recommendId: $("#recommendId").val(),
                productItemCode: productItemCode,
                idNumber: idNumber
            }
            var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;


            ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                if (data.respCode == '0000') {

                    $("#feeRate").val(data.feeRate);
                    oldRate = $("#feeRate").val();
                    var aObj = document.getElementById("oldRate");
                    aObj.innerText = '(上限' + oldRate + '%)';
                    if(data.comCode=='4417'||data.comCode=='4413'||data.comCode=='4412'){
                        $("#feeRateInput").hide();
                    }
                }
            });
        }
    });
}

function validateNumber(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        if (isNaN(value)) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            if($this.attr('id') == 'unit'){
                selectAccidentItem();
            }
            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function insurePayInfo() {
    var age = 0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var address = $("#address").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    var insureAreaCode = $('#insureAreaCode').val();
    var mortgageNo = $('#mortgageNo').val();
    var loanBankCode = $('#loanBankCode').val();
    var loanUsage = $('#loanUsage').val();
    var preChar1 = $('#preChar1').val();
    var claimBase = $('#claimBase').val();
    var saleArea = $('#saleArea').val();
    var officeType = $('#officeType').val();
    var guaranteeName = $('#guaranteeName').val();
    var unit = $('#unit').val();
    var feeRate = $('#feeRate').val();
    var licenseNo = $("#licenseNo").val();
    var vehicleSeat = $("#vehicleSeat").val();
    var productPlan =  $("#productPlan").val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber)
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        policyPay: '1',
        recommendId: recommendId,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        gender: gender,
        age: age,
        birthDay: birthDay,
        address:address,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
        insureAreaCode: insureAreaCode,
        mortgageNo: mortgageNo,
        loanBankCode: loanBankCode,
        loanUsage: loanUsage,
        preChar1: preChar1,
        claimBase: claimBase,
        saleArea: saleArea,
        officeType: officeType,
        guaranteeName: guaranteeName,
        unit:unit,
        feeRate:feeRate,
        licenseNo :licenseNo,
        vehicleSeat :vehicleSeat
    }
    var errorCount = 0;
    if (!isNotNull(name)) {
        errorCount++;
        alert('填写的*被保人姓名不能为空');
        return;
    }
    if (!validateName("#name")) {
        errorCount++;
        alert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(idNumber)) {
        errorCount++;
        alert('填写的*被保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(mobile)) {
        errorCount++;
        alert('填写的*被保人手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(address)) {
        errorCount++;
        showAlert('填写的*被保人详细地址不能为空');
        return;
    }
    if (!validateNull("#address")) {
        errorCount++;
        showAlert('填写的*被保人详细地址有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantName)) {
        errorCount++;
        alert('填写的*投保人姓名不能为空');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantIdNumber)) {
        errorCount++;
        alert('填写的*投保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if(applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantMobile)) {
        errorCount++;
        alert('填写的*投保人手机号不能为空');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (!checkApplicantInfoAndInsuranInfo()) {
        errorCount++;
        return;
    }
    if(productPlan=="LDO440003v"||productPlan=="LDO440003w"||productPlan=="LDO440003x"||productPlan=="LDO440003y"){
        if (!isNotNull(licenseNo)) {
            errorCount++;
            alert('填写的*车牌号不能为空');
            return;
        }
        if (!validateVehicleNum("#licenseNo")) {
            errorCount++;
            alert('填写的*车牌号有误，请重新修改信息。');
            return;
        }
        if (!isNotNull(vehicleSeat)) {
            errorCount++;
            alert('填写的*核定载人数不能为空');
            return;
        }
        if (!validateNumber("#vehicleSeat")) {
            errorCount++;
            alert('填写的*核定载人数有误，请重新修改信息。');
            return;
        }
    }
    if (isNotNull(feeRate)) {

        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(feeRate);
        if (!result) {
            errorCount++;
            alert('费率格式不正确');
            return;


        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                errorCount++;
                alert('修改费率不能增加');
                return;

            }
        }

    }
    if (!isNotNull(dataObj.feeRate)) {


        errorCount++;
        alert('费率不能为空');
        return;
    }
    if (errorCount == 0) {
        showLoading("正在投保中，请等待！");
        var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
        ajaxRequest(url, dataObj, function successCallback(data) {
            hideLoading();
            if (data.respCode == '0000') {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId;
                // alert("投保成功");
            } else {
                if (isNotNull(data.respMsg)) {
                    alert(data.respMsg);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, function errorCallback(error) {
            hideLoading();
            alert('网络错误，请稍后重试！');
        });
    }

}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

/**
 * 投保人 => 被保人
 */
function applicantInfoToInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {//被保人为本人
        $("#name").val($("#applicantName").val());
        $("#idType").val($("#applicantIdType").val());
        $("#idNumber").val($("#applicantIdNumber").val());
        $("#mobile").val($("#applicantMobile").val());
        $("#gender").val($("#applicantGender").val());
        $("#birthDay").val($("#applicantInfoBirthDay").val());
        $('#insuredBirthDay').html($("#applicantInfoBirthDay").val());
        changeIdType();
        changeGender($("#applicantGender").val());
    }
}

function checkApplicantInfoAndInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            alert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                alert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}
function validateName(element,flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if(flag == '1'){
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateIdCard(element, type,flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                if(flag == '1'){
                    applicantInfoToInsuranInfo();
                }
                return true;
            }
        }  else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                });
                return false;
            }
        }  else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateMobile(element,flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if(flag == '1'){
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateNull(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.info').removeClass('error');
        return true;
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

