/**
 * Created by DixonLim
 */
initInsureSmsInfo();
var riskCode = $('#risk-code').val();
var riskType = riskCode.substring(0,1);
function initInsureSmsInfo() {
    // $('#idType').html(getIdCard($('#idType').html()));
    if((riskType == "W" || riskType == "w") && "1" != $('#renewFlag').val()) {
        $('#pay-qr-code').hide();
    }
}
function validateMobile(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.center-info').addClass('error');
            return false;
        } else {
            $this.parent('.center-info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.center-info').addClass('error');
        return false;
    }
}

function checkCustomerSign(showCount) {
    var $cusSignWapper = $('#customer-sign-wapper');
    $cusSignWapper.show();

    $.ajax('/sfzn/reinsurance/checkCusSign.do?recommendId='+$('#recommendId').val(),{
        contentType: "application/json; charset=utf-8",
        dataType:'json',//服务器返回json格式数据
        type:'post',//HTTP请求类型
        timeout:10000,//超时时间设置为10秒；
        beforeSend: function() {
            $('#pay-qr-code').hide();
            $cusSignWapper.find('.check-status').html('正在查询客户签名状态...');
        },
        success:function(data){
            if(data.respCode == '0000') {
                if(data.signFlag) {
                    $cusSignWapper.find('.check-status').html('客户已经提交电子签名如下，如需客户重新签名可再次点击确认发送按钮再次发送签名链接');
                    $cusSignWapper.find('img').attr('src', data.signUrl);
                    $cusSignWapper.find('img').show();
                    var $dom = $cusSignWapper.find('.button-line');

                    if($dom.length <= 0) {
                        $dom = $('<div class="button-line">\n' +
                            '                        <span class="button-text" >确认签名</span>\n' +
                            '                        </div>');

                        $cusSignWapper.append($dom);
                        $dom.find('.button-text').on('click', function () {
                            $('#pay-qr-code').show();
                        });
                    }

                    window.clearInterval(checkCustomerInterval);
                } else {
                    $cusSignWapper.find('img').hide();
                    if(showCount) {
                        $cusSignWapper.find('.check-status').html('客户暂未提交签名，<span class="time-count">10</span>秒后重试');
                    } else {
                        $cusSignWapper.hide();
                    }
                }
            } else {
                if(showCount) {
                    $cusSignWapper.find('img').hide();
                    $cusSignWapper.find('.check-status').html('查询失败，<span class="time-count">10</span>秒后重试');
                } else {
                    $cusSignWapper.hide();
                }
            }
        },
        error:function(xhr,type,errorThrown){
            if(showCount) {
                $cusSignWapper.find('img').hide();
                $cusSignWapper.find('.check-status').html('查询失败，<span class="time-count">10</span>秒后重试');
            } else {
                $cusSignWapper.hide();
            }
        }
    });
}
var checkCustomerInterval = undefined;
function sendInsureSms(showCount) {
    var recommendId = $("#recommendId").val();
    var mobile = $("#mobile").val();
    var dataObj = {
        recommendId: recommendId,
        mobile: mobile,
        cusSignType: ''
    };
    if(riskType == "W" || riskType == "w") {
        dataObj.cusSignType = $('#cusSignType').val();
    }

    var errorCount = 0;
    if (!isNotNull(mobile)) {
        errorCount++;
        alert('填写的*客户手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*客户手机号有误，请重新修改信息。');
        return;
    }

    if (errorCount == 0) {

        var url = '/sfzn/sms/sendInsureSms.do?recommendId=' + recommendId+'&mobile='+mobile+'&cusSignType='+dataObj.cusSignType;
        ajaxRequest(url, dataObj, function successCallback(data) {

            if (data.respCode == '0000') {
                alert("发送短信成功！");
                var riskCode = $('#risk-code').val();
                if(riskCode == "WBK" || riskCode == "WBK_2") {
                    var $cusSignWapper = $('#customer-sign-wapper');
                    $cusSignWapper.show();
                    $cusSignWapper.find('img').hide();
                    $cusSignWapper.find('.check-status').html('正在查询客户签名状态...');
                    checkCustomerInterval = window.setInterval(function () {
                        checkCustomerSign(true);
                    }, 10000);
                }

            } else {
                if (isNotNull(data.respMsg)) {
                    alert(data.respMsg);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, function errorCallback(error) {
            hideLoading();
            alert('网络错误，请稍后重试！');
        });
    }
}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

function getIdCard(value) {
    var result='本人';
    switch (value) {
        case '01':
            result='身份证';
            break;
        case '02':
            result='户口薄';
            break;
        case '03':
            result='护照';
            break;
        case '04':
            result='军人证件';
            break;
        case '05':
            result='驾驶执照';
            break;
        case '06':
            result='返乡证';
            break;
        case '07':
            result='港澳身份证';
            break;
        case '08':
            result='工号';
            break;
        case '09':
            result='赴台通行证';
            break;
        case '10':
            result='港澳通行证';
            break;
        case '15':
            result='士兵证';
            break;
        case '21':
            result='外国护照';
            break;
        case '22':
            result='旅行证';
            break;
        case '23':
            result='回乡证';
            break;
        case '24':
            result='居留证件';
            break;
        case '25':
            result='港澳居民来往内地通行证';
            break;
        case '26':
            result='台湾居民来往内地通行证';
            break;
        case '29':
            result='其他个人证件';
            break;
        case '31':
            result='组织机构代码证';
            break;
        case '32':
            result='工商登记证';
            break;
        case '33':
            result='税务登记证';
            break;
        case '34':
            result='营业执照';
            break;
        case '37':
            result='统一社会信用代码';
            break;
        case '99':
            result='其他';
            break;
        default:
            result='其他';
            break;
    }
    return result;
}

if(riskType == "W" || riskType == "w") {
    checkCustomerSign(false);
    // 处理消息模板变更
    $('#cusSignType').on('change', function (e) {
        if($(this).val() == '2') {
            $('#sms-content').html($('#smsContentSignSelfhelp').val());
        } else {
            $('#sms-content').html($('#smsContentSignOnly').val());
        }
    });

}


