function isArray(arr) {
    return (Array.isArray ? Array.isArray(arr) : (typeof arr === 'object') && (arr instanceof Array));
}

function validateOrganizeCode(element, type, flag) {
    return true;
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var $infoEl = $this.parent('.info');
        if (checkCodingForTheRepresentationOfOrganization(value)) {
            $infoEl.html($infoEl.attr("txt_backup"));
            $infoEl.removeClass('error');
            return true;
        } else {
            $infoEl.addClass('error');
            layui.use('layer', function () {
                layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
            });
            return false;
        }
    }
    else {
        $this.parent('.info').addClass('error');
        return false;
    }
}



function validateIdCard(element, type, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                var $insuredIdentity = $('#insuredIdentity');
                if (flag == '1' && ($insuredIdentity && $insuredIdentity.length > 0 && $insuredIdentity.val() != '0')) {
                    applicantInfoToInsuranInfo();
                }
                return true;
            }
        } else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if (checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                });
                return false;
            }
        }else if(idType=='37')
        {
            if (validateCard(value)) {
                var dataObj = {
                    applicantIdNumber: $("#applicantIdNumber").val()
                }
                var applicantIdNumber = $("#applicantIdNumber").val();
                var url = '/sfzn/renewal/findCode.do?applicantIdNumber=' + applicantIdNumber;
                ajaxRequest(url, dataObj, function successCallback(data) {
                    hideLoading();

                    if(data==null){
                        alert('该机构无法获取组织机构代码证号需手工补充');
                        $('#organizecode').show();
                    }else{
                        $('#organizecode').show();
                        $("#organizetext").val(data);
                    }


                    $this.parent('.info').removeClass('error');
                    return true;

                }, function errorCallback(error) {
                    $this.parent('.info').addClass('error');
                    return false;
                });

            } else {
                $this.parent('.info').addClass('error');
                return false;
            }

        } else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

function checkApplicantInfoAndInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            alert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                alert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

/**
 * 投保人 => 被保人
 */
function applicantInfoToInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {//被保人为本人
        $("#name").val($("#applicantName").val());
        $("#idType").val($("#applicantIdType").val());
        $("#idNumber").val($("#applicantIdNumber").val());
        $("#mobile").val($("#applicantMobile").val());
        $("#gender").val($("#applicantGender").val());
        $("#birthDay").val($("#applicantInfoBirthDay").val());
        $('#insuredBirthDay').html($("#applicantInfoBirthDay").val());
        changeIdType();
        changeGender($("#applicantGender").val());
    }
}
/**
 * 判断是否续保
 * @param params
 */
function checkRenewal(params) {
    var recommendId = params.recommendId;
    var idnum = params.idnum;
    // 当方案中存在续保方案时，判断选取哪个方案
    var url = '/sfzn/renewal/renewal.do?recommendId=' + recommendId + '&idnum=' + idnum;
    // 调用接口获取是否续保
    var _this = this;
    ajaxRequest(url, {}, function (data) {
        if($.isFunction(params.success)) {
            params.success.call(_this, data);
        }
    }, function (data) {

    });

}