/**
 * Created by DixonLim
 */

$("#birthDay").change(function () {
    getProductItem($("#birthDay").val());
});



$('#amountSelect').change(function () {
    getProductItem();
});


$('#insuredIdentity').change(function () {
    changeInsuredIdentity();
});

$('input[name="applicantIsSocialSe"]').change(function () {
    var $applicantIsSocialSe = $(this);
    var applicantIsSocialSe = $applicantIsSocialSe.val();
    $('#applicantIsSocialSe').val(applicantIsSocialSe);
    getProductItem();
});
$('#idNumber').change(function () {
    if (validateIdCard("#idNumber", '1')) {
        getProductItem();
    }
});
$('input[name="isBeneficiary"]').change(function () {
    var $isBeneficiary = $(this);
    var isBeneficiary = $isBeneficiary.val();
    $('#isBeneficiary').val(isBeneficiary);
    changeIsBeneficiary(isBeneficiary);
});

$('input[name="gender"]').change(function () {
    var $gender = $(this);
    var gender = $gender.val();
    $('#gender').val(gender);
});

$('input[name="applicantGender"]').change(function () {
    var $applicantGender = $(this);
    var applicantGender = $applicantGender.val();
    $('#applicantGender').val(applicantGender);
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }
});





function changeInsuredIdentity() {
    if ($('#insuredIdentity').val() == '0') {
        applicantInfoToInsuranInfo();
    }
}

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    } else {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    }
}

function changeIsBeneficiary(isBeneficiary) {
    if (isBeneficiary == '0') {
        $('.beneficiaryDiv').hide();
    } else {
        $('.beneficiaryDiv').show();
    }
}


initInsuranInfo();

function initInsuranInfo() {
    changeIdType();
    changeApplicantIdType();
    changeInsuredIdentity();
    var $isCarNo = $('input[name="isCarNo"]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    getProductItem();
    changeIsBeneficiary($("#isBeneficiary").val())
}

var renewalFlag = null;


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function insurePayInfo() {
    var age = 0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var applicantIsSocialSe = $('#applicantIsSocialSe').val();
    var area = $('#area').val();
    var address = $('#address').val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber)
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        policyPay: '1',
        recommendId: recommendId,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        gender: gender,
        age: age,
        birthDay: birthDay,
        applicantIsSocialSe: applicantIsSocialSe,
        area: area,
        address: address,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
    }
    var errorCount = 0;
    if (!isNotNull(name)) {
        errorCount++;
        alert('填写的*被保人姓名不能为空');
        return;
    }
    if (!validateName("#name")) {
        errorCount++;
        alert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(idNumber)) {
        errorCount++;
        alert('填写的*被保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(mobile)) {
        errorCount++;
        alert('填写的*被保人手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantName)) {
        errorCount++;
        alert('填写的*投保人姓名不能为空');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantIdNumber)) {
        errorCount++;
        alert('填写的*投保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if (applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantMobile)) {
        errorCount++;
        alert('填写的*投保人手机号不能为空');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (!checkApplicantInfoAndInsuranInfo()) {
        errorCount++;
        return;
    }
    if (!isNotNull(address)) {
        errorCount++;
        alert('填写的*投保人地址不能为空');
        return;
    }
    if (!isNotNull(area)) {
        errorCount++;
        alert('填写的*投保人邮编不能为空');
        return;
    }
    if (!validatePostCode('#area')) {
        errorCount++;
        alert('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
        return;
    }
    var url = '/sfzn/renewal/renewal.do?recommendId=' + $("#recommendId").val();
    var open = "false";
    var isRenewal = false;
    showLoading("正在投保中，请等待！");
    ajaxRequest(url, dataObj, function successCallback(data1) {
        hideLoading();
        isRenewal = data1.insureVo.renewal;
        if (errorCount == 0) {
            if (!isRenewal && (productItemCode == "WBK000005u" || productItemCode == "WBK0000067")) {
                errorCount++;
                alert('被保人年龄超出新保允许范围（人人安康61-65岁只支持续保）');
                return;
            }
            showLoading("正在投保中，请等待！");
            var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
            ajaxRequest(url, dataObj, function successCallback(data) {
                hideLoading();
                if (data.respCode == '0000') {
                    window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId + 'renewFlag=' + isRenewal ? 1 : 0;
                    // alert("投保成功");
                } else {
                    if (isNotNull(data.respMsg)) {
                        alert(data.respMsg);
                    } else {
                        alert('网络错误，请稍后重试！');
                    }
                }
            }, function errorCallback(error) {
                hideLoading();
                alert('网络错误，请稍后重试！');
            });
        }

    });

}



