/**
 * Created by DixonLim
 */
var renewCheckEnabled = false;

$("#applicantInfoBirthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#birthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    yearRange: 'c-100: c'
});
$("#insuranceStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    minDate: 0
});


$('#insuredIdentity').on('change', function () {
    var $this = $(this);
    if ($this.val() == '0') {
        applicantInfoToInsuranInfo();
        $('#application-infoes').addClass('hidden');
        $('#self-insure-infoes').removeClass('hidden');
    } else {
        $('#application-infoes').removeClass('hidden');
        $('#self-insure-infoes').addClass('hidden');
    }
});

$("#insuranceStartDate").change(function () {
    setInsuranEndDate($("#insuranceStartDate").val());
});

$("#applicantInfoBirthDay").change(function () {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }
});

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

$('#idType').change(function () {
    changeIdType();
});
$('#applicantIdType').change(function () {
    changeApplicantIdType();
});



$('input[name="gender"]').change(function () {
    var $gender = $(this);
    var gender = $gender.val();
    $('#gender').val(gender);
});

$('input[name="applicantGender"]').change(function () {
    var $applicantGender = $(this);
    var applicantGender = $applicantGender.val();
    $('#applicantGender').val(applicantGender);
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }
});

function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            $('#applicantInfoBirthDay').val('-');
            $('#birthDay').val('-');
        }

        $('.insuredInfoCard').show();
    }
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }



}

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    } else {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    }
}

function changeGender(value) {
    $('input[name="gender"]').removeAttr('checked');
    $('input[name="gender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}
var oldRate = null;
initInsuranInfo();

function initInsuranInfo() {
    changeIdType();
    changeApplicantIdType();
    var $isCarNo = $('input[name="isCarNo"]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    $('#feeRate').change(function () {
        var feeRate = $("#feeRate").val();
        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(feeRate);
        if (!result) {
            alert("费率格式不正确。");
        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                alert("修改费率不能增加。");
            }
        }
    });
}

getAccidentItem();

function getAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val()
    }

    var url = '/sfzn/reinsurance/getAccidentItems.do?recommendId=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var url = '/sfzn/renewal/renewal.do?recommendId=' + $("#recommendId").val()
            if (renewCheckEnabled) {
                ajaxRequest(url, dataObj, function successCallback(data1) {
                    var isnewal = data1.insureVo.renewal;
                    $("#productPlan").html("");
                    var productItemCode = $("#productItemCode").val();
                    for (var i = 0; i < data.productItems.length; i++) {
                        var productItem = data.productItems[i];
                        if (isNotNull(productItemCode)) {
                            if (isnewal == true) {
                                if (productItem.renewalFlag == "1" || productItem.renewalFlag == "0") {
                                    if (productItem.productCode == productItemCode) {
                                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    } else {
                                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    }
                                }
                            } else {
                                if (productItem.renewalFlag == "0" || productItem.renewalFlag == "2") {


                                    if (productItem.productCode == productItemCode) {
                                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    } else {
                                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    }
                                }
                            }
                        } else {
                            if (isnewal == true) {
                                if (productItem.renewalFlag == "1" || productItem.renewalFlag == "0") {
                                    if (i == 0) {
                                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    } else {
                                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    }
                                }
                            } else {
                                if (productItem.renewalFlag == "0" || productItem.renewalFlag == "2") {
                                    if (i == 0) {
                                        $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    } else {
                                        $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                                    }
                                }
                            }
                        }
                    }

                });
            } else {
                for (var i = 0; i < data.productItems.length; i++) {
                    var productItem = data.productItems[i];
                    if (isNotNull(productItemCode)) {
                        if (productItem.productCode == productItemCode) {
                            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        } else {
                            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        }
                    } else {
                        if (i == 0) {
                            $("#productPlan").append('<option selected="selected" value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        } else {
                            $("#productPlan").append('<option value="' + productItem.productCode + '">' + productItem.productName + '</option>');
                        }
                    }
                }
                $("#productItemCode").val($("#productPlan").val());
                selectAccidentItem();
            }


        }
    });
}

$('#productPlan').change(function () {
    $("#productItemCode").val($("#productPlan").val());
    selectAccidentItem();
})

function selectAccidentItem() {
    var dataObj = {
        recommendId: $("#recommendId").val(),
        productItemCode: $("#productItemCode").val()
    }
    var url = '/sfzn/reinsurance/selectAccidentItem.do?recommendId=' + $("#recommendId").val() + '&productItemCode=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var productItem = data.productItem;
            if (renewCheckEnabled) {
                var productItemCode = null;
                if (data.productItem.renewalFlag == "1") {
                    var url = '/sfzn/renewal/renewal.do?recommendId=' + $("#recommendId").val()
                    ajaxRequest(url, dataObj, function successCallback(data1) {

                            if (data.ageKey != "13") {
                                if (data1.insureVo.lastClaimCount != null && data1.insureVo.lastClaimCount != "0") {
                                    var extArrt = productItem.extArrt;

                                    if (extArrt != null) {
                                        var obj = eval(extArrt);
                                        var len = obj.length;

                                        for (var i = 0; i < len; i++) {
                                            if (obj[i].calimCountHigher == null && obj[i].calimCountLower == null) {
                                                continue;
                                            }
                                            if (obj[i].calimCountHigher == null && obj[i].calimCountLower != null) {
                                                if (obj[i].calimCountLower <= data1.insureVo.lastClaimCount) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                     productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                            if (obj[i].calimCountLower == null && obj[i].calimCountHigher != null) {
                                                if (data1.insureVo.lastClaimCount <= obj[i].calimCountHigher) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                     productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                            if (obj[i].calimCountLower != null && obj[i].calimCountHigher != null) {
                                                if (data1.insureVo.lastClaimCount <= data1.insureVo.lastClaimCount && data1.insureVo.lastClaimCount <= obj[i].calimCountHigher) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                     productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                        }
                                        var idNumber = $("#applicantIdNumber").val();
                                        var dataObjRate = {
                                            recommendId: $("#recommendId").val(),
                                            productItemCode: productItemCode,
                                            idNumber: idNumber
                                        }
                                        var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;


                                        ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                                            if (data.respCode == '0000') {

                                                $("#feeRate").val(data.feeRate);
                                                oldRate = $("#feeRate").val();
                                                var aObj = document.getElementById("oldRate");
                                                aObj.innerText = '(上限' + oldRate + '%)';
                                                if(data.comCode=='4417'||data.comCode=='4413'||data.comCode=='4412'){
                                                    $("#feeRateInput").hide();
                                                }
                                            }
                                        });
                                    }

                                } else {
                                    var insurancePremium = parseFloat(data.productItem.insurancePremium);
                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                     productItemCode = data.productItem.productCode;
                                    $("#productItemCode").val(productItemCode);
                                    var idNumber = $("#applicantIdNumber").val();
                                    var dataObjRate = {
                                        recommendId: $("#recommendId").val(),
                                        productItemCode: productItemCode,
                                        idNumber: idNumber
                                    }
                                    var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;


                                    ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                                        if (data.respCode == '0000') {

                                            $("#feeRate").val(data.feeRate);
                                            oldRate = $("#feeRate").val();
                                            var aObj = document.getElementById("oldRate");
                                            aObj.innerText = '(上限' + oldRate + '%)';
                                            if(data.comCode=='4417'||data.comCode=='4413'||data.comCode=='4412'){
                                                $("#feeRateInput").hide();
                                            }
                                        }
                                    });

                                }
                            } else {
                                var insurancePremium = parseFloat(data.productItem.insurancePremium);
                                $("#insurancePremium").html(insurancePremium.toFixed(2));
                                 productItemCode = data.productItem.productCode;
                                $("#productItemCode").val(productItemCode);
                                var idNumber = $("#applicantIdNumber").val();
                                var dataObjRate = {
                                    recommendId: $("#recommendId").val(),
                                    productItemCode: productItemCode,
                                    idNumber: idNumber
                                }
                                var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;


                                ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                                    if (data.respCode == '0000') {

                                        $("#feeRate").val(data.feeRate);
                                        oldRate = $("#feeRate").val();
                                        var aObj = document.getElementById("oldRate");
                                        aObj.innerText = '(上限' + oldRate + '%)';
                                        if(data.comCode=='4417'||data.comCode=='4413'||data.comCode=='4412'){
                                            $("#feeRateInput").hide();
                                        }
                                    }
                                });
                            }
                        }
                    );
                }
            } else {
                var insurancePremium = parseFloat(data.productItem.insurancePremium);
                $("#insurancePremium").html(insurancePremium.toFixed(2));
                 productItemCode = data.productItem.productCode;
                $("#productItemCode").val(productItemCode);
                var idNumber = $("#applicantIdNumber").val();
                var dataObjRate = {
                    recommendId: $("#recommendId").val(),
                    productItemCode: productItemCode,
                    idNumber: idNumber
                }
                var urlRate = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + $("#recommendId").val() + '&productItemCode=' + productItemCode + '&idNumber=' + idNumber;


                ajaxRequest(urlRate, dataObjRate, function successCallback(data) {
                    if (data.respCode == '0000') {

                        $("#feeRate").val(data.feeRate);
                        oldRate = $("#feeRate").val();
                        var aObj = document.getElementById("oldRate");
                        aObj.innerText = '(上限' + oldRate + '%)';
                        if(data.comCode=='4417'||data.comCode=='4413'||data.comCode=='4412'){
                            $("#feeRateInput").hide();
                        }
                    }
                });
            }
        }
    });
}

function insurePayInfo() {
    var age = 0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    var feeRate = $('#feeRate').val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber)
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }

    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    if(applicantIdType== '37'){
        $("#applicantIdType").val('31');
        applicantIdType = '31';
        $("#applicantIdNumber").val($("#organizetext").val());
        applicantIdNumber = $("#organizetext").val();

    }
    if (insuredIdentity == '0') {//如果是本人,人人安康做被保人赋值给投保人的处理
        applicantName = name;
        applicantIdType = idType;
        applicantIdNumber = idNumber;
        applicantGender = gender;
        applicantAge = age;
        applicantInfoBirthDay = birthDay;
        applicantMobile = mobile;
        $("#applicantName").val(name);
        $("#applicantIdType").val(idType);
        $("#applicantIdNumber").val(idNumber);
        $("#applicantGender").val(gender);
        $("#applicantAge").val(age);
        $("#applicantInfoBirthDay").val(birthDay);
        $("#applicantMobile").val(mobile);
    }
    var dataObj = {
        policyPay: '1',
        recommendId: recommendId,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        gender: gender,
        age: age,
        birthDay: birthDay,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
        feeRate: feeRate
    }
    var errorCount = 0;
    if (!isNotNull(name)) {
        errorCount++;
        alert('填写的*被保人姓名不能为空');
        return;
    }
    if (!validateName("#name")) {
        errorCount++;
        alert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(idNumber)) {
        errorCount++;
        alert('填写的*被保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(mobile)) {
        errorCount++;
        alert('填写的*被保人手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantName)) {
        errorCount++;
        alert('填写的*投保人姓名不能为空');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantIdNumber)) {
        errorCount++;
        alert('填写的*投保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if (applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantMobile)) {
        errorCount++;
        alert('填写的*投保人手机号不能为空');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (!checkApplicantInfoAndInsuranInfo()) {
        errorCount++;
        return;
    }
    if (isNotNull(feeRate)) {

        var patt1 = new RegExp(/[0-9]*/);

        var result = patt1.test(feeRate);
        if (!result) {
            errorCount++;
            alert('费率格式不正确');
            return;


        } else {
            var feeNum = feeRate;
            var oldRateNum = oldRate;
            if (parseInt(feeNum) > parseInt(oldRateNum)) {
                errorCount++;
                alert('修改费率不能增加');
                return;

            }
        }

    }
    if (!isNotNull(dataObj.feeRate)) {


        errorCount++;
        alert('费率不能为空');
        return;
    }
    if (errorCount == 0) {
        showLoading("正在投保中，请等待！");
        var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
        ajaxRequest(url, dataObj, function successCallback(data) {
            hideLoading();
            if (data.respCode == '0000') {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId;
                // alert("投保成功");
            } else {
                if (isNotNull(data.respMsg)) {
                    alert(data.respMsg);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, function errorCallback(error) {
            hideLoading();
            alert('网络错误，请稍后重试！');
        });
    }

}




function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}


function validateName(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if (flag == '1') {
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}







function validateMobile(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if (flag == '1') {
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

