/**
 * Created by DixonLim
 */

function validateName(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validatePostCode(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkPostCode(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateIdCard(element, type, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                return true;
            }
        }  else if (idType == '31') {
            var $infoEl = $this.parent('.info');
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $infoEl.html($infoEl.attr("txt_backup"));
                $infoEl.removeClass('error');
                return true;
            } else {
                // $infoEl.attr("txt_backup", $infoEl.html());
                // $infoEl.html("请输入正确的组织结构代码证号, 例如客户\"英德市石灰铺镇人民政府\"，统一社会信用代码是\"11441881007312939J\"，组织机构代码是\"00731293-9\"");
                $infoEl.addClass('error');
                layui.use('layer', function () {
                    // layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
                    layer.tips('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"', $this,{
                        tips: 1,
                        time: 0
                    });
                });

                return false;
            }
        }  else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateMobile(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

var renewCheckEnabled = true;

function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            $('#birthDay').val(Date.today().add(-1).toString("yyyy-MM-dd"));
        }

        $('.insuredInfoCard').show();
    }
    if ($('#idType6').val() == '01') {
        $('.insuredInfoCard0').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            $('#birthDay6').val(Date.today().add(-1).toString("yyyy-MM-dd"));
        }

        $('.insuredInfoCard0').show();
    }
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
}

function changeIsCarNo(isCarNo) {
    if (isCarNo == '0') {
        $('.licenseNoInfo').show();
        $('.engineNoInfo').hide();
    } else {
        $('.licenseNoInfo').hide();
        $('.engineNoInfo').show();
    }
}

function changeIsBeneficiary(isBeneficiary) {
    if (isBeneficiary == '0') {
        $('.beneficiaryDiv').hide();
    } else {
        $('.beneficiaryDiv').show();
    }
}

function changeGender(value) {
    $('input[name="gender"]').removeAttr('checked');
    $('input[name="gender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}

function changeApplicantGender(value) {
    $('input[name="applicantGender"]').removeAttr('checked');
    $('input[name="applicantGender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}

function initInsuranInfo() {
    $('#amountSelect').change(function () {
        getProductItem();
    });
    $('#idType').change(function () {
        changeIdType();
        insuranInfoToApplicantInfo();
    });
    $('#idType6').change(function () {
        changeIdType();
        insuranInfoToApplicantInfo();
    });
    $('#name').change(function () {
        validateName(this);
        insuranInfoToApplicantInfo();
    });
    $('#mobile').change(function () {
        validateMobile(this);
        insuranInfoToApplicantInfo();
    });
    $('input[name="applicantIsSocialSe"]').change(function () {
        var $applicantIsSocialSe = $(this);
        var applicantIsSocialSe = $applicantIsSocialSe.val();
        $('#applicantIsSocialSe').val(applicantIsSocialSe);
        getProductItem();
    });
    $('input[name="applicantIsSocialSe6"]').change(function () {
        var $applicantIsSocialSe6 = $(this);
        var applicantIsSocialSe6 = $applicantIsSocialSe6.val();
        $('#applicantIsSocialSe6').val(applicantIsSocialSe6);
        getProductItem();
    });
    $('#idNumber').change(function () {
        if (validateIdCard("#idNumber", '1')) {
            getProductItem();
        }
        insuranInfoToApplicantInfo();
    });
    $('#idNumber6').change(function () {
        if (validateIdCard("#idNumber6", '1')) {
            getProductItem();
        }
        insuranInfoToApplicantInfo();
    });
    $('input[name="isBeneficiary"]').change(function () {
        var $isBeneficiary = $(this);
        var isBeneficiary = $isBeneficiary.val();
        $('#isBeneficiary').val(isBeneficiary);
        changeIsBeneficiary(isBeneficiary);
    });

    $('input[name="gender"]').change(function () {
        var $gender = $(this);
        var gender = $gender.val();
        $('#gender').val(gender);
        insuranInfoToApplicantInfo();
    });
    $('input[name="gender6"]').change(function () {
        var $gender = $(this);
        var gender = $gender.val();
        $('#gender6').val(gender);
        insuranInfoToApplicantInfo();
    });

    $('input[name="applicantGender"]').change(function () {
        var $applicantGender = $(this);
        var applicantGender = $applicantGender.val();
        $('#applicantGender').val(applicantGender);
    });
    $('#insuredIdentity').on('change', function () {
        var $this = $(this);
        if ($this.val() == '0') {
            insuranInfoToApplicantInfo();
            $('#application-infoes').addClass('hidden');
            $('#self-insure-infoes').removeClass('hidden');
        } else {
            $('#application-infoes').removeClass('hidden');
            $('#self-insure-infoes').addClass('hidden');
        }
    });
    $('#insuredIdentity6').on('change', function () {
        var $this = $(this);
        if ($this.val() == '0') {
            insuranInfoToApplicantInfo();

        }
    });

    // 投保人录入项相关事件绑定
    $('#applicantName').on('change', function () {
        var $p = $(this).parents('.info-line');
        if(!$p.hasClass('hidden')) {
            validateName(this,'1');
        }
    });
    // 投保人证件类型转变
    $('#applicantIdType').change(function () {
        changeApplicantIdType();
    });

    layui.use('laydate', function(){
        var laydate = layui.laydate;

        // 被保险人生日
        laydate.render({
            elem: '#birthDay' //指定元素
            , done: function(value, date, endDate){
                // console.log(value); //得到日期生成的值，如：2017-08-18
                // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                getProductItem(value);
                insuranInfoToApplicantInfo();
            }
        });
        // 第二被被保险人生日
        laydate.render({
            elem: '#birthDay6' //指定元素
            , done: function(value, date, endDate){
                // console.log(value); //得到日期生成的值，如：2017-08-18
                // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                getProductItem(value);
                insuranInfoToApplicantInfo();
            }
        });
        // 投保人生日
        laydate.render({
            elem: '#applicantInfoBirthDay' //指定元素
            , done: function(value, date, endDate){
                // console.log(value); //得到日期生成的值，如：2017-08-18
                // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                // getProductItem(value);
                // insuranInfoToApplicantInfo();
            }
        });
        // 起保日期选择
        laydate.render({
            elem: '#insuranceStartDate' //指定元素
            , min: 1
            , done: function(value, date, endDate) {
                setInsuranEndDate(value);
            }
        });
    });

    changeIdType();
    // changeApplicantIdType();
    $('#insuredIdentity').change();
    $('#insuredIdentity6').change();
    var $isCarNo = $('input[name="isCarNo"]');
    changeIsCarNo($isCarNo.val());
    setInsuranEndDate($("#insuranceStartDate").val());
    getProductItem();
    changeIsBeneficiary($("#isBeneficiary").val())
}

var renewalFlag = null;

function getProductItem(birthDay) {

    var a = i;

    var age6 = 0;
    var applicantIsSocialSe6 = $("#applicantIsSocialSe6").val();
    var idNumber6 = $("#idNumber6").val();
    var idType6 = $("#idType6").val();
    if (idType6 == '01') {
        age6 = getAgeBybirthDay(getbirthDayByIdNum(idNumber6));
    } else {
        if (birthDay == undefined) {
            birthDay = $('#birthDay6').val();
        }
        age6 = getAgeBybirthDay(birthDay);
    }

    if(age6!="0"&&applicantIsSocialSe6!="") {
        var age = 0;
        var applicantIsSocialSe = $("#applicantIsSocialSe").val();
        var idNumber = $("#idNumber").val();
        var idType = $("#idType").val();


        var amountSelect = $("#amountSelect").val();
        var idNumbers = {};
        var idTypes = {};
        var applicantIsSocialSes = {};
        var ages = {};
        var birthDays = {};
        var birthDay6;
        if (idType == '01') {
            age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        } else {
            if (birthDay6 == undefined) {
                birthDay6 = $('#birthDay').val();
            }
            age = getAgeBybirthDay(birthDay6);
        }

        var dataObj = {
            a: a,
            applicantIsSocialSe: applicantIsSocialSe,
            age: age,
            applicantIsSocialSe6: applicantIsSocialSe6,
            age6: age6,
            amountSelect: amountSelect,
            recommendId: $("#recommendId").val()
        }


        for (var n = 1; n <= a; n++) {
            idTypes['idType' + n] = cards['card' + n];
            idNumbers['idNumber' + n] = $("#idNumber" + n + "").val();
            applicantIsSocialSes['applicantIsSocialSe' + n] = singles['single' + n];

            if (idTypes['idType' + n] == null || idTypes['idType' + n] == '01') {
                ages['age' + n] = getAgeBybirthDay(getbirthDayByIdNum(idNumbers['idNumber' + n]))
            }
            else {
                birthDays['birthDay' + n] = dates['date' + n];
                ages['age' + n] = getAgeBybirthDay(birthDays['birthDay' + n]);
            }
            dataObj['applicantIsSocialSe' + n] = applicantIsSocialSes['applicantIsSocialSe' + n];
            dataObj['age' + n] = ages['age' + n];


        }
        var url = "/sfzn/reinsurance/getProductItem.do?recommendId=" + $("#recommendId").val();
        ajaxRequest(url, dataObj, function successCallback(data) {
            if (data.respCode == '0000') {

                var productItem = data.productItem[0];
                var insurancePremium = parseFloat(productItem.insurancePremium);
                $("#insurancePremium").html(insurancePremium.toFixed(2));
                var productItemCode = productItem.productCode;
                $("#productItemCode").val(productItemCode);

            } else {
                hideLoading();
            }
        })
        ;
    }
}


function insurePayInfo() {
    var a = i;
    var age = 0;
    var age6 =0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var applicantIsSocialSe = $('#applicantIsSocialSe').val();
    var area = $('#area').val();
    var address = $('#address').val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    var names = {};
    var idNumbers = {};
    var insuredIdentitys = {};
    var idTypes = {};
    var applicantIsSocialSes = {};
    var ages = {};
    var birthDays = {};
    var genders = {};
    var mobiles = {};
    var areas = {};
    var name6 = $("#name6").val();
    var mobile6 = $("#mobile6").val();
    var insuredIdentity6 = $("#insuredIdentity6").val();
    var idNumber6 = $("#idNumber6").val();
    var idType6 = $("#idType6").val();
    var applicantIsSocialSe6 = $("#applicantIsSocialSe6").val();
    var gender6 = $("#gender6").val();
    var birthDay6 = $("#birthDay6").val();
    var amountSelect = $("#amountSelect").val();
    if (idType6 == '01') {
        age6 = getAgeBybirthDay(getbirthDayByIdNum(idNumber6));
        birthDay6 = getbirthDayByIdNum(idNumber6);
        gender6 = getSexByIdNum(idNumber6);
    } else {
        birthDay6 = $('#birthDay6').val();
        age6 = getAgeBybirthDay(birthDay6);

    }
    if (a != 0) {

        for (var n = 1; n <= a; n++) {
            names['name' + n] = $("#name" + n + "").val();
            mobiles['mobile' + n] = $("#mobile" + n + "").val();
            idNumbers['idNumber' + n] = $("#idNumber" + n + "").val();
            insuredIdentitys['insuredIdentity' + n] = dataValues["dataValue" + n];
            idTypes['idType' + n] = cards['card' + n];
            applicantIsSocialSes['applicantIsSocialSe' + n] = singles['single' + n];
            areas['area' + n] = $("#area" + n + "").val();
            // idTypes['idType' + n]=  cards["card"+n];
            if (idTypes['idType' + n] == null || idTypes['idType' + n] == '01') {


                ages['age' + n] = getAgeBybirthDay(getbirthDayByIdNum(idNumbers['idNumber' + n]))
                birthDays['birthDay' + n] = getbirthDayByIdNum(idNumbers['idNumber' + n]);
                genders['gender' + n] = getSexByIdNum(idNumbers['idNumber' + n]);


            } else {
                birthDays['birthDay' + n] = dates['date' + n];
                ages['age' + n] = getAgeBybirthDay(birthDays['birthDay' + n]);
                genders['gender' + n] = sexs['sex' + n];
            }
        }
    }
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber)
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        p: a,
        policyPay: '1',
        recommendId: recommendId,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        gender: gender,
        age: age,
        birthDay: birthDay,
        applicantIsSocialSe: applicantIsSocialSe,
        area: area,
        address: address,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode,
        amountSelect:amountSelect,
        name6: name6,
        mobile6: mobile6,
        insuredIdentity6: insuredIdentity6,
        idNumber6: idNumber6,
        idType6: idType6,
        applicantIsSocialSe6: applicantIsSocialSe6,
        gender6: gender6,
        birthDay6: birthDay6,
        age6: age6
    }

if (a != 0) {
    for (var n = 1; n <= a; n++) {
        dataObj["name" + n] = names['name' + n];
        dataObj["idNumber" + n] = idNumbers['idNumber' + n];
        dataObj["insuredIdentity" + n] = insuredIdentitys['insuredIdentity' + n];
        dataObj['idType' + n] = idTypes['idType' + n];
        dataObj['applicantIsSocialSe' + n] = applicantIsSocialSes['applicantIsSocialSe' + n];
        dataObj['age' + n] = ages['age' + n];
        dataObj['birthDay' + n] = birthDays['birthDay' + n];
        dataObj['gender' + n] = genders['gender' + n];
        dataObj['mobile' + n] = mobiles['mobile' + n];
        dataObj['area' + n] = areas['area' + n];

    }
}
    var errorCount = 0;
    if (!isNotNull(name)) {
        errorCount++;
        alert('填写的*被保人姓名不能为空');
        return;
    }
    if (!validateName("#name")) {
        errorCount++;
        alert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(name6)) {
        errorCount++;
        showAlert('填写的*被保人姓名不能为空');
        return;
    }
    if (!validateName("#name6")) {
        errorCount++;
        showAlert('填写的*被保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(idNumber)) {
        errorCount++;
        alert('填写的*被保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!validateIdCard("#idNumber6", '1')) {
        errorCount++;
        alert('填写的*被保人证件号码有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(mobile)) {
        errorCount++;
        alert('填写的*被保人手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(mobile6)) {
        errorCount++;
        alert('填写的*被保人手机号不能为空');
        return;
    }
    if (!validateMobile("#mobile6")) {
        errorCount++;
        alert('填写的*被保人手机号有误，请重新修改信息。');
        return;
    }
    if (a != 0) {
        for (var m = 1; m <= a; m++) {
            if (!isNotNull(names['name' + m])) {
                errorCount++;
                showAlert('填写的*被保人姓名不能为空');
                return;
            }
            if (!validateName("#name"+m)) {
                errorCount++;
                alert('填写的*被保人姓名有误，请重新修改信息。');
                return;
            }

            if (!isNotNull(idNumbers['idNumber' + m])) {
                errorCount++;
                showAlert('填写的*被保人证件号码不能为空');
                return;
            }
            if (!validateIdCard("#idNumber"+m, '1')) {
                errorCount++;
                alert('填写的*被保人证件号码有误，请重新修改信息。');
                return;
            }
            if (!isNotNull(mobiles['mobile'+m])) {
                errorCount++;
                alert('填写的*被保人手机号不能为空');
                return;
            }
            if (!validateMobile("#mobile"+m)) {
                errorCount++;
                alert('填写的*被保人手机号有误，请重新修改信息。');
                return;
            }
            if (!isNotNull(areas['area'+m])) {
                errorCount++;
                alert('填写的*投保人邮编不能为空');
                return;
            }
            if (!validatePostCode('#area'+m)) {
                errorCount++;
                alert('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
                return;
            }
            if (!isNotNull(applicantIsSocialSes['applicantIsSocialSe'+m])) {
                errorCount++;
                alert('请选选择被保人的社保类型');
                return;
            }




        }
    }
    if (!isNotNull(applicantName)) {
        errorCount++;
        alert('填写的*投保人姓名不能为空');
        return;
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        alert('填写的*投保人姓名有误，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantIdNumber)) {
        errorCount++;
        alert('填写的*投保人证件号码不能为空');
        return;
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        alert('填写的*投保人证件号码有误，请重新修改信息。');
        return;
    }
    if (applicantAge < 18) {
        errorCount++;
        alert('投保人未满18周岁，请重新修改信息。');
        return;
    }
    if (!isNotNull(applicantMobile)) {
        errorCount++;
        alert('填写的*投保人手机号不能为空');
        return;
    }
    if (!validateMobile("#applicantMobile")) {
        errorCount++;
        alert('填写的*投保人手机号有误，请重新修改信息。');
        return;
    }
    if (!checkApplicantInfoAndInsuranInfo()) {
        errorCount++;
        return;
    }
    if (!isNotNull(address)) {
        errorCount++;
        alert('填写的*投保人地址不能为空');
        return;
    }
    if (!isNotNull(area)) {
        errorCount++;
        alert('填写的*投保人邮编不能为空');
        return;
    }
    if (!validatePostCode('#area')) {
        errorCount++;
        alert('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
        return;
    }
    if (!isNotNull(area6)) {
        errorCount++;
        alert('填写的*投保人邮编不能为空');
        return;
    }
    if (!validatePostCode('#area6')) {
        errorCount++;
        alert('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
        return;
    }
    var url = '/sfzn/renewal/renewal.do?recommendId=' + $("#recommendId").val();
    var open = "false";
    var isRenewal = false;
    showLoading("正在投保中，请等待！");
    if(renewCheckEnabled) {


        showLoading("正在投保中，请等待！");
        var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + recommendId;
        ajaxRequest(url, dataObj, function successCallback(data) {
            hideLoading();
            if (data.respCode == '0000') {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId + ('&renewFlag=' + (isRenewal ? 1 : 0));
                // alert("投保成功");
            } else {
                if (isNotNull(data.respMsg)) {
                    alert(data.respMsg);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, function errorCallback(error) {
            hideLoading();
            alert('网络错误，请稍后重试！');
        });


    }
}

function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

/**
 * 投保人 => 被保人
 */
// function applicantInfoToInsuranInfo() {
//     var insuredIdentity = $('#insuredIdentity').val();
//     if (insuredIdentity == '0') {//被保人为本人
//         // $("#name").val($("#applicantName").val());
//         // $("#idType").val($("#applicantIdType").val());
//         // $("#idNumber").val($("#applicantIdNumber").val());
//         // $("#mobile").val($("#applicantMobile").val());
//         // $("#gender").val($("#applicantGender").val());
//         // $("#birthDay").val($("#applicantInfoBirthDay").val());
//         // $('#insuredBirthDay').html($("#applicantInfoBirthDay").val());
//
//         $("#applicantName").val($("#name").val()).trigger('change');
//         $("#applicantIdType").val($("#idType").val()).trigger('change');
//         $("#applicantIdNumber").val($("#idNumber").val()).trigger('change');
//         $("#applicantMobile").val($("#mobile").val()).trigger('change');
//         $("#applicantGender").val($("#gender").val()).trigger('change');
//         $("#applicantInfoBirthDay").val($("#birthDay").val()).trigger('change');
//         // $('#applicantInfoBirthDay').html($("#birthDay").val());
//         changeIdType();
//         changeGender($("#gender").val());
//     }
// }

/**
 * 被保人 => 投保人
 */
function insuranInfoToApplicantInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {//被保人为本人
        $("#applicantName").val($("#name").val()).trigger('change');
        $("#applicantIdType").val($("#idType").val()).trigger('change');
        $("#applicantIdNumber").val($("#idNumber").val()).trigger('change');
        $("#applicantMobile").val($("#mobile").val()).trigger('change');
        $("#applicantGender").val($("#gender").val()).trigger('change');
        $("#applicantInfoBirthDay").val($("#birthDay").val()).trigger('change');
        // $('#applicantInfoBirthDay').html($("#birthDay").val());
        changeApplicantGender($("#gender").val());

    }
}

function checkApplicantInfoAndInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            alert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                alert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            if (typeof successCallback == 'function') {
                successCallback(JSON.parse(data));
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}
$(function(){
    var checkLayuiInterval = window.setInterval(function () {
        if(typeof layui != 'undefined' && layui != null) {
            window.clearInterval(checkLayuiInterval);
            initInsuranInfo();
        }
    }, 10);

// $("#birthDay").datepicker({
//     changeMonth: true,
//     changeYear: true,
//     dateFormat: 'yy-mm-dd',
//     yearRange: 'c-100, c'
// });


});







var i = 0;
var dataValues = {};
var cards = {};
var singles = {};
var dates = {};
var sexs = {};

function add() {

    i = i + 1;
    if (i > 5) {
        showAlert('被保险人数量最多为7');
        return;
    }

    $('#first1').append(' <div id = "add' + i + '">\n' +
        '        <div class="base-title"  >\n' +
        '            家庭成员 <input type=\'button\'  class=\'delete\' value=\'删除\' onclick = "deleteDiv(this)"/>\n' +
        '            <div class="infotwo">\n' +
        '\n' +
        '                <span class="lable-text">与投保人的关系:</span>\n' +
        '                <select class="select-text" name="insuredIdentity' + i + '" id="insuredIdentity' + i + '">\n' +
        // '                    <option value="99" ></option>\n' +
        '                    <option value="1" >配偶</option>\n' +
        '                    <option value="2" >父母</option>\n' +
        '                    <option value="3" >子女</option>\n' +
        '                    <option value="4">兄弟姐妹\n' +
        '                    </option>\n' +
        '                    <option value="5" >(外)祖父母\n' +
        '                    </option>\n' +
        '                    <option value="6" >雇佣</option>\n' +
        '                    <option value="7" >其他</option>\n' +
        '                </select>\n' +
        '            </div>\n' +
        '<div class="info ">\n' +
        '                <span class="lable-text">有无社保:</span>\n' +
        '                <span class="radio-text">\n' +

        '                            <input type="radio" name="applicantIsSocialSe' + i + '"  value="0"\n' +
        '                                  />无\n' +
        '                        <input type="radio" name="applicantIsSocialSe' + i + '" value="1"\n' +
        '                               />有\n' +
        ' <input type="hidden" id="applicantIsSocialSe' + i + '"\n' +
        '                           value="${insuredInfo.applicantIsSocialSe' + i + ' !"0"}"/>'+
        '                </span>\n' +
        '            </div>\n'+
        '        </div>\n' +
        '        <div class="base-info">\n' +
        '            <div class="info-line">\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">被保人姓名:</span>\n' +
        '                    <input type="text" class="input-text" name="name" id="name' + i + '" value=""/>\n' +
        '                </div>\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">证件类型:</span>\n' +
        '                    <select class="card" name="idType" id="idType">\n' +
        // '                        <option value="100" ></option>\n'+
        '                        <option value="01" >身份证</option>\n' +
        '                        <option value="02" >户口薄</option>\n' +
        '                        <option value="03" >护照</option>\n' +
        '                        <option value="04" >军人证件</option>\n' +
        '                    <#--<option value="05">驾驶执照</option>-->\n' +
        '                    <#--<option value="06" >返乡证</option>-->\n' +
        '                        <option value="07" >港澳身份证</option>\n' +
        '                    <#--<option value="08" >工号</option>-->\n' +
        '                    <#--<option value="09" >赴台通行证</option>-->\n' +
        '                    <#--<option value="10" >港澳通行证</option>-->\n' +
        '                    <#--<option value="15" >士兵证</option>-->\n' +
        '                    <#--<option value="21" >外国护照</option>-->\n' +
        '                    <#--<option value="22" >旅行证</option>-->\n' +
        '                    <#--<option value="23" >回乡证</option>-->\n' +
        '                    <#--<option value="24" >居留证件</option>-->\n' +
        '                        <option value="25" >港澳居民来往内地通行证\n' +
        '                        </option>\n' +
        '                        <option value="26">台湾居民来往内地通行证\n' +
        '                        </option>\n' +
        '                    <#--<option value="29" >其他个人证件</option>-->\n' +
        '                        <option value="31" >组织机构代码证</option>\n' +
        '                    <#--<option value="32" >工商登记证</option>-->\n' +
        '                    <#--<option value="33" >税务登记证</option>-->\n' +
        '                    <#--<option value="34" >营业执照</option>-->\n' +
        '                        <option value="99" >其他</option>\n' +
        '                    <#--<option value="37" >统一社会信用代码</option>-->\n' +
        '                    </select>\n' +
        '                </div>\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">证件号码:</span>\n' +
        '                    <input type="text" class="input-text" name="idNumber" id="idNumber' + i + '"\n' +
        '                           value="" />\n' +
        '                </div>\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">被保人手机:</span>\n' +
        '                    <input type="text" class="input-text" name="mobile" id="mobile' + i + '" value="" />\n' +
        '                </div>\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">被保人地址:</span>\n' +
        '                    <input type="text" class="input-text" name="address" id="address' + i + '" value="-"/>\n' +
        '                </div>\n' +
        '                <div class="info">\n' +
        '                    <span class="lable-text">被保人邮编:</span>\n' +
        '                    <input type="text" class="input-text" name="area" id="area' + i + '" value=""/>\n' +
        '                </div>\n' +
        '                <div class="info cardbirth" style="display:none;">\n' +
        '                    <span class="lable-text">被保人性别:</span>\n' +
        '                    <span class="radio-text">\n' +
        '                        <input type="radio" name="gender' + i + '" value="1"\n' +
        '                              />男\n' +
        '                        <input type="radio" name="gender' + i + '" value="2"\n' +
        '                              />女\n' +
        '                        <input type="hidden" id="gender' + i + '" value=""}"/>\n' +
        '                    </span>\n' +
        '                </div>\n' +
        '                <div class="info cardbirth" style="display:none;">\n' +
        '                    <span class="lable-text">出生日期:</span>\n' +
        '                    <input type="text" class="input-text" readonly="readonly" name="birthDay" id="birthDay' + i + '"\n' +
        '                           value=""/>\n' +
        '                </div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '        </div>');


+


    $('#add' + i + ' .card').change(function () {
        var $card = $(this);
        var card = $card.val();
        if ($('#add' + i + ' .card').val() == '01') {
            $('#add' + i + '  .cardbirth').hide();
        } else {
            $('#add' + i + '  .cardbirth').show();
        }
        cards["card" + i] = card;

    });

    $('#birthDay' + i + ' ').bind("click", function () {
        layui.use('laydate', function(){
            var laydate = layui.laydate;

            // 被保险人生日
            laydate.render({
                elem: '#birthDay' + i + '' //指定元素
                , done: function(value, date, endDate){
                    // console.log(value); //得到日期生成的值，如：2017-08-18
                    // console.log(date); //得到日期时间对象：{year: 2017, month: 8, date: 18, hours: 0, minutes: 0, seconds: 0}
                    // console.log(endDate); //得结束的日期时间对象，开启范围选择（range: true）才会返回。对象成员同上。
                    dates["date" + i] = value;
                    getProductItem(value);

                    insuranInfoToApplicantInfo();
                }
            });



        });

    });

    $('input[name="applicantIsSocialSe'+i+'"]').change(function () {
        var $applicantIsSocialSe6 = $(this);
        var applicantIsSocialSe6 = $applicantIsSocialSe6.val();
        singles["single" + i] = applicantIsSocialSe6;
        getProductItem();
    });

    $('input[name="gender'+i+'"]').change(function () {
        var $gender = $(this);
        var gender = $gender.val();
        sexs["sex" + i] = gender;
        insuranInfoToApplicantInfo();
    });



    $('#insuredIdentity' + i + '').change(function () {
        var $value = $(this);
        var value = $value.val();
        dataValues["dataValue" + i] = value;
        getProductItem();
    });

    function getProductItem(birthDay) {

        var a = i;

        var age6 = 0;
        var applicantIsSocialSe6 = $("#applicantIsSocialSe6").val();
        var idNumber6 = $("#idNumber6").val();
        var idType6 = $("#idType6").val();
        if (idType6 == '01') {
            age6 = getAgeBybirthDay(getbirthDayByIdNum(idNumber6));
        } else {
            if (birthDay == undefined) {
                birthDay = $('#birthDay6').val();
            }
            age6 = getAgeBybirthDay(birthDay);
        }

        if(age6!="0"&&applicantIsSocialSe6!="") {
            var age = 0;
            var applicantIsSocialSe = $("#applicantIsSocialSe").val();
            var idNumber = $("#idNumber").val();
            var idType = $("#idType").val();


            var amountSelect = $("#amountSelect").val();
            var idNumbers = {};
            var idTypes = {};
            var applicantIsSocialSes = {};
            var ages = {};
            var birthDays = {};
            var birthDay6;
            if (idType == '01') {
                age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
            } else {
                if (birthDay6 == undefined) {
                    birthDay6 = $('#birthDay').val();
                }
                age = getAgeBybirthDay(birthDay6);
            }

            var dataObj = {
                a: a,
                applicantIsSocialSe: applicantIsSocialSe,
                age: age,
                applicantIsSocialSe6: applicantIsSocialSe6,
                age6: age6,
                amountSelect: amountSelect,
                recommendId: $("#recommendId").val()
            }


            for (var n = 1; n <= a; n++) {
                idTypes['idType' + n] = cards['card' + n];
                idNumbers['idNumber' + n] = $("#idNumber" + n + "").val();
                applicantIsSocialSes['applicantIsSocialSe' + n] = singles['single' + n];

                if (idTypes['idType' + n] == null || idTypes['idType' + n] == '01') {
                    ages['age' + n] = getAgeBybirthDay(getbirthDayByIdNum(idNumbers['idNumber' + n]))
                }
                else {
                    birthDays['birthDay' + n] = dates['date' + n];
                    ages['age' + n] = getAgeBybirthDay(birthDays['birthDay' + n]);
                }
                dataObj['applicantIsSocialSe' + n] = applicantIsSocialSes['applicantIsSocialSe' + n];
                dataObj['age' + n] = ages['age' + n];


            }
            var url = "/sfzn/reinsurance/getProductItem.do?recommendId=" + $("#recommendId").val();
            ajaxRequest(url, dataObj, function successCallback(data) {
                if (data.respCode == '0000') {

                    var productItem = data.productItem[0];
                    var insurancePremium = parseFloat(productItem.insurancePremium);
                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                    var productItemCode = productItem.productCode;
                    $("#productItemCode").val(productItemCode);

                } else {
                    hideLoading();
                }
            })
            ;
        }
    }
}



function deleteDiv(a) {

    var id = "add" + i;
    var my = document.getElementById(id);
    if (my != null)
        my.parentNode.removeChild(my);
    i = i - 1;
    getProductItem();

    function getProductItem(birthDay) {
        var a = i;

        var age6 = 0;
        var applicantIsSocialSe6 = $("#applicantIsSocialSe6").val();
        var idNumber6 = $("#idNumber6").val();
        var idType6 = $("#idType6").val();
        if (idType6 == '01') {
            age6 = getAgeBybirthDay(getbirthDayByIdNum(idNumber6));
        } else {
            if (birthDay == undefined) {
                birthDay = $('#birthDay6').val();
            }
            age6 = getAgeBybirthDay(birthDay);
        }
        if(age6!="0"&&applicantIsSocialSe6!=""){


            var age = 0;
            var applicantIsSocialSe = $("#applicantIsSocialSe").val();
            var idNumber = $("#idNumber").val();
            var idType = $("#idType").val();


            var amountSelect = $("#amountSelect").val();
            var idNumbers = {};
            var idTypes = {};
            var applicantIsSocialSes = {};
            var ages = {};
            var birthDays = {};
            var birthDay6;
            if (idType == '01') {
                age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
            } else {
                if (birthDay6 == undefined) {
                    birthDay6 = $('#birthDay').val();
                }
                age = getAgeBybirthDay(birthDay6);
            }
            var dataObj = {
                a: a,
                applicantIsSocialSe: applicantIsSocialSe,
                age: age,
                applicantIsSocialSe6: applicantIsSocialSe6,
                age6: age6,
                amountSelect: amountSelect,
                recommendId: $("#recommendId").val()
            }


            for (var n = 1; n <= a; n++) {
                idTypes['idType' + n] = cards['card' + n];
                idNumbers['idNumber' + n] = $("#idNumber" + n + "").val();
                applicantIsSocialSes['applicantIsSocialSe' + n] = singles['single' + n];

                if (idTypes['idType' + n] == null || idTypes['idType' + n] == '01') {
                    ages['age' + n] = getAgeBybirthDay(getbirthDayByIdNum(idNumbers['idNumber' + n]))
                }
                else {
                    birthDays['birthDay' + n] = dates['date' + n];
                    ages['age' + n] = getAgeBybirthDay(birthDays['birthDay' + n]);
                }
                dataObj['applicantIsSocialSe' + n] = applicantIsSocialSes['applicantIsSocialSe' + n];
                dataObj['age' + n] = ages['age' + n];


            }

            var url = "/sfzn/reinsurance/getProductItem.do?recommendId=" + $("#recommendId").val();
            showLoading("正在处理...");
            ajaxRequest(url, dataObj, function successCallback(data) {
                hideLoading();
                if (data.respCode == '0000') {
                    var productItem = data.productItem[0];
                    var insurancePremium = parseFloat(productItem.insurancePremium);
                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                    var productItemCode = productItem.productCode;
                    $("#productItemCode").val(productItemCode);

                }
            })
            ;
        }
    }

}