/**
 * Ajax模式List页面支持JS
 */
function dataTablesCommon(opt) {
	this.datatable = {};
	this.options = {
		"formId": "form",
		"method": "POST",
		'afterDataSerialized': null
	};

	this.options = $.extend(this.options, opt);

	if(opt.pageLength == undefined) {
		this.options.pageLength = 10;
    }else {
		this.options.pageLength = opt.pageLength;
	}

	var _that = this;

	this.queryData = function(d, table) {
		var data = $("#"+_that.options.formId).serializeJson();
		if(_that.options.afterDataSerialized
			&& typeof _that.options.afterDataSerialized != 'undefined'
			&& $.isFunction(_that.options.afterDataSerialized)) {
			data = _that.options.afterDataSerialized(data);
		}
		d.start = ((typeof d.start == 'undefined' || d.start == null || isNaN(d.start)) ? 0 : d.start );
		d.length = ((typeof d.length == 'undefined' || d.length == null || isNaN(d.length)) ? 10 : d.length );

		data.start = ( d.start / d.length) + 1;
		data.order = d.order;
		data.length = d.length;
		return data;
	};


	this.init();
}
(function($){  
    $.fn.serializeJson=function(){  
        var serializeObj={};  
        var array=this.serializeArray();
        $(array).each(function(){  
            if(serializeObj[this.name]){  
                if($.isArray(serializeObj[this.name])){  
                    serializeObj[this.name].push(this.value);  
                 }else{  
                     serializeObj[this.name]=[serializeObj[this.name],this.value];  
                 }  
             }else{  
                 serializeObj[this.name]=this.value;   
             }  
         });  
         return serializeObj;  
     };
 })(jQuery);

dataTablesCommon.prototype.init = function() {
	var innerDataTable = $(this.options.selector);
	var innerTargetUrl = this.options.targetUrl;
	var innerFormId = this.options.formId;
	var innerColumns = this.options.columns;
	var innerRowCallback = this.options.rowCallback;
	var method = this.options.method;
	var drawCallback = this.options.drawCallback;
	var options = $.extend( $.fn.dataTable.defaults, {
		"paging": true,
		"lengthChange": true,
		"ordering": false,
		"info": true,
		dom: '<"top">rt<"bottom" ilp><"clear">',
		autoWidth: false, //禁用自动调整列宽
		stripeClasses: ["odd", "even"], //为奇偶行加上样式，兼容不支持CSS伪类的场合
		processing: true, //隐藏加载提示,自行处理
		serverSide: true, //启用服务器端分页
		searching: false, //禁用原生搜索
		orderMulti: false, //启用多列排序
		order: [], //取消默认排序查询,否则复选框一列会出现小箭头
		renderer: "bootstrap", //渲染样式：Bootstrap和jquery-ui
		pagingType: "simple_numbers", //分页样式：simple,simple_numbers,full,full_numbers
		columnDefs: [{
			"targets": 'nosort', //列的样式名
			"orderable": false //包含上样式名‘nosort'的禁止排序
		}],
		"stateSave": false,
		"language" : {
			"lengthMenu" : "每页显示 _MENU_ 条记录",
			"zeroRecords" : "没有检索到数据",
			"info" : "当前第  _PAGE_ 页 （共   _PAGES_ 页  _TOTAL_ 条记录）",
			"emptyTable":'没有检索到数据',
			"infoEmpty" : "当前第 1 页 （共 0 条记录）",
			"infoFiltered" : "(filtered from _MAX_ total records)",
			"processing" : "数据加载中...",
			"decimal" : ",",
			"thousands" : "",
			"paginate" : {
				"first" : "<span class='glyphicon glyphicon-step-backward'></span>",
				"previous" : "<span class='glyphicon glyphicon-backward'></span>",
				"next" : "<span class='glyphicon glyphicon-forward'></span>",
				"last" : "<span class='glyphicon glyphicon-step-forward'></span>"
			}
		},
		"pageLength": this.options.pageLength,
		"lengthMenu": [10, 25, 50, 100],
		"destroy" : true,
		"ajax" : {
			url : innerTargetUrl,
			data: this.queryData,
			"method" : method,
		},
		"columns" : innerColumns,
		"rowCallback" : innerRowCallback,
		"drawCallback": drawCallback
	} );
	this.datatable = innerDataTable.dataTable(options);
};

dataTablesCommon.prototype.query = function() {
	if(this.datatable==null||JSON.stringify(this.datatable)=="{}"){
		this.init();
	} else {
		this.datatable.api().ajax.reload();
	}
	return this.datatable;
};
