/**
 * Created by yale on 2017/12/28.
 *
 * 时间操作工具
 */

/**
 * 开始时间startDate - 结束时间endDate 相距多少天
 * * 不包含endDate，如2017-12-25 2017-12-27相距2天
 * @param startDate
 * @param endDate
 * @return {number}
 */
function dateInteval(startDate, endDate){
    var day1 = new Date(startDate);
    var day2 = new Date(endDate);
    return (day2 - day1) / (1000 * 60 * 60 * 24);
}

/**
 * 获取两个日期之间所有日期
 * @return {string}
 */
Date.prototype.format = function() {
    var s = '';
    var mouth = (this.getMonth() + 1)>=10?(this.getMonth() + 1):('0'+(this.getMonth() + 1));
    var day = this.getDate()>=10?this.getDate():('0'+this.getDate());
    s += this.getFullYear() + '/'; // 获取年份。
    s += mouth + "/"; // 获取月份。
    s += day; // 获取日。
    return (s); // 返回日期。
};
function getAll(begin, end) {
    var ab = begin.split("/");
    var ae = end.split("/");
    var db = new Date();
    db.setUTCFullYear(ab[0], ab[1] - 1, ab[2]);
    var de = new Date();
    de.setUTCFullYear(ae[0], ae[1] - 1, ae[2]);
    var unixDb = db.getTime();
    var unixDe = de.getTime();

    var intervalDate = [];
    for (var k = unixDb; k <= unixDe;) {
        if((new Date(parseInt(k))).format()!=undefined){
            intervalDate.push((new Date(parseInt(k))).format());
        }
        k = k + 24 * 60 * 60 * 1000;
    }
    return intervalDate;
}

/**
 * 获取当前时间前x天日期不包括当前天
 * 若：今天27号，x=7，则return 20号
 * @return {number}
 */
function lastXDate(x){
    var now = new Date();
    var date = new Date(now.getTime() - x * 24 * 3600 * 1000);
    var year = date.getFullYear();
    var month = date.getMonth() + 1;
    var day = date.getDate();
    var hour = date.getHours();
    var minute = date.getMinutes();
    var second = date.getSeconds();
    if(month<10){
        month = "0"+month;
    }
    if(day<10){
        day = "0"+day;
    }
    //alert(year + '-' + month + '-' + day  + ' ' + hour + ':' + minute + ':' + second);
    return (year + '/' + month + '/' + day);
}

/**
 * 获取当前时间 format: yyyy-MM-dd
 * @return {string}
 */
function currentDate(){
    var date = new Date();
    var year = date.getFullYear();
    var month = date.getMonth()+1;
    var day = date.getDate();
    return year+'/'+month+'/'+day;
}

/**
 * 获取当天开始时间 format: yyyy-MM-dd HH:mm:ss
 */
function currentStartDateTime(){
    var date = new Date();
    var year = date.getFullYear();
    var month = date.getMonth() + 1;
    var day = date.getDate();
    var hour = "00";
    var minute = "00";
    var second = "00";
    // var hour = date.getHours();
    // var minute = date.getMinutes();
    // var second = date.getSeconds();
    var dateTime = year + '-' + month + '-' + day  + ' ' + hour + ':' + minute + ':' + second;
    return new Date(dateTime);
    // return (year + '-' + month + '-' + day  + ' ' + hour + ':' + minute + ':' + second);
}

/**
 * 判断是否是在同一个年份内
 * @param startDate
 * @param endDate
 * @return {boolean}
 */
function isSameYear(startDate, endDate){
    var date1 = new Date(startDate);
    var date2 = new Date(endDate);
    var year1 = date1.getFullYear();
    var year2 = date2.getFullYear();
    if(year1==year2){
        return true;
    }
    return false;
}

/**
 * 获取当前时间前x天日期,不包括当前天，同时：两个日期满足在同一年份区间
 * 若：今天27号，x=7，则return 20号
 * 若：今天4号，x=7，则return 1号
 * @return {number}
 */
function lastXDateAndSameYear(x){
    var now = new Date();
    var year = "";
    var date = "";
    var nowYear = now.getFullYear();
    for(var i=x;i>0;i--){
        date = new Date(now.getTime() - i * 24 * 3600 * 1000);
        year = date.getFullYear();
        if(year == nowYear){
            break;
        }
    }
    var month = date.getMonth() + 1;
    var day = date.getDate();
    var hour = date.getHours();
    var minute = date.getMinutes();
    var second = date.getSeconds();
    if(month<10){
        month = "0"+month;
    }
    if(day<10){
        day = "0"+day;
    }

    //alert(year + '-' + month + '-' + day  + ' ' + hour + ':' + minute + ':' + second);
    return (year + '/' + month + '/' + day);
}

/**
 * 获取前2个月的第一天
 * @param x
 * @returns {string}
 */
function lastXMonthDateAndSameYear(x){
    Date.today().addMonths(-2).moveToFirstDayOfMonth().toString('d-MMM-yyyy');

    //alert(year + '-' + month + '-' + day  + ' ' + hour + ':' + minute + ':' + second);
    return (year + '/' + month + '/' + day);
}

/**
 * 从 yyyy-MM 格式中获取 MM
 * @param str
 * @return {string}
 */
function splitGetMonth(str){
    var month = "";
    if(str!=undefined && str!=null && str!=""){
        month = str.split('-')[1];
    }
    return month;
}

//时间转换格式为yyyy-MM-dd h:m:s
Date.prototype.dateTimeConvert = function(format) {
    var date = {
        "M+": this.getMonth() + 1,  //月份
        "d+": this.getDate(),    //日
        "h+": this.getHours(),  //小时
        "m+": this.getMinutes(),     //分
        "s+": this.getSeconds(),    //秒
        "q+": Math.floor((this.getMonth() + 3) / 3),    //季度
        "S+": this.getMilliseconds()    //毫秒
    };
    if (/(y+)/i.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    for (var k in date) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1
                ? date[k] : ("00" + date[k]).substr(("" + date[k]).length));
        }
    }
    return format;
}

//时间转换格式为yyyy-MM-dd
Date.prototype.dateConvert = function(format) {
    var date = {
        "M+": this.getMonth() + 1,  //月份
        "d+": this.getDate()    //日
    };
    if (/(y+)/i.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    for (var k in date) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1
                ? date[k] : ("00" + date[k]).substr(("" + date[k]).length));
        }
    }
    return format;
}