/**
 * Created by root on 2018/3/19.
 */
// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
Date.prototype.format = function(fmt)
{ //author: meizz
    var o = {
        "M+" : this.getMonth()+1,                 //月份
        "d+" : this.getDate(),                    //日
        "h+" : this.getHours(),                   //小时
        "m+" : this.getMinutes(),                 //分
        "s+" : this.getSeconds(),                 //秒
        "q+" : Math.floor((this.getMonth()+3)/3), //季度
        "S"  : this.getMilliseconds()             //毫秒
    };
    if(/(y+)/.test(fmt)){
        fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
    }
    for(var k in o){
        if(new RegExp("("+ k +")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
        }
    }
    return fmt;
}
/*!
 Math.uuid.js (v1.4)
 http://www.broofa.com
 mailto:robert@broofa.com

 Copyright (c) 2010 Robert Kieffer
 Dual licensed under the MIT and GPL licenses.
 */

/*
 * Generate a random uuid.
 *
 * USAGE: Math.uuid(length, radix)
 *   length - the desired number of characters
 *   radix  - the number of allowable values for each character.
 *
 * EXAMPLES:
 *   // No arguments  - returns RFC4122, version 4 ID
 *   >>> Math.uuid()
 *   "92329D39-6F5C-4520-ABFC-AAB64544E172"
 *
 *   // One argument - returns ID of the specified length
 *   >>> Math.uuid(15)     // 15 character ID (default base=62)
 *   "VcydxgltxrVZSTV"
 *
 *   // Two arguments - returns ID of the specified length, and radix. (Radix must be <= 62)
 *   >>> Math.uuid(8, 2)  // 8 character ID (base=2)
 *   "01001010"
 *   >>> Math.uuid(8, 10) // 8 character ID (base=10)
 *   "47473046"
 *   >>> Math.uuid(8, 16) // 8 character ID (base=16)
 *   "098F4D35"
 */

// Private array of chars to use
var CHARS = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');

Math.uuid = function (len, radix) {
    var chars = CHARS, uuid = [], i;
    radix = radix || chars.length;

    if (len) {
        // Compact form
        for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
        // rfc4122, version 4 form
        var r;

        // rfc4122 requires these characters
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';

        // Fill in random data.  At i==19 set the high bits of clock sequence as
        // per rfc4122, sec. 4.1.5
        for (i = 0; i < 36; i++) {
            if (!uuid[i]) {
                r = 0 | Math.random() * 16;
                uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
            }
        }
    }

    return uuid.join('');
};

layui.use(['layer'], function(){
    var layer = layui.layer;
    // 面板
    var panelID = $('#panelID');
    if(panelID[0] && $(window).width() > 750) {
        layer.ready(function () {
            layer.open({
                type: 1
                , content: panelID
                , skin: 'layui-layer-dir'
                , area: 'auto'
                , maxHeight: $(window).height() - 150
                , title: "操 作 面 板"
                ,closeBtn: false
                , offset: 'r'
                , shade: false
                ,resize:true
                , success: function (layero, index) {
                    layer.style(index, {
                        marginLeft: -15
                    });
                }
            });
        });
        panelID.find('dd').on('click', function () {
            var othis = $(this);
            othis.find('a').addClass('layui-this');
            othis.siblings().find('a').removeClass('layui-this');
            othis.find('button').addClass('layui-this');
            othis.siblings().find('button').removeClass('layui-this');

        });
    }
    layer.ready(function () {
        var tips_sortable_lock = true;
        //标签排序
        $( "#sortable" ).sortable( {
            remove: function(e,ui){
                if(tips_sortable_lock){
                    tips_sortable_lock =false;
                    flashDataForTagging();
                    flashShowForTagging();
                    tips_sortable_lock = true;
                }

            }
            ,stop: function( e,ui ) {
                if(tips_sortable_lock) {
                    tips_sortable_lock = false;
                    flashDataForTagging();
                    flashShowForTagging();
                    tips_sortable_lock = true;
                }
            }
            ,update:function( e,ui ) {
                if(tips_sortable_lock) {
                    tips_sortable_lock = false;
                    flashDataForTagging();
                    flashShowForTagging();
                    tips_sortable_lock = true;
                }
            }

        });
        $( "#sortable" ).disableSelection();
        // 展开更多分类标签 或隐藏部分标签
        $("span[moreTaggingArea]").removeClass("layui-hide");

        $("span[moreTaggingArea] legend[moreTaggingButton]").on('click',function () {
            flashShowForTagging();
            var moreTaggingButtonAttr = $(this).attr("moreTaggingButton")||"";
            if(moreTaggingButtonAttr ==='zoomIn'){
                $(".customTagging li span[tagging-data]").parent("a").parent("li").removeClass("layui-hide");
                $(".customTagging li span[tagging-data-more]").parent("a").parent("li").removeClass("layui-hide");
            }else if(moreTaggingButtonAttr ==='zoomOut'){
                $(".customTagging li span[tagging-data-more]").parent("a").parent("li").addClass("layui-hide");
            }

            $("span[moreTaggingArea] legend[moreTaggingButton]").toggleClass("layui-hide");
        });

        var tagging_flash_data_lock = true;
        //添加标签
        $('input[addTagging]').focusin(function (e) {
            layer.tips('按<span class="tips-text">回车</span>或点击<span class="tips-text">界面空白处</span>预览','#addTaggingID', {
                tips: 2
                ,time:3000
            });
            e.stopPropagation();
        });
        $('input[addTagging]').keyup(function(e){
            e.stopPropagation();
            if(e.keyCode ==13) {
                if(tagging_flash_data_lock){
                    tagging_flash_data_lock = false;
                    addTaggingMain(tips_sortable_lock);
                    tagging_flash_data_lock = true;
                }

            }
        });
        $('input[addTagging]').focusout(function (e) {
            e.stopPropagation();
            if(tagging_flash_data_lock){
                tagging_flash_data_lock = false;
                addTaggingMain(tips_sortable_lock);
                tagging_flash_data_lock = true;
            }
        });
        flashDataForTagging();
        addBindShowOrHideDelTaggingCloseBtnEvent(tips_sortable_lock);
        addBindCickDelTaggingBtnEvent();
    });

// 检查重复标签
    var checkDuplicateTaggingData = function (newDataStr,oldDataStr) {
        var oldDataArr = oldDataStr.split(";");
        var doJobFlag = true;
        for(var x = 0 ;x<oldDataArr.length; x++){
            if(oldDataArr[x]==newDataStr){
                doJobFlag = false;
                break;
            }else{
                doJobFlag = true;
            }
        }
        return doJobFlag;
    };
// 添加标签主逻辑
    var addTaggingMain = function (tips_sortable_lock) {
        var data = $("input[addTagging]").val()||"";
        $("input[addTagging]").val("");
        $("input[addTagging]").attr("placeholder","添加新标签");
        var oldData = $("input[name='tagging']").val()||"";
        data = data.replace(/^\s+|\s+$/gm,'');
        if(data!="" ){
            // 检查是否是重复标签
            if(checkDuplicateTaggingData(data,oldData)) {
                //隐藏没有标签分类数据的提示
                var noTagging = $("span[noTaagging]");
                noTagging.removeClass("layui-hide");
                noTagging.addClass("layui-hide");
                // 添加标签
                addTagging(data,tips_sortable_lock);
            }else{
                layer.tips('已存在标签：<span class="tips-text">'+data+'</span> 请勿重复添加','#addTaggingID', {
                    tips: 3
                    ,time:3000
                });
            }
        }
    };


// 添加标签
    var addTagging = function(data,tips_sortable_lock){
        // 添加标签
        $("div[taggingtml] li span[class*='tagging-text']").text(data);
        var taggingData = $(".customTagging li span[tagging-data]").length;
        var taggingDataMore = $(".customTagging li span[tagging-data-more]").length;
        var taggingTotal = taggingData + taggingDataMore+1;

        if (taggingTotal == 1) {
            $("div[taggingtml] li span[class*='tagging-text']").attr("tagging-data", data);
            $("div[taggingtml] li span[class*='tagging-text']").removeAttr("tagging-data-more");
            $("div[taggingtml] li a").addClass("layui-bg-red");
            $("div[taggingtml] li a").removeClass("layui-bg-gray");
            $("div[taggingtml] li a").removeClass("layui-bg-orange");
        } else if (taggingTotal > 1 && taggingTotal <= 5) {
            $("div[taggingtml] li span[class*='tagging-text']").attr("tagging-data", data);
            $("div[taggingtml] li span[class*='tagging-text']").removeAttr("tagging-data-more");
            $("div[taggingtml] li a").addClass("layui-bg-orange");
            $("div[taggingtml] li a").removeClass("layui-bg-gray");
            $("div[taggingtml] li a").removeClass("layui-bg-red");
        } else {
            $("div[taggingtml] li span[class*='tagging-text']").attr("tagging-data-more", data);
            $("div[taggingtml] li span[class*='tagging-text']").removeAttr("tagging-data");
            $("span[moreTaggingArea]").removeClass("layui-hide");
            $("div[moreTaggingAreaDiv]").removeClass("layui-hide");
            $(".customTagging li span[tagging-data-more]").parent("a").parent("li").removeClass("layui-hide");
            $("span[moreTaggingArea] legend[moreTaggingButton='zoomIn']").addClass("layui-hide");
            $("span[moreTaggingArea] legend[moreTaggingButton='zoomOut']").removeClass("layui-hide");
            $("div[taggingtml] li a").addClass("layui-bg-gray");
            $("div[taggingtml] li a").removeClass("layui-bg-orange");
            $("div[taggingtml] li a").removeClass("layui-bg-red");
        }

        $("#addTaggingID").before($("div[taggingtml]").html());
        setTimeout(flashDataForTagging,1500);
        setTimeout(addBindShowOrHideDelTaggingCloseBtnEvent,1500,tips_sortable_lock);
        setTimeout(addBindCickDelTaggingBtnEvent,1500);
    };

    var  sortTipsShow = function(obj,tips_sortable_lock){
        if( tips_sortable_lock ){
            tips_sortable_lock = false;
            layer.tips('拖放<span class="tips-text"> 标签</span> 进行排序',obj.children(".tagging-text"), {
                tips: 1
                ,time:2000
            });
            tips_sortable_lock = true;
        }

    }
// 绑定显示、隐藏删除标签按钮事件
    var addBindShowOrHideDelTaggingCloseBtnEvent = function(tips_sortable_lock){
        $(".tagging-btn").mouseover(function (e) {
            $(this).children(".tagging-close-btn").removeClass("layui-hide");
            $(this).children(".tagging-close-btn").fadeIn("slow");
            if(tips_sortable_lock){
                tips_sortable_lock = false;
                layer.tips('点击<span class="tips-text"> <i class="layui-icon">&#x1006;</i></span> 按钮删除标签',$(this).children(".tagging-close-btn"), {
                    tips: 3
                    ,time:1000
                });
                tips_sortable_lock=true;
                setTimeout(sortTipsShow,1000,$(this),tips_sortable_lock);
            }
            e.stopPropagation();
        });
        $(".tagging-btn").mouseout(function (e) {
            $(this).children(".tagging-close-btn").addClass("layui-hide");
            $(this).children(".tagging-close-btn").fadeOut("normal");
            e.stopPropagation();
        });
    };

    //删除标签
    var addBindCickDelTaggingBtnEvent = function () {
        $(".tagging-close-btn").on('click',function (e) {
            $(this).parent("a").parent("li").remove();
            e.stopPropagation();
            setTimeout(flashDataForTagging,1500);
            setTimeout(flashShowForTagging,1500);
        });
    };
    // 刷新标签显示
    var flashShowForTagging = function () {
        var counter = 0;
        $(".customTagging li[tag]").each(function( k,domEle){
            counter ++;
            var index = $(domEle).index();
            var wrapTaggingA = $(domEle).children("a");
            var taggingText = $("span[class*='tagging-text']",domEle);
            var data = taggingText.html()||"";
            if(index == 0){
                taggingText.attr("tagging-data", data);
                $(domEle).removeClass("layui-hide");
                taggingText.removeAttr("tagging-data-more");
                wrapTaggingA.addClass("layui-bg-red");
                wrapTaggingA.removeClass("layui-bg-gray");
                wrapTaggingA.removeClass("layui-bg-orange");
            }else if(index >=1 && index <5){
                taggingText.attr("tagging-data", data);
                $(domEle).removeClass("layui-hide");
                taggingText.removeAttr("tagging-data-more");
                wrapTaggingA.addClass("layui-bg-orange");
                wrapTaggingA.removeClass("layui-bg-gray");
                wrapTaggingA.removeClass("layui-bg-red");
            }else{
                taggingText.attr("tagging-data-more", data);
                taggingText.removeAttr("tagging-data");
                wrapTaggingA.addClass("layui-bg-gray");
                wrapTaggingA.removeClass("layui-bg-orange");
                wrapTaggingA.removeClass("layui-bg-red");
            }
        });
        if(counter<=0){
             $("span[noTaagging]").removeClass("layui-hide");
        }else{
            $("span[noTaagging]").addClass("layui-hide");
        }
        if(counter<=5){
            $("span[moreTaggingArea]").addClass("layui-hide");
        }else{
            $("span[moreTaggingArea]").removeClass("layui-hide");
        }
    };

    // 分类标签隐藏域刷值
    var flashDataForTagging = function(){
        // 分类标签隐藏域刷值
        var txt = "";
        $(".customTagging li span[tagging-data]").each(function (y,domEle) {
            txt +=(txt=="")?$(domEle).html():";"+$(domEle).html();
        });
        $(".customTagging li span[tagging-data-more]").each(function (z,domEle) {
            txt +=(txt=="")?$(domEle).html():";"+$(domEle).html();
        });
        $("input[name='tagging']").val(txt);
    };
    var customSortForArr = function (a,b) {
        var result = false;
        try{
            var at = "";
            var bt = "";
            if(a.hasOwnProperty("time")){
               at = new Date(a.time).getTime();
            }
            if(b.hasOwnProperty("time")){
                bt =  new Date(b.time).getTime();
            }
        }catch(err){
            return false;
        }
        var sortType = $("div[dealStatusTml]").attr("sortType");
        if(sortType =='desc'){
            result = bt-at; // 降序
        }else{
            result = at-bt; // 升序
        }
        return result;
    };
    // 处理进度渲染
    var showDealStatus = function(){
        var oldValue = $("input[name='dealStatus']").val();
        var oldValueJson =[];
        var msg ="";
        try{
             oldValueJson =JSON.parse(oldValue).sort(customSortForArr) || [];
             $.each(oldValueJson,function(i,n){
                 var title = n.title || "";
                 var time = n.time || "";
                 var content = n.content || "";
                 $("div[dealStatusTml] li h3[class*='deal-status-title'] span[showTitle]").html(title);
                 $("div[dealStatusTml] li span[class*='deal-status-tips'] span[showTips]").html(time);
                 $("div[dealStatusTml] li div[class*='deal-status-content'] div[showContent]").html(content);
                 $("div[dealStatusTml] li h3[class*='deal-status-title'] span[showTitle]").removeClass("layui-hide");
                 $("div[dealStatusTml] li h3[class*='deal-status-title'] span[showTips]").removeClass("layui-hide");
                 $("div[dealStatusTml] li div[class*='deal-status-content'] div[showContent]").removeClass("layui-hide");
                 msg += (msg=="")?$("div[dealStatusTml]").html():"<br/>"+$("div[dealStatusTml]").html();
             });

        }catch (err){
            var timeErr = "1970-01-01 00:00:00";
            $("input[name='dateCreated']").siblings("span").each(function (i,n) {
                timeErr = $(n).html();
                return false;
            });
            var a = [];
            var o = {
                "title":""
                ,"time":timeErr
                ,"content":oldValue
            };
            a.push(o);
            $("input[name='dealStatus']").val(JSON.stringify(a));
            setTimeout(function () {
                showDealStatus();
            },1500);
           // msg +="<span id='dealstatus-err'>无法显示,异常信息:"+err+"</span>";
        }
        if(msg != ""){
            $("input[name='dealStatus']").after(msg);
        }
    };
    showDealStatus();
    // 编辑处理进度
    var editDealStatus = function () {
        var time =(new Date()).format("yyyy-MM-dd hh:mm:ss");
        var uuid = Math.uuid(5, 16)+(new Date()).format("yyyyMMddhhmmss");
        $("div[dealStatusTml] li h3[class*='deal-status-title']").append("<input type='text' autofocus dealstatu-editor  iDNumber='"+uuid+"' placeholder='请输入标题' class='layui-text custom-dealstatus-title'>");
        $("div[dealStatusTml] li span[class*='deal-status-tips'] span[showTips]").html(time);
        $("div[dealStatusTml] li div[class*='deal-status-content']").append("<textarea type='text' dealstatu-editor iDNumber='"+uuid+"'  placeholder='请输入内容'  class='layui-textarea custom-dealstatus-content'></textarea>");
        $("div[dealStatusTml] li h3[class*='deal-status-title'] span[showTitle]").html("");
        $("div[dealStatusTml] li div[class*='deal-status-content'] div[showContent]").html("");
        $("div[dealStatusTml] li h3[class*='deal-status-title'] span[showTitle]").addClass("layui-hide");
        $("div[dealStatusTml] li div[class*='deal-status-content'] div[showContent]").addClass("layui-hide");
        var msg ="";
        try{
            msg = $("div[dealStatusTml]").html();
            $("div[dealStatusTml] li h3[class*='deal-status-title'] input[dealstatu-editor]").remove();
            $("div[dealStatusTml] li div[class*='deal-status-content'] textarea[dealstatu-editor]").remove();
            setTimeout(function () {
                $("*[dealstatu-editor ]").each(function (index,o) {

                    //再次编辑事件绑定
                    $(o).siblings().click(function (e) {
                        $("#dealstatus-err").addClass("layui-hide");
                        $(this).addClass("layui-hide");
                        $(this).siblings("*[dealstatu-editor ]").each(function (index,n) {
                            $(n).removeClass("layui-hide");
                        });
                        e.stopPropagation();
                    });
                    // 删除事件绑定
                    $(o).parents("div[dealStatusParent]").each(function (index,n) {
                        $(n).siblings("i").each(function (i,m) {
                            $(m).mouseover(function (e) {
                                layer.tips('点我<span class="tips-text">删除进度</span>',$(m), {
                                    tips: 4
                                    ,time:3000
                                });
                                e.stopPropagation();
                            });
                            $(m).click(function (e) {
                                $(n).parent("li").remove();
                                delDealStatus($(o));
                                e.stopPropagation();
                            });

                        });
                    });

                    // 编辑状态
                    $(o).focusin(function (e) {
                        $("#dealstatus-err").addClass("layui-hide");
                        if($(this).hasClass("custom-dealstatus-title")){
                            $(this).siblings("span[showTitle]").each(function (index,n) {
                                $(n).addClass("layui-hide");
                            });
                            $(this).removeClass("layui-hide");
                            layer.tips('按<span class="tips-text">回车</span>或点击<span class="tips-text">界面空白处</span>预览',this, {
                                tips: 4
                                ,time:3000
                            });
                        }
                        if($(this).hasClass("custom-dealstatus-content")){
                            $(this).siblings("div[showContent]").each(function (index,n) {
                                $(n).addClass("layui-hide");
                            });
                            layer.tips('点击<span class="tips-text">界面空白处</span>预览',this, {
                                tips: 3
                                ,time:3000
                            });
                        }
                        e.stopPropagation();
                    });
                    // 失去焦点预览
                    $(o).focusout(function (e) {
                        var lock = $(this).attr("lock")||false;
                        var hideFlag = false;
                        if(!lock){
                            $(this).attr("lock","true");
                            addDealStatus(this);
                            if($(this).hasClass("custom-dealstatus-title")){
                                $(this).siblings("span[showTitle]").each(function (index,n) {
                                    var html = $(n).html()||"";
                                    if(html !=""){
                                        $(n).removeClass("layui-hide");
                                        hideFlag = true;
                                    }
                                });
                            }
                            if($(this).hasClass("custom-dealstatus-content")){
                                $(this).siblings("div[showContent]").each(function (index,n) {
                                    var html = $(n).html()||"";
                                    if(html !="") {
                                        $(n).removeClass("layui-hide");
                                        hideFlag = true;
                                    }
                                });
                            }
                            if(hideFlag){
                                $(this).addClass("layui-hide");
                            }
                            $(this).removeAttr("lock");
                        }

                        e.stopPropagation();
                    });
                    // 回车预览
                    $(o).keyup(function (e) {
                        if(e.keyCode ==13 && !$(this).hasClass("custom-dealstatus-content")) {
                            var lock = $(this).attr("lock")||false;
                            var hideFlag = false;
                            if(!lock){
                                $(this).attr("lock", "true");
                                $(this).removeAttr("autofocus");
                                addDealStatus(this);
                                if($(this).hasClass("custom-dealstatus-title")){
                                    $(this).siblings("span[showTitle]").each(function (index,n) {
                                        var html = $(n).html()||"";
                                        if(html !="") {
                                            $(n).removeClass("layui-hide");
                                            hideFlag = true;
                                        }
                                    });
                                    if(hideFlag){
                                        $(this).addClass("layui-hide");
                                    }
                                }
                                $(this).removeAttr("lock");
                            }
                        }
                        e.stopPropagation();
                    });
                });
            },2000);
        }catch(err){
            msg  = "<span class='tips-text'>数据异常,添加失败</span>";
            msg +="<span>异常信息:"+err+"</span>";
        }
        var sortType = $("div[dealStatusTml]").attr("sortType");
        if(sortType =='desc'){
            $("input[name='dealStatus']").after(msg);
        }else{
            $("input[name='dealStatus']").parent().append(msg);
        }
    };
    // 添加进度处理方法
    var addDealStatus  = function (obj) {
        var oldValue = $("input[name='dealStatus']").val();
        var oldValueJson =[];
        var data = $(obj).val()||"";
        data = data.replace(/\n/g,"<br/>");
        try{
            oldValueJson =JSON.parse(oldValue).sort(customSortForArr) || [];
            if(data!=""){
                if($(obj).hasClass("custom-dealstatus-title")){
                    $(obj).siblings("span[showTitle]").each(function (index,n) {
                        $(n).html(data);
                    })
                }
                if($(obj).hasClass("custom-dealstatus-content")){
                    $(obj).siblings("div[showContent]").each(function (index,n) {
                        $(n).html(data);
                    })
                }
                var doFlag = true;
                $.each(oldValueJson,function (i,n) {
                    if(n.hasOwnProperty("IDNumber")) {
                        var idNumberInData = n.IDNumber || "";
                        var idNumber = $(obj).attr("IDNumber")||"";
                        if(idNumber!="" && idNumberInData!="" && idNumber== idNumberInData){
                            if($(obj).hasClass("custom-dealstatus-title")){
                                oldValueJson[i]['title'] = data;
                            }
                            if($(obj).hasClass("custom-dealstatus-content")){
                                oldValueJson[i]['content'] = data;
                            }
                            doFlag = false;
                            $("input[name='dealStatus']").val(JSON.stringify(oldValueJson));
                            return false;
                        }else{
                            doFlag = true;
                        }
                    }else{
                        doFlag = true;
                    }
                });
                if(doFlag){
                    var title = "";
                    var time = "";
                    $(obj).parent().siblings("span[class*='deal-status-tips']").each(function (index,n) {
                        time =  $(n).children("span[showTips]").html()||"1970-01-01 00:00:00";
                    });
                    var content = "";
                    var IDNumber =$(obj).attr("IDNumber")||"";
                    if($(obj).hasClass("custom-dealstatus-title")){
                        title = data;
                    }
                    if($(obj).hasClass("custom-dealstatus-content")){
                        content = data;
                    }
                    var jo = {
                        "title":title
                        ,"time":time
                        ,"content":content
                        ,"IDNumber":IDNumber
                    };
                    var sortType = $("div[dealStatusTml]").attr("sortType")||"";
                    if(sortType =='desc'){
                        oldValueJson.unshift(jo);
                    }else{
                        oldValueJson.pop(jo);
                    }
                    $("input[name='dealStatus']").val(JSON.stringify(oldValueJson));
                }

            }
        }catch (err){
        }
    };
    //删除进度
    var delDealStatus  = function (obj){
        var oldValue = $("input[name='dealStatus']").val();
        var oldValueJson =[];
        var idNumber = $(obj).attr("IDNumber")||"";
        try{
            oldValueJson =JSON.parse(oldValue).sort(customSortForArr) || [];
            $.each(oldValueJson,function (index,n) {
                if(n.hasOwnProperty("IDNumber")) {
                    var idNumberInData = n.IDNumber || "";
                    if (idNumber != "" && idNumberInData != "" && idNumber == idNumberInData) {
                        oldValueJson.splice(index, 1);
                        $("input[name='dealStatus']").val(JSON.stringify(oldValueJson));
                    }
                }
            });
        }catch (err){

        }

    };
    // 打开问题
    var openStaus = function () {
        var oldData = $("input[name='status']").attr("key")||"";
        var ctx = $("#ctx").val()||"";
        var goUrl = ctx+"#statusID";
        var Fault_Open = $("#dictDataID span[Fault_Open]");
        var Fault_Close = $("#dictDataID span[Fault_Close]");
        window.open(goUrl,"_self");
        if(oldData==Fault_Open.attr("key")){
            layer.tips('当前问题已处于<span class="tips-text">'+Fault_Open.attr("value")+'</span>','#statusID', {
                tips: 4
                ,time:3000
            });
        }else if(oldData==Fault_Close.attr("key")){
            $("input[name='status']").attr("key",Fault_Open.attr("key"));
            $("input[name='status']").val(Fault_Open.attr("key"));
            $("input[name='status']").siblings("span").each(function (i,n) {
                $(n).html(Fault_Open.attr("value"));
            });
            layer.tips('问题状态已切换,<span class="tips-text">请提交保存</span>,','#statusID', {
                tips: 4
                ,time:3000
            });
        }else{
            layer.tips('无法识别的<span class="tips-text">状态码</span>,操作失败!','#statusID', {
                tips: 4
                ,time:3000
            });
        }
    };
    // 关闭问题
    var closeStaus = function () {
        var oldData = $("input[name='status']").attr("key")||"";
        var ctx = $("#ctx").val()||"";
        var goUrl = ctx+"#statusID";
        var Fault_Open = $("#dictDataID span[Fault_Open]");
        var Fault_Close = $("#dictDataID span[Fault_Close]");
        window.open(goUrl,"_self");
        if(oldData==Fault_Close.attr("key")){
            layer.tips('当前问题已处于<span class="tips-text">'+Fault_Close.attr("value")+'</span>','#statusID', {
                tips: 4
                ,time:3000
            });
        }else if(oldData==Fault_Open.attr("key")){
            $("input[name='status']").attr("key",Fault_Close.attr("key"));
            $("input[name='status']").val(Fault_Close.attr("key"));
            $("input[name='status']").siblings("span").each(function (i,n) {
                $(n).html(Fault_Close.attr("value"));
            });
            layer.tips('问题状态已切换,<span class="tips-text">请提交保存</span>,','#statusID', {
                tips: 4
                ,time:3000
            });
        }else{
            layer.tips('无法识别的<span class="tips-text">状态码</span>,操作失败!','#statusID', {
                tips: 4
                ,time:3000
            });
        }
    };
    // 面板按钮事件
    $("button[edit]").click(function (e) {
        editDealStatus();
        e.stopPropagation();
    });
    $("button[open]").click(function (e) {
        openStaus();
        e.stopPropagation();
    });
    $("button[close]").click(function (e) {
        closeStaus();
        e.stopPropagation();
    });
});





