/**
 * Created by root on 2018/3/16.
 */
$(function(){
    layui.use(['form','table','layer'], function(){
        var table = layui.table;
        var form = layui.form;
        var layer = layui.layer;
        var url = $("#formId").attr("action");
        var faultCode = $("input[name='faultCode']").val()||"";
        var systemName = $("input[name='systemName']").val()||"";
        //监听提交
        form.on('submit(searchDemo)', function(data){
            //layer.msg(JSON.stringify(data.field));
            table.reload('contentTableID', {
                url: url
                ,method: 'POST'
                ,where: {
                    faultCode:data.field.faultCode
                    ,systemName:data.field.systemName
                } //设定异步数据接口的额外参数
                //,height:380
                ,page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
            return false; // 阻止提交表单(此处一定要阻止表单的默认提交行为)
        });

        //数据表格
        table.render({
            id :'contentTableID'
            ,elem: '#tableid'
           // ,height: 380
            ,skin: 'line' //行边框风格
            ,even: true //开启隔行背景
            ,size: 'lg' //大尺寸的表格
            ,url: url//数据接口
            ,where: {
                faultCode: faultCode
                ,systemName:systemName
            }
            ,loading:true
            ,method: 'post'
            ,page: {
               // elem: 'pagePaging' //注意，这里的 pagePaging 是 ID，不用加 # 号
                limit:10
                ,theme: 'pageCustomStyle' //自定义主题。支持传入：颜色值，或任意普通字符。如：1. theme: '#c00' 2. theme: 'xxx' //将会生成 class="layui-laypage-xxx" 的CSS类，以便自定义主题
                ,groups:10 // 连续出现的页码个数，默认5
                ,layout:['prev', 'page', 'next',"limit",'skip','count']
                ,first:"首页"
                ,last:"末页"
                ,prev:"上一页"
                ,next:"下一页"
            }
            ,cols: [[ //表头
                // {field: 'id', title: 'ID', width:'5%', align:'center',fixed: 'left'}
                {field: 'faultCode', title: '问题编号', fixed: 'left'}
                ,{field: 'userCode', title: '上报人工号', width:'10%' }
                ,{field: 'userName', title: '上报人名称', width:'10%'}
                ,{field: 'comCode', title: '归属机构', width: '10%'}
                ,{field: 'comName', title: '机构名称', width: '10%'}
                //   ,{field: 'systemCode', title: '系统编号', width: 100}
                ,{field: 'systemName', title: '系统名称', width: '10%'}
                //   ,{field: 'businessCode', title: '业务号', width: 100}
                //   ,{field: 'operationPoint', title: '业务节点', width: 100}
                ,{field: 'url', title: 'url', width: '10%'}
                //   ,{field: 'tips', title: '提示信息', width: 100}
                //   ,{field: 'attachment', title: '附件', width: 100}
                //   ,{field: 'businessDescription', title: '业务描述', width: 100}
                // ,{field: 'dateCreated', title: '创建时间', width: '10%'}
                //  ,{field: 'lastUpdated', title: '最后一次修改时间', width: '5%'}
                //  ,{field: 'lastmodifiedBy', title: '修改人', width: '5%'}
                //  ,{field: 'createBy', title: '创建人', width: '5%'}
                //  ,{field: 'tagging', title: '分类', width: '5%'}
                //  ,{field: 'sessionId', title: '会话id', width: '5%'}
                //  ,{field: 'sessionBelongsToUserCode', title: '占用会话用户', width: '5%'}
                //  ,{field: 'sessionContinuedTime', title: '占用会话持续时间', width: '5%'}
                //  ,{field: 'dealStatus', title: '处理状态或进度', width: '5%'}
                //  ,{field: 'dealResult', title: '处理结果', width: '5%'}
                //  ,{field: 'status', title: '问题状态', width: '5%'}
                // ,{field: 'remark', title: '备注', width: '5%'}
                // ,{field: 'pageContent', title: '备注', width: '5%'}
                ,{field: 'operationFlag', width: '10%',title: '操作', fixed: 'right',align:'center', toolbar: '#barDemo'}
            ]]
        });
        //监听工具条
        table.on('tool(contentTable)', function(obj){ //注：tool是工具条事件名，contentTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data; //获得当前行数据
            var layEvent = obj.event; //获得 lay-event 对应的值（也可以是表头的 event 参数对应的值）
            var tr = obj.tr; //获得当前行 tr 的DOM对象
            data.operationFlag = layEvent;
            var job = function(btnArr,callBackArr){
                btnArr = btnArr||[];
                callBackArr = callBackArr || [];
                var controlFlag = true;
                var layerOpenJson = {
                    title: "<i class='layui-icon'>&#xe60c;</i>"
                    ,area:['98%','96%']
                    ,offset:['2%','1%']
                    ,skin:"custom-layer"
                    ,btn:btnArr
                    ,resize:false
                    ,btnAlign: 'c'
                    ,closeBtn:false
                    ,anim: 3
                    ,type:2
                    ,content: $("#ctx").val()+"/faultClassification/loadingProgress"
                    ,success:function(layero, index){
                        layer.title("<i class='layui-icon'>&#xe63d;</i>", index);
                        if(controlFlag){
                            //layero.children(".layui-layer-content").children("iframe").prop("src","http://www.baidu.com");
                            // layer.iframeSrc(index, "http://www.baidu.com");
                            //var iframeObj = layero.find('iframe')[0];
                            var loadingProgressObj = layer.getChildFrame('#loadingProgressID', index);
                            var doSth = function (layero,index) {
                                if(loadingProgressObj.find("span").html() =="100%"){
                                    clearInterval(t);
                                    var loadingProgressObje = layer.getChildFrame("#loadingProgressID",index);
                                    loadingProgressObje.toggleClass("layui-bg-orange");
                                    loadingProgressObje.toggleClass("layui-bg-green");
                                    var url = $("#ctx").val()+"/faultClassification/doOpenDetail";
                                    $.ajax({
                                        url : url
                                        ,type:"POST"
                                        ,contentType:"application/json;charset=utf-8"
                                        ,dataType:"html"
                                        ,data:JSON.stringify(data)
                                        ,success:function (result) {
                                            layero.find('iframe')[0].contentDocument.write(result);
                                            var doChangeSth = function (layero,index) {
                                                var fieldsetHeaderID = layer.getChildFrame("#fieldsetHeaderID",index)||undefined||null;
                                                if(typeof fieldsetHeaderID ==='object'){
                                                    clearInterval(tle);
                                                    layer.title(fieldsetHeaderID.html(), index);
                                                }
                                            };
                                            var tle = setInterval(doChangeSth,300+Math.random()*1000,layero,index);

                                        }
                                    });
                                }
                            };
                            var t = setInterval(doSth,300+Math.random()*1000,layero,index);
                            controlFlag = false;
                        }
                    }
                };
                for(var i in callBackArr){
                    var prefixStr ="btn";
                    var prefixNum =1;
                    if(i<=btnArr.length){
                        if(i==0){
                            layerOpenJson.yes =( $.type(callBackArr[i]) ==='function')?callBackArr[i]:function () {
                            };
                        }else{
                            prefixNum++;
                            var key = prefixStr+prefixNum;
                            layerOpenJson[key] = ( $.type(callBackArr[i]) ==='function')?callBackArr[i]:function () {
                            };
                        }

                    }
                }
                layer.open(layerOpenJson);
            };
            if(layEvent === 'detail'){ //查看
                //do somehing
                var custombtnArrForDetail = ["返回"];
                var custombtnCallBackArrForDetail =[function (index) {
                    layer.close(index);
                }]
                job(custombtnArrForDetail,custombtnCallBackArrForDetail);
            } else if(layEvent === 'edit'){ //编辑
                //do something
                var custombtnArrForDetail = ["提交","返回"];
                var custombtnCallBackArrForDetail =[function (index) {
                    var ctx = $("#ctx").val()||"";
                    var url = ctx+"/faultClassification/save";
                    var gourl = ctx+"/faultClassification/faultSearch";
                    var form = layer.getChildFrame("form",index);
                    if(form.length>0){
                        var data = form.serializeObject();
                        if(data.hasOwnProperty("dealStatus")){
                            var arr = [];
                            $.each(JSON.parse(data["dealStatus"]),function (i,n) {
                                if(n.hasOwnProperty("IDNumber")){
                                    delete n.IDNumber;
                                }
                                arr.push(n);
                            });
                            data["dealStatus"] = JSON.stringify(arr);
                        }

                        $.ajax({
                            url: url
                            , type: "POST"
                            , contentType: "application/json;charset=utf-8"
                            , dataType: "json"
                            , data: JSON.stringify(data)
                            , success: function (result) {
                                if(result.code == 1){
                                    layer.msg(result.msg, {icon: 6});
                                    var trIndex = $(tr).attr("data-index");

                                    layer.close(index);
                                    setTimeout(function(trIndex) {
                                        layer.closeAll('dialog'); //关闭信息框
                                        window.location.href = gourl;
                                    },1500,trIndex);
                                }else{
                                    layer.msg(result.msg, {icon: 5});
                                }
                            }
                        });
                    }else{
                        layer.msg('页面未加载完成,请耐心等待...', {icon: 4});
                        return false;
                    }

                },function (index) {
                    layer.close(index);
                }]
                job(custombtnArrForDetail,custombtnCallBackArrForDetail);
            }
        });
    });

});

