function isArray(arr) {
    return (Array.isArray ? Array.isArray(arr) : (typeof arr === 'object') && (arr instanceof Array));
}
$("#applicantInfoBirthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#birthDay").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd'
});
$("#insuranceStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    minDate: 0
});

$("#insuranceStartDate").change(function () {
    setInsuranEndDate($("#insuranceStartDate").val());
});

$("#applicantInfoBirthDay").change(function () {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }
});
$('#idType').change(function () {
    changeIdType();
});

$('#applicantIdType').change(function () {
    changeApplicantIdType();
});

function applicantInfoToInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {//被保人为本人
        $("#name").val($("#applicantName").val());
        $("#idType").val($("#applicantIdType").val());
        $("#idNumber").val($("#applicantIdNumber").val());
        $("#mobile").val($("#applicantMobile").val());
        $("#gender").val($("#applicantGender").val());
        $("#birthDay").val($("#applicantInfoBirthDay").val());
        $('#insuredBirthDay').html($("#applicantInfoBirthDay").val());
        changeIdType();
        changeGender($("#applicantGender").val());
    }
}

function changeGender(value) {
    $('input[name="gender"]').removeAttr('checked');
    $('input[name="gender"]').each(function () {
        var $this = $(this);
        if ($this.val() == value) {
            $this.prop('checked', 'checked');
        }
    })
}

function changeApplicantIdType() {
    if ($('#applicantIdType').val() == '01') {
        $('.applicantInfoCard').hide();
    } else {
        $('.applicantInfoCard').show();
    }
    var insuredIdentity = $('#insuredIdentity').val();
    if (insuredIdentity == '0') {
        applicantInfoToInsuranInfo();
    }
}

function changeIdType() {
    var comIdTypes = ["31", "32", "33", "34", "37"];
    var thisIdType = $('#idType').val();
    if ($('#idType').val() == '01') {
        $('.insuredInfoCard').hide();
    } else {
        // 判断是否公司投保
        var isCompany = false;
        for (var k in comIdTypes) {
            if (comIdTypes[k] === $.trim(thisIdType)) {
                isCompany = true;
                break;
            }
        }

        if (isCompany) {
            $('#applicantInfoBirthDay').val('-');
            $('#birthDay').val('-');
        }

        $('.insuredInfoCard').show();
    }
}

function setInsuranEndDate(startDate) {
    var endDate = getDateByDateParams(startDate, '1', '+', '', '', '1', '-');
    $('#insuranceEndDate').val(endDate);
}

function getProductItem(birthDay) {
    var age = 0;
    var applicantIsSocialSe = $("#applicantIsSocialSe").val();
    var idNumber = $("#idNumber").val();
    var idType = $("#idType").val();
    var amountSelect = $("#amountSelect").val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
    } else {
        if (birthDay == undefined) {
            birthDay = $('#birthDay').val();
        }
        age = getAgeBybirthDay(birthDay);
    }
    var dataObj = {
        applicantIsSocialSe: applicantIsSocialSe,
        age: age,
        amountSelect: amountSelect,
        recommendId: $("#recommendId").val()
    }
    var url = "/sfzn/reinsurance/getProductItem.do?recommendId=" + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            var productItem = data.productItem;
            if (data.productItem.renewalFlag == "1") {
                var url = '/sfzn/renewal/renewal.do?recommendId=' + $("#recommendId").val()
                ajaxRequest(url, dataObj, function successCallback(data1) {
                        var isnewal = data1.insureVo.renewal;
                        if (isnewal == false) {
                            if (data.ageKey != "13") {
                                if (data1.insureVo.lastClaimCount != null && data1.insureVo.lastClaimCount != "0") {
                                    var extArrt = productItem.extArrt;
                                    if (extArrt != null) {

                                        var obj = eval(extArrt);
                                        var len = obj.length;
                                        for (var i = 0; i < len; i++) {
                                            if (obj[i].calimCountHigher == null && obj[i].calimCountLower == null) {
                                                continue;
                                            }
                                            if (obj[i].calimCountHigher == null && obj[i].calimCountLower != null) {
                                                if (obj[i].calimCountLower <= data1.insureVo.lastClaimCount) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                    var productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                            if (obj[i].calimCountLower == null && obj[i].calimCountHigher != null) {
                                                if (data1.insureVo.lastClaimCount <= obj[i].calimCountHigher) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                    var productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                            if (obj[i].calimCountLower != null && obj[i].calimCountHigher != null) {
                                                if (data1.insureVo.lastClaimCount <= data1.insureVo.lastClaimCount && data1.insureVo.lastClaimCount<=obj[i].calimCountHigher) {
                                                    var insurancePremium = parseFloat(productItem.insurancePremium) * (1 + obj[i].rate);
                                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                                    var productItemCode = data.productItem.productCode;
                                                    $("#productItemCode").val(productItemCode);
                                                    break;
                                                }
                                            }
                                        }
                                    }

                                }
                                else {
                                    var extArrt = productItem.extArrt;
                                    var insurancePremium = parseFloat(data.productItem.insurancePremium);
                                    $("#insurancePremium").html(insurancePremium.toFixed(2));
                                    var productItemCode = data.productItem.productCode;
                                    $("#productItemCode").val(productItemCode);

                                }
                            }
                            else {
                                var extArrt = productItem.extArrt;
                                var insurancePremium = parseFloat(data.productItem.insurancePremium);
                                $("#insurancePremium").html(insurancePremium.toFixed(2));
                                var productItemCode = data.productItem.productCode;
                                $("#productItemCode").val(productItemCode);
                            }
                        } else {
                            if (data.ageKey == "13") {
                                alert('被保人年龄超出新保允许范围（人人安康61-65岁只支持续保）');
                                renewalFlag = false;
                            } else {
                                var myDate = new Date();
                                var endDate = new Date(data1.insureVo.lastEndDate);

                                if(endDate.getTime() >=myDate.getTime()){
                                    $('#insuranceStartDate').val(data1.insureVo.endDate);
                                    setInsuranEndDate($("#insuranceStartDate").val());
                                }



                                var extArrt = productItem.extArrt;
                                var insurancePremium = parseFloat(data.productItem.insurancePremium);
                                $("#insurancePremium").html(insurancePremium.toFixed(2));
                                var productItemCode = data.productItem.productCode;
                                $("#productItemCode").val(productItemCode);
                            }
                        }


                    }
                );


            }

            var insurancePremium = parseFloat(data.productItem.insurancePremium);
            $("#insurancePremium").html(insurancePremium.toFixed(2));
            var productItemCode = data.productItem.productCode;
            $("#productItemCode").val(productItemCode);

        }
    })
    ;
}

function checkApplicantInfoAndInsuranInfo() {
    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            alert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                alert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

function validateName(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if (flag == '1') {
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateEmail(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkEmail(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    } else {
        // $this.parent('.borderbot').addClass('error');
        return true;
    }
}

function validateNull(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.borderbot').removeClass('error');
        return true;
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

function validateIdCard(element, type, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else if (type == '2') {
            idType = $('#applicantIdType').val();
        } else {
            idType = '01';
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.info').addClass('error');
                return false;
            } else {
                $this.parent('.info').removeClass('error');
                if (flag == '1') {
                    applicantInfoToInsuranInfo();
                }
                return true;
            }
        } else {
            if (validateCard(value)) {
                $this.parent('.info').removeClass('error');
                return true;
            } else {
                $this.parent('.info').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validateMobile(element, flag) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            if (flag == '1') {
                applicantInfoToInsuranInfo();
            }
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

function validatePostCode(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkPostCode(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}