layui.use(['layer','form','table'], function() {
    var layer = layui.layer,
        $ = layui.jquery,
        form = layui.form,
        table = layui.table,
        t;                  //表格数据变量

    t = {
        elem: '#userTable',
        url:'/sfzn/sell/queryRateSearch.do?',
        method:'post',
        page: { //支持传入 laypage 组件的所有参数（某些参数除外，如：jump/elem） - 详见文档
            layout: ['limit', 'count', 'prev', 'page', 'next', 'skip'], //自定义分页布局
            //,curr: 5 //设定初始在第 5 页
            groups: 6, //只显示 1 个连续页码
            first: "首页", //显示首页
            last: "尾页", //显示尾页
            limits:[3,10, 20, 30]
        },
        width: $(parent.window).width(),
        cols: [[

            {field:'riskCode',  title: '险种代码',    width:'10%'},
            {field:'companyCode',     title: '机构代码',    width:'12%' },
            {field:'salesRate',       title: '跟单手续费比例',    width:'10%'},
            {field:'planCode',       title: '方案代码',    width:'10%'},
            {field:'longTimeFlag',       title: '是否长期有效',    width:'12%',templet:'#type'},
            {field:'effectiveTime',       title: '手续费生效时间',    width:'12%',templet:'<span>{{ layui.laytpl.toDateString(d.effectiveTime) }}</span>'},
            {field:'invalidTime',       title: '手续费失效时间',    width:'12%',templet:'<span>{{ layui.laytpl.toDateString(d.invalidTime) }}</span>'},
            {field:'lastUpdated',  title: '最后更新时间',width:'14%', templet:'<span>{{ layui.laytpl.toDateString(d.lastUpdated) }}</span>'}, //单元格内容水平居中
            {fixed: 'right', title: '操作',align: 'center', toolbar: '#userBar'}
        ]]
    };
    table.render(t);

    //监听工具条
    table.on('tool(userList)', function(obj){
        var data = obj.data;



        if(obj.event === 'edit'){
            var editIndex = layer.open({
                title : "编辑信息",
                type : 2,
                content : "/sfzn/sell/edit?id="+data.id,
                success : function(layero, index){
                    setTimeout(function(){
                        layer.tips('点击此处返回列表', '.layui-layer-setwin .layui-layer-close', {
                            tips: 3
                        });
                    },500);
                }
            });
            //改变窗口大小时，重置弹窗的高度，防止超出可视区域（如F12调出debug的操作）
            $(window).resize(function(){
                layer.full(editIndex);
            });
            layer.full(editIndex);
        }

        if(obj.event === "del"){
            layer.confirm("你确定要删除该记录？",{btn:['是的,我确定','我再想想']},
                function(){
                    $.post("/sfzn/sell/delete.do?",{"id":data.id},function (res){
                        if(res.success){
                            layer.msg("删除成功",{time: 1000},function(){
                                table.reload('userTable', t);
                            });
                        }else{
                            layer.msg(res.message);
                        }

                    });
                }
            );
        }
    });

    //功能按钮
    var active={
        addUser : function(){
            var addIndex = layer.open({
                title : "添加",
                type : 2,
                content : "/sfzn/sell/add.do?",
                success : function(layero, addIndex){
                    setTimeout(function(){
                        layer.tips('点击此处返回列表', '.layui-layer-setwin .layui-layer-close', {
                            tips: 3
                        });
                    },500);
                }
            });
            //改变窗口大小时，重置弹窗的高度，防止超出可视区域（如F12调出debug的操作）
            $(window).resize(function(){
                layer.full(addIndex);
            });
            layer.full(addIndex);
        }
    };

    $('.layui-inline .layui-btn').on('click', function(){
        var type = $(this).data('type');
        active[type] ? active[type].call(this) : '';
    });

    //搜索
    form.on("submit(searchForm)",function(data){
        t.where = data.field;
        table.reload('userTable', t);
        return false;
    });

});

