/**
 * Created by DixonLim
 */
var rowDates = new Array();
var selectIndex = 0;
var columns = [
    {
        "data": null,
        "searchable": false,
        "orderable": false,
        "targets": 0
    }, {
        "data": "dateCreated",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return formatDate(data);
            } else {
                return '';
            }
        }
    }, {
        "data": "proposalNo",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return '<a href="/sfzn/reinsurance/payQrView.do?recommendId='+row.id+'" target="_blank">'+data+'</a>';
            } else {
                return '';
            }
        }
    }, {
        "data": "riskCode",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return data;
            } else {
                return '';
            }
        }
    }, {
        "data": "name",
        "orderSequence": ["asc"],
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return data;
            } else {
                return '';
            }
        }
    }, {
        "data": "mobile",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return data;
            } else {
                return '';
            }
        }
    }, {
        "data": "customerName",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return data;
            } else {
                return '';
            }
        }
    },{
        "data": "premium",
        "render": function (data, type, row) {
            if (isNotNull(data)) {
                return data;
            } else {
                return '';
            }
        }
    },{
        "data": "signUrl",
        "render": function (data, type, row) {
            return '<img class="sign-thumbnail" src="'+data+'" />';
        }
    }];

function rowCallback(row, data, displayIndex, displayIndexFull) {
    rowDates[displayIndex] = data;
    $('td:eq(0)', row).html((displayIndex + 1));
    $('td:eq(8)', row).hover(function (e) {
        $('.big-sign-modal img').attr("src", $(this).find("img").attr("src"));
        $('.big-sign-modal').show();
    }, function (e) {
        $('.big-sign-modal').hide();
    });
    // $('td:eq(4)', row).html('<a href="javascript:void(0);" onclick="downDzfpUrl(' + displayIndex + ')">电子发票链接下载</a>');
    // $('td:eq(7)', row).html('<span class="table-button" onclick="showSmsAlert(' + displayIndex + ')">发送下载链接</span>');
}

querySign();
function querySign() {
    if (isNotNull($('#resultDataTable'))) {
        var tsUserCode = $('#tsUserCode').val();
        var dataTables = new dataTablesCommon({
            selector: "#resultDataTable",
            targetUrl: '/sfzn/query/querySignSearch.do' + '?'
                + $("#searchForm").serialize(),
            columns: columns,
            rowCallback: rowCallback
        });
        dataTables.query();
    }
}

var startDatePicker = $("#insuranceStartDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    // minDate: 0
});
var endDatePicker = $("#insuranceEndDate").datepicker({
    changeMonth: true,
    changeYear: true,
    dateFormat: 'yy-mm-dd',
    // minDate: 0
});

function setDatepickerDisabled(bool) {
    startDatePicker.prop('disabled', bool);
    endDatePicker.prop('disabled', bool);
}

$("#insuranceStartDate").change(function () {
    // if ($('#insuranceDate').val() != '-1') {
    //     setInsuranEndDate($("#insuranceStartDate").val(), $('#insuranceDate').val());
    // }
});

$("#insuranceEndDate").change(function () {
    // if (!validateDate($("#insuranceStartDate").val(), $(this).val())) {
    //     if ($('#insuranceDate').val() != '-1') {
    //         setInsuranEndDate($("#insuranceStartDate").val(), $('#insuranceDate').val());
    //     } else {
    //         setInsuranEndDate($("#insuranceStartDate").val(), 1);
    //     }
    // }
});

function validateDate(startDateStr, endDateStr) {
    if (!checkDateStr(startDateStr)) {
        return false;
    }
    if (!checkDateStr(endDateStr)) {
        return false;
    }
    var startDate = new Date(startDateStr);
    var endDate = new Date(endDateStr);
    if (startDate.getTime() >= endDate.getTime()) {
        return false;
    } else {
        return true;
    }
}

function setInsuranEndDate(startDate, num) {
    var endDate = getDateByDateParams(startDate, '', '', '', '', num, '+');
    $('#insuranceEndDate').val(endDate);
}

$('input[name="insuranceDate"]').change(function () {
    var insuranceDate = $(this).val();
    var nowDay;
    $('#insuranceDate').val(insuranceDate);
    if (insuranceDate != '-1') {
        if (insuranceDate == '0') {
            nowDay = getDateByDateParams(new Date(), '', '', '', '', '', '')
        } else if (insuranceDate = '6') {
            nowDay = getDateByDateParams(new Date(), '', '', '', '', '6', '-')
        }
        $("#insuranceStartDate").val(nowDay);
        setInsuranEndDate(nowDay, insuranceDate);
        setDatepickerDisabled(true);
    } else {
        setDatepickerDisabled(false);
    }
});

initInfo();
function initInfo() {
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

function smsDownloanPolicy() {
    var row = rowDates[selectIndex];
    var mobile = $('#smsMobile').val();
    var recommendId = row.id;
    var dataObj = {recommendId: recommendId, mobile: mobile};
    showLoading("正在发送短信中，请等待！");
    var url = '/sfzn/sms/sendPolicyDownloadSms.do?recommendId=' + recommendId + '&mobile=' + mobile;
    ajaxRequest(url, dataObj, function successCallback(data) {
        hideLoading();
        hideSmsAlert();
        if (data.respCode == '0000') {
            alert("发送短信成功！");
        } else {
            if (isNotNull(data.respMsg)) {
                alert(data.respMsg);
            } else {
                alert('网络错误，请稍后重试！');
            }
        }
    }, function errorCallback(error) {
        hideSmsAlert();
        hideLoading();
        alert('网络错误，请稍后重试！');
    });
}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function downDzfpUrl(displayIndex) {
    var row = rowDates[displayIndex];
    selectIndex = displayIndex;
    var policyNo = row.policyNo;
    var requestId = row.requestId;
    var recommendId = row.id;
    var dataObj = {recommendId: recommendId, policyNo: policyNo, requestId: requestId};
    showLoading("正在获取电子发票信息，请等待！");
    var url = '/sfzn/query/downDzfpUrl.do?policyNo=' + policyNo + '&requestId=' + requestId;
    ajaxRequest(url, dataObj, function successCallback(data) {
        hideLoading();
        if (data.respCode == '0000') {
            // window.location.href = data.dzfpUrl;
        } else {
            if (isNotNull(data.respMsg)) {
                alert(data.respMsg);
            } else {
                alert('网络错误，请稍后重试！');
            }
        }
    }, function errorCallback(error) {
        hideLoading();
        alert('网络错误，请稍后重试！');
    });
}
function showSmsAlert(displayIndex) {
    var row = rowDates[displayIndex];
    selectIndex = displayIndex;
    var mobile = row.mobile;
    var recommendId = row.id;
    var textContent = '';
    var dataObj = {recommendId: recommendId};
    showLoading();
    var url = '/sfzn/query/policyDownloadSms.do?recommendId=' + recommendId;
    ajaxRequest(url, dataObj, function successCallback(data) {
        hideLoading();
        if (data.respCode == '0000') {
            textContent = data.smsContent;
            var downloadUrlEmpty = data.downloadUrlEmpty;
            var downDzfpUrlEmpty = data.downDzfpUrlEmpty;
            var textInfo = '';
            if(downloadUrlEmpty == '0' && downDzfpUrlEmpty == '0'){
                textInfo = '';
            }else if(downloadUrlEmpty == '1' && downDzfpUrlEmpty == '0'){
                textInfo = '（提示：获取电子保单失败）';
            }else if(downloadUrlEmpty == '0' && downDzfpUrlEmpty == '1'){
                textInfo = '（提示：获取电子发票失败）';
            }else if(downloadUrlEmpty == '1' && downDzfpUrlEmpty == '1'){
                textInfo = '（提示：获取电子保单和电子发票失败）';
            }
            $('.alert-content .text-title .text-info').html(textInfo);
            $('.text-content').html(textContent);
            $('#smsMobile').val(mobile);
            $('.alert-content').show();
        } else {
            if (isNotNull(data.respMsg)) {
                alert(data.respMsg);
            } else {
                alert('网络错误，请稍后重试！');
            }
        }
    }, function errorCallback(error) {
        hideLoading();
        alert('网络错误，请稍后重试！');
    });
}

$("#alert-close").click(function () {
    hideSmsAlert();
});

function hideSmsAlert() {
    $('.text-content').html('');
    $('#smsMobile').val('');
    $('.alert-content').hide();
}
$(function () {
    $(".alert-content").draggable();
});

